/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.rules.TransactionalDocumentRuleBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.CamsPropertyConstants;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetCondition;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.businessobject.BarcodeInventoryErrorDetail;
import org.kuali.kfs.module.cam.document.BarcodeInventoryErrorDocument;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.service.AssetLockService;
import org.kuali.kfs.sys.businessobject.Building;
import org.kuali.kfs.sys.businessobject.Campus;
import org.kuali.kfs.sys.businessobject.Room;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class BarcodeInventoryErrorDocumentRule
extends TransactionalDocumentRuleBase {
    private static final Logger LOG = LogManager.getLogger();
    private AssetService assetService;

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        return true;
    }

    public boolean validateBarcodeInventoryErrorDetail(BarcodeInventoryErrorDocument document, boolean updateStatus) {
        List<BarcodeInventoryErrorDetail> barcodeInventoryErrorDetails = document.getBarcodeInventoryErrorDetail();
        long lineNumber = 0L;
        for (BarcodeInventoryErrorDetail barcodeInventoryErrorDetail : barcodeInventoryErrorDetails) {
            barcodeInventoryErrorDetail.setErrorDescription("");
            if (barcodeInventoryErrorDetail.getErrorCorrectionStatusCode().equals("E")) {
                String errorPath = "document.barcodeInventoryErrorDetail[" + lineNumber + "]";
                GlobalVariables.getMessageMap().addToErrorPath(errorPath);
                Asset asset = this.validateTagNumberAndRetrieveActiveAsset(barcodeInventoryErrorDetail.getAssetTagNumber());
                boolean valid = ObjectUtils.isNotNull((Object)((Object)asset));
                valid &= this.validateCampusCode(barcodeInventoryErrorDetail.getCampusCode(), barcodeInventoryErrorDetail);
                if (ObjectUtils.isNotNull((Object)((Object)asset))) {
                    valid &= this.validateBuildingCodeAndRoomNumber(barcodeInventoryErrorDetail, asset);
                }
                valid &= this.validateConditionCode(barcodeInventoryErrorDetail.getAssetConditionCode(), barcodeInventoryErrorDetail);
                valid &= this.validateInventoryDate(barcodeInventoryErrorDetail.getUploadScanTimestamp());
                if (!(valid &= this.validateTaggingLock(barcodeInventoryErrorDetail.getAssetTagNumber(), document.getDocumentNumber()))) {
                    barcodeInventoryErrorDetail.setErrorCorrectionStatusCode("E");
                    barcodeInventoryErrorDetail.setErrorDescription(this.getErrorMessages(errorPath));
                } else {
                    if (updateStatus) {
                        barcodeInventoryErrorDetail.setErrorCorrectionStatusCode("C");
                    }
                    barcodeInventoryErrorDetail.setErrorDescription("NONE");
                }
                GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
            }
            ++lineNumber;
        }
        this.deleteLockErrorMessages();
        return true;
    }

    @Deprecated
    protected boolean validateTagNumber(String tagNumber) {
        boolean result = true;
        Collection<Asset> assets = this.getAssetService().findAssetsMatchingTagNumber(tagNumber);
        if (ObjectUtils.isNull(assets) || assets.isEmpty()) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER, "error.document.capitalAsset.not.found", new String[0]);
            result = false;
        } else {
            int activeAssets = assets.size();
            for (Asset asset : assets) {
                if (!this.getAssetService().isAssetRetired(asset)) continue;
                --activeAssets;
            }
            if (activeAssets == 0) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER, "error.document.capitalAsset.retired", new String[0]);
                result = false;
            } else if (activeAssets > 1) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER, "error.document.duplicated.tagNumber", new String[0]);
                result = false;
            }
        }
        return result;
    }

    protected Asset validateTagNumberAndRetrieveActiveAsset(String tagNumber) {
        Collection<Asset> assets = this.getAssetService().findAssetsMatchingTagNumber(tagNumber);
        if (ObjectUtils.isNull(assets) || assets.isEmpty()) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER, "error.document.capitalAsset.not.found", new String[0]);
            return null;
        }
        assets.removeIf(asset -> this.getAssetService().isAssetRetired((Asset)((Object)asset)));
        if (assets.size() == 0) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER, "error.document.capitalAsset.retired", new String[0]);
            return null;
        }
        if (assets.size() > 1) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER, "error.document.duplicated.tagNumber", new String[0]);
            return null;
        }
        return assets.iterator().next();
    }

    protected boolean validateInventoryDate(Timestamp inventoryDate) {
        boolean result = true;
        String label = this.getBusinessObjectDictionaryService().getBusinessObjectEntry(BarcodeInventoryErrorDetail.class.getName()).getAttributeDefinition(CamsPropertyConstants.BarcodeInventory.INVENTORY_DATE).getLabel();
        if (inventoryDate == null) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.INVENTORY_DATE, "error.document.invalid.field", new String[]{label});
            result = false;
        }
        return result;
    }

    protected boolean validateCampusCode(String campusCode, BarcodeInventoryErrorDetail detail) {
        boolean result = true;
        String label = this.getBusinessObjectDictionaryService().getBusinessObjectEntry(BarcodeInventoryErrorDetail.class.getName()).getAttributeDefinition(CamsPropertyConstants.BarcodeInventory.CAMPUS_CODE).getLabel();
        Campus campus = this.getCampus(campusCode);
        if (ObjectUtils.isNull((Object)campus)) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.CAMPUS_CODE, "error.document.invalid.field", new String[]{label});
            result = false;
        } else if (!campus.isActive()) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.CAMPUS_CODE, "error.document.inactive.field", new String[]{label});
            result = false;
        }
        return result;
    }

    private Campus getCampus(String campusCode) {
        BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        return (Campus)businessObjectService.findBySinglePrimaryKey(Campus.class, (Object)campusCode);
    }

    @Deprecated
    protected boolean validateBuildingCode(String buildingCode, BarcodeInventoryErrorDetail detail, Asset asset) {
        boolean result = true;
        String label = this.getBusinessObjectDictionaryService().getBusinessObjectEntry(BarcodeInventoryErrorDetail.class.getName()).getAttributeDefinition(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE).getLabel();
        String description = asset.getCapitalAssetTypeCode();
        if (StringUtils.isBlank((CharSequence)asset.getBuildingCode())) {
            if (StringUtils.isNotBlank((CharSequence)buildingCode)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.not.allowed.field", new String[]{label, description});
                result = false;
            }
        } else {
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("campusCode", detail.getCampusCode());
            fields.put("buildingCode", detail.getBuildingCode());
            Building building = (Building)this.getBusinessObjectService().findByPrimaryKey(Building.class, fields);
            if (StringUtils.isBlank((CharSequence)buildingCode)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.required.field", new String[]{label, description});
                result = false;
            } else if (ObjectUtils.isNull((Object)building)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.invalid.field", new String[]{label});
                result = false;
            } else if (!building.isActive()) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.inactive.field", new String[]{label});
                result = false;
            }
        }
        return result;
    }

    @Deprecated
    protected boolean validateBuildingRoomNumber(String roomNumber, BarcodeInventoryErrorDetail detail, Asset asset) {
        boolean result = true;
        String label = this.getBusinessObjectDictionaryService().getBusinessObjectEntry(BarcodeInventoryErrorDetail.class.getName()).getAttributeDefinition(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER).getLabel();
        String description = asset.getCapitalAssetTypeCode();
        if (StringUtils.isBlank((CharSequence)asset.getBuildingRoomNumber())) {
            if (StringUtils.isNotBlank((CharSequence)roomNumber)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, "error.document.not.allowed.field", new String[]{label, description});
                result = false;
            }
        } else {
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("campusCode", detail.getCampusCode());
            fields.put("buildingCode", detail.getBuildingCode());
            fields.put("buildingRoomNumber", detail.getBuildingRoomNumber());
            Room room = (Room)this.getBusinessObjectService().findByPrimaryKey(Room.class, fields);
            if (StringUtils.isBlank((CharSequence)roomNumber)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, "error.document.required.field", new String[]{label, description});
                result = false;
            } else if (ObjectUtils.isNull((Object)room)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, "error.document.invalid.field", new String[]{label});
                result = false;
            } else if (!room.isActive()) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, "error.document.inactive.field", new String[]{label});
                result = false;
            }
        }
        return result;
    }

    protected boolean validateBuildingCodeAndRoomNumber(BarcodeInventoryErrorDetail detail, Asset asset) {
        boolean result = true;
        String campusCode = detail.getCampusCode();
        String buildingCode = detail.getBuildingCode();
        String roomNumber = detail.getBuildingRoomNumber();
        String labelBuilding = this.getBusinessObjectDictionaryService().getBusinessObjectEntry(BarcodeInventoryErrorDetail.class.getName()).getAttributeDefinition(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE).getLabel();
        String labelRoom = this.getBusinessObjectDictionaryService().getBusinessObjectEntry(BarcodeInventoryErrorDetail.class.getName()).getAttributeDefinition(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER).getLabel();
        String assetTypeCode = asset.getCapitalAssetTypeCode();
        AssetType assetType = asset.getCapitalAssetType();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("campusCode", campusCode);
        fields.put("buildingCode", buildingCode);
        Building building = (Building)this.getBusinessObjectService().findByPrimaryKey(Building.class, fields);
        fields.put("buildingRoomNumber", roomNumber);
        Room room = (Room)this.getBusinessObjectService().findByPrimaryKey(Room.class, fields);
        if (assetType.isMovingIndicator() && !assetType.isRequiredBuildingIndicator()) {
            if (StringUtils.isBlank((CharSequence)buildingCode)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.required.field", new String[]{labelBuilding, assetTypeCode});
                result = false;
            } else if (ObjectUtils.isNull((Object)building)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.invalid.field", new String[]{labelBuilding});
                result = false;
            } else if (!building.isActive()) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.inactive.field", new String[]{labelBuilding});
                result = false;
            }
            if (StringUtils.isBlank((CharSequence)roomNumber)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, "error.document.required.field", new String[]{labelRoom, assetTypeCode});
                result = false;
            } else if (ObjectUtils.isNull((Object)room)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, "error.document.invalid.field", new String[]{labelRoom});
                result = false;
            } else if (!room.isActive()) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, "error.document.inactive.field", new String[]{labelRoom});
                result = false;
            }
        } else if (!assetType.isMovingIndicator() && assetType.isRequiredBuildingIndicator()) {
            if (StringUtils.isBlank((CharSequence)buildingCode)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.required.field", new String[]{labelBuilding, assetTypeCode});
                result = false;
            } else if (ObjectUtils.isNull((Object)building)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.invalid.field", new String[]{labelBuilding});
                result = false;
            } else if (!building.isActive()) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.inactive.field", new String[]{labelBuilding});
                result = false;
            }
            if (StringUtils.isNotBlank((CharSequence)roomNumber)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, "error.document.not.allowed.field", new String[]{labelRoom, assetTypeCode});
                result = false;
            }
        } else if (!assetType.isMovingIndicator() && !assetType.isRequiredBuildingIndicator()) {
            if (StringUtils.isNotBlank((CharSequence)buildingCode)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.not.allowed.field", new String[]{labelBuilding, assetTypeCode});
                result = false;
            }
            if (StringUtils.isNotBlank((CharSequence)roomNumber)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, "error.document.not.allowed.field", new String[]{labelRoom, assetTypeCode});
                result = false;
            }
        }
        return result;
    }

    protected boolean validateConditionCode(String conditionCode, BarcodeInventoryErrorDetail detail) {
        boolean result = true;
        String label = this.getBusinessObjectDictionaryService().getBusinessObjectEntry(BarcodeInventoryErrorDetail.class.getName()).getAttributeDefinition(CamsPropertyConstants.BarcodeInventory.ASSET_CONDITION_CODE).getLabel();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put(CamsPropertyConstants.BarcodeInventory.ASSET_CONDITION_CODE, detail.getAssetConditionCode());
        AssetCondition condition = (AssetCondition)this.getBusinessObjectService().findByPrimaryKey(AssetCondition.class, fields);
        if (ObjectUtils.isNull((Object)((Object)condition))) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.ASSET_CONDITION_CODE, "error.document.invalid.field", new String[]{label});
            result = false;
        } else if (!condition.isActive()) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.ASSET_CONDITION_CODE, "error.document.inactive.field", new String[]{label});
            result = false;
        }
        return result;
    }

    protected boolean validateTaggingLock(String tagNumber, String documentNumber) {
        String skipAssetLockValidation;
        boolean result = true;
        if (this.getParameterService().parameterExists(BarcodeInventoryErrorDocument.class, "IGNORES_LOCKS_IND").booleanValue()) {
            skipAssetLockValidation = this.getParameterService().getParameterValueAsString(BarcodeInventoryErrorDocument.class, "IGNORES_LOCKS_IND");
        } else {
            LOG.warn("CAMS Parameter 'IGNORES_LOCKS_IND' not found! - Setting default value to 'N' ");
            skipAssetLockValidation = "N";
        }
        if (skipAssetLockValidation == null || StringUtils.isEmpty((CharSequence)skipAssetLockValidation) || StringUtils.equals((CharSequence)skipAssetLockValidation, (CharSequence)"N")) {
            List<Asset> assets = this.getAssetService().findActiveAssetsMatchingTagNumber(tagNumber);
            if (assets.size() > 1) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER, "error.document.duplicated.tagNumber", new String[0]);
                result = false;
            } else if (assets.size() > 0) {
                ArrayList<Long> assetNumbers = new ArrayList<Long>();
                assetNumbers.add(assets.get(0).getCapitalAssetNumber());
                List<String> lockingDocNumbers = ((AssetLockService)SpringContext.getBean(AssetLockService.class)).getAssetLockingDocuments(assetNumbers, "BCIE", documentNumber);
                if (lockingDocNumbers != null && !lockingDocNumbers.isEmpty()) {
                    for (String lockingDocNumber : lockingDocNumbers) {
                        GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER, "error.document.locked.asset", new String[]{lockingDocNumber});
                    }
                    result = false;
                }
            }
        }
        return result;
    }

    protected String getErrorMessages(String errorPath) {
        String[] fields;
        Object message = "";
        for (String field : fields = new String[]{CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER, CamsPropertyConstants.BarcodeInventory.INVENTORY_DATE, CamsPropertyConstants.BarcodeInventory.CAMPUS_CODE, CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, CamsPropertyConstants.BarcodeInventory.ASSET_CONDITION_CODE}) {
            String propertyName = errorPath + "." + field;
            if (!GlobalVariables.getMessageMap().doesPropertyHaveError(propertyName)) continue;
            for (Object errorMessage : GlobalVariables.getMessageMap().getMessages(propertyName)) {
                String errorMsg = this.getKualiConfigurationService().getPropertyValueAsString(((ErrorMessage)errorMessage).getErrorKey());
                message = (String)message + ", " + MessageFormat.format(errorMsg, ((ErrorMessage)errorMessage).getMessageParameters());
            }
        }
        return StringUtils.isEmpty((CharSequence)message) ? message : ((String)message).substring(2);
    }

    protected void deleteLockErrorMessages() {
        ArrayList<ErrorMessage> el = new ArrayList<ErrorMessage>();
        if (GlobalVariables.getMessageMap().getMessages("GLOBAL_ERRORS") == null) {
            return;
        }
        for (ErrorMessage errorMessage : GlobalVariables.getMessageMap().getMessages("GLOBAL_ERRORS")) {
            if (!errorMessage.getErrorKey().equals("error.maintenance.locked")) continue;
            el.add(errorMessage);
        }
        for (ErrorMessage em : el) {
            GlobalVariables.getMessageMap().getMessages("GLOBAL_ERRORS").remove((Object)em);
        }
    }

    protected ParameterService getParameterService() {
        return (ParameterService)SpringContext.getBean(ParameterService.class);
    }

    protected AssetService getAssetService() {
        if (this.assetService == null) {
            this.assetService = (AssetService)SpringContext.getBean(AssetService.class);
        }
        return this.assetService;
    }

    protected void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    protected DateTimeService getDateTimeService() {
        return (DateTimeService)SpringContext.getBean(DateTimeService.class);
    }

    protected BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    }

    private BusinessObjectDictionaryService getBusinessObjectDictionaryService() {
        return (BusinessObjectDictionaryService)SpringContext.getBean(BusinessObjectDictionaryService.class);
    }
}

