/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.time.DateUtils;
import org.kuali.kfs.coreservice.api.parameter.Parameter;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cam.batch.ExtractProcessLog;
import org.kuali.kfs.module.cam.batch.service.BatchExtractService;
import org.kuali.kfs.module.cam.batch.service.BatchIntegTestBase;
import org.kuali.kfs.module.cam.batch.service.impl.BatchExtractServiceImpl;
import org.kuali.kfs.module.cam.businessobject.GeneralLedgerEntry;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableItemAsset;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableLineAssetAccount;
import org.kuali.kfs.module.cam.document.service.PurApInfoService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.ProxyUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.fixture.UserNameFixture;

public class BatchExtractServiceIntegTest
extends BatchIntegTestBase {
    private BatchExtractService batchExtractService;
    private BusinessObjectService boService;

    @Override
    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    protected void setUp() throws Exception {
        super.setUp();
        BatchExtractServiceImpl batchExtractServiceImpl = (BatchExtractServiceImpl)ProxyUtils.getTargetIfProxied((Object)SpringContext.getBean(BatchExtractService.class));
        batchExtractServiceImpl.setFinancialSystemDocumentService((FinancialSystemDocumentService)new BatchIntegTestBase.BatchTestBaseFinancialSystemDocumentService());
        BatchIntegTestBase.BatchTestBasePurApInfoService purApInfoService = new BatchIntegTestBase.BatchTestBasePurApInfoService();
        purApInfoService.setBusinessObjectService((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class));
        batchExtractServiceImpl.setPurApInfoService((PurApInfoService)purApInfoService);
        this.batchExtractService = batchExtractServiceImpl;
        this.boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    }

    public void testBatchProcess() throws Exception {
        ExtractProcessLog processLog = new ExtractProcessLog();
        Collection glEntries = this.batchExtractService.findElgibleGLEntries(processLog);
        BatchExtractServiceIntegTest.assertNotNull((Object)glEntries);
        BatchExtractServiceIntegTest.assertEquals((int)13, (int)glEntries.size());
        ArrayList fpLines = new ArrayList();
        ArrayList purapLines = new ArrayList();
        this.batchExtractService.separatePOLines(fpLines, purapLines, glEntries);
        BatchExtractServiceIntegTest.assertEquals((int)11, (int)purapLines.size());
        BatchExtractServiceIntegTest.assertEquals((int)2, (int)fpLines.size());
        this.batchExtractService.saveFPLines(fpLines, processLog);
        Collection fpGls = this.boService.findAll(GeneralLedgerEntry.class);
        BatchExtractServiceIntegTest.assertEquals((int)2, (int)fpGls.size());
        Timestamp ts = new Timestamp(DateUtils.parseDate((String)"01/01/1970 23:59:59", (String[])new String[]{"MM/dd/yyyy HH:mm:ss"}).getTime());
        this.batchExtractService.updateLastExtractTime(ts);
        Parameter parameter = this.findCabExtractTimeParam();
        BatchExtractServiceIntegTest.assertEquals((String)"01/01/1970 23:59:59", (String)parameter.getValue());
        this.batchExtractService.savePOLines(purapLines, processLog);
        Collection gls = this.boService.findAll(GeneralLedgerEntry.class);
        BatchExtractServiceIntegTest.assertEquals((int)13, (int)gls.size());
        Collection allCabDocs = this.boService.findAll(PurchasingAccountsPayableDocument.class);
        BatchExtractServiceIntegTest.assertEquals((int)7, (int)allCabDocs.size());
        Collection allCabItems = this.boService.findAll(PurchasingAccountsPayableItemAsset.class);
        BatchExtractServiceIntegTest.assertEquals((int)14, (int)allCabItems.size());
        Collection allCabAccts = this.boService.findAll(PurchasingAccountsPayableLineAssetAccount.class);
        BatchExtractServiceIntegTest.assertEquals((int)17, (int)allCabAccts.size());
    }

    public void testFindPreTaggablePOAccounts() {
        Collection preTaggablePOAccounts = this.batchExtractService.findPreTaggablePOAccounts();
        BatchExtractServiceIntegTest.assertEquals((int)6, (int)preTaggablePOAccounts.size());
    }
}

