/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cam.batch.service.AssetBarcodeInventoryLoadService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.BarcodeInventoryErrorDetail;
import org.kuali.kfs.module.cam.document.web.struts.AssetBarCodeInventoryInputFileForm;
import org.kuali.kfs.module.cam.fixture.BarcodeInventoryServiceFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.bomiddle)
public class AssetBarcodeInventoryLoadServiceIntegTest
extends KualiIntegTestBase {
    private static final String PATH_TO_FILES = AssetBarcodeInventoryLoadServiceIntegTest.class.getPackage().getName().replace('.', '/') + "/";
    private AssetBarcodeInventoryLoadService assetBarcodeInventoryLoadService;
    private BusinessObjectService businessObjectService;

    protected void setUp() throws Exception {
        super.setUp();
        this.assetBarcodeInventoryLoadService = (AssetBarcodeInventoryLoadService)SpringContext.getBean(AssetBarcodeInventoryLoadService.class);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    }

    public void testIsFileFormatValid_true() throws Exception {
        Collection uris = Stream.of(ClassLoader.getSystemResource(PATH_TO_FILES + "barcode_valid_format.csv").toURI(), ClassLoader.getSystemResource(PATH_TO_FILES + "barcode_error_data.csv").toURI()).collect(Collectors.toSet());
        for (URI uri : uris) {
            File file = Paths.get(uri).toFile();
            AssetBarcodeInventoryLoadServiceIntegTest.assertTrue((String)("Expected file format to be valid - " + file), (boolean)this.assetBarcodeInventoryLoadService.isFileFormatValid(file));
        }
    }

    public void testIsFileFormatValid_false() throws Exception {
        Collection uris = Stream.of(ClassLoader.getSystemResource(PATH_TO_FILES + "barcode_error_format_few_columns.csv").toURI(), ClassLoader.getSystemResource(PATH_TO_FILES + "barcode_error_format_field_length.csv").toURI(), ClassLoader.getSystemResource(PATH_TO_FILES + "barcode_error_format_nodata.csv").toURI(), ClassLoader.getSystemResource(PATH_TO_FILES + "barcode_error_format_too_many_columns.csv").toURI()).collect(Collectors.toSet());
        for (URI uri : uris) {
            File file = Paths.get(uri).toFile();
            AssetBarcodeInventoryLoadServiceIntegTest.assertFalse((String)("Expected file format to be invalid -- " + file), (boolean)this.assetBarcodeInventoryLoadService.isFileFormatValid(file));
        }
    }

    public void testProcessFile() throws Exception {
        Collection uris = Stream.of(ClassLoader.getSystemResource(PATH_TO_FILES + "barcode_valid_format.csv").toURI()).collect(Collectors.toSet());
        AssetBarCodeInventoryInputFileForm form = new AssetBarCodeInventoryInputFileForm();
        for (URI uri : uris) {
            try {
                File file = Paths.get(uri).toFile();
                this.assetBarcodeInventoryLoadService.processFile(file, form);
            }
            catch (IllegalArgumentException e) {
                Throwable origin = e;
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    origin = cause;
                }
                AssetBarcodeInventoryLoadServiceIntegTest.assertTrue((boolean)ValidationException.class.isAssignableFrom(origin.getClass()));
            }
        }
    }

    public void testUpdateAssetInformation() {
        List<BarcodeInventoryErrorDetail> barcodeInventoryErrorDetails = BarcodeInventoryServiceFixture.DATA.getBarcodeInventoryDetail();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        Iterator<BarcodeInventoryErrorDetail> iterator = barcodeInventoryErrorDetails.iterator();
        while (iterator.hasNext()) {
            BarcodeInventoryErrorDetail barcodeInventoryErrorDetail1;
            BarcodeInventoryErrorDetail barcodeInventoryErrorDetail = barcodeInventoryErrorDetail1 = iterator.next();
            this.assetBarcodeInventoryLoadService.updateAssetInformation(barcodeInventoryErrorDetail, false);
            fieldValues.put("campusTagNumber", barcodeInventoryErrorDetail.getAssetTagNumber());
            Asset asset = (Asset)((List)this.businessObjectService.findMatching(Asset.class, fieldValues)).get(0);
            AssetBarcodeInventoryLoadServiceIntegTest.assertTrue((String)"Error on data", (asset.getInventoryScannedCode().equals(barcodeInventoryErrorDetail.isUploadScanIndicator() ? "1" : "0") && asset.getBuildingCode().equals(barcodeInventoryErrorDetail.getBuildingCode()) && asset.getBuildingRoomNumber().equals(barcodeInventoryErrorDetail.getBuildingRoomNumber()) && asset.getBuildingSubRoomNumber().equals(barcodeInventoryErrorDetail.getBuildingSubRoomNumber()) && asset.getCampusCode().equals(barcodeInventoryErrorDetail.getCampusCode()) && asset.getConditionCode().equals(barcodeInventoryErrorDetail.getAssetConditionCode()) ? 1 : 0) != 0);
        }
    }
}

