/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.impl.AssetDateServiceImpl;
import org.kuali.kfs.module.cam.document.service.impl.AssetServiceImpl;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.impl.datetime.DateTimeServiceImpl;

@Execution(value=ExecutionMode.SAME_THREAD)
public class AssetDateServiceImplTest {
    private AssetDateServiceImpl assetDateService;
    private Asset oldAsset;
    private Asset newAsset;

    @Before
    public void setUp() {
        this.assetDateService = new AssetDateServiceImpl();
        this.assetDateService.setAssetService((AssetService)new AssetServiceImpl());
        this.assetDateService.setDateTimeService((DateTimeService)new DateTimeServiceImpl());
        this.oldAsset = new Asset();
        this.newAsset = new Asset();
        this.oldAsset.setOffCampusLocation(new AssetLocation());
        this.newAsset.setOffCampusLocation(new AssetLocation());
    }

    @Test
    public void checkAndUpdateLastInventoryDateNullOffCampusLocation() {
        this.oldAsset.setOffCampusLocation(null);
        this.newAsset.setOffCampusLocation(null);
        this.assetDateService.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assert.assertNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    public void checkAndUpdateLastInventoryDateNoChanges() {
        this.assetDateService.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assert.assertNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    public void checkAndUpdateLastInventoryDateCampusCodeChanged() {
        this.newAsset.setCampusCode("BL");
        this.assetDateService.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assert.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    public void checkAndUpdateLastInventoryDateBuildingCodeChanged() {
        this.newAsset.setBuildingCode("0001C");
        this.assetDateService.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assert.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    public void checkAndUpdateLastInventoryDateBuildingRoomNumberChanged() {
        this.newAsset.setBuildingRoomNumber("001");
        this.assetDateService.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assert.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    public void checkAndUpdateLastInventoryDateBuildingSubRoomNumberChanged() {
        this.newAsset.setBuildingSubRoomNumber("B");
        this.assetDateService.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assert.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    public void checkAndUpdateLastInventoryDateCampusTagNumberChanged() {
        this.newAsset.setCampusTagNumber("123");
        this.assetDateService.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assert.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    public void checkAndUpdateLastInventoryDateAssetLocationContactNameChanged() {
        this.newAsset.getOffCampusLocation().setAssetLocationContactName("Off Campus Location");
        this.assetDateService.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assert.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    public void checkAndUpdateLastInventoryDateAssetLocationStreetAddressChanged() {
        this.newAsset.getOffCampusLocation().setAssetLocationStreetAddress("123 Main St.");
        this.assetDateService.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assert.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    public void checkAndUpdateLastInventoryDateAssetLocationCityNameChanged() {
        this.newAsset.getOffCampusLocation().setAssetLocationCityName("Ithaca");
        this.assetDateService.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assert.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    public void checkAndUpdateLastInventoryDateAssetLocationStateCodeChanged() {
        this.newAsset.getOffCampusLocation().setAssetLocationStateCode("NY");
        this.assetDateService.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assert.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    public void checkAndUpdateLastInventoryDateAssetLocationZipCodeChanged() {
        this.newAsset.getOffCampusLocation().setAssetLocationZipCode("14850");
        this.assetDateService.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assert.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    public void checkAndUpdateLastInventoryDatesetLocationCountryCodeChanged() {
        this.newAsset.getOffCampusLocation().setAssetLocationCountryCode("US");
        this.assetDateService.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assert.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }
}

