/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.util.distribution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.util.distribution.AssetDistributionManual;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mockito;

@Execution(value=ExecutionMode.SAME_THREAD)
public class AssetDistributionManualTest {
    private AssetPaymentDocument assetPaymentDocument;
    private AssetDistributionManual assetDistributionManual;

    @Before
    public void setUp() throws Exception {
        this.assetPaymentDocument = (AssetPaymentDocument)Mockito.mock(AssetPaymentDocument.class);
        this.assetDistributionManual = new AssetDistributionManual(this.assetPaymentDocument);
    }

    @Test
    public void getAssetPaymentDistributions_noAccountingLines() {
        ArrayList assetPaymentDetails = new ArrayList();
        Mockito.when((Object)this.assetDistributionManual.getAssetPaymentDetailLines()).thenReturn(assetPaymentDetails);
        Map assetPaymentDistributions = this.assetDistributionManual.getAssetPaymentDistributions();
        Assert.assertEquals((String)"No accounting lines should result in no distribution", (long)0L, (long)assetPaymentDistributions.size());
    }

    @Test
    public void getAssetPaymentDistributions_onePositiveOneNegativeAllocation() {
        List<AssetPaymentDetail> assetPaymentDetails = this.setupAssetPaymentDetails(new int[]{100, -100}, new String[]{"1024700", "1024700"});
        Mockito.when((Object)this.assetDistributionManual.getAssetPaymentDetailLines()).thenReturn(assetPaymentDetails);
        List<AssetPaymentAssetDetail> assetPaymentAssetDetails = this.setupAssetPaymentAssetDetails(new KualiDecimal(100), new KualiDecimal(-100));
        Mockito.when((Object)this.assetPaymentDocument.getAssetPaymentAssetDetail()).thenReturn(assetPaymentAssetDetails);
        HashMap<String, int[]> expectedAmounts = new HashMap<String, int[]>();
        expectedAmounts.put("1024700", new int[]{100, -100});
        Map assetPaymentDistributions = this.assetDistributionManual.getAssetPaymentDistributions();
        this.validateAssetPaymentDistributions(assetPaymentDistributions, expectedAmounts);
    }

    @Test
    public void getAssetPaymentDistributions_twoPositiveAllocations() {
        List<AssetPaymentDetail> assetPaymentDetails = this.setupAssetPaymentDetails(new int[]{300}, new String[]{"1024700", "1024700"});
        Mockito.when((Object)this.assetDistributionManual.getAssetPaymentDetailLines()).thenReturn(assetPaymentDetails);
        List<AssetPaymentAssetDetail> assetPaymentAssetDetails = this.setupAssetPaymentAssetDetails(new KualiDecimal(200), new KualiDecimal(100));
        Mockito.when((Object)this.assetPaymentDocument.getAssetPaymentAssetDetail()).thenReturn(assetPaymentAssetDetails);
        HashMap<String, int[]> expectedAmounts = new HashMap<String, int[]>();
        expectedAmounts.put("1024700", new int[]{200, 100});
        Map assetPaymentDistributions = this.assetDistributionManual.getAssetPaymentDistributions();
        this.validateAssetPaymentDistributions(assetPaymentDistributions, expectedAmounts);
    }

    @Test
    public void getAssetPaymentDistributions_twoNegativeAllocationsTwoAccounts() {
        List<AssetPaymentDetail> assetPaymentDetails = this.setupAssetPaymentDetails(new int[]{-150, -150}, new String[]{"1024700", "1031400"});
        Mockito.when((Object)this.assetDistributionManual.getAssetPaymentDetailLines()).thenReturn(assetPaymentDetails);
        List<AssetPaymentAssetDetail> assetPaymentAssetDetails = this.setupAssetPaymentAssetDetails(new KualiDecimal(-200), new KualiDecimal(-100));
        Mockito.when((Object)this.assetPaymentDocument.getAssetPaymentAssetDetail()).thenReturn(assetPaymentAssetDetails);
        HashMap<String, int[]> expectedAmounts = new HashMap<String, int[]>();
        expectedAmounts.put("1024700", new int[]{-100, -50});
        expectedAmounts.put("1031400", new int[]{-100, -50});
        Map assetPaymentDistributions = this.assetDistributionManual.getAssetPaymentDistributions();
        this.validateAssetPaymentDistributions(assetPaymentDistributions, expectedAmounts);
    }

    @Test
    public void getAssetPaymentDistributions_onePositiveOneNegativeAllocationTwoAccounts() {
        List<AssetPaymentDetail> assetPaymentDetails = this.setupAssetPaymentDetails(new int[]{-50, -50}, new String[]{"1024700", "1031400"});
        Mockito.when((Object)this.assetDistributionManual.getAssetPaymentDetailLines()).thenReturn(assetPaymentDetails);
        List<AssetPaymentAssetDetail> assetPaymentAssetDetails = this.setupAssetPaymentAssetDetails(new KualiDecimal(-200), new KualiDecimal(100));
        Mockito.when((Object)this.assetPaymentDocument.getAssetPaymentAssetDetail()).thenReturn(assetPaymentAssetDetails);
        HashMap<String, int[]> expectedAmounts = new HashMap<String, int[]>();
        expectedAmounts.put("1024700", new int[]{-100, 50});
        expectedAmounts.put("1031400", new int[]{-100, 50});
        Map assetPaymentDistributions = this.assetDistributionManual.getAssetPaymentDistributions();
        this.validateAssetPaymentDistributions(assetPaymentDistributions, expectedAmounts);
    }

    @Test
    public void getAssetPaymentDistributions_onePositiveOneNegativeAllocationThreeAccounts() {
        List<AssetPaymentDetail> assetPaymentDetails = this.setupAssetPaymentDetails(new int[]{-50, 50, -100}, new String[]{"1024700", "1031400", "1024600"});
        Mockito.when((Object)this.assetDistributionManual.getAssetPaymentDetailLines()).thenReturn(assetPaymentDetails);
        List<AssetPaymentAssetDetail> assetPaymentAssetDetails = this.setupAssetPaymentAssetDetails(new KualiDecimal(-200), new KualiDecimal(100));
        Mockito.when((Object)this.assetPaymentDocument.getAssetPaymentAssetDetail()).thenReturn(assetPaymentAssetDetails);
        HashMap<String, int[]> expectedAmounts = new HashMap<String, int[]>();
        expectedAmounts.put("1024700", new int[]{-100, 50});
        expectedAmounts.put("1031400", new int[]{100, -50});
        expectedAmounts.put("1024600", new int[]{-200, 100});
        Map assetPaymentDistributions = this.assetDistributionManual.getAssetPaymentDistributions();
        this.validateAssetPaymentDistributions(assetPaymentDistributions, expectedAmounts);
    }

    private List<AssetPaymentDetail> setupAssetPaymentDetails(int[] assetPaymentAmounts, String[] accountNumbers) {
        ArrayList<AssetPaymentDetail> assetPaymentDetails = new ArrayList<AssetPaymentDetail>();
        int accountNumberIndex = 0;
        for (int assetPaymentAmount : assetPaymentAmounts) {
            AssetPaymentDetail assetPaymentDetail = (AssetPaymentDetail)Mockito.spy(AssetPaymentDetail.class);
            assetPaymentDetail.setFinancialObjectCode("7000");
            assetPaymentDetail.setAmount(new KualiDecimal(assetPaymentAmount));
            ((AssetPaymentDetail)Mockito.doReturn((Object)accountNumbers[accountNumberIndex]).when((Object)assetPaymentDetail)).getAccountNumber();
            ((AssetPaymentDetail)Mockito.doReturn((Object)2018).when((Object)assetPaymentDetail)).getPostingYear();
            assetPaymentDetail.setSequenceNumber(Integer.valueOf(accountNumberIndex));
            assetPaymentDetails.add(assetPaymentDetail);
            ++accountNumberIndex;
        }
        return assetPaymentDetails;
    }

    private List<AssetPaymentAssetDetail> setupAssetPaymentAssetDetails(KualiDecimal firstAssetPaymentAllocatedAmount, KualiDecimal secondAssetPaymentAllocatedAmount) {
        AssetPaymentAssetDetail firstAssetPaymentAssetDetail = new AssetPaymentAssetDetail();
        firstAssetPaymentAssetDetail.setCapitalAssetNumber(Long.valueOf(319730L));
        firstAssetPaymentAssetDetail.setAllocatedUserValue(firstAssetPaymentAllocatedAmount);
        AssetPaymentAssetDetail secondAssetPaymentAssetDetail = new AssetPaymentAssetDetail();
        secondAssetPaymentAssetDetail.setCapitalAssetNumber(Long.valueOf(319731L));
        secondAssetPaymentAssetDetail.setAllocatedUserValue(secondAssetPaymentAllocatedAmount);
        ArrayList<AssetPaymentAssetDetail> assetPaymentAssetDetails = new ArrayList<AssetPaymentAssetDetail>();
        assetPaymentAssetDetails.add(firstAssetPaymentAssetDetail);
        assetPaymentAssetDetails.add(secondAssetPaymentAssetDetail);
        return assetPaymentAssetDetails;
    }

    private void validateAssetPaymentDistributions(Map<String, Map<AssetPaymentAssetDetail, KualiDecimal>> assetPaymentDistributions, Map<String, int[]> expectedAmounts) {
        Assert.assertEquals((long)expectedAmounts.size(), (long)assetPaymentDistributions.size());
        for (String assetPaymentDistributionKey : assetPaymentDistributions.keySet()) {
            String accountNumber = this.findAccountNumber(assetPaymentDistributionKey);
            Map<AssetPaymentAssetDetail, KualiDecimal> assets = assetPaymentDistributions.get(assetPaymentDistributionKey);
            Object[] amounts = assets.values().toArray();
            AssetPaymentAssetDetail assetPaymentAssetDetail = assets.keySet().iterator().next();
            int firstAssetAmount = expectedAmounts.get(accountNumber)[0];
            int secondAssetAmount = expectedAmounts.get(accountNumber)[1];
            if (assetPaymentAssetDetail.getCapitalAssetNumber().equals(319730L)) {
                Assert.assertEquals((String)("Asset 319730 should be " + firstAssetAmount + "$"), (Object)new KualiDecimal(firstAssetAmount), (Object)amounts[0]);
                Assert.assertEquals((String)("Asset 319731 should be " + secondAssetAmount + "$"), (Object)new KualiDecimal(secondAssetAmount), (Object)amounts[1]);
                continue;
            }
            Assert.assertEquals((String)("Asset 319730 should be " + firstAssetAmount + "$"), (Object)new KualiDecimal(firstAssetAmount), (Object)amounts[1]);
            Assert.assertEquals((String)("Asset 319731 should be " + secondAssetAmount + "$"), (Object)new KualiDecimal(secondAssetAmount), (Object)amounts[0]);
        }
    }

    private String findAccountNumber(String assetPaymentDistributionKey) {
        int start = assetPaymentDistributionKey.indexOf("accountNumber=") + 14;
        int end = assetPaymentDistributionKey.indexOf(", subAccountNumber=");
        return assetPaymentDistributionKey.substring(start, end);
    }
}

