/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.math.BigDecimal;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.document.service.AssetPaymentService;
import org.kuali.kfs.sys.businessobject.AccountingLineBase;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class AssetPaymentAllocationValidation
extends GenericValidation {
    private AssetPaymentService assetPaymentService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        AssetPaymentDocument assetPaymentDocument = (AssetPaymentDocument)event.getDocument();
        if ("4".equals(assetPaymentDocument.getAssetPaymentAllocationTypeCode())) {
            valid = this.validatePercentSum(assetPaymentDocument);
        } else if ("1".equals(assetPaymentDocument.getAssetPaymentAllocationTypeCode())) {
            valid = this.validateAmountSum(assetPaymentDocument);
        }
        return valid;
    }

    protected boolean validateAmountSum(AssetPaymentDocument assetPaymentDocument) {
        KualiDecimal sourceTotal;
        KualiDecimal total = this.getAllocatedTotal(assetPaymentDocument);
        if (!total.equals((Object)(sourceTotal = this.getSourceLinesTotal(assetPaymentDocument)))) {
            GlobalVariables.getMessageMap().putErrorForSectionId("commonErrorSection", "error.asset.payment.allocation.not.equal", new String[0]);
            return false;
        }
        return true;
    }

    private KualiDecimal getSourceLinesTotal(AssetPaymentDocument assetPaymentDocument) {
        KualiDecimal sourceTotal = KualiDecimal.ZERO;
        for (Object sal : assetPaymentDocument.getSourceAccountingLines()) {
            sourceTotal = (KualiDecimal)sourceTotal.add((AbstractKualiDecimal)((AccountingLineBase)sal).getAmount());
        }
        return sourceTotal;
    }

    private KualiDecimal getAllocatedTotal(AssetPaymentDocument assetPaymentDocument) {
        KualiDecimal total = KualiDecimal.ZERO;
        for (AssetPaymentAssetDetail apad : assetPaymentDocument.getAssetPaymentAssetDetail()) {
            if (assetPaymentDocument.isAllocationFromFPDocuments()) {
                total = (KualiDecimal)total.add((AbstractKualiDecimal)apad.getAllocatedAmount());
                continue;
            }
            total = (KualiDecimal)total.add((AbstractKualiDecimal)apad.getAllocatedUserValue());
        }
        return total;
    }

    private boolean validatePercentSum(AssetPaymentDocument assetPaymentDocument) {
        BigDecimal total = new BigDecimal(0.0);
        for (AssetPaymentAssetDetail apad : assetPaymentDocument.getAssetPaymentAssetDetail()) {
            BigDecimal buggyFix = new BigDecimal("" + apad.getAllocatedUserValuePct().doubleValue());
            total = total.add(buggyFix);
        }
        if (total.doubleValue() != 100.0) {
            GlobalVariables.getMessageMap().putErrorForSectionId("commonErrorSection", "error.asset.payment.allocation.percent", new String[0]);
            return false;
        }
        return true;
    }

    public AssetPaymentService getAssetPaymentService() {
        return this.assetPaymentService;
    }

    public void setAssetPaymentService(AssetPaymentService assetPaymentService) {
        this.assetPaymentService = assetPaymentService;
    }
}

