/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.identity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.membership.MemberType;
import org.kuali.kfs.kew.api.exception.WorkflowException;
import org.kuali.kfs.kim.api.KimConstants;
import org.kuali.kfs.kim.api.role.RoleMembership;
import org.kuali.kfs.kns.kim.role.DerivedRoleTypeServiceBase;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.cam.document.EquipmentLoanOrReturnDocument;

public class AssetDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    protected DocumentService documentService;

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        EquipmentLoanOrReturnDocument document;
        String documentNumber;
        this.validateRequiredAttributesAgainstReceived(qualification);
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>(1);
        if (qualification != null && !qualification.isEmpty() && StringUtils.isNotBlank((CharSequence)(documentNumber = qualification.get("documentNumber"))) && (document = this.getEquipmentLoanOrReturnDocument(documentNumber)) != null) {
            RoleMembership.Builder builder = RoleMembership.Builder.create(null, null, (String)document.getBorrowerUniversalIdentifier(), (MemberType)KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE, null);
            members.add(builder.build());
        }
        return members;
    }

    protected EquipmentLoanOrReturnDocument getEquipmentLoanOrReturnDocument(String documentNumber) {
        try {
            return (EquipmentLoanOrReturnDocument)this.documentService.getByDocumentHeaderId(documentNumber);
        }
        catch (WorkflowException e) {
            throw new RuntimeException("Workflow problem while trying to get document using doc id '" + documentNumber + "'", e);
        }
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

