/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.web.struts;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kew.api.exception.WorkflowException;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableItemAsset;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableLineAssetAccount;
import org.kuali.kfs.module.cam.document.service.PurApInfoService;
import org.kuali.kfs.module.cam.document.service.PurApLineDocumentService;
import org.kuali.kfs.module.cam.document.service.PurApLineService;
import org.kuali.kfs.module.cam.document.web.PurApLineSession;
import org.kuali.kfs.module.cam.document.web.struts.CabActionBase;
import org.kuali.kfs.module.cam.web.struts.PurApLineForm;
import org.kuali.kfs.sys.context.SpringContext;

public class PurApLineAction
extends CabActionBase {
    PurApLineService purApLineService = (PurApLineService)SpringContext.getBean(PurApLineService.class);
    PurApInfoService purApInfoService = (PurApInfoService)SpringContext.getBean(PurApInfoService.class);
    PurApLineDocumentService purApLineDocumentService = (PurApLineDocumentService)SpringContext.getBean(PurApLineDocumentService.class);

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurApLineForm purApLineForm = (PurApLineForm)form;
        if (purApLineForm.getPurchaseOrderIdentifier() == null) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.po.id.empty", new String[0]);
        } else {
            this.purApInfoService.setPurchaseOrderFromPurAp(purApLineForm);
            this.buildPurApDocList(purApLineForm);
            if (!purApLineForm.getPurApDocs().isEmpty()) {
                this.purApLineService.buildPurApItemAssetList(purApLineForm.getPurApDocs());
                this.createPurApLineSession(purApLineForm.getPurchaseOrderIdentifier());
            }
        }
        return mapping.findForward("basic");
    }

    protected void createPurApLineSession(Integer purchaseOrderIdentifier) {
        GlobalVariables.getUserSession().addObject("CABPurAp".concat(purchaseOrderIdentifier.toString()), (Object)new PurApLineSession());
    }

    protected void clearPurApLineSession(Integer purchaseOrderIdentifier) {
        if (purchaseOrderIdentifier != null) {
            GlobalVariables.getUserSession().removeObject("CABPurAp".concat(purchaseOrderIdentifier.toString()));
        }
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurApLineForm purApLineForm = (PurApLineForm)form;
        if (purApLineForm.getPurchaseOrderIdentifier() == null) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.po.id.empty", new String[0]);
        }
        purApLineForm.getPurApDocs().clear();
        this.clearPurApLineSession(purApLineForm.getPurchaseOrderIdentifier());
        return this.start(mapping, form, request, response);
    }

    protected void buildPurApDocList(PurApLineForm purApLineForm) {
        HashMap<String, Integer> cols = new HashMap<String, Integer>();
        cols.put("purchaseOrderIdentifier", purApLineForm.getPurchaseOrderIdentifier());
        Collection purApDocs = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatchingOrderBy(PurchasingAccountsPayableDocument.class, cols, "documentNumber", true);
        if (purApDocs == null || purApDocs.isEmpty()) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.po.id.invalid", new String[]{purApLineForm.getPurchaseOrderIdentifier().toString()});
        } else {
            boolean existActiveDoc = false;
            for (PurchasingAccountsPayableDocument purApDoc : purApDocs) {
                if (!ObjectUtils.isNotNull((Object)((Object)purApDoc)) || !purApDoc.isActive()) continue;
                existActiveDoc = true;
                break;
            }
            purApLineForm.getPurApDocs().clear();
            purApLineForm.getPurApDocs().addAll(purApDocs);
            this.setupObjectRelationship(purApLineForm.getPurApDocs());
            if (!existActiveDoc) {
                KNSGlobalVariables.getMessageList().add("message.no.active.purap.doc", new String[0]);
            }
        }
    }

    protected void setupObjectRelationship(List<PurchasingAccountsPayableDocument> purApDocs) {
        for (PurchasingAccountsPayableDocument purApDoc : purApDocs) {
            for (PurchasingAccountsPayableItemAsset item : purApDoc.getPurchasingAccountsPayableItemAssets()) {
                item.setPurchasingAccountsPayableDocument(purApDoc);
                for (PurchasingAccountsPayableLineAssetAccount account : item.getPurchasingAccountsPayableLineAssetAccounts()) {
                    account.setPurchasingAccountsPayableItemAsset(item);
                }
            }
        }
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("portal");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurApLineForm purApLineForm = (PurApLineForm)form;
        PurApLineSession purApLineSession = this.retrievePurApLineSession(purApLineForm);
        this.purApLineService.processSaveBusinessObjects(purApLineForm.getPurApDocs(), purApLineSession);
        KNSGlobalVariables.getMessageList().add("message.cab.changes.saved.success", new String[0]);
        return mapping.findForward("basic");
    }

    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurApLineForm purApLineForm = (PurApLineForm)form;
        String question = request.getParameter("questionIndex");
        ConfigurationService kualiConfiguration = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        if (question == null) {
            return this.performQuestionWithoutInput(mapping, form, request, response, "DocSaveBeforeClose", kualiConfiguration.getPropertyValueAsString("document.question.saveBeforeClose.text"), "confirmationQuestion", "close", "");
        }
        String buttonClicked = request.getParameter("buttonClicked");
        PurApLineSession purApLineSession = this.retrievePurApLineSession(purApLineForm);
        if ("DocSaveBeforeClose".equals(question) && "0".equals(buttonClicked)) {
            this.purApLineService.processSaveBusinessObjects(purApLineForm.getPurApDocs(), purApLineSession);
        }
        this.removePurApLineSession(purApLineForm.getPurchaseOrderIdentifier());
        return mapping.findForward("portal");
    }

    private void removePurApLineSession(Integer purchaseOrderIdentifier) {
        GlobalVariables.getUserSession().removeObject("CABPurAp".concat(purchaseOrderIdentifier.toString()));
    }

    public ActionForward split(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurApLineForm purApLineForm = (PurApLineForm)form;
        PurchasingAccountsPayableItemAsset selectedLineItem = this.getSelectedLineItem((PurApLineForm)form);
        if (selectedLineItem == null) {
            return mapping.findForward("basic");
        }
        String errorPath = "purApDocs[" + purApLineForm.getActionPurApDocIndex() + "].purchasingAccountsPayableItemAssets[" + purApLineForm.getActionItemAssetIndex() + "]";
        GlobalVariables.getMessageMap().addToErrorPath(errorPath);
        this.checkSplitQty(selectedLineItem, errorPath);
        GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
        if (GlobalVariables.getMessageMap().hasNoErrors() && selectedLineItem != null) {
            PurApLineSession purApLineSession = this.retrievePurApLineSession(purApLineForm);
            this.purApLineService.processSplit(selectedLineItem, purApLineSession.getActionsTakenHistory());
        }
        return mapping.findForward("basic");
    }

    private PurApLineSession retrievePurApLineSession(PurApLineForm purApForm) {
        PurApLineSession purApLineSession = (PurApLineSession)GlobalVariables.getUserSession().retrieveObject("CABPurAp".concat(purApForm.getPurchaseOrderIdentifier().toString()));
        if (purApLineSession == null) {
            purApLineSession = new PurApLineSession();
            GlobalVariables.getUserSession().addObject("CABPurAp".concat(purApForm.getPurchaseOrderIdentifier().toString()), (Object)purApLineSession);
        }
        return purApLineSession;
    }

    protected void checkSplitQty(PurchasingAccountsPayableItemAsset itemAsset, String errorPath) {
        if (itemAsset.getSplitQty() == null) {
            itemAsset.setSplitQty(KualiDecimal.ZERO);
        }
        if (itemAsset.getAccountsPayableItemQuantity() == null) {
            itemAsset.setAccountsPayableItemQuantity(KualiDecimal.ZERO);
        }
        KualiDecimal splitQty = itemAsset.getSplitQty();
        KualiDecimal oldQty = itemAsset.getAccountsPayableItemQuantity();
        KualiDecimal maxAllowQty = (KualiDecimal)oldQty.subtract((AbstractKualiDecimal)new KualiDecimal(0.1));
        if (splitQty == null) {
            GlobalVariables.getMessageMap().putError("splitQty", "error.split.qty.required", new String[0]);
        } else if (splitQty.isLessEqual((AbstractKualiDecimal)KualiDecimal.ZERO) || splitQty.isGreaterEqual((AbstractKualiDecimal)oldQty)) {
            GlobalVariables.getMessageMap().putError("splitQty", "error.split.qty.invalid", new String[]{maxAllowQty.toString()});
        }
    }

    public ActionForward merge(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurApLineForm purApForm = (PurApLineForm)form;
        boolean isMergeAll = this.purApLineService.isMergeAllAction(purApForm.getPurApDocs());
        List<PurchasingAccountsPayableItemAsset> mergeLines = this.purApLineService.getSelectedMergeLines(isMergeAll, purApForm.getPurApDocs());
        String question = request.getParameter("questionIndex");
        if (question != null) {
            String buttonClicked = request.getParameter("buttonClicked");
            if ("TradeInIndicatorConfirmation".equals(question) && "0".equals(buttonClicked)) {
                if (this.purApLineService.mergeLinesHasDifferentObjectSubTypes(mergeLines)) {
                    String warningMessage = this.generateObjectSubTypeQuestion();
                    return this.performQuestionWithoutInput(mapping, form, request, response, "PaymentDifferentObjectSubTypeQuestion", warningMessage, "confirmationQuestion", "merge", "");
                }
                this.performMerge(purApForm, mergeLines, isMergeAll);
            } else if ("PaymentDifferentObjectSubTypeQuestion".equals(question) && "0".equals(buttonClicked)) {
                this.performMerge(purApForm, mergeLines, isMergeAll);
            }
            return mapping.findForward("basic");
        }
        boolean tradeInAllowanceInAllLines = this.purApLineService.isTradeInAllowanceExist(purApForm.getPurApDocs());
        boolean tradeInIndicatorInSelectedLines = this.purApLineService.isTradeInIndExistInSelectedLines(mergeLines);
        this.validateMergeAction(purApForm, mergeLines, isMergeAll, tradeInAllowanceInAllLines, tradeInIndicatorInSelectedLines);
        if (GlobalVariables.getMessageMap().hasNoErrors()) {
            if (tradeInIndicatorInSelectedLines && !tradeInAllowanceInAllLines) {
                return this.performQuestionWithoutInput(mapping, form, request, response, "TradeInIndicatorConfirmation", ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("question.trade.in.indicator.existing"), "confirmationQuestion", "merge", "");
            }
            if (this.purApLineService.mergeLinesHasDifferentObjectSubTypes(mergeLines)) {
                String warningMessage = this.generateObjectSubTypeQuestion();
                return this.performQuestionWithoutInput(mapping, form, request, response, "PaymentDifferentObjectSubTypeQuestion", warningMessage, "confirmationQuestion", "merge", "");
            }
            this.performMerge(purApForm, mergeLines, isMergeAll);
        }
        return mapping.findForward("basic");
    }

    protected String generateObjectSubTypeQuestion() {
        String parameterDetail = "(module:" + KRADUtils.getNamespaceAndComponentSimpleName(AssetGlobal.class) + ")";
        ConfigurationService kualiConfiguration = this.getConfigurationService();
        String continueQuestion = kualiConfiguration.getPropertyValueAsString("document.question.continue.text");
        return kualiConfiguration.getPropertyValueAsString("question.different.object.sub.types") + " OBJECT_SUB_TYPE_GROUPS " + parameterDetail + ". " + continueQuestion;
    }

    protected void performMerge(PurApLineForm purApForm, List<PurchasingAccountsPayableItemAsset> mergeLines, boolean isMergeAll) {
        PurApLineSession purApLineSession = this.retrievePurApLineSession(purApForm);
        this.retrieveUserInputForMerge(mergeLines.get(0), purApForm);
        this.purApLineService.processMerge(mergeLines, purApLineSession.getActionsTakenHistory(), isMergeAll);
        mergeLines.remove(0);
        purApLineSession.getProcessedItems().addAll(mergeLines);
        this.clearForMerge(purApForm);
    }

    protected void retrieveUserInputForMerge(PurchasingAccountsPayableItemAsset firstItem, PurApLineForm purApForm) {
        if (ObjectUtils.isNotNull((Object)firstItem)) {
            firstItem.setAccountsPayableItemQuantity(purApForm.getMergeQty());
            firstItem.setAccountsPayableLineItemDescription(purApForm.getMergeDesc());
        }
    }

    protected void clearForMerge(PurApLineForm purApForm) {
        this.purApLineService.resetSelectedValue(purApForm.getPurApDocs());
        purApForm.setMergeQty(null);
        purApForm.setMergeDesc(null);
        purApForm.setSelectAll(false);
    }

    protected void validateMergeAction(PurApLineForm purApForm, List<PurchasingAccountsPayableItemAsset> mergeLines, boolean isMergeAll, boolean tradeInAllowanceInAllLines, boolean tradeInIndicatorInSelectedLines) {
        this.checkMergeRequiredFields(purApForm);
        if (isMergeAll) {
            this.checkMergeAllValid(tradeInAllowanceInAllLines, tradeInIndicatorInSelectedLines);
        } else {
            this.checkMergeLinesValid(mergeLines, tradeInAllowanceInAllLines, tradeInIndicatorInSelectedLines);
        }
        this.checkPreTagValidForMerge(mergeLines, purApForm.getPurchaseOrderIdentifier());
    }

    protected void checkPreTagValidForMerge(List<PurchasingAccountsPayableItemAsset> mergeLines, Integer purchaseOrderIdentifier) {
        Map validNumberMap = this.getItemLineNumberMap(mergeLines);
        if (!validNumberMap.isEmpty() && validNumberMap.size() > 1 && this.purApLineService.isMultipleTagExisting(purchaseOrderIdentifier, validNumberMap.keySet())) {
            GlobalVariables.getMessageMap().putError("purApDocs", "error.merge.with.pretagging", new String[0]);
        }
    }

    protected Map getItemLineNumberMap(List<PurchasingAccountsPayableItemAsset> itemLines) {
        HashMap<Integer, Integer> validNumberMap = new HashMap<Integer, Integer>();
        for (PurchasingAccountsPayableItemAsset item : itemLines) {
            if (item.getItemLineNumber() == null) continue;
            validNumberMap.put(item.getItemLineNumber(), item.getItemLineNumber());
        }
        return validNumberMap;
    }

    protected void checkMergeAllValid(boolean tradeInAllowanceInAllLines, boolean tradeInIndicatorInSelectedLines) {
        if (tradeInAllowanceInAllLines && tradeInIndicatorInSelectedLines) {
            GlobalVariables.getMessageMap().putError("purApDocs", "error.trade.in.pending", new String[0]);
        }
    }

    protected void checkMergeLinesValid(List<PurchasingAccountsPayableItemAsset> mergeLines, boolean tradeInAllowanceInAllLines, boolean tradeInIndicatorInSelectedLines) {
        if (mergeLines.size() <= 1) {
            GlobalVariables.getMessageMap().putError("purApDocs", "error.merge.line.selected", new String[0]);
        } else {
            if (this.purApLineService.isAdditionalChargePending(mergeLines)) {
                GlobalVariables.getMessageMap().putError("purApDocs", "error.addl.charge.pending", new String[0]);
            }
            if (tradeInIndicatorInSelectedLines && tradeInAllowanceInAllLines) {
                GlobalVariables.getMessageMap().putError("purApDocs", "error.trade.in.pending", new String[0]);
            }
        }
    }

    protected void checkMergeRequiredFields(PurApLineForm purApForm) {
        if (purApForm.getMergeQty() == null) {
            GlobalVariables.getMessageMap().putError("mergeQty", "error.merge.qty.empty", new String[0]);
        }
        if (StringUtils.isBlank((CharSequence)purApForm.getMergeDesc())) {
            GlobalVariables.getMessageMap().putError("mergeDesc", "error.merge.description.empty", new String[0]);
        }
    }

    public ActionForward percentPayment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurApLineForm purApform = (PurApLineForm)form;
        PurchasingAccountsPayableItemAsset itemAsset = this.getSelectedLineItem(purApform);
        if (itemAsset != null) {
            PurApLineSession purApLineSession = this.retrievePurApLineSession(purApform);
            this.purApLineService.processPercentPayment(itemAsset, purApLineSession.getActionsTakenHistory());
        }
        return mapping.findForward("basic");
    }

    public ActionForward allocate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurApLineForm purApForm = (PurApLineForm)form;
        PurchasingAccountsPayableItemAsset allocateSourceLine = this.getSelectedLineItem(purApForm);
        if (allocateSourceLine == null) {
            return mapping.findForward("basic");
        }
        List<PurchasingAccountsPayableItemAsset> allocateTargetLines = this.purApLineService.getAllocateTargetLines(allocateSourceLine, purApForm.getPurApDocs());
        String question = request.getParameter("questionIndex");
        if (question != null) {
            String buttonClicked = request.getParameter("buttonClicked");
            if ("TradeInIndicatorConfirmation".equals(question) && "0".equals(buttonClicked)) {
                if (this.purApLineService.allocateLinesHasDifferentObjectSubTypes(allocateTargetLines, allocateSourceLine)) {
                    String warningMessage = this.generateObjectSubTypeQuestion();
                    return this.performQuestionWithoutInput(mapping, form, request, response, "PaymentDifferentObjectSubTypeQuestion", warningMessage, "confirmationQuestion", "allocate", "");
                }
                this.performAllocate(purApForm, allocateSourceLine, allocateTargetLines);
            } else if ("PaymentDifferentObjectSubTypeQuestion".equals(question) && "0".equals(buttonClicked)) {
                this.performAllocate(purApForm, allocateSourceLine, allocateTargetLines);
            }
            return mapping.findForward("basic");
        }
        boolean targetLineHasTradeIn = this.purApLineService.isTradeInIndExistInSelectedLines(allocateTargetLines);
        boolean hasTradeInAllowance = this.purApLineService.isTradeInAllowanceExist(purApForm.getPurApDocs());
        this.validateAllocateAction(allocateSourceLine, allocateTargetLines, targetLineHasTradeIn, hasTradeInAllowance, purApForm.getPurApDocs());
        if (GlobalVariables.getMessageMap().hasNoErrors()) {
            if (!allocateSourceLine.isAdditionalChargeNonTradeInIndicator() && !allocateSourceLine.isTradeInAllowance() && (allocateSourceLine.isItemAssignedToTradeInIndicator() || targetLineHasTradeIn) && hasTradeInAllowance) {
                return this.performQuestionWithoutInput(mapping, form, request, response, "TradeInIndicatorConfirmation", ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("question.trade.in.indicator.existing"), "confirmationQuestion", "allocate", "");
            }
            if (this.purApLineService.allocateLinesHasDifferentObjectSubTypes(allocateTargetLines, allocateSourceLine)) {
                String warningMessage = this.generateObjectSubTypeQuestion();
                return this.performQuestionWithoutInput(mapping, form, request, response, "PaymentDifferentObjectSubTypeQuestion", warningMessage, "confirmationQuestion", "allocate", "");
            }
            this.performAllocate(purApForm, allocateSourceLine, allocateTargetLines);
        }
        return mapping.findForward("basic");
    }

    protected void performAllocate(PurApLineForm purApForm, PurchasingAccountsPayableItemAsset allocateSourceLine, List<PurchasingAccountsPayableItemAsset> allocateTargetLines) {
        PurApLineSession purApLineSession = this.retrievePurApLineSession(purApForm);
        if (!this.purApLineService.processAllocate(allocateSourceLine, allocateTargetLines, purApLineSession.getActionsTakenHistory(), purApForm.getPurApDocs(), false)) {
            GlobalVariables.getMessageMap().putError("purApDocs", "error.allocate.no.target.account", new String[0]);
        } else {
            purApLineSession.getProcessedItems().add(allocateSourceLine);
            this.purApLineService.resetSelectedValue(purApForm.getPurApDocs());
            purApForm.setSelectAll(false);
        }
    }

    protected void validateAllocateAction(PurchasingAccountsPayableItemAsset allocateSourceLine, List<PurchasingAccountsPayableItemAsset> allocateTargetLines, boolean targetLineHasTradeIn, boolean hasTradeInAllowance, List<PurchasingAccountsPayableDocument> purApDocs) {
        if (allocateTargetLines.isEmpty()) {
            GlobalVariables.getMessageMap().putError("purApDocs", "error.allocate.no.line.selected", new String[0]);
        }
        if (allocateSourceLine.isTradeInAllowance() && this.purApLineService.isAdditionalChargeExistInAllLines(purApDocs)) {
            GlobalVariables.getMessageMap().putError("purApDocs", "error.addl.charge.pending", new String[0]);
        }
        if (!allocateSourceLine.isAdditionalChargeNonTradeInIndicator() && !allocateSourceLine.isTradeInAllowance()) {
            allocateTargetLines.add(allocateSourceLine);
            if (this.purApLineService.isAdditionalChargePending(allocateTargetLines)) {
                GlobalVariables.getMessageMap().putError("purApDocs", "error.addl.charge.pending", new String[0]);
            }
            if (targetLineHasTradeIn && hasTradeInAllowance) {
                GlobalVariables.getMessageMap().putError("purApDocs", "error.trade.in.pending", new String[0]);
            }
            allocateTargetLines.remove(allocateSourceLine);
        }
    }

    private PurchasingAccountsPayableItemAsset getSelectedLineItem(PurApLineForm purApLineForm) {
        PurchasingAccountsPayableDocument purApDoc = purApLineForm.getPurApDocs().get(purApLineForm.getActionPurApDocIndex());
        PurchasingAccountsPayableItemAsset selectedItem = purApDoc.getPurchasingAccountsPayableItemAssets().get(purApLineForm.getActionItemAssetIndex());
        if (!selectedItem.isActive()) {
            selectedItem = null;
        }
        return selectedItem;
    }

    private PurchasingAccountsPayableDocument getSelectedPurApDoc(PurApLineForm purApLineForm) {
        return purApLineForm.getPurApDocs().get(purApLineForm.getActionPurApDocIndex());
    }

    public ActionForward applyPayment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurApLineForm purApForm = (PurApLineForm)form;
        PurchasingAccountsPayableItemAsset selectedLine = this.getSelectedLineItem(purApForm);
        if (selectedLine == null) {
            return mapping.findForward("basic");
        }
        String question = request.getParameter("questionIndex");
        if (question != null) {
            String buttonClicked = request.getParameter("buttonClicked");
            if ("TradeInIndicatorConfirmation".equals(question) && "0".equals(buttonClicked)) {
                return this.createApplyPaymentDocument(mapping, purApForm, selectedLine);
            }
            return mapping.findForward("basic");
        }
        if (selectedLine.isItemAssignedToTradeInIndicator()) {
            return this.performQuestionWithoutInput(mapping, form, request, response, "TradeInIndicatorConfirmation", ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("question.trade.in.indicator.existing"), "confirmationQuestion", "applyPayment", "");
        }
        return this.createApplyPaymentDocument(mapping, purApForm, selectedLine);
    }

    private ActionForward createApplyPaymentDocument(ActionMapping mapping, PurApLineForm purApForm, PurchasingAccountsPayableItemAsset selectedLine) throws WorkflowException {
        PurApLineSession purApLineSession = this.retrievePurApLineSession(purApForm);
        String documentNumber = this.purApLineDocumentService.processApplyPayment(selectedLine, purApForm.getPurApDocs(), purApLineSession, purApForm.getRequisitionIdentifier());
        if (documentNumber != null) {
            purApForm.setDocumentNumber(documentNumber);
        }
        return mapping.findForward("basic");
    }

    public ActionForward createAsset(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurApLineForm purApForm = (PurApLineForm)form;
        PurchasingAccountsPayableItemAsset selectedLine = this.getSelectedLineItem(purApForm);
        if (selectedLine == null) {
            return mapping.findForward("basic");
        }
        String question = request.getParameter("questionIndex");
        if (question != null) {
            String buttonClicked = request.getParameter("buttonClicked");
            if ("TradeInIndicatorConfirmation".equals(question) && "0".equals(buttonClicked)) {
                if (this.isSettingAssetsInPurAp(selectedLine)) {
                    return this.performQuestionWithoutInput(mapping, form, request, response, "SkipAssetNumbersToAssetGlobalConfirmation", ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("question.skip.asset.numbers.to.asset.global"), "confirmationQuestion", "createAsset", "");
                }
                return this.createAssetGlobalDocument(mapping, purApForm, selectedLine);
            }
            if ("SkipAssetNumbersToAssetGlobalConfirmation".equals(question) && "0".equals(buttonClicked)) {
                return this.createAssetGlobalDocument(mapping, purApForm, selectedLine);
            }
            return mapping.findForward("basic");
        }
        this.validateCreateAssetAction(selectedLine);
        if (GlobalVariables.getMessageMap().hasNoErrors()) {
            if (selectedLine.isItemAssignedToTradeInIndicator()) {
                return this.performQuestionWithoutInput(mapping, form, request, response, "TradeInIndicatorConfirmation", ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("question.trade.in.indicator.existing"), "confirmationQuestion", "createAsset", "");
            }
            if (this.isSettingAssetsInPurAp(selectedLine)) {
                return this.performQuestionWithoutInput(mapping, form, request, response, "SkipAssetNumbersToAssetGlobalConfirmation", ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("question.skip.asset.numbers.to.asset.global"), "confirmationQuestion", "createAsset", "");
            }
            return this.createAssetGlobalDocument(mapping, purApForm, selectedLine);
        }
        return mapping.findForward("basic");
    }

    private boolean isSettingAssetsInPurAp(PurchasingAccountsPayableItemAsset selectedLine) {
        return selectedLine.getPurApItemAssets() != null && !selectedLine.getPurApItemAssets().isEmpty();
    }

    private ActionForward createAssetGlobalDocument(ActionMapping mapping, PurApLineForm purApForm, PurchasingAccountsPayableItemAsset selectedLine) throws WorkflowException {
        PurApLineSession purApLineSession = this.retrievePurApLineSession(purApForm);
        String documentNumber = this.purApLineDocumentService.processCreateAsset(selectedLine, purApForm.getPurApDocs(), purApLineSession, purApForm.getRequisitionIdentifier());
        if (documentNumber != null) {
            purApForm.setDocumentNumber(documentNumber);
        }
        return mapping.findForward("basic");
    }

    protected void validateCreateAssetAction(PurchasingAccountsPayableItemAsset selectedLine) {
        KualiDecimal integerOne = new KualiDecimal(1);
        KualiDecimal quantity = selectedLine.getAccountsPayableItemQuantity();
        if (quantity.isGreaterThan((AbstractKualiDecimal)integerOne) && ((KualiDecimal)quantity.mod((AbstractKualiDecimal)integerOne)).isNonZero()) {
            GlobalVariables.getMessageMap().putError("purApDocs", "error.fractional.quantity", new String[0]);
        } else if (quantity.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO) && quantity.isLessThan((AbstractKualiDecimal)integerOne)) {
            selectedLine.setAccountsPayableItemQuantity(integerOne);
        }
    }

    protected ParameterService getParameterService() {
        return (ParameterService)SpringContext.getBean(ParameterService.class);
    }

    protected ConfigurationService getConfigurationService() {
        return (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
    }
}

