/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;

public class AssetPaymentAssetDetail
extends PersistableBusinessObjectBase {
    private String documentNumber;
    private Long capitalAssetNumber;
    private KualiDecimal previousTotalCostAmount;
    private KualiDecimal allocatedAmount = KualiDecimal.ZERO;
    private KualiDecimal allocatedUserValue = KualiDecimal.ZERO;
    private BigDecimal allocatedUserValuePct = BigDecimal.ZERO;
    private Asset asset;
    private List<AssetPaymentDetail> assetPaymentDetails = new ArrayList<AssetPaymentDetail>();
    private FinancialSystemDocumentHeader documentHeader = new FinancialSystemDocumentHeader();

    public Long getCapitalAssetNumber() {
        return this.capitalAssetNumber;
    }

    public void setCapitalAssetNumber(Long capitalAssetNumber) {
        this.capitalAssetNumber = capitalAssetNumber;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public KualiDecimal getPreviousTotalCostAmount() {
        return this.previousTotalCostAmount;
    }

    public void setPreviousTotalCostAmount(KualiDecimal previousTotalCostAmount) {
        this.previousTotalCostAmount = previousTotalCostAmount;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    public List<AssetPaymentDetail> getAssetPaymentDetails() {
        return this.assetPaymentDetails;
    }

    public void setAssetPaymentDetails(List<AssetPaymentDetail> assetPaymentDetails) {
        this.assetPaymentDetails = assetPaymentDetails;
    }

    public FinancialSystemDocumentHeader getDocumentHeader() {
        return this.documentHeader;
    }

    public void setDocumentHeader(FinancialSystemDocumentHeader documentHeader) {
        this.documentHeader = documentHeader;
    }

    public KualiDecimal getAllocatedAmount() {
        return this.allocatedAmount;
    }

    public void setAllocatedAmount(KualiDecimal allocatedAmount) {
        this.allocatedAmount = Objects.requireNonNullElse(allocatedAmount, KualiDecimal.ZERO);
    }

    public void setAllocatedUserValue(KualiDecimal allocatedUserValue) {
        this.allocatedUserValue = Objects.requireNonNullElse(allocatedUserValue, KualiDecimal.ZERO);
        this.setAllocatedAmount(allocatedUserValue);
    }

    public KualiDecimal getAllocatedUserValue() {
        return this.allocatedUserValue;
    }

    public KualiDecimal getNewTotal() {
        KualiDecimal previousCostAmount = this.getPreviousTotalCostAmount();
        if (ObjectUtils.isNull((Object)previousCostAmount)) {
            previousCostAmount = new KualiDecimal(0);
        }
        return (KualiDecimal)this.getAllocatedAmount().add((AbstractKualiDecimal)previousCostAmount);
    }

    public BigDecimal getAllocatedUserValuePct() {
        return this.allocatedUserValuePct;
    }

    public void setAllocatedUserValuePct(BigDecimal allocatedUserValuePct) {
        this.allocatedUserValuePct = allocatedUserValuePct;
    }
}

