/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.cam.businessobject.PurApAccountLineGroup;
import org.kuali.kfs.module.purap.businessobject.CreditMemoAccountRevision;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestAccountRevision;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLineBase;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class PurApAccountLineGroupTest {
    PurApAccountLineGroupTest() {
    }

    @Test
    void testCombineEntry_PREQ() {
        PurApAccountLineGroup group = this.createAccountLineGroup(new KualiDecimal(100), PaymentRequestAccountRevision.class);
        PurApAccountingLineBase first = this.createEntry(new KualiDecimal(200), PaymentRequestAccountRevision.class);
        Assertions.assertEquals((Object)group, (Object)((Object)new PurApAccountLineGroupTestable(first, "1001", null)));
        group.combineEntry(first);
        Assertions.assertEquals((Object)new KualiDecimal(300), (Object)group.getAmount());
        PurApAccountingLineBase second = this.createEntry(new KualiDecimal(-100), PaymentRequestAccountRevision.class);
        Assertions.assertEquals((Object)group, (Object)((Object)new PurApAccountLineGroupTestable(second, "1001", null)));
        group.combineEntry(second);
        Assertions.assertEquals((Object)new KualiDecimal(200), (Object)group.getAmount());
        PurApAccountingLineBase third = this.createEntry(new KualiDecimal(-200), PaymentRequestAccountRevision.class);
        Assertions.assertEquals((Object)group, (Object)((Object)new PurApAccountLineGroupTestable(third, "1001", null)));
        group.combineEntry(third);
        Assertions.assertEquals((Object)new KualiDecimal(0), (Object)group.getAmount());
        List sourceEntries = group.getSourceEntries();
        Assertions.assertEquals((int)4, (int)sourceEntries.size());
        KualiDecimal totalAmount = KualiDecimal.ZERO;
        for (PurApAccountingLineBase entry : sourceEntries) {
            totalAmount = (KualiDecimal)totalAmount.add((AbstractKualiDecimal)entry.getAmount());
        }
        Assertions.assertEquals((Object)group.getAmount(), (Object)totalAmount);
    }

    @Test
    void testCombineEntry_CM() {
        PurApAccountLineGroup group = this.createAccountLineGroup(new KualiDecimal(100), CreditMemoAccountRevision.class);
        PurApAccountingLineBase first = this.createEntry(new KualiDecimal(200), CreditMemoAccountRevision.class);
        Assertions.assertEquals((Object)group, (Object)((Object)new PurApAccountLineGroupTestable(first, "1001", null)));
        group.combineEntry(first);
        Assertions.assertEquals((Object)new KualiDecimal(-300), (Object)group.getAmount());
        PurApAccountingLineBase second = this.createEntry(new KualiDecimal(-100), CreditMemoAccountRevision.class);
        Assertions.assertEquals((Object)group, (Object)((Object)new PurApAccountLineGroupTestable(second, "1001", null)));
        group.combineEntry(second);
        Assertions.assertEquals((Object)new KualiDecimal(-200), (Object)group.getAmount());
        PurApAccountingLineBase third = this.createEntry(new KualiDecimal(-200), CreditMemoAccountRevision.class);
        Assertions.assertEquals((Object)group, (Object)((Object)new PurApAccountLineGroupTestable(third, "1001", null)));
        group.combineEntry(third);
        Assertions.assertEquals((Object)new KualiDecimal(0), (Object)group.getAmount());
        List sourceEntries = group.getSourceEntries();
        Assertions.assertEquals((int)4, (int)sourceEntries.size());
        KualiDecimal totalAmount = KualiDecimal.ZERO;
        for (PurApAccountingLineBase entry : sourceEntries) {
            totalAmount = (KualiDecimal)totalAmount.add((AbstractKualiDecimal)entry.getAmount());
        }
        Assertions.assertEquals((Object)group.getAmount(), (Object)totalAmount);
    }

    private PurApAccountLineGroup createAccountLineGroup(KualiDecimal amount, Class<? extends PurApAccountingLineBase> clazz) {
        PurApAccountingLineBase entry = this.createEntry(amount, clazz);
        return new PurApAccountLineGroupTestable(entry, "1001", null);
    }

    private PurApAccountingLineBase createEntry(KualiDecimal amount, Class<? extends PurApAccountingLineBase> clazz) {
        PurApAccountingLineBase entryMock = (PurApAccountingLineBase)Mockito.mock(clazz);
        Mockito.when((Object)entryMock.getPostingYear()).thenReturn((Object)2008);
        Mockito.when((Object)entryMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)entryMock.getAccountNumber()).thenReturn((Object)"BL002323");
        Mockito.when((Object)entryMock.getSubAccountNumber()).thenReturn((Object)"--");
        Mockito.when((Object)entryMock.getFinancialObjectCode()).thenReturn((Object)"7000");
        Mockito.when((Object)entryMock.getFinancialSubObjectCode()).thenReturn(null);
        Mockito.when((Object)entryMock.getPostingPeriodCode()).thenReturn((Object)"01");
        Mockito.when((Object)entryMock.getAmount()).thenReturn((Object)amount);
        return entryMock;
    }

    public static class PurApAccountLineGroupTestable
    extends PurApAccountLineGroup {
        PurApAccountLineGroupTestable(PurApAccountingLineBase entry, String docNum, String refDocNum) {
            this.setDocumentNumber(docNum);
            this.setReferenceFinancialDocumentNumber(refDocNum);
            this.setUniversityFiscalYear(entry.getPostingYear());
            this.setUniversityFiscalPeriodCode(entry.getPostingPeriodCode());
            this.setChartOfAccountsCode(entry.getChartOfAccountsCode());
            this.setAccountNumber(entry.getAccountNumber());
            this.setSubAccountNumber(entry.getSubAccountNumber());
            this.setFinancialObjectCode(entry.getFinancialObjectCode());
            this.setFinancialSubObjectCode(entry.getFinancialSubObjectCode());
            this.getSourceEntries().add(entry);
            if (CreditMemoAccountRevision.class.isAssignableFrom(entry.getClass())) {
                this.setAmount((KualiDecimal)entry.getAmount().negated());
            } else {
                this.setAmount(entry.getAmount());
            }
        }
    }
}

