/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableActionHistory;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableItemAsset;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableLineAssetAccount;
import org.kuali.kfs.module.cam.document.service.PurApLineService;
import org.kuali.kfs.module.cam.fixture.PurchasingAccountsPayableDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

public class PurApLineServiceIntegTest
extends KualiIntegTestBase {
    private PurApLineService purApLineService;
    private List<PurchasingAccountsPayableDocument> purApDocuments;
    private PurchasingAccountsPayableItemAsset percentItemAsset;
    private PurchasingAccountsPayableDocument preqDocumentWithSingleItemSingleAccount;
    private PurchasingAccountsPayableDocument preqDocumentWithTwoItemsSingleAccount;
    private PurchasingAccountsPayableDocument cmDocumentWithSingleItemTwoAccounts;

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    protected void setUp() throws Exception {
        super.setUp();
        this.purApLineService = (PurApLineService)SpringContext.getBean(PurApLineService.class);
        this.prepareTestDataRecords();
    }

    private void prepareTestDataRecords() {
        this.purApDocuments = PurchasingAccountsPayableDocumentFixture.createPurApDocuments();
        this.preqDocumentWithTwoItemsSingleAccount = this.purApDocuments.get(0);
        this.preqDocumentWithSingleItemSingleAccount = this.purApDocuments.get(1);
        this.cmDocumentWithSingleItemTwoAccounts = this.purApDocuments.get(2);
        this.percentItemAsset = (PurchasingAccountsPayableItemAsset)this.preqDocumentWithTwoItemsSingleAccount.getPurchasingAccountsPayableItemAssets().get(0);
    }

    public void testProcessPercentPayment() {
        ArrayList actionsTaken = new ArrayList();
        this.purApLineService.processPercentPayment(this.percentItemAsset, actionsTaken);
        PurApLineServiceIntegTest.assertEquals((Object)this.percentItemAsset.getAccountsPayableItemQuantity(), (Object)new KualiDecimal(1));
        PurApLineServiceIntegTest.assertEquals((Object)this.percentItemAsset.getTotalCost(), (Object)this.getTotalCost(this.percentItemAsset));
        PurApLineServiceIntegTest.assertEquals((Object)this.percentItemAsset.getUnitCost(), (Object)this.getTotalCost(this.percentItemAsset));
        PurApLineServiceIntegTest.assertEquals((int)actionsTaken.size(), (int)1);
        PurApLineServiceIntegTest.assertEquals((String)((PurchasingAccountsPayableActionHistory)actionsTaken.get(0)).getActionTypeCode(), (String)"percent payment");
    }

    public void testProcessPercentPayment_noAction() {
        this.percentItemAsset.setAccountsPayableItemQuantity(new KualiDecimal(2));
        ArrayList actionsTaken = new ArrayList();
        this.purApLineService.processPercentPayment(this.percentItemAsset, actionsTaken);
        PurApLineServiceIntegTest.assertEquals((Object)this.percentItemAsset.getAccountsPayableItemQuantity(), (Object)new KualiDecimal(2));
        PurApLineServiceIntegTest.assertEquals((int)actionsTaken.size(), (int)0);
    }

    private KualiDecimal getTotalCost(PurchasingAccountsPayableItemAsset item) {
        KualiDecimal totalCost = KualiDecimal.ZERO;
        for (PurchasingAccountsPayableLineAssetAccount account : item.getPurchasingAccountsPayableLineAssetAccounts()) {
            totalCost = (KualiDecimal)totalCost.add((AbstractKualiDecimal)account.getItemAccountTotalAmount());
        }
        return totalCost;
    }

    public void testMergeLinesHasDifferentObjectSubTypes_True() {
        ArrayList<PurchasingAccountsPayableItemAsset> items = new ArrayList<PurchasingAccountsPayableItemAsset>();
        items.add((PurchasingAccountsPayableItemAsset)this.purApDocuments.get(0).getPurchasingAccountsPayableItemAssets().get(1));
        items.add((PurchasingAccountsPayableItemAsset)this.purApDocuments.get(1).getPurchasingAccountsPayableItemAssets().get(0));
        PurApLineServiceIntegTest.assertTrue((String)"objectSubTypes are different for Merge", (boolean)this.purApLineService.mergeLinesHasDifferentObjectSubTypes(items));
    }

    public void testMergeLinesHasDifferentObjectSubTypes_False() {
        ArrayList<PurchasingAccountsPayableItemAsset> items = new ArrayList<PurchasingAccountsPayableItemAsset>();
        items.add((PurchasingAccountsPayableItemAsset)this.purApDocuments.get(0).getPurchasingAccountsPayableItemAssets().get(0));
        items.add((PurchasingAccountsPayableItemAsset)this.purApDocuments.get(0).getPurchasingAccountsPayableItemAssets().get(1));
        PurApLineServiceIntegTest.assertFalse((String)"objectSubTypes are the same for Merge", (boolean)this.purApLineService.mergeLinesHasDifferentObjectSubTypes(items));
    }

    public void testAllocateLinesHasDifferentObjectSubTypes_True() {
        ArrayList<PurchasingAccountsPayableItemAsset> items = new ArrayList<PurchasingAccountsPayableItemAsset>();
        items.add((PurchasingAccountsPayableItemAsset)this.purApDocuments.get(0).getPurchasingAccountsPayableItemAssets().get(0));
        items.add((PurchasingAccountsPayableItemAsset)this.purApDocuments.get(0).getPurchasingAccountsPayableItemAssets().get(1));
        PurchasingAccountsPayableItemAsset allocateSourceItem = (PurchasingAccountsPayableItemAsset)this.purApDocuments.get(1).getPurchasingAccountsPayableItemAssets().get(0);
        PurApLineServiceIntegTest.assertTrue((String)"objectSubTypes are different for Allocate", (boolean)this.purApLineService.allocateLinesHasDifferentObjectSubTypes(items, allocateSourceItem));
    }

    public void testAllocateLinesHasDifferentObjectSubTypes_False() {
        ArrayList<PurchasingAccountsPayableItemAsset> items = new ArrayList<PurchasingAccountsPayableItemAsset>();
        items.add((PurchasingAccountsPayableItemAsset)this.purApDocuments.get(0).getPurchasingAccountsPayableItemAssets().get(0));
        items.add((PurchasingAccountsPayableItemAsset)this.purApDocuments.get(2).getPurchasingAccountsPayableItemAssets().get(0));
        PurchasingAccountsPayableItemAsset allocateSourceItem = (PurchasingAccountsPayableItemAsset)this.purApDocuments.get(0).getPurchasingAccountsPayableItemAssets().get(1);
        PurApLineServiceIntegTest.assertFalse((String)"objectSubTypes are the same for Allocate", (boolean)this.purApLineService.allocateLinesHasDifferentObjectSubTypes(items, allocateSourceItem));
    }

    public void testProcessSplit_ItemHasSingleAccount() {
        ArrayList actionsTaken = new ArrayList();
        PurchasingAccountsPayableItemAsset splitItemAsset = (PurchasingAccountsPayableItemAsset)this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets().get(0);
        int oldItemSize = this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets().size();
        KualiDecimal oldQuantity = splitItemAsset.getAccountsPayableItemQuantity();
        KualiDecimal oldTotalCost = this.getTotalCost(splitItemAsset);
        splitItemAsset.setSplitQty(new KualiDecimal(1));
        this.purApLineService.processSplit(splitItemAsset, actionsTaken);
        String ERROR_PROCESS_SPLIT_SINGLE_ACCOUNT = "process split error happens when one item has one account";
        PurApLineServiceIntegTest.assertEquals((String)ERROR_PROCESS_SPLIT_SINGLE_ACCOUNT, (int)(++oldItemSize), (int)this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets().size());
        PurApLineServiceIntegTest.assertEquals((String)ERROR_PROCESS_SPLIT_SINGLE_ACCOUNT, (Object)splitItemAsset.getAccountsPayableItemQuantity(), (Object)oldQuantity.subtract((AbstractKualiDecimal)new KualiDecimal(1)));
        KualiDecimal newQuantity = KualiDecimal.ZERO;
        for (PurchasingAccountsPayableItemAsset item : this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets()) {
            newQuantity = (KualiDecimal)newQuantity.add((AbstractKualiDecimal)item.getAccountsPayableItemQuantity());
        }
        PurApLineServiceIntegTest.assertEquals((Object)oldQuantity, (Object)newQuantity);
        KualiDecimal newTotalCost = KualiDecimal.ZERO;
        newTotalCost = (KualiDecimal)newTotalCost.add((AbstractKualiDecimal)this.getTotalCost((PurchasingAccountsPayableItemAsset)this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets().get(0)));
        newTotalCost = (KualiDecimal)newTotalCost.add((AbstractKualiDecimal)this.getTotalCost((PurchasingAccountsPayableItemAsset)this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets().get(1)));
        PurApLineServiceIntegTest.assertEquals((String)ERROR_PROCESS_SPLIT_SINGLE_ACCOUNT, (Object)oldTotalCost, (Object)newTotalCost);
        PurApLineServiceIntegTest.assertEquals((String)ERROR_PROCESS_SPLIT_SINGLE_ACCOUNT, (int)1, (int)actionsTaken.size());
    }

    public void testProcessSplit_ItemHasTwoAccounts() {
        ArrayList actionsTaken = new ArrayList();
        PurchasingAccountsPayableItemAsset splitItemAsset = (PurchasingAccountsPayableItemAsset)this.cmDocumentWithSingleItemTwoAccounts.getPurchasingAccountsPayableItemAssets().get(0);
        int oldItemSize = this.cmDocumentWithSingleItemTwoAccounts.getPurchasingAccountsPayableItemAssets().size();
        KualiDecimal oldQuantity = splitItemAsset.getAccountsPayableItemQuantity();
        KualiDecimal oldTotalCost = this.getTotalCost(splitItemAsset);
        splitItemAsset.setSplitQty(new KualiDecimal(1));
        this.purApLineService.processSplit(splitItemAsset, actionsTaken);
        String ERROR_PROCESS_SPLIT_MULTIPLE_ACCOUNT = "process split error happens when one item has multiple accounts";
        PurApLineServiceIntegTest.assertEquals((String)ERROR_PROCESS_SPLIT_MULTIPLE_ACCOUNT, (int)(++oldItemSize), (int)this.cmDocumentWithSingleItemTwoAccounts.getPurchasingAccountsPayableItemAssets().size());
        PurApLineServiceIntegTest.assertEquals((String)ERROR_PROCESS_SPLIT_MULTIPLE_ACCOUNT, (Object)splitItemAsset.getAccountsPayableItemQuantity(), (Object)oldQuantity.subtract((AbstractKualiDecimal)new KualiDecimal(1)));
        KualiDecimal newQuantity = KualiDecimal.ZERO;
        for (PurchasingAccountsPayableItemAsset item : this.cmDocumentWithSingleItemTwoAccounts.getPurchasingAccountsPayableItemAssets()) {
            newQuantity = (KualiDecimal)newQuantity.add((AbstractKualiDecimal)item.getAccountsPayableItemQuantity());
        }
        PurApLineServiceIntegTest.assertEquals((Object)oldQuantity, (Object)newQuantity);
        KualiDecimal newTotalCost = KualiDecimal.ZERO;
        newTotalCost = (KualiDecimal)newTotalCost.add((AbstractKualiDecimal)this.getTotalCost((PurchasingAccountsPayableItemAsset)this.cmDocumentWithSingleItemTwoAccounts.getPurchasingAccountsPayableItemAssets().get(0)));
        newTotalCost = (KualiDecimal)newTotalCost.add((AbstractKualiDecimal)this.getTotalCost((PurchasingAccountsPayableItemAsset)this.cmDocumentWithSingleItemTwoAccounts.getPurchasingAccountsPayableItemAssets().get(1)));
        PurApLineServiceIntegTest.assertEquals((String)ERROR_PROCESS_SPLIT_MULTIPLE_ACCOUNT, (Object)oldTotalCost, (Object)newTotalCost);
        PurApLineServiceIntegTest.assertEquals((String)ERROR_PROCESS_SPLIT_MULTIPLE_ACCOUNT, (int)2, (int)actionsTaken.size());
    }

    public void testProcessMerge_NotMergeAll() {
        ArrayList actionsTakeHistory = new ArrayList();
        ArrayList mergeLines = new ArrayList();
        mergeLines.addAll(this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets());
        mergeLines.addAll(this.preqDocumentWithTwoItemsSingleAccount.getPurchasingAccountsPayableItemAssets());
        KualiDecimal oldTotalCost = KualiDecimal.ZERO;
        for (PurchasingAccountsPayableItemAsset item : mergeLines) {
            oldTotalCost = (KualiDecimal)oldTotalCost.add((AbstractKualiDecimal)this.getTotalCost(item));
        }
        this.purApLineService.processMerge(mergeLines, actionsTakeHistory, false);
        String ERROR_PROCESS_MERGE = "process merge error";
        PurApLineServiceIntegTest.assertEquals((String)ERROR_PROCESS_MERGE, (int)1, (int)this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets().size());
        PurApLineServiceIntegTest.assertTrue((String)ERROR_PROCESS_MERGE, (boolean)this.preqDocumentWithTwoItemsSingleAccount.getPurchasingAccountsPayableItemAssets().isEmpty());
        KualiDecimal newTotalCost = this.getTotalCost((PurchasingAccountsPayableItemAsset)this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets().get(0));
        PurApLineServiceIntegTest.assertEquals((String)ERROR_PROCESS_MERGE, (Object)oldTotalCost, (Object)newTotalCost);
        PurApLineServiceIntegTest.assertFalse((boolean)this.preqDocumentWithTwoItemsSingleAccount.isActive());
        PurApLineServiceIntegTest.assertEquals((String)ERROR_PROCESS_MERGE, (int)2, (int)actionsTakeHistory.size());
    }

    public void testProcessAllocate_AllocateOneItemToAllTheOtherItems() {
        ArrayList actionsTakeHistory = new ArrayList();
        PurchasingAccountsPayableItemAsset sourceLineItem = (PurchasingAccountsPayableItemAsset)this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets().get(0);
        ArrayList<PurchasingAccountsPayableItemAsset> allocateTargetLines = new ArrayList<PurchasingAccountsPayableItemAsset>();
        KualiDecimal oldTotalCost = this.getTotalCost(sourceLineItem);
        for (Object item : this.preqDocumentWithTwoItemsSingleAccount.getPurchasingAccountsPayableItemAssets()) {
            allocateTargetLines.add((PurchasingAccountsPayableItemAsset)item);
            oldTotalCost = (KualiDecimal)oldTotalCost.add((AbstractKualiDecimal)this.getTotalCost((PurchasingAccountsPayableItemAsset)item));
        }
        for (Object item : this.cmDocumentWithSingleItemTwoAccounts.getPurchasingAccountsPayableItemAssets()) {
            allocateTargetLines.add((PurchasingAccountsPayableItemAsset)item);
            oldTotalCost = (KualiDecimal)oldTotalCost.add((AbstractKualiDecimal)this.getTotalCost((PurchasingAccountsPayableItemAsset)item));
        }
        this.purApLineService.processAllocate(sourceLineItem, allocateTargetLines, actionsTakeHistory, this.purApDocuments, false);
        PurApLineServiceIntegTest.assertTrue((String)"PurchasingAccountsPayableItemAssets was not empty", (boolean)this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets().isEmpty());
        PurApLineServiceIntegTest.assertFalse((String)"preqDocumentWithSingleItemSingleAccount was active", (boolean)this.preqDocumentWithSingleItemSingleAccount.isActive());
        KualiDecimal newTotalCost = KualiDecimal.ZERO;
        for (PurchasingAccountsPayableItemAsset item : allocateTargetLines) {
            newTotalCost = (KualiDecimal)newTotalCost.add((AbstractKualiDecimal)this.getTotalCost(item));
        }
        String ERROR_PROCESS_ALLOCATE = "process allocate error";
        PurApLineServiceIntegTest.assertEquals((String)ERROR_PROCESS_ALLOCATE, (Object)oldTotalCost, (Object)newTotalCost);
        PurApLineServiceIntegTest.assertEquals((String)ERROR_PROCESS_ALLOCATE, (int)4, (int)actionsTakeHistory.size());
    }
}

