/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentInProcessPayment;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.document.validation.impl.AssetPaymentInProcessPaymentValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class AssetPaymentInProcessPaymentValidationTest {
    public static final Integer SEQUENCE_NUMBER1 = 1;

    AssetPaymentInProcessPaymentValidationTest() {
    }

    @Test
    void testValidate_noInProcessPayments(@Mock(stubOnly=true) AttributedDocumentEvent attributedDocumentEvent, @Mock(stubOnly=true) AssetPaymentDocument assetPaymentDocument) {
        Mockito.when((Object)attributedDocumentEvent.getDocument()).thenReturn((Object)assetPaymentDocument);
        ArrayList assetPaymentInProcessPayments = new ArrayList();
        Mockito.when((Object)assetPaymentDocument.getAssetPaymentInProcessPayments()).thenReturn(assetPaymentInProcessPayments);
        AssetPaymentInProcessPaymentValidation assetPaymentInProcessPaymentValidation = new AssetPaymentInProcessPaymentValidation();
        boolean valid = assetPaymentInProcessPaymentValidation.validate(attributedDocumentEvent);
        Assertions.assertTrue((boolean)valid);
    }

    @Test
    void testValidate_inProcessPayments_toZero(@Mock(stubOnly=true) AttributedDocumentEvent attributedDocumentEvent, @Mock(stubOnly=true) AssetPaymentDocument assetPaymentDocument) {
        List<AssetPaymentInProcessPayment> assetPaymentInProcessPayments = this.generateAssetPaymentInProcessPayments(new KualiDecimal(-25), new KualiDecimal(-25));
        List<AssetPaymentDetail> assetPaymentDetails = this.generateAssetPaymentDetails(new KualiDecimal(50));
        Mockito.when((Object)attributedDocumentEvent.getDocument()).thenReturn((Object)assetPaymentDocument);
        Mockito.when((Object)assetPaymentDocument.getAssetPaymentInProcessPayments()).thenReturn(assetPaymentInProcessPayments);
        Mockito.when((Object)assetPaymentDocument.getSourceAccountingLines()).thenReturn(assetPaymentDetails);
        AssetPaymentInProcessPaymentValidation assetPaymentInProcessPaymentValidation = new AssetPaymentInProcessPaymentValidation();
        boolean valid = assetPaymentInProcessPaymentValidation.validate(attributedDocumentEvent);
        Assertions.assertTrue((boolean)valid);
    }

    @Test
    void testValidate_inProcessPayments_noneZero(@Mock(stubOnly=true) AttributedDocumentEvent attributedDocumentEvent, @Mock(stubOnly=true) AssetPaymentDocument assetPaymentDocument) {
        List<AssetPaymentInProcessPayment> assetPaymentInProcessPayments = this.generateAssetPaymentInProcessPayments(new KualiDecimal(-25), new KualiDecimal(-25));
        List<AssetPaymentDetail> assetPaymentDetails = this.generateAssetPaymentDetails(new KualiDecimal(40));
        Mockito.when((Object)attributedDocumentEvent.getDocument()).thenReturn((Object)assetPaymentDocument);
        Mockito.when((Object)assetPaymentDocument.getAssetPaymentInProcessPayments()).thenReturn(assetPaymentInProcessPayments);
        Mockito.when((Object)assetPaymentDocument.getSourceAccountingLines()).thenReturn(assetPaymentDetails);
        AssetPaymentInProcessPaymentValidation assetPaymentInProcessPaymentValidation = new AssetPaymentInProcessPaymentValidation();
        boolean valid = assetPaymentInProcessPaymentValidation.validate(attributedDocumentEvent);
        Assertions.assertFalse((boolean)valid);
    }

    protected List<AssetPaymentInProcessPayment> generateAssetPaymentInProcessPayments(KualiDecimal assetPayment1AccountChargeAmount, KualiDecimal assetPayment2AccountChargeAmount) {
        AssetPayment assetPayment1 = new AssetPayment();
        assetPayment1.setAccountChargeAmount(assetPayment1AccountChargeAmount);
        AssetPaymentInProcessPayment assetPaymentInProcessPayment1 = (AssetPaymentInProcessPayment)Mockito.mock(AssetPaymentInProcessPayment.class);
        Mockito.when((Object)assetPaymentInProcessPayment1.getSequenceNumber()).thenReturn((Object)SEQUENCE_NUMBER1);
        Mockito.when((Object)assetPaymentInProcessPayment1.getAssetPayment()).thenReturn((Object)assetPayment1);
        ArrayList<AssetPaymentInProcessPayment> assetPaymentInProcessPayments = new ArrayList<AssetPaymentInProcessPayment>();
        assetPaymentInProcessPayments.add(assetPaymentInProcessPayment1);
        AssetPayment assetPayment2 = new AssetPayment();
        assetPayment2.setAccountChargeAmount(assetPayment2AccountChargeAmount);
        AssetPaymentInProcessPayment assetPaymentInProcessPayment2 = (AssetPaymentInProcessPayment)Mockito.mock(AssetPaymentInProcessPayment.class);
        Mockito.when((Object)assetPaymentInProcessPayment2.getSequenceNumber()).thenReturn((Object)SEQUENCE_NUMBER1);
        Mockito.when((Object)assetPaymentInProcessPayment2.getAssetPayment()).thenReturn((Object)assetPayment2);
        assetPaymentInProcessPayments.add(assetPaymentInProcessPayment2);
        return assetPaymentInProcessPayments;
    }

    protected List<AssetPaymentDetail> generateAssetPaymentDetails(KualiDecimal assetPaymentDetail1Amount) {
        AssetPaymentDetail assetPaymentDetail = new AssetPaymentDetail();
        assetPaymentDetail.setSequenceNumber(SEQUENCE_NUMBER1);
        assetPaymentDetail.setAmount(assetPaymentDetail1Amount);
        ArrayList<AssetPaymentDetail> assetPaymentDetails = new ArrayList<AssetPaymentDetail>();
        assetPaymentDetails.add(assetPaymentDetail);
        return assetPaymentDetails;
    }
}

