/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.service.impl;

import java.util.HashMap;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.fp.businessobject.CapitalAssetInformation;
import org.kuali.kfs.fp.businessobject.CapitalAssetInformationDetail;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.service.impl.CapitalAssetManagementModuleServiceImpl;
import org.kuali.kfs.sys.businessobject.Building;
import org.kuali.kfs.sys.businessobject.Campus;
import org.kuali.kfs.sys.businessobject.Room;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.springframework.util.AutoPopulatingList;

class CapitalAssetManagementModuleServiceImplTest {
    private static final AssetType TYPE_MOVABLE_ASSET = new AssetType();
    private static final AssetType TYPE_NON_MOVABLE_ASSET;
    @Mock
    private DataDictionaryService dataDictionaryService;
    @Mock
    private ParameterService parameterService;
    @Mock
    private BusinessObjectService businessObjectService;
    @Mock
    private BusinessObjectDictionaryService businessObjectDictionaryService;
    private CapitalAssetManagementModuleServiceImpl cut;

    CapitalAssetManagementModuleServiceImplTest() {
    }

    @BeforeEach
    void setUp() {
        GlobalVariables.clear();
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new CapitalAssetManagementModuleServiceImpl();
        this.cut.setDataDictionaryService(this.dataDictionaryService);
        this.cut.setParameterService(this.parameterService);
        this.cut.setBusinessObjectService(this.businessObjectService);
        this.cut.setBusinessObjectDictionaryService(this.businessObjectDictionaryService);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterAll
    static void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void testCheckNewCapitalAssetFieldsExist_MissingCapitalAssetTypeCode() {
        String labelName = "capitalAssetTypeCode";
        String labelValue = "CAP_ASSET_LABEL";
        Class<CapitalAssetInformation> attrClass = CapitalAssetInformation.class;
        this.setupMocksForCheckNewCapitalAssetFieldExists("capitalAssetTypeCode", "CAP_ASSET_LABEL", attrClass, false, false, null);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        boolean valid = this.cut.checkNewCapitalAssetFieldsExist(capitalAssetInformation, null, 0);
        this.assertForCheckNewCapitalAssetFieldsExistWithSingleErrorMessage("capitalAssetTypeCode", "CAP_ASSET_LABEL", valid);
    }

    @Test
    void testCheckNewCapitalAssetFieldsExist_CapitalAssetQuantity() {
        String labelName = "capitalAssetQuantity";
        String labelValue = "CAP_ASSET_QUANTITY";
        Class<CapitalAssetInformation> attrClass = CapitalAssetInformation.class;
        this.setupMocksForCheckNewCapitalAssetFieldExists("capitalAssetQuantity", "CAP_ASSET_QUANTITY", attrClass, false, false, null);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode("FOO");
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(0));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        boolean valid = this.cut.checkNewCapitalAssetFieldsExist(capitalAssetInformation, null, 0);
        this.assertForCheckNewCapitalAssetFieldsExistWithSingleErrorMessage("capitalAssetQuantity", "CAP_ASSET_QUANTITY", valid);
    }

    @Test
    void testCheckNewCapitalAssetFieldsExist_VendorName() {
        String labelName = "vendorName";
        String labelValue = "CAP_ASSET_VENDOR_NAME";
        Class<CapitalAssetInformation> attrClass = CapitalAssetInformation.class;
        this.setupMocksForCheckNewCapitalAssetFieldExists("vendorName", "CAP_ASSET_VENDOR_NAME", attrClass, true, false, null);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode("FOO");
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        boolean valid = this.cut.checkNewCapitalAssetFieldsExist(capitalAssetInformation, null, 0);
        this.assertForCheckNewCapitalAssetFieldsExistWithSingleErrorMessage("vendorName", "CAP_ASSET_VENDOR_NAME", valid);
    }

    @Test
    void testCheckNewCapitalAssetFieldsExist_ManufacturerName() {
        String labelName = "capitalAssetManufacturerName";
        String labelValue = "CAP_ASSET_MANUFACTURER_NAME";
        Class<CapitalAssetInformation> attrClass = CapitalAssetInformation.class;
        this.setupMocksForCheckNewCapitalAssetFieldExists("capitalAssetManufacturerName", "CAP_ASSET_MANUFACTURER_NAME", attrClass, false, true, null);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode("FOO");
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        boolean valid = this.cut.checkNewCapitalAssetFieldsExist(capitalAssetInformation, null, 0);
        this.assertForCheckNewCapitalAssetFieldsExistWithSingleErrorMessage("capitalAssetManufacturerName", "CAP_ASSET_MANUFACTURER_NAME", valid);
    }

    @Test
    void testCheckNewCapitalAssetFieldsExist_CapitalAssetDesc() {
        String labelName = "capitalAssetDescription";
        String labelValue = "CAP_ASSET_DESC";
        Class<CapitalAssetInformation> attrClass = CapitalAssetInformation.class;
        this.setupMocksForCheckNewCapitalAssetFieldExists("capitalAssetDescription", "CAP_ASSET_DESC", attrClass, false, false, null);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode("FOO");
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        boolean valid = this.cut.checkNewCapitalAssetFieldsExist(capitalAssetInformation, null, 0);
        this.assertForCheckNewCapitalAssetFieldsExistWithSingleErrorMessage("capitalAssetDescription", "CAP_ASSET_DESC", valid);
    }

    @Test
    void testCheckNewCapitalAssetFieldsExist_CapitalAssetDetailMissingCampusCode() {
        String labelName = "campusCode";
        String labelValue = "CAMPUS";
        Class<Campus> attrClass = Campus.class;
        this.setupMocksForCheckNewCapitalAssetFieldExists("campusCode", "CAMPUS", attrClass, false, false, TYPE_MOVABLE_ASSET);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_MOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setBuildingCode("BLD1");
        capitalAssetInformationDetail.setBuildingRoomNumber("100");
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        boolean valid = this.cut.checkNewCapitalAssetFieldsExist(capitalAssetInformation, null, 0);
        this.assertForCheckNewCapitalAssetFieldsExistWithSingleErrorMessage("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].campusCode", "CAMPUS", valid);
    }

    @Test
    void testCheckNewCapitalAssetFieldsExist_CapitalAssetDetailMissingBuildingCode() {
        String labelName = "buildingCode";
        String labelValue = "BUILDING";
        Class<Building> attrClass = Building.class;
        this.setupMocksForCheckNewCapitalAssetFieldExists("buildingCode", "BUILDING", attrClass, false, false, TYPE_MOVABLE_ASSET);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_MOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setCampusCode("BL");
        capitalAssetInformationDetail.setBuildingRoomNumber("100");
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        boolean valid = this.cut.checkNewCapitalAssetFieldsExist(capitalAssetInformation, null, 0);
        this.assertForCheckNewCapitalAssetFieldsExistWithSingleErrorMessage("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].buildingCode", "BUILDING", valid);
    }

    @Test
    void testCheckNewCapitalAssetFieldsExist_CapitalAssetDetailMissingRoom() {
        String labelName = "buildingRoomNumber";
        String labelValue = "ROOM";
        Class<Room> attrClass = Room.class;
        this.setupMocksForCheckNewCapitalAssetFieldExists("buildingRoomNumber", "ROOM", attrClass, false, false, TYPE_MOVABLE_ASSET);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_MOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setCampusCode("BL");
        capitalAssetInformationDetail.setBuildingCode("BLD1");
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        boolean valid = this.cut.checkNewCapitalAssetFieldsExist(capitalAssetInformation, null, 0);
        this.assertForCheckNewCapitalAssetFieldsExistWithSingleErrorMessage("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].buildingRoomNumber", "ROOM", valid);
    }

    @Test
    void testCheckNewCapitalAssetFieldsExist_Valid() {
        String labelName = "buildingRoomNumber";
        String labelValue = "ROOM";
        Class<Room> attrClass = Room.class;
        this.setupMocksForCheckNewCapitalAssetFieldExists("buildingRoomNumber", "ROOM", attrClass, false, false, TYPE_MOVABLE_ASSET);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_MOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setCampusCode("BL");
        capitalAssetInformationDetail.setBuildingCode("BLD1");
        capitalAssetInformationDetail.setBuildingRoomNumber("001");
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        Assertions.assertTrue((boolean)this.cut.checkNewCapitalAssetFieldsExist(capitalAssetInformation, null, 0), (String)"Expected valid for asset fields exist");
    }

    private void setupMocksForCheckNewCapitalAssetFieldExists(String labelName, String labelValue, Class attributeClass, boolean vendorNameRequired, boolean manufacturerNameRequired, AssetType assetType) {
        Mockito.when((Object)this.dataDictionaryService.getAttributeLabel(attributeClass, labelName)).thenReturn((Object)labelValue);
        Mockito.when((Object)this.parameterService.getParameterValueAsString(Asset.class, "VENDOR_REQUIRED_FOR_NON_MOVEABLE_ASSET_IND")).thenReturn((Object)(vendorNameRequired ? "Y" : "N"));
        Mockito.when((Object)this.parameterService.getParameterValueAsString(Asset.class, "MANUFACTURER_REQUIRED_FOR_NON_MOVEABLE_ASSET_IND")).thenReturn((Object)(manufacturerNameRequired ? "Y" : "N"));
        if (assetType != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("capitalAssetTypeCode", assetType.getCapitalAssetTypeCode());
            Mockito.when((Object)((AssetType)this.businessObjectService.findByPrimaryKey(AssetType.class, params))).thenReturn((Object)assetType);
        }
    }

    private void assertForCheckNewCapitalAssetFieldsExistWithSingleErrorMessage(String labelName, String labelValue, boolean valid) {
        Assertions.assertFalse((boolean)valid, (String)"Expected new capital assets fields exist to return false");
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount(), (String)"Expected one error message");
        AutoPopulatingList errorList = GlobalVariables.getMessageMap().getErrorMessagesForProperty(labelName);
        Assertions.assertNotNull((Object)errorList, (String)("Expected error messages for property " + labelName));
        Assertions.assertEquals((int)1, (int)errorList.size(), (String)"Expected one error message");
        ErrorMessage errorMessage = (ErrorMessage)errorList.get(0);
        Assertions.assertEquals((Object)"error.required", (Object)errorMessage.getErrorKey(), (String)"Unexpected error key");
        Assertions.assertEquals((int)1, (int)(errorMessage.getMessageParameters() != null ? errorMessage.getMessageParameters().length : 0), (String)"Expected only one message parameter");
        Assertions.assertEquals((Object)labelValue, (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void testValidateAssetTagLocationLines_MissingCampus() {
        String labelName = "campusCode";
        String labelValue = "CAMPUS";
        Class<Campus> attrClass = Campus.class;
        this.setupMocksForValidateAssetTagLocationLines("campusCode", "CAMPUS", attrClass, TYPE_NON_MOVABLE_ASSET, null, null, null, null, null, null);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_NON_MOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        boolean valid = this.cut.validateAssetTagLocationLines(capitalAssetInformation, 0, null);
        this.assertForValidateAssetTagLocationLine("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].campusCode", "error.existence", valid, 1, new String[]{"CAMPUS"});
        ((BusinessObjectDictionaryService)Mockito.verify((Object)this.businessObjectDictionaryService, (VerificationMode)Mockito.atLeastOnce())).performForceUppercase((BusinessObject)Mockito.any());
    }

    @Test
    void testValidateAssetTagLocationLines_InvalidBuilding() {
        String labelName = "buildingCode";
        String labelValue = "BUILDING";
        Class<Building> attrClass = Building.class;
        Campus campus = new Campus();
        campus.setCode("EA");
        String buildingCode = "FFF";
        this.setupMocksForValidateAssetTagLocationLines("buildingCode", "BUILDING", attrClass, TYPE_MOVABLE_ASSET, campus.getCode(), campus, "FFF", null, null, null);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_MOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setCampusCode(campus.getCode());
        capitalAssetInformationDetail.setBuildingCode("FFF");
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        boolean valid = this.cut.validateAssetTagLocationLines(capitalAssetInformation, 0, null);
        this.assertForValidateAssetTagLocationLine("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].buildingCode", "error.asset.location.invalid.building.code", valid, 1, new String[]{"FFF", campus.getCode()});
        ((BusinessObjectDictionaryService)Mockito.verify((Object)this.businessObjectDictionaryService, (VerificationMode)Mockito.atLeastOnce())).performForceUppercase((BusinessObject)Mockito.any());
    }

    @Test
    void testValidateAssetTagLocationLines_InvalidRoomNumber() {
        String labelName = "buildingRoomNumber";
        String labelValue = "ROOM";
        Class<Room> attrClass = Room.class;
        Campus campus = new Campus();
        campus.setCode("EA");
        Building building = new Building();
        String roomNumber = "999";
        building.setCampusCode(campus.getCode());
        building.setBuildingCode("FFF");
        this.setupMocksForValidateAssetTagLocationLines("buildingRoomNumber", "ROOM", attrClass, TYPE_MOVABLE_ASSET, campus.getCode(), campus, building.getBuildingCode(), building, "999", null);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_MOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setCampusCode(campus.getCode());
        capitalAssetInformationDetail.setBuildingCode(building.getBuildingCode());
        capitalAssetInformationDetail.setBuildingRoomNumber("999");
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        boolean valid = this.cut.validateAssetTagLocationLines(capitalAssetInformation, 0, null);
        this.assertForValidateAssetTagLocationLine("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].buildingRoomNumber", "error.asset.location.invalid.room.code", valid, 1, new String[]{"999", building.getBuildingCode(), campus.getCode()});
        ((BusinessObjectDictionaryService)Mockito.verify((Object)this.businessObjectDictionaryService, (VerificationMode)Mockito.atLeastOnce())).performForceUppercase((BusinessObject)Mockito.any());
    }

    @Test
    void testValidateAssetTagLocationLines_Valid() {
        String labelName = "buildingCode";
        String labelValue = "BUILDING";
        Class<Building> attrClass = Building.class;
        Campus campus = new Campus();
        campus.setCode("EA");
        Building building = new Building();
        Room room = new Room();
        building.setCampusCode(campus.getCode());
        building.setBuildingCode("FFF");
        room.setBuildingRoomNumber("100");
        this.setupMocksForValidateAssetTagLocationLines("buildingCode", "BUILDING", attrClass, TYPE_MOVABLE_ASSET, campus.getCode(), campus, building.getBuildingCode(), building, room.getBuildingRoomNumber(), room);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_MOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setCampusCode(campus.getCode());
        capitalAssetInformationDetail.setBuildingCode(building.getBuildingCode());
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        Assertions.assertTrue((boolean)this.cut.validateAssetTagLocationLines(capitalAssetInformation, 0, null), (String)"Expected valid result");
        ((BusinessObjectDictionaryService)Mockito.verify((Object)this.businessObjectDictionaryService, (VerificationMode)Mockito.atLeastOnce())).performForceUppercase((BusinessObject)Mockito.any());
    }

    @Test
    void testValidateAssetTagLocationLines_BuildingCodeWithNonmovableAsset() {
        String labelName = "buildingCode";
        String labelValue = "BUILDING";
        Class<Building> attrClass = Building.class;
        Campus campus = new Campus();
        campus.setCode("EA");
        Building building = new Building();
        building.setCampusCode(campus.getCode());
        building.setBuildingCode("FFF");
        this.setupMocksForValidateAssetTagLocationLines("buildingCode", "BUILDING", attrClass, TYPE_NON_MOVABLE_ASSET, campus.getCode(), campus, building.getBuildingCode(), building, null, null);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_NON_MOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setCampusCode(campus.getCode());
        capitalAssetInformationDetail.setBuildingCode(building.getBuildingCode());
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        boolean valid = this.cut.validateAssetTagLocationLines(capitalAssetInformation, 0, null);
        this.assertForValidateAssetTagLocationLine("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].buildingCode", "error.asset.location.building.number.non.movable", valid, 1, new String[]{"BUILDING"});
        ((BusinessObjectDictionaryService)Mockito.verify((Object)this.businessObjectDictionaryService, (VerificationMode)Mockito.atLeastOnce())).performForceUppercase((BusinessObject)Mockito.any());
    }

    @Test
    void testValidateAssetTagLocationLines_RoomWithNonmovableAsset() {
        String labelName = "buildingRoomNumber";
        String labelValue = "ROOM";
        Class<Room> attrClass = Room.class;
        Campus campus = new Campus();
        campus.setCode("EA");
        Room room = new Room();
        room.setBuildingRoomNumber("100");
        this.setupMocksForValidateAssetTagLocationLines("buildingRoomNumber", "ROOM", attrClass, TYPE_NON_MOVABLE_ASSET, campus.getCode(), campus, null, null, room.getBuildingRoomNumber(), room);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_NON_MOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setCampusCode(campus.getCode());
        capitalAssetInformationDetail.setBuildingRoomNumber(room.getBuildingRoomNumber());
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        boolean valid = this.cut.validateAssetTagLocationLines(capitalAssetInformation, 0, null);
        this.assertForValidateAssetTagLocationLine("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].buildingRoomNumber", "error.asset.location.room.number.non.movable", valid, 1, new String[]{"ROOM"});
        ((BusinessObjectDictionaryService)Mockito.verify((Object)this.businessObjectDictionaryService, (VerificationMode)Mockito.atLeastOnce())).performForceUppercase((BusinessObject)Mockito.any());
    }

    @Test
    void testValidateAssetTagLocationLines_BuildingAndRoomWithNonmovableAsset() {
        String labelName = "buildingCode";
        String labelValue = "BUILDINGORROOM";
        Class<Building> attrClass = Building.class;
        Campus campus = new Campus();
        campus.setCode("EA");
        Building building = new Building();
        building.setCampusCode(campus.getCode());
        building.setBuildingCode("FFF");
        Room room = new Room();
        room.setBuildingRoomNumber("100");
        Mockito.when((Object)this.dataDictionaryService.getAttributeLabel(Room.class, "buildingRoomNumber")).thenReturn((Object)"BUILDINGORROOM");
        this.setupMocksForValidateAssetTagLocationLines("buildingCode", "BUILDINGORROOM", attrClass, TYPE_NON_MOVABLE_ASSET, campus.getCode(), campus, building.getBuildingCode(), building, room.getBuildingRoomNumber(), room);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_NON_MOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setCampusCode(campus.getCode());
        capitalAssetInformationDetail.setBuildingCode(building.getBuildingCode());
        capitalAssetInformationDetail.setBuildingRoomNumber(room.getBuildingRoomNumber());
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        boolean valid = this.cut.validateAssetTagLocationLines(capitalAssetInformation, 0, null);
        this.assertForValidateAssetTagLocationLine("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].buildingCode", "error.asset.location.building.number.non.movable", valid, 2, new String[]{"BUILDINGORROOM"});
        this.assertForValidateAssetTagLocationLine("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].buildingRoomNumber", "error.asset.location.room.number.non.movable", valid, 2, new String[]{"BUILDINGORROOM"});
        ((BusinessObjectDictionaryService)Mockito.verify((Object)this.businessObjectDictionaryService, (VerificationMode)Mockito.atLeastOnce())).performForceUppercase((BusinessObject)Mockito.any());
    }

    private void setupMocksForValidateAssetTagLocationLines(String labelName, String labelValue, Class attributeClass, AssetType assetType, String campusCode, Campus campusResult, String buildingCode, Building buildingResult, String roomNumber, Room roomResult) {
        Mockito.when((Object)this.dataDictionaryService.getAttributeLabel(attributeClass, labelName)).thenReturn((Object)labelValue);
        if (campusResult != null) {
            Mockito.when((Object)((Campus)this.businessObjectService.findBySinglePrimaryKey(Campus.class, (Object)campusCode))).thenReturn((Object)campusResult);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("campusCode", campusCode);
        params.put("buildingCode", buildingCode);
        Mockito.when((Object)((Building)this.businessObjectService.findByPrimaryKey(Building.class, params))).thenReturn((Object)buildingResult);
        params = new HashMap();
        params.put("campusCode", campusCode);
        params.put("buildingCode", buildingCode);
        params.put("buildingRoomNumber", roomNumber);
        Mockito.when((Object)((Room)this.businessObjectService.findByPrimaryKey(Room.class, params))).thenReturn((Object)roomResult);
        if (assetType != null) {
            params = new HashMap();
            params.put("capitalAssetTypeCode", assetType.getCapitalAssetTypeCode());
            Mockito.when((Object)((AssetType)this.businessObjectService.findByPrimaryKey(AssetType.class, params))).thenReturn((Object)assetType);
        }
        this.businessObjectDictionaryService.performForceUppercase((BusinessObject)Mockito.any());
    }

    private void assertForValidateAssetTagLocationLine(String labelName, String errorKey, boolean valid, int totalErrorCount, String[] expectedMessageParameters) {
        Assertions.assertFalse((boolean)valid, (String)"Expected new capital assets fields exist to return false");
        Assertions.assertEquals((int)totalErrorCount, (int)GlobalVariables.getMessageMap().getErrorCount(), (String)("Expected " + totalErrorCount + " error messages"));
        AutoPopulatingList errorList = GlobalVariables.getMessageMap().getErrorMessagesForProperty(labelName);
        Assertions.assertNotNull((Object)errorList, (String)("Expected error messages for property " + labelName));
        Assertions.assertEquals((int)1, (int)errorList.size(), (String)"Expected one error message");
        ErrorMessage errorMessage = (ErrorMessage)errorList.get(0);
        Assertions.assertEquals((Object)errorKey, (Object)errorMessage.getErrorKey(), (String)"Unexpected error key");
        Assertions.assertEquals((int)expectedMessageParameters.length, (int)(errorMessage.getMessageParameters() != null ? errorMessage.getMessageParameters().length : 0), (String)("Expected " + expectedMessageParameters.length + " message parameter(s)"));
        String[] actualMessageParameters = errorMessage.getMessageParameters();
        for (int i = 0; i < expectedMessageParameters.length; ++i) {
            Assertions.assertEquals((Object)expectedMessageParameters[i], (Object)actualMessageParameters[i]);
        }
    }

    static {
        TYPE_MOVABLE_ASSET.setCapitalAssetTypeCode("F");
        TYPE_MOVABLE_ASSET.setActive(true);
        TYPE_MOVABLE_ASSET.setCapitalAssetTypeDescription("Test Movable Asset Type");
        TYPE_MOVABLE_ASSET.setMovingIndicator(true);
        TYPE_MOVABLE_ASSET.setRequiredBuildingIndicator(true);
        TYPE_NON_MOVABLE_ASSET = new AssetType();
        TYPE_NON_MOVABLE_ASSET.setCapitalAssetTypeCode("T");
        TYPE_NON_MOVABLE_ASSET.setActive(true);
        TYPE_NON_MOVABLE_ASSET.setCapitalAssetTypeDescription("Test Non-movable Asset Type");
        TYPE_NON_MOVABLE_ASSET.setMovingIndicator(false);
        TYPE_NON_MOVABLE_ASSET.setRequiredBuildingIndicator(false);
    }
}

