/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.utils;

import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.util.AssetSeparatePaymentDistributor;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class AssetSeparatePaymentDistributorTest {
    AssetSeparatePaymentDistributorTest() {
    }

    @Test
    void distribute() {
        Asset sourceAsset = new Asset();
        sourceAsset.getAssetPayments().add(this.createPayment("0", "DUMMY1"));
        sourceAsset.getAssetPayments().add(this.createPayment("13", "DUMMY2"));
        sourceAsset.getAssetPayments().add(this.createPayment("13", "DUMMY3"));
        sourceAsset.getAssetPayments().add(this.createPayment("13", "DUMMY4"));
        sourceAsset.getAssetPayments().add(this.createPayment("0", "DUMMY5"));
        AssetGlobal assetGlobal = new AssetGlobal();
        assetGlobal.setTotalCostAmount(new KualiDecimal("39"));
        assetGlobal.setSeparateSourceTotalAmount(new KualiDecimal("39"));
        assetGlobal.setSeparateSourceRemainingAmount(new KualiDecimal("13"));
        assetGlobal.getAssetGlobalDetails().add(this.createDetail(1L, new KualiDecimal("22")));
        assetGlobal.getAssetGlobalDetails().add(this.createDetail(2L, new KualiDecimal("17")));
        ArrayList<Asset> newAssets = new ArrayList<Asset>();
        newAssets.add(this.createAsset(1L));
        newAssets.add(this.createAsset(2L));
        AssetSeparatePaymentDistributor cut = new AssetSeparatePaymentDistributor(sourceAsset, sourceAsset.getAssetPayments(), Integer.valueOf(5), assetGlobal, newAssets);
        try (MockedStatic kradServiceLocatorMockedStatic = Mockito.mockStatic(KRADServiceLocator.class);){
            kradServiceLocatorMockedStatic.when(KRADServiceLocator::getPersistenceStructureService).thenReturn(Mockito.mock(PersistenceStructureService.class));
            cut.distribute();
        }
        Asset asset = (Asset)newAssets.get(0);
        Assertions.assertEquals((int)3, (int)asset.getAssetPayments().size());
        Assertions.assertEquals((Object)new KualiDecimal("7.33"), (Object)((AssetPayment)asset.getAssetPayments().get(0)).getAccountChargeAmount());
        Assertions.assertEquals((Object)"DUMMY2", (Object)((AssetPayment)asset.getAssetPayments().get(0)).getAccountNumber());
        Assertions.assertEquals((Object)new KualiDecimal("7.33"), (Object)((AssetPayment)asset.getAssetPayments().get(1)).getAccountChargeAmount());
        Assertions.assertEquals((Object)"DUMMY3", (Object)((AssetPayment)asset.getAssetPayments().get(1)).getAccountNumber());
        Assertions.assertEquals((Object)new KualiDecimal("7.34"), (Object)((AssetPayment)asset.getAssetPayments().get(2)).getAccountChargeAmount());
        Assertions.assertEquals((Object)"DUMMY4", (Object)((AssetPayment)asset.getAssetPayments().get(2)).getAccountNumber());
        Assertions.assertEquals((Object)new KualiDecimal("7.33"), (Object)((AssetPayment)asset.getAssetPayments().get(0)).getPrimaryDepreciationBaseAmount());
        Assertions.assertEquals((Object)new KualiDecimal("7.33"), (Object)((AssetPayment)asset.getAssetPayments().get(1)).getPrimaryDepreciationBaseAmount());
        Assertions.assertEquals((Object)new KualiDecimal("7.34"), (Object)((AssetPayment)asset.getAssetPayments().get(2)).getPrimaryDepreciationBaseAmount());
        Assertions.assertEquals((Object)new KualiDecimal("3.89"), (Object)((AssetPayment)asset.getAssetPayments().get(0)).getAccumulatedPrimaryDepreciationAmount());
        Assertions.assertEquals((Object)new KualiDecimal("3.89"), (Object)((AssetPayment)asset.getAssetPayments().get(1)).getAccumulatedPrimaryDepreciationAmount());
        Assertions.assertEquals((Object)new KualiDecimal("3.89"), (Object)((AssetPayment)asset.getAssetPayments().get(2)).getAccumulatedPrimaryDepreciationAmount());
        asset = (Asset)newAssets.get(1);
        Assertions.assertEquals((int)3, (int)asset.getAssetPayments().size());
        Assertions.assertEquals((Object)new KualiDecimal("5.67"), (Object)((AssetPayment)asset.getAssetPayments().get(0)).getAccountChargeAmount());
        Assertions.assertEquals((Object)"DUMMY2", (Object)((AssetPayment)asset.getAssetPayments().get(0)).getAccountNumber());
        Assertions.assertEquals((Object)new KualiDecimal("5.67"), (Object)((AssetPayment)asset.getAssetPayments().get(1)).getAccountChargeAmount());
        Assertions.assertEquals((Object)"DUMMY3", (Object)((AssetPayment)asset.getAssetPayments().get(1)).getAccountNumber());
        Assertions.assertEquals((Object)new KualiDecimal("5.66"), (Object)((AssetPayment)asset.getAssetPayments().get(2)).getAccountChargeAmount());
        Assertions.assertEquals((Object)"DUMMY4", (Object)((AssetPayment)asset.getAssetPayments().get(2)).getAccountNumber());
        Assertions.assertEquals((Object)new KualiDecimal("5.67"), (Object)((AssetPayment)asset.getAssetPayments().get(0)).getPrimaryDepreciationBaseAmount());
        Assertions.assertEquals((Object)new KualiDecimal("5.67"), (Object)((AssetPayment)asset.getAssetPayments().get(1)).getPrimaryDepreciationBaseAmount());
        Assertions.assertEquals((Object)new KualiDecimal("5.66"), (Object)((AssetPayment)asset.getAssetPayments().get(2)).getPrimaryDepreciationBaseAmount());
        Assertions.assertEquals((Object)new KualiDecimal("3.01"), (Object)((AssetPayment)asset.getAssetPayments().get(0)).getAccumulatedPrimaryDepreciationAmount());
        Assertions.assertEquals((Object)new KualiDecimal("3.01"), (Object)((AssetPayment)asset.getAssetPayments().get(1)).getAccumulatedPrimaryDepreciationAmount());
        Assertions.assertEquals((Object)new KualiDecimal("3.01"), (Object)((AssetPayment)asset.getAssetPayments().get(2)).getAccumulatedPrimaryDepreciationAmount());
        Assertions.assertEquals((int)8, (int)sourceAsset.getAssetPayments().size());
        Assertions.assertEquals((Object)new KualiDecimal("-13"), (Object)((AssetPayment)sourceAsset.getAssetPayments().get(5)).getAccountChargeAmount());
        Assertions.assertEquals((Object)"DUMMY2", (Object)((AssetPayment)sourceAsset.getAssetPayments().get(5)).getAccountNumber());
        Assertions.assertEquals((Object)new KualiDecimal("-13"), (Object)((AssetPayment)sourceAsset.getAssetPayments().get(6)).getAccountChargeAmount());
        Assertions.assertEquals((Object)"DUMMY3", (Object)((AssetPayment)sourceAsset.getAssetPayments().get(6)).getAccountNumber());
        Assertions.assertEquals((Object)new KualiDecimal("-13"), (Object)((AssetPayment)sourceAsset.getAssetPayments().get(7)).getAccountChargeAmount());
        Assertions.assertEquals((Object)"DUMMY4", (Object)((AssetPayment)sourceAsset.getAssetPayments().get(7)).getAccountNumber());
        Assertions.assertEquals((Object)new KualiDecimal("-13"), (Object)((AssetPayment)sourceAsset.getAssetPayments().get(5)).getPrimaryDepreciationBaseAmount());
        Assertions.assertEquals((Object)new KualiDecimal("-13"), (Object)((AssetPayment)sourceAsset.getAssetPayments().get(6)).getPrimaryDepreciationBaseAmount());
        Assertions.assertEquals((Object)new KualiDecimal("-13"), (Object)((AssetPayment)sourceAsset.getAssetPayments().get(7)).getPrimaryDepreciationBaseAmount());
        Assertions.assertEquals((Object)new KualiDecimal("-6.9"), (Object)((AssetPayment)sourceAsset.getAssetPayments().get(5)).getAccumulatedPrimaryDepreciationAmount());
        Assertions.assertEquals((Object)new KualiDecimal("-6.9"), (Object)((AssetPayment)sourceAsset.getAssetPayments().get(6)).getAccumulatedPrimaryDepreciationAmount());
        Assertions.assertEquals((Object)new KualiDecimal("-6.9"), (Object)((AssetPayment)sourceAsset.getAssetPayments().get(7)).getAccumulatedPrimaryDepreciationAmount());
        Assertions.assertEquals((Object)new KualiDecimal("13"), (Object)((AssetPayment)((Asset)newAssets.get(0)).getAssetPayments().get(0)).getAccountChargeAmount().add((AbstractKualiDecimal)((AssetPayment)((Asset)newAssets.get(1)).getAssetPayments().get(0)).getAccountChargeAmount()));
        Assertions.assertEquals((Object)new KualiDecimal("13"), (Object)((AssetPayment)((Asset)newAssets.get(0)).getAssetPayments().get(1)).getAccountChargeAmount().add((AbstractKualiDecimal)((AssetPayment)((Asset)newAssets.get(1)).getAssetPayments().get(1)).getAccountChargeAmount()));
        Assertions.assertEquals((Object)new KualiDecimal("13"), (Object)((AssetPayment)((Asset)newAssets.get(0)).getAssetPayments().get(2)).getAccountChargeAmount().add((AbstractKualiDecimal)((AssetPayment)((Asset)newAssets.get(1)).getAssetPayments().get(2)).getAccountChargeAmount()));
    }

    private Asset createAsset(long assetNumber) {
        Asset asset = new Asset();
        asset.setCapitalAssetNumber(Long.valueOf(assetNumber));
        return asset;
    }

    private AssetGlobalDetail createDetail(long assetNumber, KualiDecimal separateAmount) {
        AssetGlobalDetail detail = new AssetGlobalDetail();
        detail.setCapitalAssetNumber(Long.valueOf(assetNumber));
        detail.setSeparateSourceAmount(separateAmount);
        return detail;
    }

    private AssetPayment createPayment(String amount, String acctNo) {
        AssetPayment payment = new AssetPayment();
        payment.setAccountNumber(acctNo);
        payment.setAccountChargeAmount(new KualiDecimal(amount));
        payment.setPrimaryDepreciationBaseAmount(new KualiDecimal(amount));
        payment.setPreviousYearPrimaryDepreciationAmount(new KualiDecimal("2.3"));
        payment.setAccumulatedPrimaryDepreciationAmount(new KualiDecimal("6.9"));
        payment.setPeriod2Depreciation1Amount(new KualiDecimal("2.3"));
        payment.setPeriod3Depreciation1Amount(new KualiDecimal("2.3"));
        payment.setPeriod4Depreciation1Amount(KualiDecimal.ZERO);
        payment.setPeriod5Depreciation1Amount(null);
        return payment;
    }
}

