/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.utils;

import java.util.List;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.IterableUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.module.cam.businessobject.BarcodeInventoryErrorDetail;
import org.kuali.kfs.module.cam.document.BarcodeInventoryErrorDocument;
import org.kuali.kfs.module.cam.fixture.BarcodeInventoryErrorDetailPredicateFixture;
import org.kuali.kfs.module.cam.util.BarcodeInventoryErrorDetailPredicate;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class BarcodeInventoryErrorDetailPredicateTest {
    BarcodeInventoryErrorDetailPredicateTest() {
    }

    @Test
    void testUpdateAssetInformation() {
        BarcodeInventoryErrorDocument barcodeInventoryErrorDocument;
        try (MockedStatic kradServiceLocatorWebStaticMock = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            DocumentHeaderService documentHeaderServiceMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
            Class<FinancialSystemDocumentHeader> documentHeaderBaseClass = FinancialSystemDocumentHeader.class;
            Mockito.when((Object)documentHeaderServiceMock.getDocumentHeaderBaseClass()).thenReturn(documentHeaderBaseClass);
            kradServiceLocatorWebStaticMock.when(KRADServiceLocatorWeb::getDocumentHeaderService).thenReturn((Object)documentHeaderServiceMock);
            barcodeInventoryErrorDocument = BarcodeInventoryErrorDetailPredicateFixture.DATA.getBarcodeInventoryErrorDocument();
        }
        List<BarcodeInventoryErrorDetail> barcodeInventoryErrorDetails = BarcodeInventoryErrorDetailPredicateFixture.DATA.getBarcodeInventoryDetail();
        List<BarcodeInventoryErrorDetail> barcodeInventoryErrorExpectedDetails = BarcodeInventoryErrorDetailPredicateFixture.DATA.getExpectedResults();
        BarcodeInventoryErrorDetailPredicate predicatedClosure = new BarcodeInventoryErrorDetailPredicate(barcodeInventoryErrorDocument);
        IterableUtils.forEach(barcodeInventoryErrorDetails, (Closure)predicatedClosure);
        for (int row = 0; row < barcodeInventoryErrorDetails.size(); ++row) {
            BarcodeInventoryErrorDetail barcodeInventoryErrorDetail = barcodeInventoryErrorDetails.get(row);
            BarcodeInventoryErrorDetail barcodeInventoryErrorExpectedDetail = barcodeInventoryErrorExpectedDetails.get(row);
            Assertions.assertTrue((barcodeInventoryErrorDetail.getCampusCode().equals(barcodeInventoryErrorExpectedDetail.getCampusCode()) && barcodeInventoryErrorDetail.getBuildingCode().equals(barcodeInventoryErrorExpectedDetail.getBuildingCode()) && barcodeInventoryErrorDetail.getBuildingRoomNumber().equals(barcodeInventoryErrorExpectedDetail.getBuildingRoomNumber()) && barcodeInventoryErrorDetail.getBuildingSubRoomNumber().equals(barcodeInventoryErrorExpectedDetail.getBuildingSubRoomNumber()) && barcodeInventoryErrorDetail.getAssetConditionCode().equals(barcodeInventoryErrorExpectedDetail.getAssetConditionCode()) ? 1 : 0) != 0);
        }
    }
}

