/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document;

import java.io.Serializable;
import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.parameter.ParameterEvaluator;
import org.kuali.kfs.core.api.parameter.ParameterEvaluatorService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kim.api.identity.Person;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.maintenance.MaintenanceLock;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetDepreciationConvention;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetOrganization;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.businessobject.defaultvalue.NextAssetNumberFinder;
import org.kuali.kfs.module.cam.document.gl.AssetGlobalGeneralLedgerPendingEntrySource;
import org.kuali.kfs.module.cam.document.service.AssetDateService;
import org.kuali.kfs.module.cam.document.service.AssetGlobalService;
import org.kuali.kfs.module.cam.document.validation.impl.AssetGlobalRule;
import org.kuali.kfs.module.cam.util.KualiDecimalUtils;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.LedgerPostingMaintainable;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public class AssetGlobalMaintainableImpl
extends LedgerPostingMaintainable {
    private static final Logger LOG = LogManager.getLogger();
    protected static volatile AssetDateService assetDateService;
    protected static volatile AssetGlobalService assetGlobalService;
    protected static volatile ObjectCodeService objectCodeService;
    protected static final String REQUIRES_REVIEW = "RequiresReview";

    public List getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        for (Section section : sections) {
            if (!section.getSectionId().equalsIgnoreCase("Accounting Period") || this.isAuthorizedToEditFiscalPeriod((Document)document)) continue;
            section.setReadOnly(true);
        }
        return sections;
    }

    private boolean isAuthorizedToEditFiscalPeriod(Document document) {
        Person user = GlobalVariables.getUserSession().getPerson();
        return this.getDocumentDictionaryService().getDocumentAuthorizer(document).isAuthorized((Object)document, "KFS-SYS", "Edit Accounting Period", user.getPrincipalId());
    }

    public List<String> getWorkflowEngineDocumentIdsToLock() {
        String poDocId;
        AssetGlobal assetGlobal = (AssetGlobal)this.getBusinessObject();
        if (ObjectUtils.isNotNull((Object)((Object)assetGlobal)) && assetGlobal.isCapitalAssetBuilderOriginIndicator() && StringUtils.isNotBlank((CharSequence)(poDocId = ((CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class)).getCurrentPurchaseOrderDocumentNumber(this.getDocumentNumber())))) {
            ArrayList<String> documentIds = new ArrayList<String>();
            documentIds.add(poDocId);
            return documentIds;
        }
        return null;
    }

    protected boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (REQUIRES_REVIEW.equals(nodeName)) {
            return !this.isAccountAndOrganizationReviewRequired();
        }
        throw new UnsupportedOperationException("Cannot answer split question for this node you call \"" + nodeName + "\"");
    }

    protected boolean isAccountAndOrganizationReviewRequired() {
        return ((AssetGlobal)this.getBusinessObject()).isCapitalAssetBuilderOriginIndicator();
    }

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> parameters) {
        AssetGlobal assetGlobal = (AssetGlobal)this.getBusinessObject();
        this.setSeparateSourceCapitalAssetParameters(assetGlobal, parameters);
        this.setFinancialDocumentTypeCode(assetGlobal, parameters);
        if (this.getAssetGlobalService().isAssetSeparate(assetGlobal)) {
            Asset asset = this.getAsset(assetGlobal);
            AssetOrganization assetOrganization = this.getAssetOrganization(assetGlobal);
            this.populateAssetSeparateAssetDetails(assetGlobal, asset, assetOrganization);
            this.populateAssetSeparatePaymentDetails(assetGlobal, asset);
            this.populateAssetLocationTabInformation(asset);
            AssetGlobalRule.validateAssetTotalCostMatchesPaymentTotalCost(assetGlobal);
            if (this.getAssetGlobalService().isAssetSeparateByPayment(assetGlobal)) {
                AssetGlobalRule.validateAssetAlreadySeparated(assetGlobal.getSeparateSourceCapitalAssetNumber());
            }
            document.getDocumentHeader().setDocumentDescription("Separate an Asset");
        }
        super.processAfterNew(document, parameters);
    }

    public void setGenerateDefaultValues(String docTypeName) {
    }

    public void setupNewFromExisting(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.setupNewFromExisting(document, parameters);
        AssetGlobal assetGlobal = (AssetGlobal)this.getBusinessObject();
        if (this.isFiscalPeriodEditable(document) && this.isPeriod13(assetGlobal)) {
            Integer closingYear = Integer.valueOf(this.getParameterService().getParameterValueAsString(KfsParameterConstants.GENERAL_LEDGER_BATCH.class, "ANNUAL_CLOSING_FISCAL_YEAR"));
            String closingDate = this.getClosingDate(closingYear);
            try {
                this.updateAssetGlobalForPeriod13(assetGlobal, closingYear, closingDate);
                assetGlobal.refreshNonUpdateableReferences();
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        assetGlobal.setLastInventoryDate(this.getDateTimeService().getCurrentSqlDate());
    }

    private boolean isFiscalPeriodEditable(MaintenanceDocument document) {
        String docType = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        ParameterEvaluatorService parameterEvaluatorService = (ParameterEvaluatorService)SpringContext.getBean(ParameterEvaluatorService.class);
        ParameterEvaluator evaluator = parameterEvaluatorService.getParameterEvaluator("KFS-SYS", "Document", "FISCAL_PERIOD_SELECTION_DOCUMENT_TYPES", docType);
        return evaluator.evaluationSucceeds();
    }

    protected Asset getAsset(AssetGlobal assetGlobal) {
        return (Asset)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findBySinglePrimaryKey(Asset.class, (Object)assetGlobal.getSeparateSourceCapitalAssetNumber());
    }

    protected AssetOrganization getAssetOrganization(AssetGlobal assetGlobal) {
        return (AssetOrganization)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findBySinglePrimaryKey(AssetOrganization.class, (Object)assetGlobal.getSeparateSourceCapitalAssetNumber());
    }

    protected void populateAssetSeparateAssetDetails(AssetGlobal assetGlobal, Asset asset, AssetOrganization assetOrganization) {
        assetGlobal.setOrganizationOwnerAccountNumber(asset.getOrganizationOwnerAccountNumber());
        assetGlobal.setOrganizationOwnerChartOfAccountsCode(asset.getOrganizationOwnerChartOfAccountsCode());
        assetGlobal.setAgencyNumber(asset.getAgencyNumber());
        assetGlobal.setAcquisitionTypeCode(asset.getAcquisitionTypeCode());
        assetGlobal.setInventoryStatusCode(asset.getInventoryStatusCode());
        assetGlobal.setConditionCode(asset.getConditionCode());
        assetGlobal.setCapitalAssetDescription(asset.getCapitalAssetDescription());
        assetGlobal.setCapitalAssetTypeCode(asset.getCapitalAssetTypeCode());
        assetGlobal.setVendorName(asset.getVendorName());
        assetGlobal.setManufacturerName(asset.getManufacturerName());
        assetGlobal.setManufacturerModelNumber(asset.getManufacturerModelNumber());
        if (ObjectUtils.isNotNull((Object)((Object)assetOrganization))) {
            assetGlobal.setOrganizationText(assetOrganization.getOrganizationText());
        }
        if (asset.getLastInventoryDate() == null) {
            assetGlobal.setLastInventoryDate(this.getDateTimeService().getCurrentSqlDate());
        } else {
            assetGlobal.setLastInventoryDate(new Date(asset.getLastInventoryDate().getTime()));
        }
        assetGlobal.setCreateDate(asset.getCreateDate());
        assetGlobal.setCapitalAssetInServiceDate(asset.getCapitalAssetInServiceDate());
        assetGlobal.setCapitalAssetDepreciationDate(asset.getDepreciationDate());
        assetGlobal.setLandCountyName(asset.getLandCountyName());
        assetGlobal.setLandAcreageSize(asset.getLandAcreageSize());
        assetGlobal.setLandParcelNumber(asset.getLandParcelNumber());
        this.doPeriod13Changes(assetGlobal);
        this.refreshReferenceObject(assetGlobal, "organizationOwnerAccount");
    }

    protected void refreshReferenceObject(PersistableBusinessObjectBase persistableBusinessObject, String referenceObjectName) {
        persistableBusinessObject.refreshReferenceObject(referenceObjectName);
    }

    private void populateAssetSeparatePaymentDetails(AssetGlobal assetGlobal, Asset asset) {
        assetGlobal.getAssetPaymentDetails().clear();
        List<AssetPaymentDetail> newAssetPaymentDetailList = assetGlobal.getAssetPaymentDetails();
        if (!this.getAssetGlobalService().isAssetSeparateByPayment(assetGlobal)) {
            for (AssetPayment assetPayment : asset.getAssetPayments()) {
                AssetPaymentDetail assetPaymentDetail = new AssetPaymentDetail(assetPayment);
                newAssetPaymentDetailList.add(assetPaymentDetail);
            }
            assetGlobal.setTotalCostAmount(asset.getTotalCostAmount());
            assetGlobal.setSeparateSourceRemainingAmount(asset.getTotalCostAmount());
        } else {
            for (AssetPayment assetPayment : asset.getAssetPayments()) {
                if (!assetPayment.getPaymentSequenceNumber().equals(assetGlobal.getSeparateSourcePaymentSequenceNumber())) continue;
                AssetPaymentDetail assetPaymentDetail = new AssetPaymentDetail(assetPayment);
                newAssetPaymentDetailList.add(assetPaymentDetail);
                assetGlobal.setTotalCostAmount(assetPayment.getAccountChargeAmount());
                assetGlobal.setSeparateSourceRemainingAmount(assetPayment.getAccountChargeAmount());
                break;
            }
        }
        assetGlobal.setSeparateSourceTotalAmount(KualiDecimal.ZERO);
        assetGlobal.setAssetPaymentDetails(newAssetPaymentDetailList);
    }

    private void setSeparateSourceCapitalAssetParameters(AssetGlobal assetGlobal, Map<String, String[]> parameters) {
        String[] separateSourcePaymentSequenceNumber;
        String[] separateSourceCapitalAssetNumber = parameters.get("separateSourceCapitalAssetNumber");
        if (separateSourceCapitalAssetNumber != null) {
            assetGlobal.setSeparateSourceCapitalAssetNumber(Long.parseLong(separateSourceCapitalAssetNumber[0]));
        }
        if ((separateSourcePaymentSequenceNumber = parameters.get("separateSourcePaymentSequenceNumber")) != null) {
            assetGlobal.setSeparateSourcePaymentSequenceNumber(Integer.parseInt(separateSourcePaymentSequenceNumber[0]));
        }
    }

    private void setFinancialDocumentTypeCode(AssetGlobal assetGlobal, Map<String, String[]> parameters) {
        String[] financialDocumentTypeCode = parameters.get("financialDocumentTypeCode");
        if (financialDocumentTypeCode != null) {
            assetGlobal.setFinancialDocumentTypeCode(financialDocumentTypeCode[0]);
        }
    }

    public void addNewLineToCollection(String collectionName) {
        int sharedDetailsIndex;
        AssetGlobal assetGlobal = (AssetGlobal)this.getBusinessObject();
        if ("assetPaymentDetails".equalsIgnoreCase(collectionName)) {
            this.handAssetPaymentsCollection(collectionName, assetGlobal);
        }
        if ("assetSharedDetails".equalsIgnoreCase(collectionName)) {
            this.handleAssetSharedDetailsCollection(collectionName, assetGlobal);
        }
        if ((sharedDetailsIndex = assetGlobal.getAssetSharedDetails().size() - 1) > -1 && ("assetSharedDetails[" + sharedDetailsIndex + "].assetGlobalUniqueDetails").equalsIgnoreCase(collectionName)) {
            this.handleAssetUniqueCollection(collectionName, assetGlobal);
        }
        super.addNewLineToCollection(collectionName);
    }

    private void handleAssetUniqueCollection(String collectionName, AssetGlobal assetGlobal) {
        AssetGlobalDetail assetGlobalDetail = (AssetGlobalDetail)((Object)this.newCollectionLines.get(collectionName));
        if (ObjectUtils.isNotNull((Object)((Object)assetGlobalDetail))) {
            assetGlobalDetail.setCapitalAssetNumber(NextAssetNumberFinder.getLongValue());
            if (ObjectUtils.isNotNull((Object)((Object)assetGlobal)) && this.getAssetGlobalService().isAssetSeparate(assetGlobal)) {
                if (assetGlobalDetail.getCapitalAssetTypeCode() == null) {
                    assetGlobalDetail.setCapitalAssetTypeCode(assetGlobal.getCapitalAssetTypeCode());
                }
                if (assetGlobalDetail.getCapitalAssetDescription() == null) {
                    assetGlobalDetail.setCapitalAssetDescription(assetGlobal.getCapitalAssetDescription());
                }
                if (assetGlobalDetail.getManufacturerName() == null) {
                    assetGlobalDetail.setManufacturerName(assetGlobal.getManufacturerName());
                }
                if (assetGlobalDetail.getSeparateSourceAmount() == null) {
                    assetGlobalDetail.setSeparateSourceAmount(KualiDecimal.ZERO);
                }
            }
        }
    }

    private void handleAssetSharedDetailsCollection(String collectionName, AssetGlobal assetGlobal) {
        AssetGlobalDetail assetGlobalDetail = (AssetGlobalDetail)((Object)this.newCollectionLines.get(collectionName));
        Integer locationQuantity = assetGlobalDetail.getLocationQuantity();
        while (locationQuantity != null && locationQuantity > 0) {
            AssetGlobalDetail newAssetUnique = new AssetGlobalDetail();
            newAssetUnique.setCapitalAssetNumber(NextAssetNumberFinder.getLongValue());
            if (this.getAssetGlobalService().isAssetSeparate(assetGlobal)) {
                newAssetUnique.setCapitalAssetTypeCode(assetGlobal.getCapitalAssetTypeCode());
                newAssetUnique.setCapitalAssetDescription(assetGlobal.getCapitalAssetDescription());
                newAssetUnique.setManufacturerName(assetGlobal.getManufacturerName());
                newAssetUnique.setOrganizationInventoryName(this.getAsset(assetGlobal).getOrganizationInventoryName());
                newAssetUnique.setSeparateSourceAmount(KualiDecimal.ZERO);
            }
            assetGlobalDetail.getAssetGlobalUniqueDetails().add(newAssetUnique);
            newAssetUnique.setNewCollectionRecord(true);
            Integer n = locationQuantity;
            Integer n2 = locationQuantity = Integer.valueOf(locationQuantity - 1);
        }
    }

    private void handAssetPaymentsCollection(String collectionName, AssetGlobal assetGlobal) {
        AssetPaymentDetail assetPaymentDetail = (AssetPaymentDetail)((Object)this.newCollectionLines.get(collectionName));
        if (assetPaymentDetail != null) {
            assetPaymentDetail.setSequenceNumber(assetGlobal.incrementFinancialDocumentLineNumber());
            if (this.getAssetGlobalService().existsInGroup(this.getAssetGlobalService().getNonNewAcquisitionCodeGroup(), assetGlobal.getAcquisitionTypeCode())) {
                assetPaymentDetail.setExpenditureFinancialDocumentNumber(this.getDocumentNumber());
                assetPaymentDetail.setExpenditureFinancialDocumentTypeCode("AA");
                assetPaymentDetail.setExpenditureFinancialSystemOriginationCode("01");
            }
            assetPaymentDetail.setPostingPeriodCode(assetGlobal.getFinancialDocumentPostingPeriodCode());
            assetPaymentDetail.setPostingYear(assetGlobal.getFinancialDocumentPostingYear());
        }
    }

    public List<MaintenanceLock> generateMaintenanceLocks() {
        return new ArrayList<MaintenanceLock>();
    }

    protected CapitalAssetManagementModuleService getCapitalAssetManagementModuleService() {
        return (CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class);
    }

    public void prepareForSave() {
        super.prepareForSave();
        AssetGlobal assetGlobal = (AssetGlobal)this.getBusinessObject();
        if (StringUtils.isNotBlank((CharSequence)assetGlobal.getAccountingPeriodCompositeString())) {
            assetGlobal.setFinancialDocumentPostingPeriodCode(StringUtils.left((String)assetGlobal.getAccountingPeriodCompositeString(), (int)2));
            assetGlobal.setFinancialDocumentPostingYear(Integer.valueOf(StringUtils.right((String)assetGlobal.getAccountingPeriodCompositeString(), (int)4)));
        }
        List<AssetGlobalDetail> assetSharedDetails = assetGlobal.getAssetSharedDetails();
        ArrayList<AssetGlobalDetail> newDetails = new ArrayList<AssetGlobalDetail>();
        if (!assetSharedDetails.isEmpty() && !assetSharedDetails.get(0).getAssetGlobalUniqueDetails().isEmpty()) {
            for (AssetGlobalDetail locationDetail : assetSharedDetails) {
                List<AssetGlobalDetail> assetGlobalUniqueDetails = locationDetail.getAssetGlobalUniqueDetails();
                for (AssetGlobalDetail detail : assetGlobalUniqueDetails) {
                    if (ObjectUtils.isNotNull((Object)locationDetail.getCampusCode())) {
                        detail.setCampusCode(locationDetail.getCampusCode().toUpperCase(Locale.US));
                    } else {
                        detail.setCampusCode(locationDetail.getCampusCode());
                    }
                    if (ObjectUtils.isNotNull((Object)locationDetail.getBuildingCode())) {
                        detail.setBuildingCode(locationDetail.getBuildingCode().toUpperCase(Locale.US));
                    } else {
                        detail.setBuildingCode(locationDetail.getBuildingCode());
                    }
                    detail.setBuildingRoomNumber(locationDetail.getBuildingRoomNumber());
                    detail.setBuildingSubRoomNumber(locationDetail.getBuildingSubRoomNumber());
                    detail.setOffCampusName(locationDetail.getOffCampusName());
                    detail.setOffCampusAddress(locationDetail.getOffCampusAddress());
                    detail.setOffCampusCityName(locationDetail.getOffCampusCityName());
                    detail.setOffCampusStateCode(locationDetail.getOffCampusStateCode());
                    detail.setOffCampusCountryCode(locationDetail.getOffCampusCountryCode());
                    detail.setOffCampusZipCode(locationDetail.getOffCampusZipCode());
                    newDetails.add(detail);
                }
            }
        }
        if (assetGlobal.getCapitalAssetTypeCode() != null) {
            this.refreshReferenceObject(assetGlobal, "capitalAssetType");
            AssetType capitalAssetType = assetGlobal.getCapitalAssetType();
            if (ObjectUtils.isNotNull((Object)((Object)capitalAssetType))) {
                if (!this.getAssetGlobalService().isAssetSeparate(assetGlobal)) {
                    if (capitalAssetType.getDepreciableLifeLimit() != null && capitalAssetType.getDepreciableLifeLimit() != 0) {
                        assetGlobal.setCapitalAssetInServiceDate(assetGlobal.getCreateDate() == null ? this.getDateTimeService().getCurrentSqlDate() : assetGlobal.getCreateDate());
                    } else {
                        assetGlobal.setCapitalAssetInServiceDate(null);
                    }
                    this.computeDepreciationDate(assetGlobal);
                }
                this.doPeriod13Changes(assetGlobal);
            }
        }
        assetGlobal.getAssetGlobalDetails().clear();
        assetGlobal.getAssetGlobalDetails().addAll(newDetails);
    }

    private void computeDepreciationDate(AssetGlobal assetGlobal) {
        List<AssetPaymentDetail> assetPaymentDetails = assetGlobal.getAssetPaymentDetails();
        if (assetPaymentDetails != null && !assetPaymentDetails.isEmpty()) {
            LOG.debug("Compute depreciation date based on asset type, depreciation convention and in-service date");
            AssetPaymentDetail firstAssetPaymentDetail = assetPaymentDetails.get(0);
            ObjectCode objectCode = this.getObjectCodeService().getByPrimaryId(firstAssetPaymentDetail.getPostingYear(), firstAssetPaymentDetail.getChartOfAccountsCode(), firstAssetPaymentDetail.getFinancialObjectCode());
            if (ObjectUtils.isNotNull((Object)objectCode)) {
                HashMap<String, String> primaryKeys = new HashMap<String, String>();
                primaryKeys.put("financialObjectSubTypeCode", objectCode.getFinancialObjectSubTypeCode());
                AssetDepreciationConvention depreciationConvention = (AssetDepreciationConvention)this.getBusinessObjectService().findByPrimaryKey(AssetDepreciationConvention.class, primaryKeys);
                Date depreciationDate = this.getAssetDateService().computeDepreciationDate(assetGlobal.getCapitalAssetType(), depreciationConvention, assetGlobal.getCapitalAssetInServiceDate());
                assetGlobal.setCapitalAssetDepreciationDate(depreciationDate);
            }
        }
    }

    public void processAfterRetrieve() {
        super.processAfterRetrieve();
        AssetGlobal assetGlobal = (AssetGlobal)this.getBusinessObject();
        assetGlobal.refresh();
        this.refreshReferenceObject(assetGlobal, "separateSourceCapitalAsset");
        if (ObjectUtils.isNotNull((Object)((Object)assetGlobal.getSeparateSourceCapitalAsset())) && ObjectUtils.isNotNull((Object)assetGlobal.getSeparateSourceCapitalAsset().getLastInventoryDate())) {
            assetGlobal.setLastInventoryDate(new Date(assetGlobal.getSeparateSourceCapitalAsset().getLastInventoryDate().getTime()));
            this.doPeriod13Changes(assetGlobal);
        } else {
            assetGlobal.setLastInventoryDate(this.getDateTimeService().getCurrentSqlDate());
            this.doPeriod13Changes(assetGlobal);
        }
        List<AssetGlobalDetail> assetGlobalDetails = assetGlobal.getAssetGlobalDetails();
        HashMap<String, AssetGlobalDetail> locationMap = new HashMap<String, AssetGlobalDetail>();
        for (AssetGlobalDetail detail : assetGlobalDetails) {
            AssetGlobalDetail copyValue = (AssetGlobalDetail)((Object)ObjectUtils.deepCopy((Serializable)((Object)detail)));
            copyValue.getAssetGlobalUniqueDetails().clear();
            String key = this.generateLocationKey(copyValue);
            AssetGlobalDetail currLocationDetail = (AssetGlobalDetail)((Object)locationMap.get(key));
            if (currLocationDetail == null) {
                currLocationDetail = copyValue;
                locationMap.put(key, currLocationDetail);
            }
            currLocationDetail.getAssetGlobalUniqueDetails().add(copyValue);
            currLocationDetail.setLocationQuantity(currLocationDetail.getAssetGlobalUniqueDetails().size());
        }
        assetGlobal.getAssetSharedDetails().clear();
        assetGlobal.getAssetSharedDetails().addAll(locationMap.values());
        this.setAssetTotalAmountFromPersistence(assetGlobal);
    }

    private void setAssetTotalAmountFromPersistence(AssetGlobal assetGlobal) {
        KualiDecimal maxAssetTotalAmount;
        KualiDecimal minAssetTotalAmount = this.getAssetGlobalService().totalPaymentByAsset(assetGlobal, false);
        if (minAssetTotalAmount.isGreaterThan((AbstractKualiDecimal)(maxAssetTotalAmount = this.getAssetGlobalService().totalPaymentByAsset(assetGlobal, true)))) {
            KualiDecimal totalPayment = minAssetTotalAmount;
            minAssetTotalAmount = maxAssetTotalAmount;
            maxAssetTotalAmount = totalPayment;
        }
        assetGlobal.setMinAssetTotalAmount(minAssetTotalAmount);
        assetGlobal.setMaxAssetTotalAmount(maxAssetTotalAmount);
    }

    private String generateLocationKey(AssetGlobalDetail location) {
        return (location.getCampusCode() == null ? "" : location.getCampusCode().trim().toLowerCase(Locale.US)) + (location.getBuildingCode() == null ? "" : location.getBuildingCode().trim().toLowerCase(Locale.US)) + (location.getBuildingRoomNumber() == null ? "" : location.getBuildingRoomNumber().trim().toLowerCase(Locale.US)) + (location.getBuildingSubRoomNumber() == null ? "" : location.getBuildingSubRoomNumber().trim().toLowerCase(Locale.US)) + (location.getOffCampusName() == null ? "" : location.getOffCampusName().trim().toLowerCase(Locale.US)) + (location.getOffCampusAddress() == null ? "" : location.getOffCampusAddress().trim().toLowerCase(Locale.US)) + (location.getOffCampusCityName() == null ? "" : location.getOffCampusCityName().trim().toLowerCase(Locale.US)) + (location.getOffCampusStateCode() == null ? "" : location.getOffCampusStateCode().trim().toLowerCase(Locale.US)) + (location.getOffCampusZipCode() == null ? "" : location.getOffCampusZipCode().trim().toLowerCase(Locale.US)) + (location.getOffCampusCountryCode() == null ? "" : location.getOffCampusCountryCode().trim().toLowerCase(Locale.US));
    }

    public void processAfterPost(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterPost(document, parameters);
        AssetGlobal assetGlobal = (AssetGlobal)this.getBusinessObject();
        List<AssetGlobalDetail> sharedDetailsList = assetGlobal.getAssetSharedDetails();
        int locationQtyTotal = 0;
        if (!sharedDetailsList.isEmpty()) {
            for (AssetGlobalDetail sharedDetail : sharedDetailsList) {
                sharedDetail.setLocationQuantity(sharedDetail.getAssetGlobalUniqueDetails().size());
                locationQtyTotal += sharedDetail.getLocationQuantity().intValue();
            }
        }
        if (this.getAssetGlobalService().isAssetSeparate(assetGlobal) && sharedDetailsList.size() >= 1) {
            String[] customAction = parameters.get("customAction");
            if (customAction != null && "calculateEqualSourceAmountsButton".equals(customAction[0])) {
                KualiDecimal[] equalSourceAmountsArray = KualiDecimalUtils.allocateByQuantity(assetGlobal.getTotalCostAmount(), locationQtyTotal + 1);
                this.setEqualSeparateSourceAmounts(equalSourceAmountsArray, assetGlobal);
                this.recalculateTotalAmount(assetGlobal);
            }
            this.recalculateTotalAmount(assetGlobal);
        }
    }

    protected void recalculateTotalAmount(AssetGlobal assetGlobal) {
        assetGlobal.setSeparateSourceTotalAmount(this.getAssetGlobalService().getUniqueAssetsTotalAmount(assetGlobal));
        assetGlobal.setSeparateSourceRemainingAmount((KualiDecimal)assetGlobal.getTotalCostAmount().subtract((AbstractKualiDecimal)this.getAssetGlobalService().getUniqueAssetsTotalAmount(assetGlobal)));
    }

    public void setEqualSeparateSourceAmounts(KualiDecimal[] equalSourceAmountsArray, AssetGlobal assetGlobal) {
        int i = 0;
        for (AssetGlobalDetail assetSharedDetail : assetGlobal.getAssetSharedDetails()) {
            for (AssetGlobalDetail assetGlobalUniqueDetail : assetSharedDetail.getAssetGlobalUniqueDetails()) {
                assetGlobalUniqueDetail.setSeparateSourceAmount(equalSourceAmountsArray[i]);
                ++i;
            }
        }
    }

    public void doRouteStatusChange(DocumentHeader documentHeader) {
        AssetGlobalService assetGlobalService;
        super.doRouteStatusChange(documentHeader);
        AssetGlobal assetGlobal = (AssetGlobal)this.getBusinessObject();
        List<GeneralLedgerPendingEntry> generalLedgerPendingEntries = assetGlobal.getGeneralLedgerPendingEntries();
        new AssetGlobalGeneralLedgerPendingEntrySource(documentHeader).doRouteStatusChange(generalLedgerPendingEntries);
        WorkflowDocument workflowDoc = documentHeader.getWorkflowDocument();
        if (workflowDoc.isCanceled() && ObjectUtils.isNotNull((Object)((Object)assetGlobal))) {
            List<AssetGlobalDetail> assetGlobalDetailsList = assetGlobal.getAssetGlobalDetails();
            for (AssetGlobalDetail assetGlobalDetails : assetGlobalDetailsList) {
                ((CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class)).reactivatePretagDetails(assetGlobalDetails.getCampusTagNumber());
            }
        }
        if ((assetGlobalService = (AssetGlobalService)SpringContext.getBean(AssetGlobalService.class)).isAssetSeparate(assetGlobal) && (workflowDoc.isCanceled() || workflowDoc.isDisapproved() || workflowDoc.isProcessed())) {
            this.getCapitalAssetManagementModuleService().deleteAssetLocks(this.getDocumentNumber(), null);
        }
        if (((AssetGlobal)this.getBusinessObject()).isCapitalAssetBuilderOriginIndicator()) {
            ((CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class)).notifyRouteStatusChange(documentHeader);
        }
    }

    public Class<? extends PersistableBusinessObject> getPrimaryEditedBusinessObjectClass() {
        return Asset.class;
    }

    private void populateAssetLocationTabInformation(Asset asset) {
        AssetGlobalDetail assetSharedDetail = (AssetGlobalDetail)this.getNewCollectionLine("assetSharedDetails");
        assetSharedDetail.setCampusCode(asset.getCampusCode());
        assetSharedDetail.setBuildingCode(asset.getBuildingCode());
        assetSharedDetail.setBuildingRoomNumber(asset.getBuildingRoomNumber());
    }

    private boolean isPeriod13(AssetGlobal assetGlobal) {
        if (ObjectUtils.isNull((Object)assetGlobal.getAccountingPeriod())) {
            return false;
        }
        return "13".equals(assetGlobal.getAccountingPeriod().getUniversityFiscalPeriodCode());
    }

    private String getClosingDate(Integer closingYear) {
        return this.getAssetGlobalService().getFiscalYearEndDayAndMonth() + closingYear.toString();
    }

    private String getClosingCalendarDate(Integer closingYear) {
        return "01/01/" + closingYear.toString();
    }

    private DateTimeService getDateTimeService() {
        return (DateTimeService)SpringContext.getBean(DateTimeService.class);
    }

    private void doPeriod13Changes(AssetGlobal assetGlobal) {
        if (this.isPeriod13(assetGlobal)) {
            Integer closingYear = Integer.valueOf(this.getParameterService().getParameterValueAsString(KfsParameterConstants.GENERAL_LEDGER_BATCH.class, "ANNUAL_CLOSING_FISCAL_YEAR"));
            String closingDate = this.getClosingDate(closingYear);
            try {
                this.updateAssetGlobalForPeriod13(assetGlobal, closingYear, closingDate);
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
    }

    private void updateAssetGlobalForPeriod13(AssetGlobal assetGlobal, Integer closingYear, String closingDate) throws ParseException {
        assetGlobal.setCreateDate(this.getDateTimeService().getCurrentSqlDate());
        assetGlobal.setCapitalAssetInServiceDate(this.getDateTimeService().convertToSqlDate(closingDate));
        assetGlobal.setCreateDate(this.getDateTimeService().convertToSqlDate(closingDate));
        assetGlobal.setCapitalAssetDepreciationDate(this.getDateTimeService().convertToSqlDate(this.getClosingCalendarDate(closingYear)));
        assetGlobal.setLastInventoryDate(this.getDateTimeService().getCurrentSqlDate());
    }

    protected void populateChartOfAccountsCodeFields() {
        super.populateChartOfAccountsCodeFields();
        AccountService acctService = (AccountService)SpringContext.getBean(AccountService.class);
        PersistableBusinessObject newAccount = this.getNewCollectionLine("assetPaymentDetails");
        String accountNumber = (String)ObjectUtils.getPropertyValue((Object)newAccount, (String)"accountNumber");
        String coaCode = null;
        Account account = acctService.getUniqueAccountForAccountNumber(accountNumber);
        if (ObjectUtils.isNotNull((Object)account)) {
            coaCode = account.getChartOfAccountsCode();
        }
        try {
            ObjectUtils.setObjectProperty((Object)newAccount, (String)"chartOfAccountsCode", (Object)coaCode);
        }
        catch (Exception e) {
            LOG.error("Error in setting property value for chartOfAccountsCode");
        }
    }

    public AssetDateService getAssetDateService() {
        if (assetDateService == null) {
            assetDateService = (AssetDateService)SpringContext.getBean(AssetDateService.class);
        }
        return assetDateService;
    }

    public void setAssetDateService(AssetDateService assetDateService) {
        AssetGlobalMaintainableImpl.assetDateService = assetDateService;
    }

    public AssetGlobalService getAssetGlobalService() {
        if (assetGlobalService == null) {
            assetGlobalService = (AssetGlobalService)SpringContext.getBean(AssetGlobalService.class);
        }
        return assetGlobalService;
    }

    public void setAssetGlobalService(AssetGlobalService assetGlobalService) {
        AssetGlobalMaintainableImpl.assetGlobalService = assetGlobalService;
    }

    private ObjectCodeService getObjectCodeService() {
        if (objectCodeService == null) {
            objectCodeService = (ObjectCodeService)SpringContext.getBean(ObjectCodeService.class);
        }
        return objectCodeService;
    }

    public void setObjectCodeService(ObjectCodeService objectCodeService) {
        AssetGlobalMaintainableImpl.objectCodeService = objectCodeService;
    }

    private ParameterService getParameterService() {
        return (ParameterService)SpringContext.getBean(ParameterService.class);
    }
}

