/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.gl;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.UniversityDateService;

public abstract class CamsGeneralLedgerPendingEntrySourceBase
implements GeneralLedgerPendingEntrySource {
    private List<GeneralLedgerPendingEntry> pendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
    private DocumentHeader documentHeader;
    private List<GeneralLedgerPendingEntrySourceDetail> postables = new ArrayList<GeneralLedgerPendingEntrySourceDetail>();
    private String postingPeriodCode;
    private Integer postingYear;

    public CamsGeneralLedgerPendingEntrySourceBase(DocumentHeader documentHeader) {
        this.documentHeader = documentHeader;
    }

    public void addPendingEntry(GeneralLedgerPendingEntry entry) {
        this.pendingEntries.add(entry);
    }

    public void clearAnyGeneralLedgerPendingEntries() {
        this.pendingEntries.clear();
    }

    public void customizeExplicitGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail postable, GeneralLedgerPendingEntry explicitEntry) {
    }

    public boolean generateDocumentGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        return true;
    }

    public DocumentHeader getDocumentHeader() {
        return this.documentHeader;
    }

    public KualiDecimal getGeneralLedgerPendingEntryAmountForDetail(GeneralLedgerPendingEntrySourceDetail postable) {
        return (KualiDecimal)postable.getAmount().abs();
    }

    public List<GeneralLedgerPendingEntrySourceDetail> getGeneralLedgerPendingEntrySourceDetails() {
        return this.postables;
    }

    public Integer getPostingYear() {
        if (this.postingYear != null) {
            return this.postingYear;
        }
        return ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear();
    }

    public void setPostingYear(Integer postingYear) {
        this.postingYear = postingYear;
    }

    public String getPostingPeriodCode() {
        return this.postingPeriodCode;
    }

    public void setPostingPeriodCode(String postingPeriodCode) {
        this.postingPeriodCode = postingPeriodCode;
    }

    public List<GeneralLedgerPendingEntry> getPendingEntries() {
        return this.pendingEntries;
    }

    public void setPendingEntries(List<GeneralLedgerPendingEntry> pendingEntries) {
        this.pendingEntries = pendingEntries;
    }

    public List<GeneralLedgerPendingEntrySourceDetail> getPostables() {
        return this.postables;
    }

    public void setPostables(List<GeneralLedgerPendingEntrySourceDetail> postables) {
        this.postables = postables;
    }

    public void setDocumentHeader(DocumentHeader documentHeader) {
        this.documentHeader = documentHeader;
    }

    public void doRouteStatusChange(List<GeneralLedgerPendingEntry> glPendingEntries) {
        if (glPendingEntries == null || glPendingEntries.isEmpty()) {
            return;
        }
        if (this.documentHeader.getWorkflowDocument().isProcessed()) {
            for (GeneralLedgerPendingEntry glpe : glPendingEntries) {
                glpe.setFinancialDocumentApprovedCode("A");
            }
            ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save(glPendingEntries);
        } else if (this.getDocumentHeader().getWorkflowDocument().isCanceled() || this.documentHeader.getWorkflowDocument().isDisapproved()) {
            this.removeGeneralLedgerPendingEntries(this.documentHeader.getDocumentNumber());
        }
    }

    private void removeGeneralLedgerPendingEntries(String docNumber) {
        GeneralLedgerPendingEntryService glpeService = (GeneralLedgerPendingEntryService)SpringContext.getBean(GeneralLedgerPendingEntryService.class);
        glpeService.delete(docNumber);
    }

    public boolean generateGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySourceDetail postable, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        GeneralLedgerPendingEntry explicitEntry = new GeneralLedgerPendingEntry();
        ((GeneralLedgerPendingEntryService)SpringContext.getBean(GeneralLedgerPendingEntryService.class)).populateExplicitGeneralLedgerPendingEntry((GeneralLedgerPendingEntrySource)this, postable, sequenceHelper, explicitEntry);
        this.customizeExplicitGeneralLedgerPendingEntry(postable, explicitEntry);
        this.addPendingEntry(explicitEntry);
        return true;
    }
}

