/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.OffsetDefinition;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coa.service.OffsetDefinitionService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetGlpeSourceDetail;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.businessobject.AssetObjectCode;
import org.kuali.kfs.module.cam.businessobject.AssetOrganization;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.document.AssetTransferDocument;
import org.kuali.kfs.module.cam.document.service.AssetLocationService;
import org.kuali.kfs.module.cam.document.service.AssetObjectCodeService;
import org.kuali.kfs.module.cam.document.service.AssetPaymentService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.AssetTransferService;
import org.kuali.kfs.module.cam.util.ObjectValueUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.util.KfsDateUtils;

public class AssetTransferServiceImpl
implements AssetTransferService {
    private static final Logger LOG = LogManager.getLogger();
    private AssetService assetService;
    private UniversityDateService universityDateService;
    private BusinessObjectService businessObjectService;
    private AssetPaymentService assetPaymentService;
    private AssetObjectCodeService assetObjectCodeService;
    private DateTimeService dateTimeService;
    private AssetLocationService assetLocationService;

    protected AssetGlpeSourceDetail createAssetGlpePostable(AssetTransferDocument document, Account plantAccount, AssetPayment assetPayment, boolean isSource, AmountCategory amountCategory) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Start - createAssetGlpePostable (" + document.getDocumentNumber() + "-" + plantAccount.getAccountNumber() + ")");
        }
        AssetGlpeSourceDetail postable = new AssetGlpeSourceDetail();
        postable.setSource(isSource);
        postable.setAccount(plantAccount);
        postable.setAccountNumber(plantAccount.getAccountNumber());
        postable.setBalanceTypeCode("AC");
        String organizationOwnerChartOfAccountsCode = isSource ? document.getAsset().getOrganizationOwnerChartOfAccountsCode() : document.getOrganizationOwnerChartOfAccountsCode();
        ObjectCodeService objectCodeService = (ObjectCodeService)SpringContext.getBean(ObjectCodeService.class);
        ObjectCode objectCode = objectCodeService.getByPrimaryIdForCurrentYear(assetPayment.getChartOfAccountsCode(), assetPayment.getFinancialObjectCode());
        String plantChartOfAccountsCode = plantAccount.getChartOfAccountsCode();
        postable.setChartOfAccountsCode(plantChartOfAccountsCode);
        postable.setDocumentNumber(document.getDocumentNumber());
        postable.setPostingYear(this.getUniversityDateService().getCurrentUniversityDate().getUniversityFiscalYear());
        postable.setProjectCode(assetPayment.getProjectCode());
        postable.setOrganizationReferenceId(assetPayment.getOrganizationReferenceId());
        AssetObjectCode assetObjectCode = this.getAssetObjectCodeService().findAssetObjectCode(organizationOwnerChartOfAccountsCode, objectCode.getFinancialObjectSubTypeCode());
        OffsetDefinition offsetDefinition = ((OffsetDefinitionService)SpringContext.getBean(OffsetDefinitionService.class)).getByPrimaryId(this.getUniversityDateService().getCurrentFiscalYear(), organizationOwnerChartOfAccountsCode, "AT", "AC");
        amountCategory.setParams(postable, assetPayment, assetObjectCode, isSource, offsetDefinition);
        if (LOG.isDebugEnabled()) {
            LOG.debug("End - createAssetGlpePostable(" + document.getDocumentNumber() + "-" + plantAccount.getAccountNumber() + "-)");
        }
        return postable;
    }

    @Override
    public void createGLPostables(AssetTransferDocument document) {
        document.clearGlPostables();
        Asset asset = document.getAsset();
        if (this.getAssetService().isCapitalAsset(asset) && !asset.getAssetPayments().isEmpty()) {
            asset.refreshReferenceObject("organizationOwnerAccount");
            document.refreshReferenceObject("organizationOwnerAccount");
            boolean movableAsset = this.getAssetService().isAssetMovableCheckByPayment(asset);
            if (this.isGLPostable(document, asset, movableAsset)) {
                asset.refreshReferenceObject("assetPayments");
                List<AssetPayment> assetPayments = asset.getAssetPayments();
                this.createSourceGLPostables(document, assetPayments, movableAsset);
                this.createTargetGLPostables(document, assetPayments, movableAsset);
            }
        }
    }

    protected Integer createNewPayments(AssetTransferDocument document, List<PersistableBusinessObject> persistableObjects, List<AssetPayment> originalPayments, Integer maxSequence) {
        Integer maxSequenceNo = maxSequence;
        for (AssetPayment assetPayment : originalPayments) {
            if ("Y".equals(assetPayment.getTransferPaymentCode())) continue;
            try {
                if (maxSequenceNo == null) {
                    maxSequenceNo = ((AssetPaymentService)SpringContext.getBean(AssetPaymentService.class)).getMaxSequenceNumber(assetPayment.getCapitalAssetNumber());
                }
                AssetPayment newPayment = new AssetPayment();
                ObjectValueUtils.copySimpleProperties((Object)assetPayment, (Object)newPayment);
                maxSequenceNo = maxSequenceNo + 1;
                newPayment.setPaymentSequenceNumber(maxSequenceNo);
                newPayment.setAccountNumber(document.getOrganizationOwnerAccountNumber());
                newPayment.setChartOfAccountsCode(document.getOrganizationOwnerChartOfAccountsCode());
                newPayment.setSubAccountNumber(null);
                newPayment.setDocumentNumber(document.getDocumentNumber());
                newPayment.setFinancialDocumentTypeCode("AT");
                newPayment.setFinancialDocumentPostingDate(KfsDateUtils.convertToSqlDate((Date)this.dateTimeService.getCurrentDate()));
                newPayment.setFinancialDocumentPostingYear(this.getUniversityDateService().getCurrentUniversityDate().getUniversityFiscalYear());
                newPayment.setFinancialDocumentPostingPeriodCode(this.getUniversityDateService().getCurrentUniversityDate().getUniversityFiscalAccountingPeriod());
                this.getAssetPaymentService().adjustPaymentAmounts(newPayment, false, true);
                newPayment.setTransferPaymentCode("N");
                persistableObjects.add((PersistableBusinessObject)newPayment);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return maxSequenceNo;
    }

    protected Integer createOffsetPayments(AssetTransferDocument document, List<PersistableBusinessObject> persistableObjects, List<AssetPayment> originalPayments) {
        Integer maxSequenceNo = null;
        for (AssetPayment assetPayment : originalPayments) {
            if ("Y".equals(assetPayment.getTransferPaymentCode())) continue;
            try {
                if (maxSequenceNo == null) {
                    maxSequenceNo = ((AssetPaymentService)SpringContext.getBean(AssetPaymentService.class)).getMaxSequenceNumber(assetPayment.getCapitalAssetNumber());
                }
                AssetPayment offsetPayment = new AssetPayment();
                ObjectValueUtils.copySimpleProperties((Object)assetPayment, (Object)offsetPayment);
                offsetPayment.setDocumentNumber(document.getDocumentNumber());
                offsetPayment.setFinancialDocumentTypeCode("AT");
                offsetPayment.setFinancialDocumentPostingDate(KfsDateUtils.convertToSqlDate((Date)this.dateTimeService.getCurrentDate()));
                offsetPayment.setFinancialDocumentPostingYear(this.getUniversityDateService().getCurrentUniversityDate().getUniversityFiscalYear());
                offsetPayment.setFinancialDocumentPostingPeriodCode(this.getUniversityDateService().getCurrentUniversityDate().getUniversityFiscalAccountingPeriod());
                this.getAssetPaymentService().adjustPaymentAmounts(offsetPayment, true, true);
                offsetPayment.setTransferPaymentCode("Y");
                maxSequenceNo = maxSequenceNo + 1;
                offsetPayment.setPaymentSequenceNumber(maxSequenceNo);
                persistableObjects.add((PersistableBusinessObject)offsetPayment);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return maxSequenceNo;
    }

    protected void createSourceGLPostables(AssetTransferDocument document, List<AssetPayment> assetPayments, boolean movableAsset) {
        ObjectCodeService objectCodeService = (ObjectCodeService)SpringContext.getBean(ObjectCodeService.class);
        for (AssetPayment assetPayment : assetPayments) {
            ObjectCode objectCode;
            if (!this.getAssetPaymentService().isPaymentEligibleForGLPosting(assetPayment) || !ObjectUtils.isNotNull((Object)(objectCode = objectCodeService.getByPrimaryIdForCurrentYear(assetPayment.getChartOfAccountsCode(), assetPayment.getFinancialObjectCode())))) continue;
            Account paymentSrcPlantAcct = movableAsset ? assetPayment.getAccount().getOrganization().getOrganizationPlantAccount() : assetPayment.getAccount().getOrganization().getCampusPlantAccount();
            if (this.getAssetPaymentService().isPaymentEligibleForCapitalizationGLPosting(assetPayment)) {
                document.getSourceAssetGlpeSourceDetails().add(this.createAssetGlpePostable(document, paymentSrcPlantAcct, assetPayment, true, AmountCategory.CAPITALIZATION));
            }
            if (this.getAssetPaymentService().isPaymentEligibleForAccumDeprGLPosting(assetPayment)) {
                document.getSourceAssetGlpeSourceDetails().add(this.createAssetGlpePostable(document, paymentSrcPlantAcct, assetPayment, true, AmountCategory.ACCUM_DEPRECIATION));
            }
            if (!this.getAssetPaymentService().isPaymentEligibleForOffsetGLPosting(assetPayment)) continue;
            document.getSourceAssetGlpeSourceDetails().add(this.createAssetGlpePostable(document, paymentSrcPlantAcct, assetPayment, true, AmountCategory.OFFSET_AMOUNT));
        }
    }

    protected void createTargetGLPostables(AssetTransferDocument document, List<AssetPayment> assetPayments, boolean movableAsset) {
        Account targetPlantAcct = movableAsset ? document.getOrganizationOwnerAccount().getOrganization().getOrganizationPlantAccount() : document.getOrganizationOwnerAccount().getOrganization().getCampusPlantAccount();
        for (AssetPayment assetPayment : assetPayments) {
            if (!this.getAssetPaymentService().isPaymentEligibleForGLPosting(assetPayment)) continue;
            if (this.getAssetPaymentService().isPaymentEligibleForCapitalizationGLPosting(assetPayment)) {
                document.getTargetAssetGlpeSourceDetails().add(this.createAssetGlpePostable(document, targetPlantAcct, assetPayment, false, AmountCategory.CAPITALIZATION));
            }
            if (this.getAssetPaymentService().isPaymentEligibleForAccumDeprGLPosting(assetPayment)) {
                document.getTargetAssetGlpeSourceDetails().add(this.createAssetGlpePostable(document, targetPlantAcct, assetPayment, false, AmountCategory.ACCUM_DEPRECIATION));
            }
            if (!this.getAssetPaymentService().isPaymentEligibleForOffsetGLPosting(assetPayment)) continue;
            document.getTargetAssetGlpeSourceDetails().add(this.createAssetGlpePostable(document, targetPlantAcct, assetPayment, false, AmountCategory.OFFSET_AMOUNT));
        }
    }

    public AssetPaymentService getAssetPaymentService() {
        return this.assetPaymentService;
    }

    public AssetService getAssetService() {
        return this.assetService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public UniversityDateService getUniversityDateService() {
        return this.universityDateService;
    }

    protected boolean isGLPostable(AssetTransferDocument document, Asset asset, boolean movableAsset) {
        boolean isGLPostable = true;
        Account srcPlantAcct = null;
        if (ObjectUtils.isNotNull((Object)asset.getOrganizationOwnerAccount())) {
            srcPlantAcct = movableAsset ? asset.getOrganizationOwnerAccount().getOrganization().getOrganizationPlantAccount() : asset.getOrganizationOwnerAccount().getOrganization().getCampusPlantAccount();
        }
        if (ObjectUtils.isNull(srcPlantAcct)) {
            isGLPostable = false;
        }
        Account targetPlantAcct = null;
        if (ObjectUtils.isNotNull((Object)document.getOrganizationOwnerAccount())) {
            targetPlantAcct = movableAsset ? document.getOrganizationOwnerAccount().getOrganization().getOrganizationPlantAccount() : document.getOrganizationOwnerAccount().getOrganization().getCampusPlantAccount();
        }
        if (ObjectUtils.isNull(targetPlantAcct)) {
            isGLPostable = false;
        }
        return isGLPostable;
    }

    @Override
    public void saveApprovedChanges(AssetTransferDocument document) {
        ArrayList<PersistableBusinessObject> persistableObjects = new ArrayList<PersistableBusinessObject>();
        Asset saveAsset = new Asset();
        saveAsset.setCapitalAssetNumber(document.getCapitalAssetNumber());
        saveAsset = (Asset)this.getBusinessObjectService().retrieve((PersistableBusinessObject)saveAsset);
        this.saveAssetOwnerData(document, saveAsset);
        this.saveLocationChanges(document, saveAsset);
        this.saveOrganizationChanges(document, saveAsset);
        if (this.getAssetService().isCapitalAsset(saveAsset)) {
            if (ObjectUtils.isNull(saveAsset.getAssetPayments())) {
                saveAsset.refreshReferenceObject("assetPayments");
            }
            List<AssetPayment> originalPayments = saveAsset.getAssetPayments();
            Integer maxSequence = this.createOffsetPayments(document, persistableObjects, originalPayments);
            this.createNewPayments(document, persistableObjects, originalPayments, maxSequence);
            this.updateOriginalPayments(persistableObjects, originalPayments);
        }
        saveAsset.setTransferOfFundsFinancialDocumentNumber(document.getTransferOfFundsFinancialDocumentNumber());
        persistableObjects.add((PersistableBusinessObject)saveAsset);
        this.getBusinessObjectService().save(persistableObjects);
    }

    protected void saveAssetOwnerData(AssetTransferDocument document, Asset saveAsset) {
        saveAsset.setOrganizationOwnerAccountNumber(document.getOrganizationOwnerAccountNumber());
        saveAsset.setOrganizationOwnerChartOfAccountsCode(document.getOrganizationOwnerChartOfAccountsCode());
    }

    protected void saveLocationChanges(AssetTransferDocument document, Asset saveAsset) {
        saveAsset.setLastInventoryDate(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentTimestamp());
        saveAsset.setCampusCode(document.getCampusCode());
        saveAsset.setBuildingCode(document.getBuildingCode());
        saveAsset.setBuildingRoomNumber(document.getBuildingRoomNumber());
        saveAsset.setBuildingSubRoomNumber(document.getBuildingSubRoomNumber());
        AssetLocation offCampusLocation = null;
        if (StringUtils.isBlank((CharSequence)saveAsset.getBuildingCode()) && StringUtils.isBlank((CharSequence)saveAsset.getBuildingRoomNumber()) && StringUtils.isBlank((CharSequence)saveAsset.getBuildingSubRoomNumber())) {
            List<AssetLocation> originalLocations = saveAsset.getAssetLocations();
            for (AssetLocation assetLocation : originalLocations) {
                if (!"O".equals(assetLocation.getAssetLocationTypeCode())) continue;
                offCampusLocation = assetLocation;
                break;
            }
            if (ObjectUtils.isNull(offCampusLocation)) {
                offCampusLocation = new AssetLocation();
                offCampusLocation.setCapitalAssetNumber(saveAsset.getCapitalAssetNumber());
                offCampusLocation.setAssetLocationTypeCode("O");
                saveAsset.getAssetLocations().add(offCampusLocation);
            }
            offCampusLocation.setAssetLocationContactName(document.getOffCampusName());
            offCampusLocation.setAssetLocationState(document.getOffCampusState());
            offCampusLocation.setPostalZipCode(document.getPostalZipCode());
            offCampusLocation.setAssetLocationCountryCode(document.getOffCampusCountryCode());
            offCampusLocation.setAssetLocationStreetAddress(document.getOffCampusAddress());
            offCampusLocation.setAssetLocationCityName(document.getOffCampusCityName());
            offCampusLocation.setAssetLocationStateCode(document.getOffCampusStateCode());
            offCampusLocation.setAssetLocationZipCode(document.getOffCampusZipCode());
            if (this.getAssetLocationService().isOffCampusLocationEmpty(offCampusLocation)) {
                saveAsset.getAssetLocations().remove((Object)offCampusLocation);
            }
        } else {
            for (AssetLocation assetLocation : saveAsset.getAssetLocations()) {
                this.getBusinessObjectService().delete((PersistableBusinessObject)assetLocation);
            }
            saveAsset.getAssetLocations().clear();
            saveAsset.setOffCampusLocation(null);
        }
    }

    protected void saveOrganizationChanges(AssetTransferDocument document, Asset saveAsset) {
        if (ObjectUtils.isNull((Object)((Object)saveAsset.getAssetOrganization()))) {
            AssetOrganization assetOrganization = new AssetOrganization();
            assetOrganization.setCapitalAssetNumber(saveAsset.getCapitalAssetNumber());
            saveAsset.setAssetOrganization(assetOrganization);
        }
        saveAsset.setOrganizationInventoryName(document.getOrganizationInventoryName());
        saveAsset.setRepresentativeUniversalIdentifier(document.getRepresentativeUniversalIdentifier());
        saveAsset.getAssetOrganization().setOrganizationTagNumber(document.getOrganizationTagNumber());
        saveAsset.getAssetOrganization().setOrganizationText(document.getOrganizationText());
    }

    public void setAssetPaymentService(AssetPaymentService assetPaymentService) {
        this.assetPaymentService = assetPaymentService;
    }

    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    protected void updateOriginalPayments(List<PersistableBusinessObject> persistableObjects, List<AssetPayment> originalPayments) {
        for (AssetPayment assetPayment : originalPayments) {
            if ("Y".equals(assetPayment.getTransferPaymentCode())) continue;
            assetPayment.setTransferPaymentCode("Y");
            persistableObjects.add((PersistableBusinessObject)assetPayment);
        }
    }

    public AssetObjectCodeService getAssetObjectCodeService() {
        return this.assetObjectCodeService;
    }

    public void setAssetObjectCodeService(AssetObjectCodeService assetObjectCodeService) {
        this.assetObjectCodeService = assetObjectCodeService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public AssetLocationService getAssetLocationService() {
        return this.assetLocationService;
    }

    public void setAssetLocationService(AssetLocationService assetLocationService) {
        this.assetLocationService = assetLocationService;
    }

    protected static enum AmountCategory {
        CAPITALIZATION{

            @Override
            public void setParams(AssetGlpeSourceDetail postable, AssetPayment assetPayment, AssetObjectCode assetObjectCode, boolean isSource, OffsetDefinition offsetDefinition) {
                postable.setFinancialDocumentLineDescription((isSource ? "Reverse" : "Transfer") + " asset cost");
                postable.setAmount(assetPayment.getAccountChargeAmount());
                postable.setFinancialObjectCode(assetObjectCode.getCapitalizationFinancialObjectCode());
                postable.setObjectCode(assetObjectCode.getCapitalizationFinancialObject());
                postable.setCapitalization(true);
            }
        }
        ,
        ACCUM_DEPRECIATION{

            @Override
            public void setParams(AssetGlpeSourceDetail postable, AssetPayment assetPayment, AssetObjectCode assetObjectCode, boolean isSource, OffsetDefinition offsetDefinition) {
                postable.setFinancialDocumentLineDescription((isSource ? "Reverse" : "Transfer") + " accumulated depreciation");
                postable.setAmount(assetPayment.getAccumulatedPrimaryDepreciationAmount());
                postable.setFinancialObjectCode(assetObjectCode.getAccumulatedDepreciationFinancialObjectCode());
                postable.setObjectCode(assetObjectCode.getAccumulatedDepreciationFinancialObject());
                postable.setAccumulatedDepreciation(true);
            }
        }
        ,
        OFFSET_AMOUNT{

            @Override
            public void setParams(AssetGlpeSourceDetail postable, AssetPayment assetPayment, AssetObjectCode assetObjectCode, boolean isSource, OffsetDefinition offsetDefinition) {
                postable.setFinancialDocumentLineDescription((isSource ? "Reverse" : "Transfer") + " offset amount");
                postable.setAmount((KualiDecimal)assetPayment.getAccountChargeAmount().subtract((AbstractKualiDecimal)assetPayment.getAccumulatedPrimaryDepreciationAmount()));
                postable.setFinancialObjectCode(offsetDefinition.getFinancialObjectCode());
                postable.setObjectCode(offsetDefinition.getFinancialObject());
                postable.setCapitalizationOffset(true);
            }
        };


        abstract void setParams(AssetGlpeSourceDetail var1, AssetPayment var2, AssetObjectCode var3, boolean var4, OffsetDefinition var5);
    }
}

