/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.document.service.PaymentSummaryService;
import org.kuali.kfs.sys.service.UniversityDateService;

public class PaymentSummaryServiceImpl
implements PaymentSummaryService {
    private static Map<Integer, Method> DEPR_AMT_FIELDS = new HashMap<Integer, Method>();
    private UniversityDateService universityDateService;
    private ParameterService parameterService;

    protected KualiDecimal addAmount(KualiDecimal amount, KualiDecimal addend) {
        if (addend != null) {
            return (KualiDecimal)amount.add((AbstractKualiDecimal)addend);
        }
        return amount;
    }

    @Override
    public void calculateAndSetPaymentSummary(Asset asset) {
        if (ObjectUtils.isNotNull((Object)((Object)asset))) {
            asset.setFederalContribution(this.calculateFederalContribution(asset));
            this.setPaymentYearToDate(asset);
            asset.setPaymentTotalCost(this.calculatePaymentTotalCost(asset));
            asset.setAccumulatedDepreciation(this.calculatePrimaryAccumulatedDepreciation(asset));
            asset.setBaseAmount(this.calculatePrimaryBaseAmount(asset));
            asset.setBookValue(this.calculatePrimaryBookValue(asset));
            asset.setPrevYearDepreciation(this.calculatePrimaryPrevYearDepreciation(asset));
            asset.setYearToDateDepreciation(this.calculatePrimaryYTDDepreciation(asset));
            asset.setCurrentMonthDepreciation(this.calculatePrimaryCurrentMonthDepreciation(asset));
        }
    }

    @Override
    public KualiDecimal calculateFederalContribution(Asset asset) {
        KualiDecimal amount = new KualiDecimal(0);
        if (ObjectUtils.isNull((Object)((Object)asset))) {
            return amount;
        }
        List<AssetPayment> assetPayments = asset.getAssetPayments();
        for (AssetPayment payment : assetPayments) {
            if (ObjectUtils.isNull((Object)payment.getObjectCodeCurrent())) {
                payment.refreshReferenceObject("objectCodeCurrent");
            }
            Collection fedContrTypes = this.parameterService.getParameterValuesAsString(Asset.class, "FEDERAL_CONTRIBUTION_SUB_TYPES");
            if (ObjectUtils.isNull((Object)payment.getObjectCodeCurrent()) || !fedContrTypes.contains(payment.getObjectCodeCurrent().getFinancialObjectSubTypeCode())) continue;
            amount = this.addAmount(amount, payment.getAccountChargeAmount());
        }
        return amount;
    }

    @Override
    public KualiDecimal calculatePaymentTotalCost(Asset asset) {
        KualiDecimal totalCost = new KualiDecimal(0);
        if (ObjectUtils.isNotNull((Object)((Object)asset))) {
            List<AssetPayment> payments = asset.getAssetPayments();
            for (AssetPayment payment : payments) {
                totalCost = this.addAmount(totalCost, payment.getAccountChargeAmount());
            }
        }
        return totalCost;
    }

    @Override
    public KualiDecimal calculatePrimaryAccumulatedDepreciation(Asset asset) {
        List<AssetPayment> assetPayments;
        KualiDecimal amount = new KualiDecimal(0);
        if (ObjectUtils.isNotNull((Object)((Object)asset)) && (assetPayments = asset.getAssetPayments()) != null) {
            for (AssetPayment assetPayment : assetPayments) {
                amount = this.addAmount(amount, assetPayment.getAccumulatedPrimaryDepreciationAmount());
            }
        }
        return amount;
    }

    protected KualiDecimal calculatePrimaryBaseAmount(Asset asset) {
        List<AssetPayment> assetPayments;
        KualiDecimal amount = new KualiDecimal(0);
        if (ObjectUtils.isNotNull((Object)((Object)asset)) && (assetPayments = asset.getAssetPayments()) != null) {
            for (AssetPayment assetPayment : assetPayments) {
                amount = this.addAmount(amount, assetPayment.getPrimaryDepreciationBaseAmount());
            }
        }
        return amount;
    }

    @Override
    public KualiDecimal calculatePrimaryBookValue(Asset asset) {
        KualiDecimal baseAmount = this.calculatePrimaryBaseAmount(asset);
        KualiDecimal accumDeprAmount = this.calculatePrimaryAccumulatedDepreciation(asset);
        KualiDecimal salvageAmount = asset.getSalvageAmount();
        if ("SV".equals(asset.getPrimaryDepreciationMethodCode()) && salvageAmount != null) {
            return (KualiDecimal)((KualiDecimal)baseAmount.subtract((AbstractKualiDecimal)accumDeprAmount)).subtract((AbstractKualiDecimal)salvageAmount);
        }
        return (KualiDecimal)baseAmount.subtract((AbstractKualiDecimal)accumDeprAmount);
    }

    protected KualiDecimal calculatePrimaryCurrentMonthDepreciation(Asset asset) {
        List<AssetPayment> assetPayments;
        KualiDecimal amount = new KualiDecimal(0);
        if (ObjectUtils.isNotNull((Object)((Object)asset)) && (assetPayments = asset.getAssetPayments()) != null) {
            for (AssetPayment assetPayment : assetPayments) {
                amount = this.addAmount(amount, this.getCurrentMonthDepreciationAmount(assetPayment));
            }
        }
        return amount;
    }

    protected KualiDecimal calculatePrimaryPrevYearDepreciation(Asset asset) {
        List<AssetPayment> assetPayments;
        KualiDecimal amount = new KualiDecimal(0);
        if (ObjectUtils.isNotNull((Object)((Object)asset)) && (assetPayments = asset.getAssetPayments()) != null) {
            for (AssetPayment assetPayment : assetPayments) {
                amount = this.addAmount(amount, assetPayment.getPreviousYearPrimaryDepreciationAmount());
            }
        }
        return amount;
    }

    protected KualiDecimal calculatePrimaryYTDDepreciation(Asset asset) {
        List<AssetPayment> assetPayments;
        KualiDecimal amount = new KualiDecimal(0);
        if (ObjectUtils.isNotNull((Object)((Object)asset)) && (assetPayments = asset.getAssetPayments()) != null) {
            for (AssetPayment assetPayment : assetPayments) {
                amount = this.addAmount(amount, assetPayment.getPeriod1Depreciation1Amount());
                amount = this.addAmount(amount, assetPayment.getPeriod2Depreciation1Amount());
                amount = this.addAmount(amount, assetPayment.getPeriod3Depreciation1Amount());
                amount = this.addAmount(amount, assetPayment.getPeriod4Depreciation1Amount());
                amount = this.addAmount(amount, assetPayment.getPeriod5Depreciation1Amount());
                amount = this.addAmount(amount, assetPayment.getPeriod6Depreciation1Amount());
                amount = this.addAmount(amount, assetPayment.getPeriod7Depreciation1Amount());
                amount = this.addAmount(amount, assetPayment.getPeriod8Depreciation1Amount());
                amount = this.addAmount(amount, assetPayment.getPeriod9Depreciation1Amount());
                amount = this.addAmount(amount, assetPayment.getPeriod10Depreciation1Amount());
                amount = this.addAmount(amount, assetPayment.getPeriod11Depreciation1Amount());
                amount = this.addAmount(amount, assetPayment.getPeriod12Depreciation1Amount());
            }
        }
        return amount;
    }

    protected KualiDecimal getCurrentMonthDepreciationAmount(AssetPayment assetPayment) {
        KualiDecimal amount;
        Object[] emptyParams = new Object[]{};
        Integer currPeriod = Integer.valueOf(this.universityDateService.getCurrentUniversityDate().getUniversityFiscalAccountingPeriod());
        try {
            amount = (KualiDecimal)DEPR_AMT_FIELDS.get(currPeriod).invoke((Object)assetPayment, emptyParams);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return amount;
    }

    public UniversityDateService getUniversityDateService() {
        return this.universityDateService;
    }

    protected void setPaymentYearToDate(Asset asset) {
        List<AssetPayment> assetPayments = asset.getAssetPayments();
        if (assetPayments != null) {
            for (AssetPayment assetPayment : assetPayments) {
                KualiDecimal yearToDate = new KualiDecimal(0);
                yearToDate = this.addAmount(yearToDate, assetPayment.getPeriod1Depreciation1Amount());
                yearToDate = this.addAmount(yearToDate, assetPayment.getPeriod2Depreciation1Amount());
                yearToDate = this.addAmount(yearToDate, assetPayment.getPeriod3Depreciation1Amount());
                yearToDate = this.addAmount(yearToDate, assetPayment.getPeriod4Depreciation1Amount());
                yearToDate = this.addAmount(yearToDate, assetPayment.getPeriod5Depreciation1Amount());
                yearToDate = this.addAmount(yearToDate, assetPayment.getPeriod6Depreciation1Amount());
                yearToDate = this.addAmount(yearToDate, assetPayment.getPeriod7Depreciation1Amount());
                yearToDate = this.addAmount(yearToDate, assetPayment.getPeriod8Depreciation1Amount());
                yearToDate = this.addAmount(yearToDate, assetPayment.getPeriod9Depreciation1Amount());
                yearToDate = this.addAmount(yearToDate, assetPayment.getPeriod10Depreciation1Amount());
                yearToDate = this.addAmount(yearToDate, assetPayment.getPeriod11Depreciation1Amount());
                yearToDate = this.addAmount(yearToDate, assetPayment.getPeriod12Depreciation1Amount());
                assetPayment.setYearToDate(yearToDate);
            }
        }
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    static {
        try {
            Class[] emptyParams = new Class[]{};
            DEPR_AMT_FIELDS.put(1, AssetPayment.class.getMethod("getPeriod1Depreciation1Amount", emptyParams));
            DEPR_AMT_FIELDS.put(2, AssetPayment.class.getMethod("getPeriod2Depreciation1Amount", emptyParams));
            DEPR_AMT_FIELDS.put(3, AssetPayment.class.getMethod("getPeriod3Depreciation1Amount", emptyParams));
            DEPR_AMT_FIELDS.put(4, AssetPayment.class.getMethod("getPeriod4Depreciation1Amount", emptyParams));
            DEPR_AMT_FIELDS.put(5, AssetPayment.class.getMethod("getPeriod5Depreciation1Amount", emptyParams));
            DEPR_AMT_FIELDS.put(6, AssetPayment.class.getMethod("getPeriod6Depreciation1Amount", emptyParams));
            DEPR_AMT_FIELDS.put(7, AssetPayment.class.getMethod("getPeriod7Depreciation1Amount", emptyParams));
            DEPR_AMT_FIELDS.put(8, AssetPayment.class.getMethod("getPeriod8Depreciation1Amount", emptyParams));
            DEPR_AMT_FIELDS.put(9, AssetPayment.class.getMethod("getPeriod9Depreciation1Amount", emptyParams));
            DEPR_AMT_FIELDS.put(10, AssetPayment.class.getMethod("getPeriod10Depreciation1Amount", emptyParams));
            DEPR_AMT_FIELDS.put(11, AssetPayment.class.getMethod("getPeriod11Depreciation1Amount", emptyParams));
            DEPR_AMT_FIELDS.put(12, AssetPayment.class.getMethod("getPeriod12Depreciation1Amount", emptyParams));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

