/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.parameter.ParameterEvaluatorService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kim.api.identity.Person;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetComponent;
import org.kuali.kfs.module.cam.businessobject.AssetFabrication;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.businessobject.AssetRepairHistory;
import org.kuali.kfs.module.cam.businessobject.AssetWarranty;
import org.kuali.kfs.module.cam.businessobject.defaultvalue.NextAssetNumberFinder;
import org.kuali.kfs.module.cam.document.service.AssetComponentService;
import org.kuali.kfs.module.cam.document.service.AssetDateService;
import org.kuali.kfs.module.cam.document.service.AssetLocationService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.EquipmentLoanOrReturnService;
import org.kuali.kfs.module.cam.document.service.PaymentSummaryService;
import org.kuali.kfs.module.cam.document.service.RetirementInfoService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.springframework.util.AutoPopulatingList;

public class AssetRule
extends MaintenanceDocumentRuleBase {
    private static final Logger LOG = LogManager.getLogger();
    protected static final Map<AssetLocationService.LocationField, String> LOCATION_FIELD_MAP = new HashMap<AssetLocationService.LocationField, String>();
    protected AssetService assetService = (AssetService)SpringContext.getBean(AssetService.class);
    protected ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
    protected PaymentSummaryService paymentSummaryService = (PaymentSummaryService)SpringContext.getBean(PaymentSummaryService.class);
    protected RetirementInfoService retirementInfoService = (RetirementInfoService)SpringContext.getBean(RetirementInfoService.class);
    protected EquipmentLoanOrReturnService equipmentLoanOrReturnService = (EquipmentLoanOrReturnService)SpringContext.getBean(EquipmentLoanOrReturnService.class);
    protected AssetDateService assetDateService = (AssetDateService)SpringContext.getBean(AssetDateService.class);
    protected AssetComponentService assetComponentService = (AssetComponentService)SpringContext.getBean(AssetComponentService.class);
    protected UniversityDateService universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
    protected AssetLocationService assetLocationService = (AssetLocationService)SpringContext.getBean(AssetLocationService.class);
    protected DateTimeService dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
    protected Asset newAsset;
    protected Asset oldAsset;
    protected boolean isFabrication;

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean valid;
        this.initializeAttributes(document);
        if (((AssetService)SpringContext.getBean(AssetService.class)).isAssetFabrication(document)) {
            this.isFabrication = true;
            valid = this.validateAccount();
            valid &= this.validateLocation();
            valid &= this.validateFabricationDetails();
        } else {
            this.setAssetComponentNumbers(this.newAsset);
            this.paymentSummaryService.calculateAndSetPaymentSummary(this.oldAsset);
            this.paymentSummaryService.calculateAndSetPaymentSummary(this.newAsset);
            this.assetService.setSeparateHistory(this.oldAsset);
            this.assetService.setSeparateHistory(this.newAsset);
            this.retirementInfoService.setRetirementInfo(this.oldAsset);
            this.retirementInfoService.setRetirementInfo(this.newAsset);
            this.equipmentLoanOrReturnService.setEquipmentLoanInfo(this.oldAsset);
            this.equipmentLoanOrReturnService.setEquipmentLoanInfo(this.newAsset);
            valid = this.processAssetValidation(document);
            valid &= this.validateWarrantyInformation(this.newAsset);
            valid &= this.validateDepreciationData(this.newAsset);
            valid &= this.checkAssetDepreciationMethodChange();
            if (valid &= super.processCustomSaveDocumentBusinessRules(document)) {
                this.assetDateService.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
                this.assetDateService.checkAndUpdateDepreciationDate(this.oldAsset, this.newAsset);
                this.assetDateService.checkAndUpdateFiscalYearAndPeriod(this.oldAsset, this.newAsset);
            }
            valid &= this.checkAssetLocked(document);
        }
        return valid &= this.validateManufacturer(this.newAsset);
    }

    protected boolean checkAssetLocked(MaintenanceDocument document) {
        Asset asset = (Asset)document.getNewMaintainableObject().getBusinessObject();
        return !this.getCapitalAssetManagementModuleService().isAssetLocked(this.retrieveAssetNumberForLocking(asset), "CASM", document.getDocumentNumber());
    }

    protected List<Long> retrieveAssetNumberForLocking(Asset asset) {
        ArrayList<Long> capitalAssetNumbers = new ArrayList<Long>();
        if (asset.getCapitalAssetNumber() != null) {
            capitalAssetNumbers.add(asset.getCapitalAssetNumber());
        }
        return capitalAssetNumbers;
    }

    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument documentCopy, String collectionName, PersistableBusinessObject bo) {
        if (collectionName.equals("assetRepairHistory")) {
            Asset asset = (Asset)documentCopy.getNewMaintainableObject().getBusinessObject();
            HashSet<Date> incidentDateSet = new HashSet<Date>();
            for (AssetRepairHistory assetRepairHistory : asset.getAssetRepairHistory()) {
                if (assetRepairHistory.getIncidentDate() == null) continue;
                incidentDateSet.add(assetRepairHistory.getIncidentDate());
            }
            AssetRepairHistory assetRepairHistoryDetails = (AssetRepairHistory)bo;
            boolean success = this.checkDuplicateIncidentDate(assetRepairHistoryDetails, incidentDateSet);
            return success & super.processCustomAddCollectionLineBusinessRules(documentCopy, collectionName, bo);
        }
        return true;
    }

    protected boolean checkDuplicateIncidentDate(AssetRepairHistory assetRepairHistory, Set<Date> incidentDateSet) {
        boolean success = true;
        if (!incidentDateSet.add(assetRepairHistory.getIncidentDate())) {
            GlobalVariables.getMessageMap().putError("incidentDate", "error.duplicate.incident.date", new String[0]);
            success = false;
        }
        return success;
    }

    protected boolean validateFabricationDetails() {
        boolean valid = true;
        if (this.newAsset.getFabricationEstimatedTotalAmount() != null && this.newAsset.getFabricationEstimatedTotalAmount().isNegative()) {
            this.putFieldError("fabricationEstimatedTotalAmount", "error.asset.fabrication.totalAmount.negative");
            valid = false;
        }
        if (this.newAsset.getEstimatedFabricationCompletionDate() != null && this.newAsset.getEstimatedFabricationCompletionDate().before(KfsDateUtils.clearTimeFields((Date)this.dateTimeService.getCurrentDate()))) {
            this.putFieldError("estimatedFabricationCompletionDate", "error.asset.fabrication.completionDate.past");
            valid = false;
        }
        if (this.newAsset.getFabricationEstimatedRetentionYears() != null && this.newAsset.getFabricationEstimatedRetentionYears() < 0) {
            this.putFieldError("fabricationEstimatedRetentionYears", "error.asset.fabrication.lifeLimit.negative");
            valid = false;
        }
        return valid;
    }

    protected boolean validateAccount() {
        boolean valid = true;
        Account currentOwnerAccount = this.newAsset.getOrganizationOwnerAccount();
        Account previousOwnerAccount = this.oldAsset.getOrganizationOwnerAccount();
        if (ObjectUtils.isNull((Object)currentOwnerAccount) && StringUtils.isNotBlank((CharSequence)this.newAsset.getOrganizationOwnerAccountNumber())) {
            this.putFieldError("organizationOwnerAccountNumber", "error.asset.org.owner.account.invalid");
            valid = false;
        }
        if (ObjectUtils.isNotNull((Object)previousOwnerAccount) && ObjectUtils.isNotNull((Object)currentOwnerAccount) && previousOwnerAccount.getChartOfAccountsCode().equals(currentOwnerAccount.getChartOfAccountsCode()) && previousOwnerAccount.getAccountNumber().equals(currentOwnerAccount.getAccountNumber())) {
            return valid;
        }
        if (ObjectUtils.isNotNull((Object)currentOwnerAccount) && (currentOwnerAccount.isExpired() || !currentOwnerAccount.isActive())) {
            this.putFieldError("organizationOwnerAccountNumber", "error.asset.org.owner.account.inactive");
            valid = false;
        }
        return valid;
    }

    protected boolean validateAssetRepresentative() {
        boolean valid = true;
        String principalName = this.newAsset.getAssetRepresentative().getPrincipalName();
        Person assetRepresentative = ((PersonService)SpringContext.getBean(PersonService.class)).getPersonByPrincipalName(principalName);
        if (ObjectUtils.isNull((Object)assetRepresentative) && StringUtils.isNotBlank((CharSequence)principalName)) {
            this.putFieldError("assetRepresentative", "error.invalid.representative.id");
            valid = false;
        }
        return valid;
    }

    protected void setAssetComponentNumbers(Asset asset) {
        List<AssetComponent> assetComponents = asset.getAssetComponents();
        Integer maxNo = null;
        for (AssetComponent assetComponent : assetComponents) {
            assetComponent.setCapitalAssetNumber(asset.getCapitalAssetNumber());
            if (maxNo == null) {
                maxNo = this.assetComponentService.getMaxSequenceNumber(assetComponent);
            }
            if (assetComponent.getComponentNumber() != null) continue;
            maxNo = maxNo + 1;
            assetComponent.setComponentNumber(maxNo);
        }
    }

    protected boolean processAssetValidation(MaintenanceDocument document) {
        boolean valid = true;
        if (!StringUtils.equalsIgnoreCase((CharSequence)this.oldAsset.getInventoryStatusCode(), (CharSequence)this.newAsset.getInventoryStatusCode())) {
            valid = this.validateInventoryStatusCode(this.oldAsset.getInventoryStatusCode(), this.newAsset.getInventoryStatusCode());
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)this.oldAsset.getOrganizationOwnerAccountNumber(), (CharSequence)this.newAsset.getOrganizationOwnerAccountNumber())) {
            valid &= this.validateAccount();
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)this.oldAsset.getAssetRepresentative().getPrincipalName(), (CharSequence)this.newAsset.getAssetRepresentative().getPrincipalName())) {
            valid &= this.validateAssetRepresentative();
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)this.oldAsset.getVendorName(), (CharSequence)this.newAsset.getVendorName())) {
            valid &= this.validateVendorName();
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)this.oldAsset.getCampusTagNumber(), (CharSequence)this.newAsset.getCampusTagNumber())) {
            valid &= this.validateTagNumber();
        }
        valid &= this.validateLocation();
        if (this.assetService.isInServiceDateChanged(this.oldAsset, this.newAsset)) {
            valid &= this.validateInServiceDate();
        }
        return valid;
    }

    protected boolean validateInServiceDate() {
        boolean valid = true;
        if (ObjectUtils.isNull((Object)this.newAsset.getCapitalAssetInServiceDate()) && this.assetService.isAssetDepreciationStarted(this.oldAsset)) {
            this.putFieldError("capitalAssetInServiceDate", "error.blank.in.service.date.disallowed");
            valid = false;
        } else if (ObjectUtils.isNotNull((Object)this.newAsset.getCapitalAssetInServiceDate()) && this.universityDateService.getFiscalYear((Date)this.newAsset.getCapitalAssetInServiceDate()) == null) {
            this.putFieldError("capitalAssetInServiceDate", "error.invalid.in.service.date");
            valid = false;
        }
        return valid;
    }

    protected boolean isOffCampusLocationChanged() {
        boolean changed = false;
        AssetLocation oldLocation = this.oldAsset.getOffCampusLocation();
        AssetLocation newLocation = this.newAsset.getOffCampusLocation();
        if (!(StringUtils.equalsIgnoreCase((CharSequence)newLocation.getAssetLocationContactName(), (CharSequence)oldLocation.getAssetLocationContactName()) && StringUtils.equalsIgnoreCase((CharSequence)newLocation.getAssetLocationStreetAddress(), (CharSequence)oldLocation.getAssetLocationStreetAddress()) && StringUtils.equalsIgnoreCase((CharSequence)newLocation.getAssetLocationCityName(), (CharSequence)oldLocation.getAssetLocationCityName()) && StringUtils.equalsIgnoreCase((CharSequence)newLocation.getAssetLocationStateCode(), (CharSequence)oldLocation.getAssetLocationStateCode()) && StringUtils.equalsIgnoreCase((CharSequence)newLocation.getAssetLocationZipCode(), (CharSequence)oldLocation.getAssetLocationZipCode()) && StringUtils.equalsIgnoreCase((CharSequence)newLocation.getAssetLocationCountryCode(), (CharSequence)oldLocation.getAssetLocationCountryCode()))) {
            changed = true;
        }
        return changed;
    }

    protected boolean validateInventoryStatusCode(String oldInventoryStatusCode, String newInventoryStatusCode) {
        boolean valid;
        if (this.assetService.isCapitalAsset(this.oldAsset) && this.assetService.isAssetRetired(this.newAsset)) {
            this.putFieldError("inventoryStatusCode", "error.asset.retired.capital");
            valid = false;
        } else {
            GlobalVariables.getMessageMap().addToErrorPath("document.newMaintainableObject");
            valid = ((ParameterEvaluatorService)SpringContext.getBean(ParameterEvaluatorService.class)).getParameterEvaluator(Asset.class, "VALID_ASSET_TRANSITIONS", "INVALID_ASSET_TRANSITIONS", this.oldAsset.getInventoryStatusCode(), this.newAsset.getInventoryStatusCode()).evaluateAndAddError(((Object)((Object)this.newAsset)).getClass(), "inventoryStatusCode");
            GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject");
        }
        return valid;
    }

    protected void initializeAttributes(MaintenanceDocument document) {
        if (this.newAsset == null) {
            this.newAsset = (Asset)document.getNewMaintainableObject().getBusinessObject();
        }
        if (this.oldAsset == null) {
            this.oldAsset = (Asset)document.getOldMaintainableObject().getBusinessObject();
        }
        if (this.oldAsset == null) {
            this.oldAsset = this.newAsset;
        }
    }

    protected boolean validateTagNumber() {
        boolean valid = true;
        if (!this.assetService.isTagNumberCheckExclude(this.newAsset)) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            if (ObjectUtils.isNotNull((Object)this.newAsset.getCampusTagNumber())) {
                fieldValues.put("campusTagNumber", this.newAsset.getCampusTagNumber().toUpperCase(Locale.US));
                Collection results = this.getBoService().findMatching(Asset.class, fieldValues);
                for (Asset asset : results) {
                    if (asset.getCapitalAssetNumber().equals(this.newAsset.getCapitalAssetNumber())) continue;
                    if (StringUtils.isBlank((CharSequence)asset.getRetirementReasonCode())) {
                        this.putFieldError("campusTagNumber", "error.asset.location.duplicate.tag.number", new String[]{this.newAsset.getCampusTagNumber(), asset.getCapitalAssetNumber().toString(), this.newAsset.getCapitalAssetNumber().toString()});
                        valid = false;
                        LOG.info("The asset tag number [" + this.newAsset.getCampusTagNumber().toUpperCase(Locale.US) + "] is a duplicate of asset number [" + asset.getCapitalAssetNumber().toString() + "]'s tag number");
                        continue;
                    }
                    LOG.info("Although the asset tag number [" + this.newAsset.getCampusTagNumber().toUpperCase(Locale.US) + "] is a duplicate of asset number [" + asset.getCapitalAssetNumber().toString() + "]'s tag number, the old asset has already been retired");
                }
            }
        }
        return valid;
    }

    protected boolean validateVendorName() {
        boolean valid = true;
        if (this.assetService.isCapitalAsset(this.newAsset) && StringUtils.isBlank((CharSequence)this.newAsset.getVendorName())) {
            this.putFieldError("vendorName", "error.capital.asset.vendor.name.required");
            valid = false;
        }
        return valid;
    }

    protected boolean validateLocation() {
        GlobalVariables.getMessageMap().addToErrorPath("document.newMaintainableObject");
        boolean isCapitalAsset = this.assetService.isCapitalAsset(this.newAsset);
        boolean valid = this.assetLocationService.validateLocation(LOCATION_FIELD_MAP, (BusinessObject)this.newAsset, isCapitalAsset, this.newAsset.getCapitalAssetType());
        GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject");
        if (valid && (this.isFabrication || this.isOffCampusLocationChanged())) {
            this.assetLocationService.updateOffCampusLocation(this.newAsset);
        }
        return valid;
    }

    protected boolean validateWarrantyInformation(Asset asset) {
        AssetWarranty warranty = asset.getAssetWarranty();
        if (warranty != null && (StringUtils.isNotEmpty((CharSequence)warranty.getWarrantyContactName()) || StringUtils.isNotEmpty((CharSequence)warranty.getWarrantyPhoneNumber()) || StringUtils.isNotEmpty((CharSequence)warranty.getWarrantyText()) || warranty.getWarrantyBeginningDate() != null || warranty.getWarrantyEndingDate() != null) && StringUtils.isEmpty((CharSequence)warranty.getWarrantyNumber())) {
            this.putFieldError("assetWarranty.warrantyNumber", "error.invalid.asset.warranty.no");
            return false;
        }
        return true;
    }

    protected boolean validateDepreciationData(Asset asset) {
        if (ObjectUtils.isNotNull((Object)asset.getTotalCostAmount()) && asset.getTotalCostAmount().compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) < 0) {
            return true;
        }
        if (asset.getSalvageAmount() == null) {
            asset.setSalvageAmount(KualiDecimal.ZERO);
        }
        if (asset.getBaseAmount() == null) {
            asset.setBaseAmount(KualiDecimal.ZERO);
        }
        if (asset.getSalvageAmount().compareTo((AbstractKualiDecimal)asset.getBaseAmount()) > 0) {
            GlobalVariables.getMessageMap().putWarning("document.newMaintainableObject.salvageAmount", "error.asset.salvage.amount.not.valid", new String[0]);
        }
        if (!this.newAsset.getSalvageAmount().equals((Object)this.oldAsset.getSalvageAmount()) && asset.getBookValue().compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) < 0) {
            this.putFieldError("bookValue", "error.asset.bookValue.amount.not.valid");
            return false;
        }
        return true;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean valid = super.processCustomRouteDocumentBusinessRules(document);
        this.initializeAttributes(document);
        if (((AssetService)SpringContext.getBean(AssetService.class)).isAssetFabrication(document) && this.newAsset.getCapitalAssetNumber() == null) {
            this.newAsset.setCapitalAssetNumber(NextAssetNumberFinder.getLongValue());
            this.oldAsset.setCapitalAssetNumber(this.newAsset.getCapitalAssetNumber());
            this.newAsset.setLastInventoryDate(new Timestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate().getTime()));
            this.oldAsset.setLastInventoryDate(new Timestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate().getTime()));
        }
        valid &= this.checkAcquisitionTypeCodeChange();
        valid &= this.checkConditionCodeChange();
        valid &= this.checkAssetStatusCodeChange();
        valid &= this.checkAssetTypeCodeChange();
        valid &= this.checkFinancialObjectSubtypeCodeChange();
        valid &= this.validateAccount();
        WorkflowDocument workflowDoc = document.getDocumentHeader().getWorkflowDocument();
        if (this.newAsset instanceof Asset && !(this.newAsset instanceof AssetFabrication) && !GlobalVariables.getMessageMap().hasErrors() && (workflowDoc.isInitiated() || workflowDoc.isSaved())) {
            valid &= this.setAssetLock(document);
        }
        return valid;
    }

    protected boolean setAssetLock(MaintenanceDocument document) {
        Asset asset = (Asset)document.getNewMaintainableObject().getBusinessObject();
        return this.getCapitalAssetManagementModuleService().storeAssetLocks(this.retrieveAssetNumberForLocking(asset), document.getDocumentNumber(), "CASM", null);
    }

    protected CapitalAssetManagementModuleService getCapitalAssetManagementModuleService() {
        return (CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class);
    }

    public AutoPopulatingList<ErrorMessage> putError(String propertyName, String errorKey, String ... errorParameters) {
        return GlobalVariables.getMessageMap().putError("document." + propertyName, errorKey, errorParameters);
    }

    protected boolean checkAcquisitionTypeCodeChange() {
        if (ObjectUtils.isNull((Object)((Object)this.newAsset.getAcquisitionType()))) {
            this.putFieldError("acquisitionTypeCode", "error.acquisition.type.code.invalid");
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)this.newAsset.getAcquisitionTypeCode(), (CharSequence)this.oldAsset.getAcquisitionTypeCode())) {
            this.newAsset.refreshReferenceObject("acquisitionType");
            if (ObjectUtils.isNotNull((Object)((Object)this.newAsset.getAcquisitionType())) && !this.newAsset.getAcquisitionType().isActive()) {
                this.putFieldError("acquisitionTypeCode", "error.acquisition.type.code.inactive");
                return false;
            }
        }
        return true;
    }

    protected boolean checkConditionCodeChange() {
        if (ObjectUtils.isNull((Object)((Object)this.newAsset.getCondition()))) {
            this.putFieldError("conditionCode", "error.asset.condition.invalid");
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)this.newAsset.getConditionCode(), (CharSequence)this.oldAsset.getConditionCode())) {
            this.newAsset.refreshReferenceObject("condition");
            if (ObjectUtils.isNotNull((Object)((Object)this.newAsset.getCondition())) && !this.newAsset.getCondition().isActive()) {
                this.putFieldError("conditionCode", "error.asset.condition.inactive");
                return false;
            }
        }
        return true;
    }

    protected boolean checkAssetDepreciationMethodChange() {
        if (ObjectUtils.isNull((Object)((Object)this.newAsset.getAssetPrimaryDepreciationMethod()))) {
            this.putFieldError("primaryDepreciationMethodCode", "error.deprecation.method.code.invalid");
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)this.newAsset.getPrimaryDepreciationMethodCode(), (CharSequence)this.oldAsset.getPrimaryDepreciationMethodCode())) {
            this.newAsset.refreshReferenceObject("assetPrimaryDepreciationMethod");
            if (ObjectUtils.isNotNull((Object)((Object)this.newAsset.getAssetPrimaryDepreciationMethod())) && !this.newAsset.getAssetPrimaryDepreciationMethod().isActive()) {
                this.putFieldError("primaryDepreciationMethodCode", "error.deprecation.method.code.inactive");
                return false;
            }
        }
        return true;
    }

    protected boolean checkAssetStatusCodeChange() {
        if (ObjectUtils.isNull((Object)((Object)this.newAsset.getInventoryStatus()))) {
            this.putFieldError("inventoryStatusCode", "error.asset.status.invalid");
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)this.newAsset.getInventoryStatusCode(), (CharSequence)this.oldAsset.getInventoryStatusCode())) {
            this.newAsset.refreshReferenceObject("inventoryStatus");
            if (ObjectUtils.isNotNull((Object)((Object)this.newAsset.getInventoryStatus())) && !this.newAsset.getInventoryStatus().isActive()) {
                this.putFieldError("inventoryStatusCode", "error.asset.status.inactive");
                return false;
            }
        }
        return true;
    }

    protected boolean checkAssetTypeCodeChange() {
        if (ObjectUtils.isNull((Object)((Object)this.newAsset.getCapitalAssetType()))) {
            this.putFieldError("capitalAssetTypeCode", "error.type.code.invalid");
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)this.newAsset.getCapitalAssetTypeCode(), (CharSequence)this.oldAsset.getCapitalAssetTypeCode())) {
            this.newAsset.refreshReferenceObject("capitalAssetType");
            if (ObjectUtils.isNotNull((Object)((Object)this.newAsset.getCapitalAssetType())) && !this.newAsset.getCapitalAssetType().isActive()) {
                this.putFieldError("capitalAssetTypeCode", "error.type.code.inactive");
                return false;
            }
        }
        return true;
    }

    protected boolean checkFinancialObjectSubtypeCodeChange() {
        if (ObjectUtils.isNotNull((Object)this.newAsset.getFinancialObjectSubType()) || StringUtils.isNotBlank((CharSequence)this.newAsset.getFinancialObjectSubTypeCode())) {
            this.newAsset.refreshReferenceObject("financialObjectSubType");
            if (ObjectUtils.isNull((Object)this.newAsset.getFinancialObjectSubType())) {
                this.putFieldError("financialObjectSubTypeCode", "error.financial.object.subtype.code.invalid");
                return false;
            }
            if (!this.newAsset.getFinancialObjectSubType().isActive()) {
                this.putFieldError("financialObjectSubTypeCode", "error.financial.object.subtype.code.inactive");
                return false;
            }
        }
        return true;
    }

    protected boolean validateManufacturer(Asset asset) {
        boolean valid = true;
        if (this.assetService.isCapitalAsset(asset) && this.parameterService.getParameterValueAsBoolean("KFS-CAM", "Asset", "MANUFACTURER_REQUIRED_FOR_NON_MOVEABLE_ASSET_IND").booleanValue() && StringUtils.isEmpty((CharSequence)asset.getManufacturerName())) {
            this.putFieldError("manufacturerName", "error.capital.asset.manufacturer.name.required");
            valid = false;
        }
        return valid;
    }

    static {
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.CAMPUS_CODE, "campusCode");
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.BUILDING_CODE, "buildingCode");
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.ROOM_NUMBER, "buildingRoomNumber");
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.SUB_ROOM_NUMBER, "buildingSubRoomNumber");
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.CONTACT_NAME, "offCampusLocation.assetLocationContactName");
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.STREET_ADDRESS, "offCampusLocation.assetLocationStreetAddress");
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.CITY_NAME, "offCampusLocation.assetLocationCityName");
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.STATE_CODE, "offCampusLocation.assetLocationStateCode");
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.ZIP_CODE, "offCampusLocation.assetLocationZipCode");
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.COUNTRY_CODE, "offCampusLocation.assetLocationCountryCode");
    }
}

