/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.document.web;

import org.kuali.kfs.module.cam.businessobject.GeneralLedgerEntry;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableActionHistory;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableItemAsset;

import java.util.ArrayList;
import java.util.List;

public class PurApLineSession {
    private List<PurchasingAccountsPayableActionHistory> actionsTakenHistory;
    private List<GeneralLedgerEntry> glEntryUpdateList;
    private List<PurchasingAccountsPayableItemAsset> processedItems;

    public PurApLineSession() {
        actionsTakenHistory = new ArrayList<>();
        glEntryUpdateList = new ArrayList<>();
        processedItems = new ArrayList<>();
    }

    public List<PurchasingAccountsPayableItemAsset> getProcessedItems() {
        return processedItems;
    }

    public List<GeneralLedgerEntry> getGlEntryUpdateList() {
        return glEntryUpdateList;
    }

    public void setGlEntryUpdateList(List<GeneralLedgerEntry> glEntryList) {
        this.glEntryUpdateList = glEntryList;
    }

    public List<PurchasingAccountsPayableActionHistory> getActionsTakenHistory() {
        return actionsTakenHistory;
    }

    public void setActionsTakenHistory(List<PurchasingAccountsPayableActionHistory> actionsTakenHistory) {
        this.actionsTakenHistory = actionsTakenHistory;
    }
}
