/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.krad.bo.GlobalBusinessObject;
import org.kuali.kfs.krad.bo.GlobalBusinessObjectDetail;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.businessobject.AssetLocationGlobalDetail;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;

public class AssetLocationGlobal
extends PersistableBusinessObjectBase
implements GlobalBusinessObject {
    private String documentNumber;
    private DocumentHeader documentHeader;
    private List<AssetLocationGlobalDetail> assetLocationGlobalDetails = new ArrayList<AssetLocationGlobalDetail>();

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public DocumentHeader getDocumentHeader() {
        return this.documentHeader;
    }

    public void setDocumentHeader(DocumentHeader documentHeader) {
        this.documentHeader = documentHeader;
    }

    public List<AssetLocationGlobalDetail> getAssetLocationGlobalDetails() {
        return this.assetLocationGlobalDetails;
    }

    public void setAssetLocationGlobalDetails(List<AssetLocationGlobalDetail> assetLocationGlobalDetails) {
        this.assetLocationGlobalDetails = assetLocationGlobalDetails;
    }

    public List<PersistableBusinessObject> generateDeactivationsToPersist() {
        return null;
    }

    public List<PersistableBusinessObject> generateGlobalChangesToPersist() {
        ArrayList<PersistableBusinessObject> persistables = new ArrayList<PersistableBusinessObject>();
        for (AssetLocationGlobalDetail detail : this.assetLocationGlobalDetails) {
            boolean isCampusCodeChanged = false;
            boolean isBuildingCodeChanged = false;
            boolean isBuildingRoomNumberChanged = false;
            boolean isBuildingSubRoomNumberChanged = false;
            boolean isCampusTagNumberChanged = false;
            Asset asset = (Asset)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(Asset.class, detail.getPrimaryKeys());
            if (asset == null) continue;
            if (!StringUtils.equalsIgnoreCase((CharSequence)asset.getCampusCode(), (CharSequence)detail.getCampusCode())) {
                asset.setCampusCode(detail.getCampusCode());
                isCampusCodeChanged = true;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)asset.getBuildingCode(), (CharSequence)detail.getBuildingCode())) {
                asset.setBuildingCode(detail.getBuildingCode());
                isBuildingCodeChanged = true;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)asset.getBuildingRoomNumber(), (CharSequence)detail.getBuildingRoomNumber())) {
                asset.setBuildingRoomNumber(detail.getBuildingRoomNumber());
                isBuildingRoomNumberChanged = true;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)asset.getBuildingSubRoomNumber(), (CharSequence)detail.getBuildingSubRoomNumber())) {
                asset.setBuildingSubRoomNumber(detail.getBuildingSubRoomNumber());
                isBuildingSubRoomNumberChanged = true;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)detail.getCampusTagNumber(), (CharSequence)asset.getCampusTagNumber())) {
                asset.setOldTagNumber(asset.getCampusTagNumber());
                asset.setCampusTagNumber(detail.getCampusTagNumber());
                isCampusTagNumberChanged = true;
            }
            this.updateOffCampusWithOnCampusValues(asset);
            if (isCampusCodeChanged || isBuildingCodeChanged || isBuildingRoomNumberChanged || isBuildingSubRoomNumberChanged || isCampusTagNumberChanged) {
                asset.setLastInventoryDate(new Timestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate().getTime()));
            }
            persistables.add((PersistableBusinessObject)asset);
        }
        return persistables;
    }

    private void updateOffCampusWithOnCampusValues(Asset asset) {
        if (asset.getAssetLocations() != null) {
            for (AssetLocation location : asset.getAssetLocations()) {
                boolean buildingOrRoom;
                boolean offCampus = "O".equals(location.getAssetLocationTypeCode());
                boolean bl = buildingOrRoom = StringUtils.isNotBlank((CharSequence)asset.getBuildingCode()) || StringUtils.isNotBlank((CharSequence)asset.getBuildingRoomNumber());
                if (!offCampus || !buildingOrRoom) continue;
                location.setAssetLocationContactName(null);
                location.setAssetLocationStreetAddress(null);
                location.setAssetLocationCityName(null);
                location.setAssetLocationStateCode(null);
                location.setAssetLocationCountryCode(null);
                location.setAssetLocationZipCode(null);
            }
        }
    }

    public boolean isPersistable() {
        return true;
    }

    public List<? extends GlobalBusinessObjectDetail> getAllDetailObjects() {
        return this.getAssetLocationGlobalDetails();
    }

    public List<Collection<PersistableBusinessObject>> buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(new ArrayList<AssetLocationGlobalDetail>(this.getAssetLocationGlobalDetails()));
        return managedLists;
    }
}

