/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.integration.purap.CapitalAssetSystem;
import org.kuali.kfs.integration.purap.ItemCapitalAsset;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableItemAsset;
import org.kuali.kfs.module.cam.document.exception.PurApDocumentUnavailableException;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.PurApInfoService;
import org.kuali.kfs.module.cam.web.struts.PurApLineForm;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingCapitalAssetItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.exception.PurError;

public class PurApInfoServiceImpl
implements PurApInfoService {
    private static final Logger LOG = LogManager.getLogger();
    protected static final String PURCHASE_ORDER_CURRENT_INDICATOR = "purchaseOrderCurrentIndicator";
    private AssetService assetService;
    private BusinessObjectService businessObjectService;
    private PurapService purapService;
    private PurchaseOrderService purchaseOrderService;

    @Override
    public PurchaseOrderDocument getCurrentDocumentForPurchaseOrderIdentifier(Integer poId) {
        Iterator poIterator;
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("purapDocumentIdentifier", poId);
        fieldValues.put(PURCHASE_ORDER_CURRENT_INDICATOR, "Y");
        Collection poDocs = this.businessObjectService.findMatching(PurchaseOrderDocument.class, fieldValues);
        if (poDocs != null && !poDocs.isEmpty() && (poIterator = poDocs.iterator()).hasNext()) {
            return (PurchaseOrderDocument)poIterator.next();
        }
        return null;
    }

    @Override
    public void setPurchaseOrderFromPurAp(PurApLineForm purApLineForm) {
        PurchaseOrderDocument purchaseOrderDocument = this.getCurrentDocumentForPurchaseOrderIdentifier(purApLineForm.getPurchaseOrderIdentifier());
        if (ObjectUtils.isNull((Object)purchaseOrderDocument)) {
            return;
        }
        if (purchaseOrderDocument.getInstitutionContactEmailAddress() != null) {
            purApLineForm.setPurApContactEmailAddress(purchaseOrderDocument.getInstitutionContactEmailAddress());
        } else if (purchaseOrderDocument.getRequestorPersonEmailAddress() != null) {
            purApLineForm.setPurApContactEmailAddress(purchaseOrderDocument.getRequestorPersonEmailAddress());
        }
        if (purchaseOrderDocument.getInstitutionContactPhoneNumber() != null) {
            purApLineForm.setPurApContactPhoneNumber(purchaseOrderDocument.getInstitutionContactPhoneNumber());
        } else if (purchaseOrderDocument.getRequestorPersonPhoneNumber() != null) {
            purApLineForm.setPurApContactPhoneNumber(purchaseOrderDocument.getRequestorPersonPhoneNumber());
        }
        purApLineForm.setRequisitionIdentifier(purchaseOrderDocument.getRequisitionIdentifier());
    }

    @Override
    public void setCamsTransactionFromPurAp(List<PurchasingAccountsPayableDocument> purApDocs) {
        if (ObjectUtils.isNull(purApDocs) || purApDocs.isEmpty()) {
            return;
        }
        Integer poId = purApDocs.get(0).getPurchaseOrderIdentifier();
        PurchaseOrderDocument purApdocument = this.getCurrentDocumentForPurchaseOrderIdentifier(poId);
        if (ObjectUtils.isNull((Object)purApdocument)) {
            return;
        }
        String capitalAssetSystemTypeCode = purApdocument.getCapitalAssetSystemTypeCode();
        String capitalAssetSystemStateCode = purApdocument.getCapitalAssetSystemStateCode();
        boolean individualItemLock = false;
        if ("IND".equalsIgnoreCase(capitalAssetSystemTypeCode)) {
            this.setIndividualAssetsFromPurAp(poId, purApDocs, capitalAssetSystemStateCode);
            individualItemLock = true;
        } else if ("ONE".equalsIgnoreCase(capitalAssetSystemTypeCode)) {
            this.setOneSystemFromPurAp(poId, purApDocs, capitalAssetSystemStateCode);
        } else if ("MUL".equalsIgnoreCase(capitalAssetSystemTypeCode)) {
            this.setMultipleSystemFromPurAp(poId, purApDocs, capitalAssetSystemStateCode);
        }
        for (PurchasingAccountsPayableDocument purApDoc : purApDocs) {
            for (PurchasingAccountsPayableItemAsset itemAsset : purApDoc.getPurchasingAccountsPayableItemAssets()) {
                itemAsset.setLockingInformation(individualItemLock ? itemAsset.getAccountsPayableLineItemIdentifier().toString() : "-1");
            }
        }
    }

    protected void setMultipleSystemFromPurAp(Integer poId, List<PurchasingAccountsPayableDocument> purApDocs, String capitalAssetSystemStateCode) {
        CapitalAssetSystem capitalAssetSystem;
        List capitalAssetSystems = this.purchaseOrderService.retrieveCapitalAssetSystemsForMultipleSystem(poId);
        if (ObjectUtils.isNotNull((Object)capitalAssetSystems) && !capitalAssetSystems.isEmpty() && ObjectUtils.isNotNull((Object)(capitalAssetSystem = (CapitalAssetSystem)capitalAssetSystems.get(0)))) {
            String capitalAssetTransactionType = this.getCapitalAssetTransTypeForOneSystem(poId);
            List<ItemCapitalAsset> purApCapitalAssets = null;
            if ("MOD".equalsIgnoreCase(capitalAssetSystemStateCode)) {
                purApCapitalAssets = this.getAssetsFromItemCapitalAsset(capitalAssetSystem.getItemCapitalAssets());
            }
            for (PurchasingAccountsPayableDocument purApDoc : purApDocs) {
                this.setItemAssetsCamsTransaction(capitalAssetSystem.getCapitalAssetSystemIdentifier(), capitalAssetTransactionType, purApCapitalAssets, purApDoc.getPurchasingAccountsPayableItemAssets());
            }
        }
    }

    protected void setOneSystemFromPurAp(Integer poId, List<PurchasingAccountsPayableDocument> purApDocs, String capitalAssetSystemStateCode) {
        CapitalAssetSystem capitalAssetSystem = this.purchaseOrderService.retrieveCapitalAssetSystemForOneSystem(poId);
        String capitalAssetTransactionTypeCode = this.getCapitalAssetTransTypeForOneSystem(poId);
        List<ItemCapitalAsset> purApCapitalAssets = null;
        if ("MOD".equalsIgnoreCase(capitalAssetSystemStateCode)) {
            purApCapitalAssets = this.getAssetsFromItemCapitalAsset(capitalAssetSystem.getItemCapitalAssets());
        }
        for (PurchasingAccountsPayableDocument purApDoc : purApDocs) {
            this.setItemAssetsCamsTransaction(capitalAssetSystem.getCapitalAssetSystemIdentifier(), capitalAssetTransactionTypeCode, purApCapitalAssets, purApDoc.getPurchasingAccountsPayableItemAssets());
        }
    }

    protected void setItemAssetsCamsTransaction(Integer capitalAssetSystemIdentifier, String capitalAssetTransactionTypeCode, List<ItemCapitalAsset> purApCapitalAssets, List<PurchasingAccountsPayableItemAsset> itemAssets) {
        for (PurchasingAccountsPayableItemAsset item : itemAssets) {
            item.setCapitalAssetTransactionTypeCode(capitalAssetTransactionTypeCode);
            if (purApCapitalAssets != null && !purApCapitalAssets.isEmpty()) {
                item.getPurApItemAssets().addAll(purApCapitalAssets);
            }
            item.setCapitalAssetSystemIdentifier(capitalAssetSystemIdentifier);
        }
    }

    protected String getCapitalAssetTransTypeForOneSystem(Integer poId) {
        List capitalAssetItems;
        PurchaseOrderDocument poDoc = this.getCurrentDocumentForPurchaseOrderIdentifier(poId);
        if (ObjectUtils.isNotNull((Object)poDoc) && ObjectUtils.isNotNull((Object)(capitalAssetItems = poDoc.getPurchasingCapitalAssetItems())) && capitalAssetItems.get(0) != null) {
            return ((PurchasingCapitalAssetItem)capitalAssetItems.get(0)).getCapitalAssetTransactionTypeCode();
        }
        return null;
    }

    protected void setIndividualAssetsFromPurAp(Integer poId, List<PurchasingAccountsPayableDocument> purApDocs, String capitalAssetSystemStateCode) {
        List capitalAssetItems = this.purchaseOrderService.retrieveCapitalAssetItemsForIndividual(poId);
        List<ItemCapitalAsset> purApCapitalAssets = null;
        for (PurchasingCapitalAssetItem purchasingCapitalAssetItem : capitalAssetItems) {
            String capitalAssetTransactionTypeCode = purchasingCapitalAssetItem.getCapitalAssetTransactionTypeCode();
            List<PurchasingAccountsPayableItemAsset> matchingItems = this.getMatchingItems(purchasingCapitalAssetItem.getItemIdentifier(), purApDocs);
            if ("MOD".equalsIgnoreCase(capitalAssetSystemStateCode)) {
                purApCapitalAssets = this.getAssetsFromItemCapitalAsset(purchasingCapitalAssetItem.getPurchasingCapitalAssetSystem().getItemCapitalAssets());
            }
            this.setItemAssetsCamsTransaction(purchasingCapitalAssetItem.getCapitalAssetSystemIdentifier(), capitalAssetTransactionTypeCode, purApCapitalAssets, matchingItems);
        }
    }

    protected List<ItemCapitalAsset> getAssetsFromItemCapitalAsset(List<ItemCapitalAsset> itemCapitalAssets) {
        ArrayList<ItemCapitalAsset> assetNumbers = new ArrayList<ItemCapitalAsset>();
        for (ItemCapitalAsset asset : itemCapitalAssets) {
            if (asset.getCapitalAssetNumber() == null || this.isAssetNumberDuplicate(asset.getCapitalAssetNumber(), assetNumbers)) continue;
            assetNumbers.add(asset);
        }
        return assetNumbers;
    }

    protected boolean isAssetNumberDuplicate(Long candidateNumber, List<ItemCapitalAsset> assetNumbers) {
        for (ItemCapitalAsset existingNumber : assetNumbers) {
            if (!existingNumber.getCapitalAssetNumber().equals(candidateNumber)) continue;
            return true;
        }
        return false;
    }

    protected List<PurchasingAccountsPayableItemAsset> getMatchingItems(Integer itemIdentifier, List<PurchasingAccountsPayableDocument> purApDocs) {
        ArrayList<PurchasingAccountsPayableItemAsset> matchingItems = new ArrayList<PurchasingAccountsPayableItemAsset>();
        if (itemIdentifier != null) {
            for (PurchasingAccountsPayableDocument purApDoc : purApDocs) {
                for (PurchasingAccountsPayableItemAsset item : purApDoc.getPurchasingAccountsPayableItemAssets()) {
                    if (!itemIdentifier.equals(item.getPurchaseOrderItemIdentifier())) continue;
                    matchingItems.add(item);
                }
            }
        }
        return matchingItems;
    }

    @Override
    public void setAccountsPayableItemsFromPurAp(PurchasingAccountsPayableItemAsset purchasingAccountsPayableItemAsset, String docTypeCode) {
        HashMap<String, Integer> pKeys = new HashMap<String, Integer>();
        pKeys.put("itemIdentifier", purchasingAccountsPayableItemAsset.getAccountsPayableLineItemIdentifier());
        if ("PREQ".equalsIgnoreCase(docTypeCode)) {
            PaymentRequestItem item = (PaymentRequestItem)this.businessObjectService.findByPrimaryKey(PaymentRequestItem.class, pKeys);
            if (ObjectUtils.isNull((Object)item)) {
                throw new PurApDocumentUnavailableException("PaymentRequestItem with id = " + purchasingAccountsPayableItemAsset.getAccountsPayableLineItemIdentifier() + " doesn't exist in table.");
            }
            purchasingAccountsPayableItemAsset.setItemLineNumber(item.getItemLineNumber());
            if (item.getItemType() != null) {
                purchasingAccountsPayableItemAsset.setAdditionalChargeNonTradeInIndicator(item.getItemType().isAdditionalChargeIndicator() & !"TRDI".equalsIgnoreCase(item.getItemTypeCode()));
                purchasingAccountsPayableItemAsset.setTradeInAllowance(item.getItemType().isAdditionalChargeIndicator() & "TRDI".equalsIgnoreCase(item.getItemTypeCode()));
                purchasingAccountsPayableItemAsset.setItemTypeCode(item.getItemTypeCode());
            }
            purchasingAccountsPayableItemAsset.setItemAssignedToTradeInIndicator(item.getItemAssignedToTradeInIndicator());
            PurchaseOrderItem poi = item.getPurchaseOrderItem();
            if (poi != null) {
                purchasingAccountsPayableItemAsset.setPurchaseOrderItemIdentifier(poi.getItemIdentifier());
            }
        } else {
            VendorCreditMemoDocument cmDoc;
            CreditMemoItem item = (CreditMemoItem)this.businessObjectService.findByPrimaryKey(CreditMemoItem.class, pKeys);
            if (ObjectUtils.isNull((Object)item)) {
                throw new PurApDocumentUnavailableException("CreditMemoItem with id = " + purchasingAccountsPayableItemAsset.getAccountsPayableLineItemIdentifier() + " doesn't exist in table.");
            }
            purchasingAccountsPayableItemAsset.setItemLineNumber(item.getItemLineNumber());
            if (item.getItemType() != null) {
                purchasingAccountsPayableItemAsset.setAdditionalChargeNonTradeInIndicator(item.getItemType().isAdditionalChargeIndicator() & !"TRDI".equalsIgnoreCase(item.getItemTypeCode()));
                purchasingAccountsPayableItemAsset.setTradeInAllowance(item.getItemType().isAdditionalChargeIndicator() & "TRDI".equalsIgnoreCase(item.getItemTypeCode()));
                purchasingAccountsPayableItemAsset.setItemTypeCode(item.getItemTypeCode());
            }
            purchasingAccountsPayableItemAsset.setItemAssignedToTradeInIndicator(item.getItemAssignedToTradeInIndicator());
            PurchaseOrderItem poi = this.getPurchaseOrderItemfromCreditMemoItem(item);
            if (poi != null) {
                purchasingAccountsPayableItemAsset.setPurchaseOrderItemIdentifier(poi.getItemIdentifier());
            }
            if (ObjectUtils.isNotNull((Object)(cmDoc = (VendorCreditMemoDocument)item.getPurapDocument())) && cmDoc.isSourceDocumentPaymentRequest()) {
                purchasingAccountsPayableItemAsset.setPaymentRequestIdentifier(cmDoc.getPaymentRequestIdentifier());
            }
        }
    }

    protected PurchaseOrderItem getPurchaseOrderItemfromCreditMemoItem(CreditMemoItem item) {
        if (ObjectUtils.isNotNull((Object)item.getPurapDocumentIdentifier()) && ObjectUtils.isNull((Object)item.getPurapDocument())) {
            item.refreshReferenceObject("purapDocument");
        }
        if (item.getPurapDocument() != null) {
            PurchaseOrderItem poi;
            PurchaseOrderDocument po = ((VendorCreditMemoDocument)item.getPurapDocument()).getPurchaseOrderDocument();
            if (item.getItemType().isLineItemIndicator()) {
                if (po.getItems() == null || po.getItems().isEmpty()) {
                    po.refreshReferenceObject("items");
                }
                poi = (PurchaseOrderItem)po.getItem(item.getItemLineNumber() - 1);
            } else {
                poi = (PurchaseOrderItem)this.purapService.getBelowTheLineByType((org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument)po, item.getItemType());
            }
            if (poi != null) {
                return poi;
            }
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((CreditMemoItem)item).getItemLineNumber();
            supplierArray[1] = () -> ((CreditMemoItem)item).getItemTypeCode();
            LOG.debug("getPurchaseOrderItemfromCreditMemoItem() Returning null because PurchaseOrderItem object for line number{}or itemType {} is null", supplierArray);
            return null;
        }
        LOG.error("getPurchaseOrderItemfromCreditMemoItem() Returning null because paymentRequest object is null");
        throw new PurError("Credit Memo Object in Purchase Order item line number " + item.getItemLineNumber() + "or itemType " + item.getItemTypeCode() + " is null");
    }

    @Override
    public List<Long> retrieveValidAssetNumberForLocking(Integer poId, String capitalAssetSystemTypeCode, PurApItem purApItem) {
        List capitalAssetSystems;
        ArrayList<Long> capitalAssetNumbers = new ArrayList<Long>();
        CapitalAssetSystem capitalAssetSystem = null;
        if ("IND".equalsIgnoreCase(capitalAssetSystemTypeCode)) {
            capitalAssetSystem = this.getCapitalAssetSystemForIndividual(poId, purApItem);
        } else if ("ONE".equalsIgnoreCase(capitalAssetSystemTypeCode)) {
            capitalAssetSystem = this.purchaseOrderService.retrieveCapitalAssetSystemForOneSystem(poId);
        } else if ("MUL".equalsIgnoreCase(capitalAssetSystemTypeCode) && ObjectUtils.isNotNull((Object)(capitalAssetSystems = this.purchaseOrderService.retrieveCapitalAssetSystemsForMultipleSystem(poId))) && !capitalAssetSystems.isEmpty()) {
            capitalAssetSystem = (CapitalAssetSystem)capitalAssetSystems.get(0);
        }
        if (ObjectUtils.isNotNull((Object)capitalAssetSystem) && capitalAssetSystem.getItemCapitalAssets() != null && !capitalAssetSystem.getItemCapitalAssets().isEmpty()) {
            for (ItemCapitalAsset itemCapitalAsset : capitalAssetSystem.getItemCapitalAssets()) {
                if (itemCapitalAsset.getCapitalAssetNumber() == null) continue;
                HashMap<String, Long> pKeys = new HashMap<String, Long>();
                pKeys.put("capitalAssetNumber", itemCapitalAsset.getCapitalAssetNumber());
                Asset asset = (Asset)this.businessObjectService.findByPrimaryKey(Asset.class, pKeys);
                if (!ObjectUtils.isNotNull((Object)((Object)asset)) || !this.assetService.isCapitalAsset(asset) || this.assetService.isAssetRetired(asset)) continue;
                capitalAssetNumbers.add(itemCapitalAsset.getCapitalAssetNumber());
            }
        }
        return capitalAssetNumbers;
    }

    protected CapitalAssetSystem getCapitalAssetSystemForIndividual(Integer poId, PurApItem purApItem) {
        List capitalAssetItems = this.purchaseOrderService.retrieveCapitalAssetItemsForIndividual(poId);
        if (capitalAssetItems == null || capitalAssetItems.isEmpty()) {
            return null;
        }
        Integer purchaseOrderItemIdentifier = null;
        PurchaseOrderItem poi = null;
        if (purApItem instanceof PaymentRequestItem) {
            poi = ((PaymentRequestItem)purApItem).getPurchaseOrderItem();
        } else if (purApItem instanceof CreditMemoItem) {
            poi = this.getPurchaseOrderItemfromCreditMemoItem((CreditMemoItem)purApItem);
        }
        if (poi != null) {
            purchaseOrderItemIdentifier = poi.getItemIdentifier();
        }
        for (PurchasingCapitalAssetItem capitalAssetItem : capitalAssetItems) {
            if (!capitalAssetItem.getItemIdentifier().equals(purchaseOrderItemIdentifier)) continue;
            return capitalAssetItem.getPurchasingCapitalAssetSystem();
        }
        return null;
    }

    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }
}

