/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.util.distribution;

import java.util.HashMap;
import java.util.Map;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.util.distribution.AssetDistribution;

public class AssetDistributionManual
extends AssetDistribution {
    public AssetDistributionManual(AssetPaymentDocument doc) {
        super(doc);
    }

    @Override
    public Map<String, Map<AssetPaymentAssetDetail, KualiDecimal>> getAssetPaymentDistributions() {
        HashMap<String, Map<AssetPaymentAssetDetail, KualiDecimal>> distributionResult = new HashMap<String, Map<AssetPaymentAssetDetail, KualiDecimal>>();
        KualiDecimal totalLineAmount = this.getTotalLineAmount();
        for (AssetPaymentDetail line : this.getAssetPaymentDetailLines()) {
            KualiDecimal lineAmount;
            KualiDecimal remainingAmount = lineAmount = line.getAmount();
            HashMap<AssetPaymentAssetDetail, KualiDecimal> apadMap = new HashMap<AssetPaymentAssetDetail, KualiDecimal>();
            int size = this.doc.getAssetPaymentAssetDetail().size();
            for (int i = 0; i < size; ++i) {
                AssetPaymentAssetDetail apad = this.doc.getAssetPaymentAssetDetail().get(i);
                if (i < size - 1) {
                    double allocationPercentage = this.determineAllocationPercentage(totalLineAmount, lineAmount, apad.getAllocatedUserValue());
                    KualiDecimal amount = new KualiDecimal(allocationPercentage * lineAmount.doubleValue());
                    apadMap.put(apad, amount);
                    remainingAmount = (KualiDecimal)remainingAmount.subtract((AbstractKualiDecimal)amount);
                    continue;
                }
                apadMap.put(apad, remainingAmount);
            }
            String assetPaymentDetailKey = line.getAssetPaymentDetailKey();
            Map<AssetPaymentAssetDetail, KualiDecimal> existingMap = this.findExistingMap(distributionResult, assetPaymentDetailKey);
            if (existingMap == null) {
                distributionResult.put(assetPaymentDetailKey, apadMap);
                continue;
            }
            this.addAmountToExistingAssetPaymentAssetDetail(apadMap, existingMap);
        }
        return distributionResult;
    }

    private Map<AssetPaymentAssetDetail, KualiDecimal> findExistingMap(Map<String, Map<AssetPaymentAssetDetail, KualiDecimal>> distributionResult, String assetPaymentDetailKey) {
        assetPaymentDetailKey = this.escapeRegexAndGenerifySequence(assetPaymentDetailKey);
        for (String key : distributionResult.keySet()) {
            if (!key.matches(assetPaymentDetailKey)) continue;
            return distributionResult.get(key);
        }
        return null;
    }

    private String escapeRegexAndGenerifySequence(String assetPaymentDetailKey) {
        assetPaymentDetailKey = assetPaymentDetailKey.replace("{", "\\{");
        assetPaymentDetailKey = assetPaymentDetailKey.replace("}", "\\}");
        assetPaymentDetailKey = assetPaymentDetailKey.replaceFirst("sequenceNumber=\\d+", "sequenceNumber=\\\\d+");
        return assetPaymentDetailKey;
    }

    protected double determineAllocationPercentage(KualiDecimal totalLineAmount, KualiDecimal lineAmount, KualiDecimal allocatedUserValue) {
        double allocationPercentage = 0.0;
        if (totalLineAmount.isNonZero()) {
            allocationPercentage = allocatedUserValue.doubleValue() / totalLineAmount.doubleValue();
        } else if (allocatedUserValue.equals((Object)lineAmount)) {
            allocationPercentage = 1.0;
        }
        return allocationPercentage;
    }

    protected void addAmountToExistingAssetPaymentAssetDetail(Map<AssetPaymentAssetDetail, KualiDecimal> newMap, Map<AssetPaymentAssetDetail, KualiDecimal> existingMap) {
        for (AssetPaymentAssetDetail existingApad : existingMap.keySet()) {
            KualiDecimal newAmount = newMap.get((Object)existingApad);
            KualiDecimal existingAmount = existingMap.get((Object)existingApad);
            existingMap.put(existingApad, (KualiDecimal)newAmount.add((AbstractKualiDecimal)existingAmount));
        }
    }

    private KualiDecimal getTotalLineAmount() {
        KualiDecimal result = KualiDecimal.ZERO;
        for (AssetPaymentDetail sourceLine : this.getAssetPaymentDetailLines()) {
            result = (KualiDecimal)result.add((AbstractKualiDecimal)sourceLine.getAmount());
        }
        return result;
    }

    public Map<AssetPaymentAssetDetail, KualiDecimal> getTotalAssetAllocations() {
        HashMap<AssetPaymentAssetDetail, KualiDecimal> assetTotalAllocationMap = new HashMap<AssetPaymentAssetDetail, KualiDecimal>();
        for (AssetPaymentAssetDetail apad : this.doc.getAssetPaymentAssetDetail()) {
            assetTotalAllocationMap.put(apad, apad.getAllocatedAmount());
        }
        return assetTotalAllocationMap;
    }
}

