/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.kuali.kfs.coa.businessobject.ObjectSubType;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;

public class AssetDepreciationConvention extends PersistableBusinessObjectBase implements MutableInactivatable {

    private String financialObjectSubTypeCode;
    private String depreciationConventionCode;
    private boolean active;

    private ObjectSubType financialObjectSubType;

    public AssetDepreciationConvention() {
    }

    public String getFinancialObjectSubTypeCode() {
        return financialObjectSubTypeCode;
    }

    public void setFinancialObjectSubTypeCode(final String financialObjectSubTypeCode) {
        this.financialObjectSubTypeCode = financialObjectSubTypeCode;
    }

    public String getDepreciationConventionCode() {
        return depreciationConventionCode;
    }

    public void setDepreciationConventionCode(final String depreciationConventionCode) {
        this.depreciationConventionCode = depreciationConventionCode;
    }

    public ObjectSubType getFinancialObjectSubType() {
        return financialObjectSubType;
    }

    public void setFinancialObjectSubType(final ObjectSubType financialObjectSubType) {
        this.financialObjectSubType = financialObjectSubType;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void setActive(final boolean active) {
        this.active = active;
    }
}
