/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.document.authorization;

import org.kuali.kfs.kim.bo.impl.KimAttributes;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentAuthorizerBase;
import org.kuali.kfs.module.cam.businessobject.Pretag;

import java.util.Map;

/**
 * AssetAuthorizer for Asset edit.
 */
public class PretagAuthorizer extends MaintenanceDocumentAuthorizerBase {

    @Override
    protected void addRoleQualification(final Object businessObject, final Map<String, String> attributes) {
        super.addRoleQualification(businessObject, attributes);

        final Pretag pretag;
        if (businessObject instanceof MaintenanceDocument) {
            pretag = (Pretag) ((MaintenanceDocument) businessObject).getNewMaintainableObject().getBusinessObject();
        } else {
            pretag = (Pretag) businessObject;
        }

        final String chart = pretag.getChartOfAccountsCode();
        attributes.put(KimAttributes.CHART_OF_ACCOUNTS_CODE, chart);

        final String org = pretag.getOrganizationCode();
        attributes.put(KimAttributes.ORGANIZATION_CODE, org);
    }
}
