/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.batch.service.impl;

import net.sf.jasperreports.engine.JRParameter;
import org.kuali.kfs.module.cam.batch.ExtractProcessLog;
import org.kuali.kfs.module.cam.batch.service.BatchExtractReportService;
import org.kuali.kfs.sys.KFSConstants.ReportGeneration;
import org.kuali.kfs.sys.report.ReportInfo;
import org.kuali.kfs.sys.service.ReportGenerationService;
import org.kuali.kfs.core.api.datetime.DateTimeService;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class BatchExtractReportServiceImpl implements BatchExtractReportService {

    protected ReportGenerationService reportGenerationService;
    protected ReportInfo cabBatchStatusReportInfo;
    protected ReportInfo cabBatchMismatchReportInfo;

    protected DateTimeService dateTimeService;

    @Override
    public File generateStatusReportPDF(final ExtractProcessLog extractProcessLog) {
        final String reportFileName = cabBatchStatusReportInfo.getReportFileName();
        final String reportDirectory = cabBatchStatusReportInfo.getReportsDirectory();
        final String reportTemplateClassPath = cabBatchStatusReportInfo.getReportTemplateClassPath();
        final String reportTemplateName = cabBatchStatusReportInfo.getReportTemplateName();
        final ResourceBundle resourceBundle = cabBatchStatusReportInfo.getResourceBundle();
        final String subReportTemplateClassPath = cabBatchStatusReportInfo.getSubReportTemplateClassPath();
        final Map<String, String> subReports = cabBatchStatusReportInfo.getSubReports();
        final Map<String, Object> reportData = new HashMap<>();
        reportData.put(JRParameter.REPORT_RESOURCE_BUNDLE, resourceBundle);
        reportData.put(ReportGeneration.PARAMETER_NAME_SUBREPORT_DIR, subReportTemplateClassPath);
        reportData.put(ReportGeneration.PARAMETER_NAME_SUBREPORT_TEMPLATE_NAME, subReports);
        final String template = reportTemplateClassPath + reportTemplateName;
        final String fullReportFileName = reportGenerationService.buildFullFileName(dateTimeService.getCurrentDate(),
                reportDirectory, reportFileName, "");
        final List<ExtractProcessLog> dataSource = new ArrayList<>();
        dataSource.add(extractProcessLog);
        reportGenerationService.generateReportToPdfFile(reportData, dataSource, template, fullReportFileName);
        return new File(fullReportFileName + ".pdf");
    }

    @Override
    public File generateMismatchReportPDF(final ExtractProcessLog extractProcessLog) {
        final String reportFileName = cabBatchMismatchReportInfo.getReportFileName();
        final String reportDirectory = cabBatchMismatchReportInfo.getReportsDirectory();
        final String reportTemplateClassPath = cabBatchMismatchReportInfo.getReportTemplateClassPath();
        final String reportTemplateName = cabBatchMismatchReportInfo.getReportTemplateName();
        final ResourceBundle resourceBundle = cabBatchMismatchReportInfo.getResourceBundle();
        final String subReportTemplateClassPath = cabBatchMismatchReportInfo.getSubReportTemplateClassPath();
        final Map<String, String> subReports = cabBatchMismatchReportInfo.getSubReports();
        final Map<String, Object> reportData = new HashMap<>();
        reportData.put(JRParameter.REPORT_RESOURCE_BUNDLE, resourceBundle);
        reportData.put(ReportGeneration.PARAMETER_NAME_SUBREPORT_DIR, subReportTemplateClassPath);
        reportData.put(ReportGeneration.PARAMETER_NAME_SUBREPORT_TEMPLATE_NAME, subReports);
        final String template = reportTemplateClassPath + reportTemplateName;
        final String fullReportFileName = reportGenerationService.buildFullFileName(dateTimeService.getCurrentDate(),
                reportDirectory, reportFileName, "");
        final List<ExtractProcessLog> dataSource = new ArrayList<>();
        dataSource.add(extractProcessLog);
        reportGenerationService.generateReportToPdfFile(reportData, dataSource, template, fullReportFileName);
        return new File(fullReportFileName + ".pdf");
    }

    public ReportGenerationService getReportGenerationService() {
        return reportGenerationService;
    }

    public void setReportGenerationService(final ReportGenerationService reportGenerationService) {
        this.reportGenerationService = reportGenerationService;
    }

    public ReportInfo getCabBatchStatusReportInfo() {
        return cabBatchStatusReportInfo;
    }

    public void setCabBatchStatusReportInfo(final ReportInfo cabBatchStatusReportInfo) {
        this.cabBatchStatusReportInfo = cabBatchStatusReportInfo;
    }

    public DateTimeService getDateTimeService() {
        return dateTimeService;
    }

    public void setDateTimeService(final DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public ReportInfo getCabBatchMismatchReportInfo() {
        return cabBatchMismatchReportInfo;
    }

    public void setCabBatchMismatchReportInfo(final ReportInfo cabBatchMismatchReportInfo) {
        this.cabBatchMismatchReportInfo = cabBatchMismatchReportInfo;
    }
}
