/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.bo.GlobalBusinessObjectDetailBase;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.sys.businessobject.Building;
import org.kuali.kfs.sys.businessobject.Campus;
import org.kuali.kfs.sys.businessobject.Room;
import org.kuali.kfs.sys.context.SpringContext;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AssetLocationGlobalDetail extends GlobalBusinessObjectDetailBase {

    private static final Logger LOG = LogManager.getLogger();

    protected String documentNumber;
    protected Long capitalAssetNumber;
    protected String campusCode;
    protected String buildingCode;
    protected String buildingRoomNumber;
    protected String buildingSubRoomNumber;
    protected String campusTagNumber;
    protected String lastInventoryDateUpdateButton;
    protected boolean updateLastInventoryDate;

    protected Asset asset;
    protected Campus campus;
    protected Building building;
    protected Room buildingRoom;

    public AssetLocationGlobalDetail() {

    }

    @Override
    public String getDocumentNumber() {
        return documentNumber;
    }

    @Override
    public void setDocumentNumber(final String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Long getCapitalAssetNumber() {
        return capitalAssetNumber;
    }

    public void setCapitalAssetNumber(final Long capitalAssetNumber) {
        this.capitalAssetNumber = capitalAssetNumber;
    }

    public String getCampusCode() {
        return campusCode;
    }

    public void setCampusCode(final String campusCode) {
        this.campusCode = campusCode;
    }

    public String getBuildingCode() {
        return buildingCode;
    }

    public void setBuildingCode(final String buildingCode) {
        this.buildingCode = buildingCode;
    }

    public String getBuildingRoomNumber() {
        return buildingRoomNumber;
    }

    public void setBuildingRoomNumber(final String buildingRoomNumber) {
        this.buildingRoomNumber = buildingRoomNumber;
    }

    public String getBuildingSubRoomNumber() {
        return buildingSubRoomNumber;
    }

    public void setBuildingSubRoomNumber(final String buildingSubRoomNumber) {
        this.buildingSubRoomNumber = buildingSubRoomNumber;
    }

    public String getCampusTagNumber() {
        return campusTagNumber;
    }

    public void setCampusTagNumber(final String campusTagNumber) {
        this.campusTagNumber = campusTagNumber;
    }

    public Asset getAsset() {
        return asset;
    }

    public void setAsset(final Asset asset) {
        this.asset = asset;
    }

    public Campus getCampus() {
        return campus;
    }

    /**
     * @deprecated
     */
    public void setCampus(final Campus campus) {
        this.campus = campus;
    }

    public Building getBuilding() {
        return building;
    }

    /**
     * @deprecated
     */
    public void setBuilding(final Building building) {
        this.building = building;
    }

    public Room getBuildingRoom() {
        return buildingRoom;
    }

    /**
     * @deprecated
     */
    public void setBuildingRoom(final Room buildingRoom) {
        this.buildingRoom = buildingRoom;
    }

    public String getLastInventoryDateUpdateButton() {
        return lastInventoryDateUpdateButton;
    }

    public void setLastInventoryDateUpdateButton(final String lastInventoryDateUpdateButton) {
        this.lastInventoryDateUpdateButton = lastInventoryDateUpdateButton;
    }

    public boolean isUpdateLastInventoryDate() {
        return updateLastInventoryDate;
    }

    public void setUpdateLastInventoryDate(final boolean updateLastInventoryDate) {
        this.updateLastInventoryDate = updateLastInventoryDate;
    }

    /**
     * @return a map of the keys<propName,value> based on the primary key names of the underlying BO and reflecting
     * into this object.
     */
    public Map<String, Object> getPrimaryKeys() {
        try {
            final List<String> keys = SpringContext.getBean(PersistenceStructureService.class).getPrimaryKeys(Asset.class);
            final HashMap<String, Object> pks = new HashMap<>(keys.size());
            for (final String key : keys) {
                // attempt to read the property of the current object
                // this requires that the field names match between the underlying BO object and this object
                pks.put(key, ObjectUtils.getPropertyValue(this, key));
            }
            return pks;
        } catch (final Exception ex) {
            LOG.error("unable to get primary keys for global detail object", ex);
        }
        return new HashMap<>(0);
    }
}
