/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.purap.ItemCapitalAsset;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.cam.businessobject.AssetGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.businessobject.Pretag;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableLineAssetAccount;
import org.kuali.kfs.module.cam.document.service.PurApLineService;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItemCapitalAsset;
import org.kuali.kfs.sys.context.SpringContext;

public class PurchasingAccountsPayableItemAsset
extends PersistableBusinessObjectBase
implements Comparable<PurchasingAccountsPayableItemAsset> {
    private String documentNumber;
    private Integer accountsPayableLineItemIdentifier;
    private Integer capitalAssetBuilderLineNumber;
    private String accountsPayableLineItemDescription;
    private KualiDecimal accountsPayableItemQuantity;
    private String capitalAssetManagementDocumentNumber;
    private String activityStatusCode;
    private PurchasingAccountsPayableDocument purchasingAccountsPayableDocument;
    private List<PurchasingAccountsPayableLineAssetAccount> purchasingAccountsPayableLineAssetAccounts;
    private boolean active;
    private Integer itemLineNumber;
    private boolean additionalChargeNonTradeInIndicator;
    private boolean tradeInAllowance;
    private boolean itemAssignedToTradeInIndicator;
    private KualiDecimal unitCost;
    private KualiDecimal totalCost;
    private String firstFincialObjectCode;
    private KualiDecimal splitQty;
    private boolean selectedValue;
    private String itemTypeCode;
    private String lockingInformation;
    private String capitalAssetTransactionTypeCode;
    private List<ItemCapitalAsset> purApItemAssets;
    private Integer capitalAssetSystemIdentifier;
    private Integer purchaseOrderItemIdentifier;
    private boolean createAssetIndicator;
    private boolean applyPaymentIndicator;
    private String preTagInquiryUrl;
    private List<Long> approvedAssetNumbers;
    private Integer paymentRequestIdentifier;

    public PurchasingAccountsPayableItemAsset() {
        this.purchasingAccountsPayableLineAssetAccounts = new ArrayList<PurchasingAccountsPayableLineAssetAccount>();
        this.selectedValue = false;
        this.createAssetIndicator = false;
        this.applyPaymentIndicator = false;
        this.purApItemAssets = new ArrayList<ItemCapitalAsset>();
    }

    public PurchasingAccountsPayableItemAsset(PurchasingAccountsPayableItemAsset initialItemAsset) {
        this.documentNumber = initialItemAsset.documentNumber;
        this.accountsPayableLineItemIdentifier = initialItemAsset.getAccountsPayableLineItemIdentifier();
        this.accountsPayableLineItemDescription = initialItemAsset.getAccountsPayableLineItemDescription();
        this.itemLineNumber = initialItemAsset.getItemLineNumber();
        this.firstFincialObjectCode = initialItemAsset.getFirstFincialObjectCode();
        this.activityStatusCode = initialItemAsset.getActivityStatusCode();
        this.tradeInAllowance = initialItemAsset.isTradeInAllowance();
        this.itemAssignedToTradeInIndicator = initialItemAsset.isItemAssignedToTradeInIndicator();
        this.additionalChargeNonTradeInIndicator = initialItemAsset.isAdditionalChargeNonTradeInIndicator();
        this.purchasingAccountsPayableLineAssetAccounts = new ArrayList<PurchasingAccountsPayableLineAssetAccount>();
        this.selectedValue = false;
        this.createAssetIndicator = initialItemAsset.isCreateAssetIndicator();
        this.applyPaymentIndicator = initialItemAsset.isApplyPaymentIndicator();
        this.purchaseOrderItemIdentifier = initialItemAsset.getPurchaseOrderItemIdentifier();
        this.capitalAssetTransactionTypeCode = initialItemAsset.getCapitalAssetTransactionTypeCode();
        this.purApItemAssets = new ArrayList<ItemCapitalAsset>(initialItemAsset.getPurApItemAssets());
        this.capitalAssetSystemIdentifier = initialItemAsset.getCapitalAssetSystemIdentifier();
        this.purchasingAccountsPayableDocument = initialItemAsset.getPurchasingAccountsPayableDocument();
        this.lockingInformation = initialItemAsset.getLockingInformation();
    }

    public String getLockingInformation() {
        return this.lockingInformation;
    }

    public void setLockingInformation(String lockingInformation) {
        this.lockingInformation = lockingInformation;
    }

    public Integer getCapitalAssetSystemIdentifier() {
        return this.capitalAssetSystemIdentifier;
    }

    public void setCapitalAssetSystemIdentifier(Integer capitalAssetSystemIdentifier) {
        this.capitalAssetSystemIdentifier = capitalAssetSystemIdentifier;
    }

    public Integer getPurchaseOrderItemIdentifier() {
        return this.purchaseOrderItemIdentifier;
    }

    public void setPurchaseOrderItemIdentifier(Integer purchaseOrderItemIdentifier) {
        this.purchaseOrderItemIdentifier = purchaseOrderItemIdentifier;
    }

    public List<ItemCapitalAsset> getPurApItemAssets() {
        return this.purApItemAssets;
    }

    public void setPurApItemAssets(List<ItemCapitalAsset> capitalAssetNumbers) {
        this.purApItemAssets = capitalAssetNumbers;
    }

    public ItemCapitalAsset getPurApItemAsset(int index) {
        while (this.getPurApItemAssets().size() <= index) {
            this.getPurApItemAssets().add((ItemCapitalAsset)new PurchaseOrderItemCapitalAsset());
        }
        return this.getPurApItemAssets().get(index);
    }

    public boolean isCreateAssetIndicator() {
        return this.createAssetIndicator;
    }

    public void setCreateAssetIndicator(boolean createAssetIndicator) {
        this.createAssetIndicator = createAssetIndicator;
    }

    public boolean isApplyPaymentIndicator() {
        return this.applyPaymentIndicator;
    }

    public void setApplyPaymentIndicator(boolean applyPaymentIndicator) {
        this.applyPaymentIndicator = applyPaymentIndicator;
    }

    public boolean isSelectedValue() {
        return this.selectedValue;
    }

    public void setSelectedValue(boolean selectedValue) {
        this.selectedValue = selectedValue;
    }

    public String getItemTypeCode() {
        return this.itemTypeCode;
    }

    public void setItemTypeCode(String itemTypeCode) {
        this.itemTypeCode = itemTypeCode;
    }

    public String getCapitalAssetTransactionTypeCode() {
        return this.capitalAssetTransactionTypeCode;
    }

    public void setCapitalAssetTransactionTypeCode(String capitalAssetTransactionTypeCode) {
        this.capitalAssetTransactionTypeCode = capitalAssetTransactionTypeCode;
    }

    public boolean isAdditionalChargeNonTradeInIndicator() {
        return this.additionalChargeNonTradeInIndicator;
    }

    public void setAdditionalChargeNonTradeInIndicator(boolean additionalChargeNonTradeInIndicator) {
        this.additionalChargeNonTradeInIndicator = additionalChargeNonTradeInIndicator;
    }

    public boolean isTradeInAllowance() {
        return this.tradeInAllowance;
    }

    public void setTradeInAllowance(boolean tradeInAllowance) {
        this.tradeInAllowance = tradeInAllowance;
    }

    public KualiDecimal getSplitQty() {
        return this.splitQty;
    }

    public void setSplitQty(KualiDecimal splitQty) {
        this.splitQty = splitQty;
    }

    public List<PurchasingAccountsPayableLineAssetAccount> getPurchasingAccountsPayableLineAssetAccounts() {
        return this.purchasingAccountsPayableLineAssetAccounts;
    }

    public void setPurchasingAccountsPayableLineAssetAccounts(List<PurchasingAccountsPayableLineAssetAccount> purchasingAccountsPayableLineAssetAccounts) {
        this.purchasingAccountsPayableLineAssetAccounts = purchasingAccountsPayableLineAssetAccounts;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Integer getAccountsPayableLineItemIdentifier() {
        return this.accountsPayableLineItemIdentifier;
    }

    public void setAccountsPayableLineItemIdentifier(Integer accountsPayableLineItemIdentifier) {
        this.accountsPayableLineItemIdentifier = accountsPayableLineItemIdentifier;
    }

    public String getAccountsPayableLineItemDescription() {
        return this.accountsPayableLineItemDescription;
    }

    public void setAccountsPayableLineItemDescription(String accountsPayableLineItemDescription) {
        this.accountsPayableLineItemDescription = accountsPayableLineItemDescription;
    }

    public KualiDecimal getAccountsPayableItemQuantity() {
        return this.accountsPayableItemQuantity;
    }

    public void setAccountsPayableItemQuantity(KualiDecimal accountsPayableItemQuantity) {
        this.accountsPayableItemQuantity = accountsPayableItemQuantity;
    }

    public Integer getCapitalAssetBuilderLineNumber() {
        return this.capitalAssetBuilderLineNumber;
    }

    public void setCapitalAssetBuilderLineNumber(Integer capitalAssetBuilderLineNumber) {
        this.capitalAssetBuilderLineNumber = capitalAssetBuilderLineNumber;
    }

    public String getCapitalAssetManagementDocumentNumber() {
        return this.capitalAssetManagementDocumentNumber;
    }

    public void setCapitalAssetManagementDocumentNumber(String capitalAssetManagementDocumentNumber) {
        this.capitalAssetManagementDocumentNumber = capitalAssetManagementDocumentNumber;
    }

    public Integer getItemLineNumber() {
        return this.itemLineNumber;
    }

    public void setItemLineNumber(Integer itemLineNumber) {
        this.itemLineNumber = itemLineNumber;
    }

    public boolean isActive() {
        return "N".equalsIgnoreCase(this.getActivityStatusCode()) || "M".equalsIgnoreCase(this.getActivityStatusCode());
    }

    public String getActivityStatusCode() {
        return this.activityStatusCode;
    }

    public void setActivityStatusCode(String activityStatusCode) {
        this.activityStatusCode = activityStatusCode;
    }

    public PurchasingAccountsPayableDocument getPurchasingAccountsPayableDocument() {
        return this.purchasingAccountsPayableDocument;
    }

    public void setPurchasingAccountsPayableDocument(PurchasingAccountsPayableDocument purchasingAccountsPayableDocument) {
        this.purchasingAccountsPayableDocument = purchasingAccountsPayableDocument;
    }

    public boolean isItemAssignedToTradeInIndicator() {
        return this.itemAssignedToTradeInIndicator;
    }

    public void setItemAssignedToTradeInIndicator(boolean itemAssignedToTradeInIndicator) {
        this.itemAssignedToTradeInIndicator = itemAssignedToTradeInIndicator;
    }

    public KualiDecimal getUnitCost() {
        return this.unitCost;
    }

    public void setUnitCost(KualiDecimal unitCost) {
        this.unitCost = unitCost;
    }

    public KualiDecimal getTotalCost() {
        return this.totalCost;
    }

    public void setTotalCost(KualiDecimal totalCost) {
        this.totalCost = totalCost;
    }

    public String getFirstFincialObjectCode() {
        return this.firstFincialObjectCode;
    }

    public void setFirstFincialObjectCode(String firstFincialObjectCode) {
        this.firstFincialObjectCode = firstFincialObjectCode;
    }

    public String getPreTagInquiryUrl() {
        if (StringUtils.isNotBlank((CharSequence)this.preTagInquiryUrl)) {
            return this.preTagInquiryUrl;
        }
        if (ObjectUtils.isNotNull((Object)((Object)this.getPurchasingAccountsPayableDocument()))) {
            Integer purchaseOrderIdentifier = this.getPurchasingAccountsPayableDocument().getPurchaseOrderIdentifier();
            PurApLineService purApLineService = (PurApLineService)SpringContext.getBean(PurApLineService.class);
            if (purApLineService.isPretaggingExisting(purApLineService.getPreTagLineItem(purchaseOrderIdentifier, this.getItemLineNumber()))) {
                String baseUrl = "inquiry.do";
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("methodToCall", "start");
                parameters.put("businessObjectClassName", Pretag.class.getName());
                parameters.put("purchaseOrderNumber", purchaseOrderIdentifier.toString());
                parameters.put("itemLineNumber", this.getItemLineNumber().toString());
                this.preTagInquiryUrl = UrlFactory.parameterizeUrl((String)"inquiry.do", parameters);
                return this.preTagInquiryUrl;
            }
        }
        return "";
    }

    @Override
    public int compareTo(PurchasingAccountsPayableItemAsset o) {
        boolean o2ItemTypeBelowTheLine;
        boolean o1ItemTypeBelowTheLine = this.isAdditionalChargeNonTradeInIndicator() || this.isTradeInAllowance();
        boolean bl = o2ItemTypeBelowTheLine = o.isAdditionalChargeNonTradeInIndicator() || o.isTradeInAllowance();
        if (o1ItemTypeBelowTheLine && !o2ItemTypeBelowTheLine) {
            return 1;
        }
        if (o2ItemTypeBelowTheLine && !o1ItemTypeBelowTheLine) {
            return -1;
        }
        return 0;
    }

    public List<Long> getApprovedAssetNumbers() {
        if (this.approvedAssetNumbers != null && !this.approvedAssetNumbers.isEmpty()) {
            return this.approvedAssetNumbers;
        }
        this.approvedAssetNumbers = new ArrayList<Long>();
        if (StringUtils.isNotEmpty((CharSequence)this.getCapitalAssetManagementDocumentNumber())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            if ("P".equalsIgnoreCase(this.getActivityStatusCode())) {
                fieldValues.put("documentNumber", this.getCapitalAssetManagementDocumentNumber());
                Collection assetGlobalDetails = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(AssetGlobalDetail.class, fieldValues);
                for (AssetGlobalDetail detail : assetGlobalDetails) {
                    this.approvedAssetNumbers.add(detail.getCapitalAssetNumber());
                }
                if (assetGlobalDetails.isEmpty()) {
                    fieldValues.clear();
                    fieldValues.put("documentNumber", this.getCapitalAssetManagementDocumentNumber());
                    Collection paymentAssetDetails = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(AssetPaymentAssetDetail.class, fieldValues);
                    for (AssetPaymentAssetDetail detail : paymentAssetDetails) {
                        this.approvedAssetNumbers.add(detail.getCapitalAssetNumber());
                    }
                }
            }
        }
        return this.approvedAssetNumbers;
    }

    public PurchasingAccountsPayableLineAssetAccount getPurchasingAccountsPayableLineAssetAccount(int index) {
        int size = this.getPurchasingAccountsPayableLineAssetAccounts().size();
        while (size <= index || this.getPurchasingAccountsPayableLineAssetAccounts().get(index) == null) {
            this.getPurchasingAccountsPayableLineAssetAccounts().add(size++, new PurchasingAccountsPayableLineAssetAccount());
        }
        return this.getPurchasingAccountsPayableLineAssetAccounts().get(index);
    }

    public Integer getPaymentRequestIdentifier() {
        return this.paymentRequestIdentifier;
    }

    public void setPaymentRequestIdentifier(Integer paymentRequestIdentifier) {
        this.paymentRequestIdentifier = paymentRequestIdentifier;
    }

    public boolean isActiveAdditionalTRDI() {
        return this.isTradeInAllowance() && this.isActive();
    }

    public boolean isActiveAdditionalNonTRDI() {
        return this.isAdditionalChargeNonTradeInIndicator() && this.isActive();
    }

    public boolean isActiveItemTradeIn() {
        return !this.isAdditionalChargeNonTradeInIndicator() && !this.isTradeInAllowance() && this.isItemAssignedToTradeInIndicator() && this.isActive();
    }

    public boolean isActiveItemLine() {
        return !this.isAdditionalChargeNonTradeInIndicator() && !this.isTradeInAllowance() && this.isActive();
    }
}

