/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.core.api.search.SearchOperator;
import org.kuali.kfs.kim.api.permission.PermissionService;
import org.kuali.kfs.kns.lookup.CollectionIncomplete;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.lookup.LookupUtils;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.businessobject.GeneralLedgerEntry;
import org.kuali.kfs.module.cam.businessobject.GeneralLedgerEntryAsset;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableDocument;

public class GeneralLedgerEntryLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private PermissionService permissionService;

    public List<HtmlData> getCustomActionUrls(BusinessObject bo, List pkNames) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("namespaceCode", "KFS-CAM");
        permissionDetails.put("actionClass", "org.kuali.kfs.module.cam.web.struts.CapitalAssetInformationAction");
        if (!this.permissionService.hasPermissionByTemplate(GlobalVariables.getUserSession().getPrincipalId(), "KFS-SYS", "Use Screen", permissionDetails)) {
            return super.getEmptyActionUrls();
        }
        GeneralLedgerEntry entry = (GeneralLedgerEntry)bo;
        ArrayList<HtmlData> anchorHtmlDataList = new ArrayList<HtmlData>();
        if (entry.isActive()) {
            HtmlData.AnchorHtmlData processLink = new HtmlData.AnchorHtmlData("camsCapitalAssetInformation.do?methodToCall=process&generalLedgerAccountIdentifier=" + entry.getGeneralLedgerAccountIdentifier(), "process", "process");
            processLink.setTarget(entry.getGeneralLedgerAccountIdentifier().toString());
            anchorHtmlDataList.add((HtmlData)processLink);
        } else {
            List<GeneralLedgerEntryAsset> generalLedgerEntryAssets = entry.getGeneralLedgerEntryAssets();
            if (!generalLedgerEntryAssets.isEmpty()) {
                for (GeneralLedgerEntryAsset generalLedgerEntryAsset : generalLedgerEntryAssets) {
                    HtmlData.AnchorHtmlData viewDocLink = new HtmlData.AnchorHtmlData("camsCapitalAssetInformation.do?methodToCall=viewDoc&documentNumber=" + generalLedgerEntryAsset.getCapitalAssetManagementDocumentNumber(), "viewDoc", generalLedgerEntryAsset.getCapitalAssetManagementDocumentNumber());
                    viewDocLink.setTarget(generalLedgerEntryAssets.get(0).getCapitalAssetManagementDocumentNumber());
                    anchorHtmlDataList.add((HtmlData)viewDocLink);
                }
            } else {
                anchorHtmlDataList.add((HtmlData)new HtmlData.AnchorHtmlData("", "n/a", "n/a"));
            }
        }
        return anchorHtmlDataList;
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        this.updateStatusCodeCriteria(fieldValues);
        List searchResults = super.getSearchResults(fieldValues);
        if (searchResults == null || searchResults.isEmpty()) {
            return searchResults;
        }
        Integer searchResultsLimit = LookupUtils.getSearchResultsLimit(GeneralLedgerEntry.class);
        ArrayList<GeneralLedgerEntry> newList = new ArrayList<GeneralLedgerEntry>();
        for (BusinessObject businessObject : searchResults) {
            GeneralLedgerEntry entry = (GeneralLedgerEntry)businessObject;
            if ("PREQ".equals(entry.getFinancialDocumentTypeCode())) continue;
            if (!"CM".equals(entry.getFinancialDocumentTypeCode())) {
                newList.add(entry);
                continue;
            }
            if (!"CM".equals(entry.getFinancialDocumentTypeCode())) continue;
            HashMap<String, String> cmKeys = new HashMap<String, String>();
            cmKeys.put("documentNumber", entry.getDocumentNumber());
            Collection matchingCreditMemos = this.businessObjectService.findMatching(PurchasingAccountsPayableDocument.class, cmKeys);
            if (matchingCreditMemos != null && !matchingCreditMemos.isEmpty()) continue;
            newList.add(entry);
        }
        long matchingResultsCount = newList.size();
        if (matchingResultsCount <= (long)searchResultsLimit.intValue()) {
            matchingResultsCount = 0L;
        }
        return new CollectionIncomplete(newList, Long.valueOf(matchingResultsCount));
    }

    protected void updateStatusCodeCriteria(Map<String, String> fieldValues) {
        String activityStatusCode = null;
        if (fieldValues.containsKey("activityStatusCode")) {
            activityStatusCode = fieldValues.get("activityStatusCode");
        }
        if ("N".equalsIgnoreCase(activityStatusCode)) {
            fieldValues.put("activityStatusCode", "N");
        } else if ("Y".equalsIgnoreCase(activityStatusCode)) {
            fieldValues.put("activityStatusCode", "P" + SearchOperator.OR.op() + "E");
        }
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

