/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetDepreciationConvention;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.document.service.AssetDateService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.service.UniversityDateService;

public class AssetDateServiceImpl
implements AssetDateService {
    private static final Logger LOG = LogManager.getLogger();
    private AssetService assetService;
    private UniversityDateService universityDateService;
    private DateTimeService dateTimeService;
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;

    @Override
    public void checkAndUpdateFiscalYearAndPeriod(Asset oldAsset, Asset newAsset) {
        if (this.assetService.isInServiceDateChanged(oldAsset, newAsset)) {
            Integer newPostingYear = null;
            String newPostingPeriodCode = null;
            if (ObjectUtils.isNotNull((Object)newAsset.getCapitalAssetInServiceDate())) {
                HashMap<String, Date> primaryKeys = new HashMap<String, Date>();
                primaryKeys.put("universityDate", newAsset.getCapitalAssetInServiceDate());
                UniversityDate inServiceDate = (UniversityDate)this.businessObjectService.findByPrimaryKey(UniversityDate.class, primaryKeys);
                if (ObjectUtils.isNotNull((Object)inServiceDate)) {
                    newPostingYear = inServiceDate.getUniversityFiscalYear();
                    newPostingPeriodCode = inServiceDate.getUniversityFiscalAccountingPeriod();
                }
            }
            newAsset.setFinancialDocumentPostingYear(newPostingYear);
            newAsset.setFinancialDocumentPostingPeriodCode(newPostingPeriodCode);
        }
    }

    @Override
    public void checkAndUpdateLastInventoryDate(Asset oldAsset, Asset newAsset) {
        if (this.assetService.hasAssetLocationChanged(oldAsset, newAsset)) {
            Timestamp timestamp = new Timestamp(this.dateTimeService.getCurrentDate().getTime());
            newAsset.setLastInventoryDate(timestamp);
        }
    }

    @Override
    public void checkAndUpdateDepreciationDate(Asset oldAsset, Asset newAsset) {
        if (this.assetService.isAssetTypeCodeChanged(oldAsset, newAsset) && this.assetService.isAssetDepreciableLifeLimitZero(newAsset)) {
            newAsset.setDepreciationDate(null);
            newAsset.setCapitalAssetInServiceDate(null);
        } else if (this.assetService.isInServiceDateChanged(oldAsset, newAsset) || this.assetService.isFinancialObjectSubTypeCodeChanged(oldAsset, newAsset)) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put("financialObjectSubTypeCode", newAsset.getFinancialObjectSubTypeCode());
            AssetDepreciationConvention depreciationConvention = (AssetDepreciationConvention)this.businessObjectService.findByPrimaryKey(AssetDepreciationConvention.class, primaryKeys);
            newAsset.setDepreciationDate(this.computeDepreciationDate(newAsset.getCapitalAssetType(), depreciationConvention, newAsset.getCapitalAssetInServiceDate()));
        }
    }

    @Override
    public Date computeDepreciationDate(AssetType assetType, AssetDepreciationConvention depreciationConvention, Date inServiceDate) {
        Date depreciationDate = null;
        if (assetType.getDepreciableLifeLimit() != null && assetType.getDepreciableLifeLimit() != 0) {
            if (depreciationConvention == null || !depreciationConvention.isActive() || "CD".equalsIgnoreCase(depreciationConvention.getDepreciationConventionCode())) {
                depreciationDate = inServiceDate;
            } else {
                Date newInServiceFiscalYearStartDate;
                Integer fiscalYear = this.universityDateService.getFiscalYear((java.util.Date)inServiceDate);
                if (fiscalYear == null) {
                    throw new ValidationException("University Fiscal year is not defined for date - " + inServiceDate);
                }
                String newInServiceAssetDepreciationStartMMDD = this.parameterService.getParameterValueAsString(AssetGlobal.class, "NEW_IN_SERVICE_ASSET_DEPRECIATION_START_DATE");
                try {
                    newInServiceFiscalYearStartDate = this.dateTimeService.convertToSqlDate(newInServiceAssetDepreciationStartMMDD + "/" + fiscalYear);
                }
                catch (Exception e) {
                    String error = "Unable to construct new in service fiscal year start date - param value: [ " + newInServiceAssetDepreciationStartMMDD + "]";
                    LOG.error(error, (Throwable)e);
                    throw new IllegalArgumentException(error, e);
                }
                String conventionCode = depreciationConvention.getDepreciationConventionCode();
                if ("FY".equalsIgnoreCase(conventionCode)) {
                    LocalDate localDate = this.dateTimeService.getLocalDate(newInServiceFiscalYearStartDate).minusYears(1L);
                    depreciationDate = Date.valueOf(localDate);
                } else if ("HY".equalsIgnoreCase(conventionCode)) {
                    Date newInServiceFiscalYearStartDateForHalfYear;
                    try {
                        newInServiceFiscalYearStartDateForHalfYear = this.dateTimeService.convertToSqlDate("01/01/" + fiscalYear);
                    }
                    catch (Exception e) {
                        String error = "Unable to construct new in service fiscal year start date";
                        LOG.error("Unable to construct new in service fiscal year start date", (Throwable)e);
                        throw new IllegalArgumentException("Unable to construct new in service fiscal year start date", e);
                    }
                    depreciationDate = newInServiceFiscalYearStartDateForHalfYear;
                }
            }
        }
        return depreciationDate;
    }

    public AssetService getAssetService() {
        return this.assetService;
    }

    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    public UniversityDateService getUniversityDateService() {
        return this.universityDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public Date computeDepreciationDateForPeriod13(String depreciationConventionCode, Date inServiceDate) {
        Date depreciationDate = null;
        Integer fiscalYear = this.getUniversityDateService().getFiscalYear((java.util.Date)inServiceDate);
        Date fiscalYearStartDate = new Date(this.getUniversityDateService().getFirstDateOfFiscalYear(fiscalYear).getTime());
        if ("CD".equals(depreciationConventionCode)) {
            depreciationDate = inServiceDate;
        } else if ("FY".equals(depreciationConventionCode)) {
            depreciationDate = fiscalYearStartDate;
        } else if ("HY".equals(depreciationConventionCode)) {
            LocalDate localDate = this.dateTimeService.getLocalDate(fiscalYearStartDate).plusMonths(6L);
            depreciationDate = Date.valueOf(localDate);
        }
        return depreciationDate;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

