/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.gl.businessobject.Entry;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.AccountLineGroup;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLineBase;

public class GlAccountLineGroup
extends AccountLineGroup {
    private Entry targetEntry;
    private List<Entry> sourceEntries = new ArrayList<Entry>();
    private List<PurApAccountingLineBase> matchedPurApAcctLines = new ArrayList<PurApAccountingLineBase>();

    public GlAccountLineGroup(Entry entry) {
        this.setUniversityFiscalYear(entry.getUniversityFiscalYear());
        this.setChartOfAccountsCode(entry.getChartOfAccountsCode());
        this.setAccountNumber(entry.getAccountNumber());
        this.setSubAccountNumber(entry.getSubAccountNumber());
        this.setFinancialObjectCode(entry.getFinancialObjectCode());
        this.setFinancialSubObjectCode(entry.getFinancialSubObjectCode());
        this.setUniversityFiscalPeriodCode(entry.getUniversityFiscalPeriodCode());
        this.setDocumentNumber(entry.getDocumentNumber());
        this.setReferenceFinancialDocumentNumber(entry.getReferenceFinancialDocumentNumber());
        this.setOrganizationReferenceId(entry.getOrganizationReferenceId());
        this.setProjectCode(entry.getProjectCode());
        this.sourceEntries.add(entry);
        this.targetEntry = (Entry)ObjectUtils.deepCopy((Serializable)entry);
        KualiDecimal amount = entry.getTransactionLedgerEntryAmount();
        if ("C".equals(entry.getTransactionDebitCreditCode())) {
            this.setAmount((KualiDecimal)amount.negated());
        } else {
            this.setAmount(amount);
        }
    }

    public boolean isAccounted(Entry entry) {
        GlAccountLineGroup test = new GlAccountLineGroup(entry);
        return this.equals(test);
    }

    public void combineEntry(Entry newEntry) {
        this.sourceEntries.add(newEntry);
        KualiDecimal newAmt = newEntry.getTransactionLedgerEntryAmount();
        String newDebitCreditCode = newEntry.getTransactionDebitCreditCode();
        KualiDecimal targetAmount = this.targetEntry.getTransactionLedgerEntryAmount();
        String targetDebitCreditCode = this.targetEntry.getTransactionDebitCreditCode();
        if (targetDebitCreditCode.equals(newDebitCreditCode)) {
            targetAmount = (KualiDecimal)targetAmount.add((AbstractKualiDecimal)newAmt);
        } else if (newAmt.isGreaterThan((AbstractKualiDecimal)targetAmount)) {
            targetDebitCreditCode = newDebitCreditCode;
            targetAmount = (KualiDecimal)newAmt.subtract((AbstractKualiDecimal)targetAmount);
        } else {
            targetAmount = (KualiDecimal)targetAmount.subtract((AbstractKualiDecimal)newAmt);
        }
        this.targetEntry.setTransactionDebitCreditCode(targetDebitCreditCode);
        this.targetEntry.setTransactionLedgerEntryAmount(targetAmount);
        if ("C".equals(targetDebitCreditCode)) {
            this.setAmount((KualiDecimal)targetAmount.negated());
        } else {
            this.setAmount(targetAmount);
        }
    }

    public Entry getTargetEntry() {
        return this.targetEntry;
    }

    public void setTargetEntry(Entry targetGlEntry) {
        this.targetEntry = targetGlEntry;
    }

    public List<Entry> getSourceEntries() {
        return this.sourceEntries;
    }

    public void setSourceEntries(List<Entry> sourceGlEntries) {
        this.sourceEntries = sourceGlEntries;
    }

    public List<PurApAccountingLineBase> getMatchedPurApAcctLines() {
        return this.matchedPurApAcctLines;
    }

    public void setMatchedPurApAcctLines(List<PurApAccountingLineBase> matchedPurApAcctLines) {
        this.matchedPurApAcctLines = matchedPurApAcctLines;
    }
}

