/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.kfs.krad.document.Copyable;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.batch.AssetDepreciationStep;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetObjectCode;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAllocationType;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentInProcessPayment;
import org.kuali.kfs.module.cam.document.service.AssetObjectCodeService;
import org.kuali.kfs.module.cam.document.service.AssetPaymentService;
import org.kuali.kfs.module.cam.document.validation.event.AssetPaymentManuallyAddAccountingLineEvent;
import org.kuali.kfs.module.cam.util.distribution.AssetDistribution;
import org.kuali.kfs.module.cam.util.distribution.AssetDistributionEvenly;
import org.kuali.kfs.module.cam.util.distribution.AssetDistributionManual;
import org.kuali.kfs.module.cam.util.distribution.AssetDistributionPercent;
import org.kuali.kfs.module.cam.util.distribution.AssetPaymentDistributionByTotalCost;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocumentBase;
import org.kuali.kfs.sys.document.AmountTotaling;
import org.kuali.kfs.sys.document.validation.impl.AccountingDocumentRuleBaseConstants;

public class AssetPaymentDocument
extends AccountingDocumentBase
implements Copyable,
AmountTotaling {
    private static final Logger LOG = LogManager.getLogger();
    protected List<AssetPaymentAssetDetail> assetPaymentAssetDetail;
    protected Long capitalAssetNumber;
    protected boolean capitalAssetBuilderOriginIndicator;
    protected AssetPaymentAllocationType assetPaymentAllocationType;
    protected String assetPaymentAllocationTypeCode;
    protected boolean allocationFromFPDocuments;
    protected List<AssetPaymentInProcessPayment> assetPaymentInProcessPayments;
    protected transient AssetPayment apipAssetPaymentHelper;
    protected transient KualiDecimal apipAssetPaymentTotalDepreciationHelper;

    public AssetPaymentDocument() {
        this.setAllocationFromFPDocuments(false);
        this.assetPaymentAllocationTypeCode = "2";
        this.setAssetPaymentAssetDetail(new ArrayList<AssetPaymentAssetDetail>());
        this.setAssetPaymentInProcessPayments(new ArrayList<AssetPaymentInProcessPayment>());
    }

    public List buildListOfDeletionAwareLists() {
        List deletionAwareList = super.buildListOfDeletionAwareLists();
        deletionAwareList.add(this.getAssetPaymentAssetDetail());
        deletionAwareList.add(this.getAssetPaymentInProcessPayments());
        return deletionAwareList;
    }

    public List generateSaveEvents() {
        ArrayList<AssetPaymentManuallyAddAccountingLineEvent> subEvents = new ArrayList<AssetPaymentManuallyAddAccountingLineEvent>();
        if (!this.isCapitalAssetBuilderOriginIndicator()) {
            String errorPathPrefix = "document.sourceAccountingLines";
            int index = 0;
            Iterator i = this.getSourceAccountingLines().iterator();
            while (i.hasNext()) {
                String indexedErrorPathPrefix = "document.sourceAccountingLines[" + index + "]";
                AccountingLine currentLine = (AccountingLine)i.next();
                AssetPaymentManuallyAddAccountingLineEvent newSubEvent = new AssetPaymentManuallyAddAccountingLineEvent(indexedErrorPathPrefix, (Document)this, currentLine);
                subEvents.add(newSubEvent);
                ++index;
            }
        }
        subEvents.addAll(super.generateSaveEvents());
        return subEvents;
    }

    public List<String> getWorkflowEngineDocumentIdsToLock() {
        String poDocId;
        ArrayList<String> documentIds = null;
        if (this.isCapitalAssetBuilderOriginIndicator() && StringUtils.isNotBlank((CharSequence)(poDocId = ((CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class)).getCurrentPurchaseOrderDocumentNumber(this.getDocumentNumber())))) {
            documentIds = new ArrayList<String>();
            documentIds.add(poDocId);
        }
        return documentIds;
    }

    public boolean isDebit(GeneralLedgerPendingEntrySourceDetail postable) {
        return false;
    }

    public boolean isCapitalAssetBuilderOriginIndicator() {
        return this.capitalAssetBuilderOriginIndicator;
    }

    public void setCapitalAssetBuilderOriginIndicator(boolean capitalAssetBuilderOriginIndicator) {
        this.capitalAssetBuilderOriginIndicator = capitalAssetBuilderOriginIndicator;
    }

    public void addAssetPaymentAssetDetail(AssetPaymentAssetDetail assetPaymentAssetDetail) {
        this.getAssetPaymentAssetDetail().add(assetPaymentAssetDetail);
    }

    public void postProcessSave(KualiDocumentEvent event) {
        super.postProcessSave(event);
        if (!(event instanceof SaveDocumentEvent)) {
            ArrayList<Long> capitalAssetNumbers = new ArrayList<Long>();
            for (AssetPaymentAssetDetail assetPaymentAssetDetail : this.getAssetPaymentAssetDetail()) {
                if (assetPaymentAssetDetail.getCapitalAssetNumber() == null) continue;
                capitalAssetNumbers.add(assetPaymentAssetDetail.getCapitalAssetNumber());
            }
            String documentTypeForLocking = "MPAY";
            if (this.isCapitalAssetBuilderOriginIndicator()) {
                documentTypeForLocking = "MPAYCAB";
            }
            if (!this.getCapitalAssetManagementModuleService().storeAssetLocks(capitalAssetNumbers, this.getDocumentNumber(), documentTypeForLocking, null)) {
                throw new ValidationException("Asset " + capitalAssetNumbers.toString() + " is being locked by other documents.");
            }
        }
    }

    protected CapitalAssetManagementModuleService getCapitalAssetManagementModuleService() {
        return (CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class);
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        WorkflowDocument workflowDocument = this.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isProcessed()) {
            ((AssetPaymentService)SpringContext.getBean(AssetPaymentService.class)).processApprovedAssetPayment(this);
        }
        if (workflowDocument.isCanceled() || workflowDocument.isDisapproved() || workflowDocument.isProcessed()) {
            this.getCapitalAssetManagementModuleService().deleteAssetLocks(this.getDocumentNumber(), null);
        }
        if (this.isCapitalAssetBuilderOriginIndicator()) {
            ((CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class)).notifyRouteStatusChange(this.getDocumentHeader());
        }
    }

    public void prepareForSave(KualiDocumentEvent event) {
        for (AssetPaymentAssetDetail assetDetail : this.getAssetPaymentAssetDetail()) {
            assetDetail.refreshReferenceObject("asset");
            if (ObjectUtils.isNotNull((Object)((Object)assetDetail.getAsset())) && assetDetail.getAsset().getTotalCostAmount() != null) {
                assetDetail.setPreviousTotalCostAmount(assetDetail.getAsset().getTotalCostAmount());
            }
            List<AssetPaymentDetail> apdList = assetDetail.getAssetPaymentDetails();
            for (AssetPaymentDetail apd : apdList) {
                String accountingPeriodCompositeString = this.getAccountingPeriodCompositeString();
                apd.setPostingYear(new Integer(StringUtils.right((String)accountingPeriodCompositeString, (int)4)));
                apd.setPostingPeriodCode(StringUtils.left((String)accountingPeriodCompositeString, (int)2));
            }
        }
        super.prepareForSave(event);
    }

    public void clearAnyGeneralLedgerPendingEntries() {
        List pendingEntrySourceDetails = this.getGeneralLedgerPendingEntrySourceDetails();
        for (GeneralLedgerPendingEntrySourceDetail sourceDetail : pendingEntrySourceDetails) {
            AssetPaymentDetail detail = (AssetPaymentDetail)sourceDetail;
            detail.setTransferPaymentIndicator(false);
        }
        super.clearAnyGeneralLedgerPendingEntries();
    }

    public boolean generateGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        LOG.debug("processGenerateGeneralLedgerPendingEntries(AccountingDocument, AccountingLine, GeneralLedgerPendingEntrySequenceHelper) - start");
        boolean success = true;
        AssetPaymentDetail assetPaymentDetail = (AssetPaymentDetail)glpeSourceDetail;
        for (AssetPaymentAssetDetail assetDetail : this.getAssetPaymentAssetDetail()) {
            this.apipAssetPaymentTotalDepreciationHelper = new KualiDecimal(0);
            for (AssetPaymentInProcessPayment assetPaymentInProcessPayment : this.assetPaymentInProcessPayments) {
                if (!assetPaymentInProcessPayment.getCapitalAssetNumber().equals(assetDetail.getCapitalAssetNumber()) || !assetPaymentInProcessPayment.getSequenceNumber().equals(assetPaymentDetail.getSequenceNumber())) continue;
                assetPaymentInProcessPayment.refreshReferenceObject("assetPayment");
                AssetPayment apipAssetPayment = assetPaymentInProcessPayment.getAssetPayment();
                if (ObjectUtils.isNotNull((Object)apipAssetPayment.getAccumulatedPrimaryDepreciationAmount())) {
                    this.apipAssetPaymentTotalDepreciationHelper = (KualiDecimal)this.apipAssetPaymentTotalDepreciationHelper.add((AbstractKualiDecimal)apipAssetPayment.getAccumulatedPrimaryDepreciationAmount());
                }
                this.apipAssetPaymentHelper = apipAssetPayment;
                assetPaymentDetail.setTransferPaymentIndicator(true);
            }
            if (!this.apipAssetPaymentTotalDepreciationHelper.isNonZero()) continue;
            success &= super.generateGeneralLedgerPendingEntries(glpeSourceDetail, sequenceHelper);
            sequenceHelper.increment();
        }
        return success;
    }

    public void customizeExplicitGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail postable, GeneralLedgerPendingEntry explicitEntry) {
        this.determinePlantFund(postable.getObjectCode().getFinancialObjectSubTypeCode(), explicitEntry);
        AssetObjectCodeService assetObjectCodeService = (AssetObjectCodeService)SpringContext.getBean(AssetObjectCodeService.class);
        AssetObjectCode assetObjectCode = assetObjectCodeService.findAssetObjectCode(this.apipAssetPaymentHelper.getChartOfAccountsCode(), this.apipAssetPaymentHelper.getFinancialObject().getFinancialObjectSubTypeCode());
        explicitEntry.setFinancialObjectCode(assetObjectCode.getAccumulatedDepreciationFinancialObjectCode());
        explicitEntry.setFinancialObjectTypeCode(assetObjectCode.getAccumulatedDepreciationFinancialObject().getFinancialObjectTypeCode());
        explicitEntry.setTransactionLedgerEntryAmount((KualiDecimal)this.apipAssetPaymentTotalDepreciationHelper.abs());
        explicitEntry.setTransactionLedgerEntryDescription("Depreciation Correction Asset " + this.apipAssetPaymentHelper.getCapitalAssetNumber());
        if (this.apipAssetPaymentTotalDepreciationHelper.isPositive()) {
            explicitEntry.setTransactionDebitCreditCode("D");
        } else {
            explicitEntry.setTransactionDebitCreditCode("C");
        }
        explicitEntry.setSubAccountNumber(AccountingDocumentRuleBaseConstants.GENERAL_LEDGER_PENDING_ENTRY_CODE.getBlankSubAccountNumber());
        explicitEntry.setFinancialSubObjectCode(AccountingDocumentRuleBaseConstants.GENERAL_LEDGER_PENDING_ENTRY_CODE.getBlankFinancialSubObjectCode());
    }

    public boolean customizeOffsetGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail accountingLine, GeneralLedgerPendingEntry explicitEntry, GeneralLedgerPendingEntry offsetEntry) {
        offsetEntry.setAccountNumber(explicitEntry.getAccountNumber());
        offsetEntry.setChartOfAccountsCode(explicitEntry.getChartOfAccountsCode());
        AssetObjectCodeService assetObjectCodeService = (AssetObjectCodeService)SpringContext.getBean(AssetObjectCodeService.class);
        AssetObjectCode assetObjectCode = assetObjectCodeService.findAssetObjectCode(this.apipAssetPaymentHelper.getChartOfAccountsCode(), this.apipAssetPaymentHelper.getFinancialObject().getFinancialObjectSubTypeCode());
        offsetEntry.setFinancialObjectCode(assetObjectCode.getDepreciationExpenseFinancialObjectCode());
        offsetEntry.setFinancialObjectTypeCode(assetObjectCode.getDepreciationExpenseFinancialObject().getFinancialObjectTypeCode());
        offsetEntry.setTransactionLedgerEntryAmount(explicitEntry.getTransactionLedgerEntryAmount());
        offsetEntry.setTransactionLedgerEntryDescription(explicitEntry.getTransactionLedgerEntryDescription());
        if (explicitEntry.getTransactionDebitCreditCode().equals("C")) {
            offsetEntry.setTransactionDebitCreditCode("D");
        } else {
            offsetEntry.setTransactionDebitCreditCode("C");
        }
        offsetEntry.setSubAccountNumber(AccountingDocumentRuleBaseConstants.GENERAL_LEDGER_PENDING_ENTRY_CODE.getBlankSubAccountNumber());
        offsetEntry.setFinancialSubObjectCode(AccountingDocumentRuleBaseConstants.GENERAL_LEDGER_PENDING_ENTRY_CODE.getBlankFinancialSubObjectCode());
        return true;
    }

    protected void determinePlantFund(String postableFinancialObjectSubTypeCode, GeneralLedgerPendingEntry explicitEntry) {
        String plantAccount = "";
        String plantCOA = "";
        ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        ArrayList organizationPlantFundObjectSubType = new ArrayList();
        ArrayList campusPlantFundObjectSubType = new ArrayList();
        if (parameterService.parameterExists(AssetDepreciationStep.class, "ORGANIZATION_PLANT_FUND_SUB_TYPES").booleanValue()) {
            organizationPlantFundObjectSubType = new ArrayList(parameterService.getParameterValuesAsString(AssetDepreciationStep.class, "ORGANIZATION_PLANT_FUND_SUB_TYPES"));
        }
        if (parameterService.parameterExists(AssetDepreciationStep.class, "CAMPUS_PLANT_FUND_SUB_TYPES").booleanValue()) {
            campusPlantFundObjectSubType = new ArrayList(parameterService.getParameterValuesAsString(AssetDepreciationStep.class, "CAMPUS_PLANT_FUND_SUB_TYPES"));
        }
        Asset apipAssetPaymentAssetHelper = this.apipAssetPaymentHelper.getAsset();
        if (organizationPlantFundObjectSubType.contains(postableFinancialObjectSubTypeCode)) {
            plantAccount = this.apipAssetPaymentHelper.getAccount().getOrganization().getOrganizationPlantAccountNumber();
            plantCOA = this.apipAssetPaymentHelper.getAccount().getOrganization().getOrganizationPlantChartCode();
        } else if (campusPlantFundObjectSubType.contains(postableFinancialObjectSubTypeCode)) {
            plantAccount = this.apipAssetPaymentHelper.getAccount().getOrganization().getCampusPlantAccountNumber();
            plantCOA = this.apipAssetPaymentHelper.getAccount().getOrganization().getCampusPlantChartCode();
        }
        if (StringUtils.isBlank((CharSequence)plantCOA) || StringUtils.isBlank((CharSequence)plantAccount)) {
            String loggablePlantCOA = plantCOA;
            String loggablePlantAccount = plantAccount;
            Supplier[] supplierArray = new Supplier[5];
            supplierArray[0] = () -> loggablePlantCOA;
            supplierArray[1] = () -> loggablePlantAccount;
            supplierArray[2] = apipAssetPaymentAssetHelper::getFinancialObjectSubTypeCode;
            supplierArray[3] = apipAssetPaymentAssetHelper::getCapitalAssetNumber;
            supplierArray[4] = this.apipAssetPaymentHelper::getPaymentSequenceNumber;
            LOG.error("Asset Manual Payment Plant COA is {} and plant account is {} for Financial Object SubType Code = {} so Asset payment will use postables account# and coaCd {} - {}", supplierArray);
        } else {
            explicitEntry.setAccountNumber(plantAccount);
            explicitEntry.setChartOfAccountsCode(plantCOA);
        }
    }

    public List<AssetPaymentAssetDetail> getAssetPaymentAssetDetail() {
        return this.assetPaymentAssetDetail;
    }

    public void setAssetPaymentAssetDetail(List<AssetPaymentAssetDetail> assetPaymentAssetDetail) {
        this.assetPaymentAssetDetail = assetPaymentAssetDetail;
    }

    public Long getCapitalAssetNumber() {
        return this.capitalAssetNumber;
    }

    public void setCapitalAssetNumber(Long capitalAssetNumber) {
        this.capitalAssetNumber = capitalAssetNumber;
    }

    public KualiDecimal getAssetsTotalHistoricalCost() {
        KualiDecimal total = new KualiDecimal(0);
        if (this.getAssetPaymentAssetDetail().isEmpty()) {
            return new KualiDecimal(0);
        }
        for (AssetPaymentAssetDetail detail : this.getAssetPaymentAssetDetail()) {
            KualiDecimal amount = detail.getPreviousTotalCostAmount() == null ? new KualiDecimal(0) : detail.getPreviousTotalCostAmount();
            total = (KualiDecimal)total.add((AbstractKualiDecimal)amount);
        }
        return total;
    }

    public AssetDistribution getAssetPaymentDistributor() {
        if ("1".equals(this.getAssetPaymentAllocationTypeCode())) {
            return new AssetDistributionManual(this);
        }
        if ("4".equals(this.getAssetPaymentAllocationTypeCode())) {
            return new AssetDistributionPercent(this);
        }
        if ("3".equals(this.getAssetPaymentAllocationTypeCode())) {
            return new AssetPaymentDistributionByTotalCost(this);
        }
        return new AssetDistributionEvenly(this);
    }

    public String getAssetPaymentAllocationTypeCode() {
        return this.assetPaymentAllocationTypeCode;
    }

    public void setAssetPaymentAllocationTypeCode(String code) {
        this.assetPaymentAllocationTypeCode = code;
        this.refreshReferenceObject("assetPaymentAllocationType");
    }

    public void setAssetPaymentAllocationType(AssetPaymentAllocationType assetPaymentAllocationType) {
        this.assetPaymentAllocationType = assetPaymentAllocationType;
    }

    public AssetPaymentAllocationType getAssetPaymentAllocationType() {
        return this.assetPaymentAllocationType;
    }

    public boolean isAllocationFromFPDocuments() {
        return this.allocationFromFPDocuments;
    }

    public void setAllocationFromFPDocuments(boolean allocationFromFPDocuments) {
        this.allocationFromFPDocuments = allocationFromFPDocuments;
    }

    public List<AssetPaymentInProcessPayment> getAssetPaymentInProcessPayments() {
        return this.assetPaymentInProcessPayments;
    }

    public void setAssetPaymentInProcessPayments(List<AssetPaymentInProcessPayment> assetPaymentInProcessPayments) {
        this.assetPaymentInProcessPayments = assetPaymentInProcessPayments;
    }
}

