/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.util.distribution;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.util.distribution.AssetDistribution;

public class AssetPaymentDistributionByTotalCost
extends AssetDistribution {
    private final KualiDecimal totalHistoricalCost;
    private Map<String, Map<AssetPaymentAssetDetail, KualiDecimal>> paymentDistributionMap;

    public AssetPaymentDistributionByTotalCost(AssetPaymentDocument doc) {
        super(doc);
        this.totalHistoricalCost = doc.getAssetsTotalHistoricalCost();
        this.calculateAssetPaymentDistributions();
    }

    private void calculateAssetPaymentDistributions() {
        HashMap<String, Map<AssetPaymentAssetDetail, KualiDecimal>> assetPaymentAssetDetailMap = new HashMap<String, Map<AssetPaymentAssetDetail, KualiDecimal>>();
        HashMap<AssetPaymentAssetDetail, Double> assetPaymentsPercentage = new HashMap<AssetPaymentAssetDetail, Double>(this.doc.getAssetPaymentAssetDetail().size());
        for (AssetPaymentAssetDetail assetPaymentAssetDetail : this.doc.getAssetPaymentAssetDetail()) {
            assetPaymentsPercentage.put(assetPaymentAssetDetail, this.getAssetDetailPercentage(this.doc.getAssetPaymentAssetDetail().size(), new Double(this.totalHistoricalCost.toString()), assetPaymentAssetDetail));
        }
        for (AssetPaymentDetail assetPaymentDetail : this.getAssetPaymentDetailLines()) {
            int paymentCount = this.doc.getAssetPaymentAssetDetail().size();
            KualiDecimal unallocatedAmount = assetPaymentDetail.getAmount();
            HashMap<AssetPaymentAssetDetail, KualiDecimal> assetDetailMap = new HashMap<AssetPaymentAssetDetail, KualiDecimal>();
            for (AssetPaymentAssetDetail assetPaymentAssetDetail : this.doc.getAssetPaymentAssetDetail()) {
                KualiDecimal amount;
                Double percentage = (Double)assetPaymentsPercentage.get((Object)assetPaymentAssetDetail);
                if (paymentCount-- == 1) {
                    amount = unallocatedAmount;
                } else {
                    Double paymentAmount = new Double(assetPaymentDetail.getAmount().toString());
                    amount = new KualiDecimal(paymentAmount * percentage);
                    unallocatedAmount = (KualiDecimal)unallocatedAmount.subtract((AbstractKualiDecimal)amount);
                }
                assetDetailMap.put(assetPaymentAssetDetail, amount);
            }
            assetPaymentAssetDetailMap.put(assetPaymentDetail.getAssetPaymentDetailKey(), assetDetailMap);
        }
        this.paymentDistributionMap = assetPaymentAssetDetailMap;
    }

    @Override
    public Map<String, Map<AssetPaymentAssetDetail, KualiDecimal>> getAssetPaymentDistributions() {
        return this.paymentDistributionMap;
    }

    public Map<AssetPaymentAssetDetail, KualiDecimal> getTotalAssetAllocations() {
        HashMap<AssetPaymentAssetDetail, KualiDecimal> assetTotalAllocationMap = new HashMap<AssetPaymentAssetDetail, KualiDecimal>();
        for (Map<AssetPaymentAssetDetail, KualiDecimal> assetDistribution : this.getAssetPaymentDistributions().values()) {
            for (AssetPaymentAssetDetail assetDetail : assetDistribution.keySet()) {
                KualiDecimal allocation = assetDistribution.get((Object)assetDetail);
                KualiDecimal total = (KualiDecimal)assetTotalAllocationMap.get((Object)assetDetail);
                assetTotalAllocationMap.put(assetDetail, total == null ? allocation : (KualiDecimal)total.add((AbstractKualiDecimal)allocation));
            }
        }
        return assetTotalAllocationMap;
    }

    private Double getAssetDetailPercentage(int detailSize, Double totalHistoricalCost, AssetPaymentAssetDetail assetPaymentAssetDetail) {
        Double previousTotalCostAmount = new Double("0");
        if (assetPaymentAssetDetail.getPreviousTotalCostAmount() != null) {
            previousTotalCostAmount = new Double((String)StringUtils.defaultIfEmpty((CharSequence)assetPaymentAssetDetail.getPreviousTotalCostAmount().toString(), (CharSequence)"0"));
        }
        double percentage = totalHistoricalCost.compareTo(0.0) != 0 ? previousTotalCostAmount / totalHistoricalCost : 1.0 / (double)detailSize;
        return percentage;
    }

    public String getLabel() {
        return this.getClass().getSimpleName();
    }
}

