/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

public class PurchasingAccountsPayableActionHistory extends PersistableBusinessObjectBase {

    private Long actionIdentifier;
    private String actionTypeCode;
    private String fromDocumentNumber;
    private Integer fromPurApLineItemIdentifier;
    private Integer fromCabLineNumber;
    private String toDocumentNumber;
    private Integer toPurApLineItemIdentifier;
    private Integer toCabLineNumber;
    private Long generalLedgerAccountIdentifier;
    private KualiDecimal itemAccountTotalAmount;
    private KualiDecimal accountsPayableItemQuantity;
    private boolean active;

    public PurchasingAccountsPayableActionHistory() {

    }

    public PurchasingAccountsPayableActionHistory(PurchasingAccountsPayableItemAsset fromItem,
            PurchasingAccountsPayableItemAsset toItem, String actionType) {
        this.actionTypeCode = actionType;
        this.fromDocumentNumber = fromItem.getDocumentNumber();
        this.fromPurApLineItemIdentifier = fromItem.getAccountsPayableLineItemIdentifier();
        this.fromCabLineNumber = fromItem.getCapitalAssetBuilderLineNumber();
        if (toItem != null) {
            this.toDocumentNumber = toItem.getDocumentNumber();
            this.toPurApLineItemIdentifier = toItem.getAccountsPayableLineItemIdentifier();
            this.toCabLineNumber = toItem.getCapitalAssetBuilderLineNumber();
        }
        this.active = true;
    }

    public Long getActionIdentifier() {
        return actionIdentifier;
    }

    public void setActionIdentifier(Long actionIdentifier) {
        this.actionIdentifier = actionIdentifier;
    }

    public String getActionTypeCode() {
        return actionTypeCode;
    }

    public void setActionTypeCode(String actionTypeCode) {
        this.actionTypeCode = actionTypeCode;
    }

    public String getFromDocumentNumber() {
        return fromDocumentNumber;
    }

    public void setFromDocumentNumber(String fromDocumentNumber) {
        this.fromDocumentNumber = fromDocumentNumber;
    }

    public Integer getFromPurApLineItemIdentifier() {
        return fromPurApLineItemIdentifier;
    }

    public void setFromPurApLineItemIdentifier(Integer fromPurApLineItemIdentifier) {
        this.fromPurApLineItemIdentifier = fromPurApLineItemIdentifier;
    }

    public Integer getFromCabLineNumber() {
        return fromCabLineNumber;
    }

    public void setFromCabLineNumber(Integer fromCabLineNumber) {
        this.fromCabLineNumber = fromCabLineNumber;
    }

    public String getToDocumentNumber() {
        return toDocumentNumber;
    }

    public void setToDocumentNumber(String toDocumentNumber) {
        this.toDocumentNumber = toDocumentNumber;
    }

    public Integer getToPurApLineItemIdentifier() {
        return toPurApLineItemIdentifier;
    }

    public void setToPurApLineItemIdentifier(Integer toPurApLineItemIdentifier) {
        this.toPurApLineItemIdentifier = toPurApLineItemIdentifier;
    }

    public Integer getToCabLineNumber() {
        return toCabLineNumber;
    }

    public void setToCabLineNumber(Integer toCabLineNumber) {
        this.toCabLineNumber = toCabLineNumber;
    }

    public Long getGeneralLedgerAccountIdentifier() {
        return generalLedgerAccountIdentifier;
    }

    public void setGeneralLedgerAccountIdentifier(Long generalLedgerAccountIdentifier) {
        this.generalLedgerAccountIdentifier = generalLedgerAccountIdentifier;
    }

    public KualiDecimal getItemAccountTotalAmount() {
        return itemAccountTotalAmount;
    }

    public void setItemAccountTotalAmount(KualiDecimal itemAccountTotalAmount) {
        this.itemAccountTotalAmount = itemAccountTotalAmount;
    }

    public KualiDecimal getAccountsPayableItemQuantity() {
        return accountsPayableItemQuantity;
    }

    public void setAccountsPayableItemQuantity(KualiDecimal accountsPayableItemQuantity) {
        this.accountsPayableItemQuantity = accountsPayableItemQuantity;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

}
