/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document;

import java.sql.Date;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coa.service.impl.ObjectCodeServiceImpl;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cam.businessobject.AssetDepreciationConvention;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.document.AssetGlobalMaintainableImpl;
import org.kuali.kfs.module.cam.document.service.AssetDateService;
import org.kuali.kfs.module.cam.document.service.AssetGlobalService;
import org.kuali.kfs.module.cam.document.service.impl.AssetDateServiceImpl;
import org.kuali.kfs.module.cam.document.service.impl.AssetGlobalServiceImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.test.util.ReflectionTestUtils;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class AssetGlobalMaintainableImplTest {
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock(stubOnly=true)
    private AccountingPeriodService accountingPeriodSvcMock;
    private AssetGlobalMaintainableImpl assetGlobalMaintainable;
    private AssetGlobal assetGlobal;
    private Date now;
    private Date yesterday;

    AssetGlobalMaintainableImplTest() {
    }

    @BeforeEach
    public void setUp() {
        long currentTimeMillis = System.currentTimeMillis();
        this.now = new Date(currentTimeMillis);
        this.yesterday = new Date(currentTimeMillis - 86400000L);
        this.assetGlobalMaintainable = new StubAssetGlobalMaintainableImpl();
        this.assetGlobal = new AssetGlobal();
        this.assetGlobal.setCreateDate(this.yesterday);
        this.assetGlobal.setCapitalAssetInServiceDate(this.now);
        this.assetGlobal.setCapitalAssetDepreciationDate(this.now);
        this.assetGlobal.setCapitalAssetTypeCode("07009");
        AssetType assetType = new AssetType();
        this.assetGlobal.setCapitalAssetType(assetType);
        ArrayList<AssetPaymentDetail> assetPaymentDetails = new ArrayList<AssetPaymentDetail>();
        AssetPaymentDetail assetPaymentDetail = new AssetPaymentDetail();
        assetPaymentDetail.setPostingYear(Integer.valueOf(2017));
        assetPaymentDetails.add(assetPaymentDetail);
        this.assetGlobal.setAssetPaymentDetails(assetPaymentDetails);
        this.assetGlobalMaintainable.setBusinessObject((PersistableBusinessObject)this.assetGlobal);
        this.assetGlobalMaintainable.setAssetGlobalService((AssetGlobalService)new AssetGlobalServiceImpl());
        this.assetGlobalMaintainable.setBusinessObjectService(this.businessObjectSvcMock);
        this.assetGlobalMaintainable.setObjectCodeService((ObjectCodeService)new StubObjectCodeServiceImpl());
        this.assetGlobalMaintainable.setAssetDateService((AssetDateService)new StubAssetDateServiceImpl());
        ReflectionTestUtils.setField((Object)this.assetGlobalMaintainable, (String)"accountingPeriodService", (Object)this.accountingPeriodSvcMock);
    }

    @Test
    void prepareForSaveAssetNotSeparate(@Mock(stubOnly=true) AccountingPeriod ap) {
        this.assetGlobal.getCapitalAssetType().setDepreciableLifeLimit(Integer.valueOf(1));
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate((Date)ArgumentMatchers.any())).thenReturn((Object)ap);
        this.assetGlobalMaintainable.prepareForSave();
        Assertions.assertEquals((Object)this.yesterday, (Object)this.assetGlobal.getCreateDate());
        Assertions.assertEquals((Object)this.yesterday, (Object)this.assetGlobal.getCapitalAssetInServiceDate());
        Assertions.assertEquals((Object)this.yesterday, (Object)this.assetGlobal.getCapitalAssetDepreciationDate());
    }

    @Test
    void prepareForSaveAssetNotSeparateNoDepreciableLifeLimit(@Mock(stubOnly=true) AccountingPeriod ap) {
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate((Date)ArgumentMatchers.any())).thenReturn((Object)ap);
        this.assetGlobalMaintainable.prepareForSave();
        Assertions.assertEquals((Object)this.yesterday, (Object)this.assetGlobal.getCreateDate());
        Assertions.assertNull((Object)this.assetGlobal.getCapitalAssetInServiceDate());
        Assertions.assertEquals((Object)this.yesterday, (Object)this.assetGlobal.getCapitalAssetDepreciationDate());
    }

    @Test
    void prepareForSaveAssetSeparate(@Mock(stubOnly=true) AccountingPeriod ap) {
        this.assetGlobal.getCapitalAssetType().setDepreciableLifeLimit(Integer.valueOf(1));
        this.assetGlobal.setFinancialDocumentTypeCode("ASEP");
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate((Date)ArgumentMatchers.any())).thenReturn((Object)ap);
        this.assetGlobalMaintainable.prepareForSave();
        Assertions.assertEquals((Object)this.yesterday, (Object)this.assetGlobal.getCreateDate());
        Assertions.assertEquals((Object)this.now, (Object)this.assetGlobal.getCapitalAssetInServiceDate());
        Assertions.assertEquals((Object)this.now, (Object)this.assetGlobal.getCapitalAssetDepreciationDate());
    }

    @Test
    void computeFiscalYearAndPeriodInServiceDate() {
        this.assetGlobal.getCapitalAssetType().setDepreciableLifeLimit(Integer.valueOf(1));
        String testPeriodCode = "12";
        int testFiscalYear = 2022;
        AccountingPeriod ap = new AccountingPeriod();
        ap.setUniversityFiscalPeriodCode("12");
        ap.setUniversityFiscalYear(Integer.valueOf(2022));
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(this.yesterday)).thenReturn((Object)ap);
        this.assetGlobalMaintainable.prepareForSave();
        Assertions.assertEquals((Object)"12", (Object)this.assetGlobal.getFinancialDocumentPostingPeriodCode());
        Assertions.assertEquals((int)2022, (Integer)this.assetGlobal.getFinancialDocumentPostingYear());
    }

    @Test
    void computeFiscalYearAndPeriodCreateDate() {
        String testPeriodCode = "12";
        int testFiscalYear = 2022;
        AccountingPeriod ap = new AccountingPeriod();
        ap.setUniversityFiscalPeriodCode("12");
        ap.setUniversityFiscalYear(Integer.valueOf(2022));
        Mockito.when((Object)this.accountingPeriodSvcMock.getByDate(this.yesterday)).thenReturn((Object)ap);
        this.assetGlobalMaintainable.prepareForSave();
        Assertions.assertEquals((Object)"12", (Object)this.assetGlobal.getFinancialDocumentPostingPeriodCode());
        Assertions.assertEquals((int)2022, (Integer)this.assetGlobal.getFinancialDocumentPostingYear());
    }

    private class StubAssetDateServiceImpl
    extends AssetDateServiceImpl {
        private StubAssetDateServiceImpl() {
        }

        public Date computeDepreciationDate(AssetType assetType, AssetDepreciationConvention depreciationConvention, Date inServiceDate) {
            return AssetGlobalMaintainableImplTest.this.assetGlobal.getCreateDate();
        }
    }

    private static class StubObjectCodeServiceImpl
    extends ObjectCodeServiceImpl {
        private StubObjectCodeServiceImpl() {
        }

        public ObjectCode getByPrimaryId(Integer universityFiscalYear, String chartOfAccountsCode, String financialObjectCode) {
            return new ObjectCode();
        }
    }

    private static class StubAssetGlobalMaintainableImpl
    extends AssetGlobalMaintainableImpl {
        private StubAssetGlobalMaintainableImpl() {
        }

        protected void refreshReferenceObject(PersistableBusinessObjectBase persistableBusinessObject, String referenceObjectName) {
        }
    }
}

