/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.sql.Date;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.api.document.WorkflowDocumentService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.document.service.AssetPaymentService;
import org.kuali.kfs.module.cam.fixture.AssetPaymentServiceFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.UniversityDateService;

@ConfigureContext(session=UserNameFixture.bomiddle)
public class AssetPaymentServiceIntegTest
extends KualiIntegTestBase {
    private UniversityDateService universityDateService;
    private AssetPaymentService assetPaymentService;
    private BusinessObjectService businessObjectService;

    protected void setUp() throws Exception {
        super.setUp();
        this.assetPaymentService = (AssetPaymentService)SpringContext.getBean(AssetPaymentService.class);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
    }

    public void testAdjustPaymentAmounts_params_false_false() throws Exception {
        AssetPayment assetPayment = AssetPaymentServiceFixture.PAYMENT1.newAssetPayment();
        this.assetPaymentService.adjustPaymentAmounts(assetPayment, false, false);
        AssetPaymentServiceIntegTest.assertTrue((boolean)assetPayment.getAccountChargeAmount().isPositive());
        AssetPaymentServiceIntegTest.assertTrue((boolean)assetPayment.getAccumulatedPrimaryDepreciationAmount().isPositive());
        AssetPaymentServiceIntegTest.assertNotNull((Object)assetPayment.getPeriod1Depreciation1Amount());
        AssetPaymentServiceIntegTest.assertNotNull((Object)assetPayment.getPeriod11Depreciation1Amount());
        AssetPaymentServiceIntegTest.assertNotNull((Object)assetPayment.getPeriod11Depreciation1Amount());
    }

    public void testAdjustPaymentAmounts_params_true_true() throws Exception {
        AssetPayment assetPayment = AssetPaymentServiceFixture.PAYMENT1.newAssetPayment();
        this.assetPaymentService.adjustPaymentAmounts(assetPayment, true, true);
        AssetPaymentServiceIntegTest.assertTrue((boolean)assetPayment.getAccountChargeAmount().isNegative());
        AssetPaymentServiceIntegTest.assertTrue((boolean)assetPayment.getAccumulatedPrimaryDepreciationAmount().isNegative());
        AssetPaymentServiceIntegTest.assertNull((Object)assetPayment.getPeriod1Depreciation1Amount());
        AssetPaymentServiceIntegTest.assertNull((Object)assetPayment.getPeriod11Depreciation1Amount());
        AssetPaymentServiceIntegTest.assertFalse((boolean)(assetPayment.getPeriod11Depreciation1Amount() instanceof KualiDecimal));
    }

    public void testAdjustPaymentAmounts_false_true() throws Exception {
        AssetPayment assetPayment = AssetPaymentServiceFixture.PAYMENT1.newAssetPayment();
        this.assetPaymentService.adjustPaymentAmounts(assetPayment, false, true);
        AssetPaymentServiceIntegTest.assertTrue((boolean)assetPayment.getAccountChargeAmount().isPositive());
        AssetPaymentServiceIntegTest.assertTrue((boolean)assetPayment.getAccumulatedPrimaryDepreciationAmount().isPositive());
        AssetPaymentServiceIntegTest.assertNull((Object)assetPayment.getPeriod1Depreciation1Amount());
        AssetPaymentServiceIntegTest.assertNull((Object)assetPayment.getPeriod2Depreciation1Amount());
        AssetPaymentServiceIntegTest.assertNull((Object)assetPayment.getPeriod3Depreciation1Amount());
        AssetPaymentServiceIntegTest.assertNull((Object)assetPayment.getPeriod4Depreciation1Amount());
        AssetPaymentServiceIntegTest.assertNull((Object)assetPayment.getPeriod5Depreciation1Amount());
        AssetPaymentServiceIntegTest.assertNull((Object)assetPayment.getPeriod6Depreciation1Amount());
        AssetPaymentServiceIntegTest.assertNull((Object)assetPayment.getPeriod7Depreciation1Amount());
        AssetPaymentServiceIntegTest.assertNull((Object)assetPayment.getPeriod8Depreciation1Amount());
        AssetPaymentServiceIntegTest.assertNull((Object)assetPayment.getPeriod9Depreciation1Amount());
        AssetPaymentServiceIntegTest.assertNull((Object)assetPayment.getPeriod10Depreciation1Amount());
        AssetPaymentServiceIntegTest.assertNull((Object)assetPayment.getPeriod11Depreciation1Amount());
        AssetPaymentServiceIntegTest.assertNull((Object)assetPayment.getPeriod12Depreciation1Amount());
    }

    public void testProcessApprovedAssetPayment() throws Exception {
        KualiDecimal calculatedAssetNewCost;
        Long capitalAssetNumber;
        AssetPaymentAssetDetail assetPaymentAssetDetail;
        int x;
        int detailRows = 0;
        int assetRows = 0;
        AssetPaymentDocument document = AssetPaymentServiceFixture.PAYMENT1.newAssetPaymentDocument();
        document.setDocumentHeader(this.getDocumentHeader());
        document.setAssetPaymentAllocationTypeCode("3");
        KualiDecimal totalDocument = new KualiDecimal(0);
        List assetPaymentAssetDetails = document.getAssetPaymentAssetDetail();
        List assetPaymentDetails = document.getSourceAccountingLines();
        for (AssetPaymentDetail assetPaymentDetail : assetPaymentDetails) {
            ++detailRows;
            totalDocument = (KualiDecimal)totalDocument.add((AbstractKualiDecimal)assetPaymentDetail.getAmount());
        }
        double totalHistoricalAmount = 0.0;
        HashMap<Long, Double> assets = new HashMap<Long, Double>();
        HashMap<Long, KualiDecimal> assetsNewCost = new HashMap<Long, KualiDecimal>();
        for (AssetPaymentAssetDetail assetPaymentAssetDetail2 : assetPaymentAssetDetails) {
            ++assetRows;
            assetPaymentAssetDetail2.refreshReferenceObject("asset");
            assets.put(assetPaymentAssetDetail2.getCapitalAssetNumber(), new Double(assetPaymentAssetDetail2.getAsset().getTotalCostAmount().toString()));
            assetPaymentAssetDetail2.setPreviousTotalCostAmount(assetPaymentAssetDetail2.getAsset().getTotalCostAmount());
            totalHistoricalAmount += new Double(assetPaymentAssetDetail2.getAsset().getTotalCostAmount().toString()).doubleValue();
        }
        this.businessObjectService.save((PersistableBusinessObject)document);
        this.assetPaymentService.processApprovedAssetPayment(document);
        HashMap<String, Object> key = new HashMap<String, Object>();
        key.put("documentNumber", document.getDocumentNumber());
        document = (AssetPaymentDocument)this.businessObjectService.findByPrimaryKey(AssetPaymentDocument.class, key);
        document.setAssetPaymentAllocationTypeCode("3");
        key = new HashMap();
        key.put("documentNumber", document.getDocumentNumber());
        List assetPayments = (List)this.businessObjectService.findMatching(AssetPayment.class, key);
        AssetPaymentServiceIntegTest.assertEquals((int)assetPayments.size(), (int)(assetRows * detailRows));
        for (x = 0; x < document.getAssetPaymentAssetDetail().size(); ++x) {
            assetPaymentAssetDetail = (AssetPaymentAssetDetail)document.getAssetPaymentAssetDetail().get(x);
            assetPaymentAssetDetail.refreshReferenceObject("asset");
            capitalAssetNumber = assetPaymentAssetDetail.getAsset().getCapitalAssetNumber();
            key = new HashMap();
            key.put("capitalAssetNumber", capitalAssetNumber);
            key.put("documentNumber", document.getDocumentNumber());
            assetPayments = (List)this.businessObjectService.findMatching(AssetPayment.class, key);
            calculatedAssetNewCost = new KualiDecimal(((Double)assets.get(capitalAssetNumber)).doubleValue());
            Double previousTotalCostAmount = (Double)assets.get(capitalAssetNumber);
            Double percentage = previousTotalCostAmount / totalHistoricalAmount;
            for (int i = 0; i < document.getSourceAccountingLines().size(); ++i) {
                AssetPaymentDetail assetPaymentDetail = (AssetPaymentDetail)document.getSourceAccountingLines().get(i);
                Double paymentAmount = new Double(assetPaymentDetail.getAmount().toString());
                KualiDecimal amount = new KualiDecimal(paymentAmount * percentage);
                calculatedAssetNewCost = (KualiDecimal)calculatedAssetNewCost.add((AbstractKualiDecimal)amount);
                AssetPayment assetPayment = (AssetPayment)assetPayments.get(i);
                AssetPaymentServiceIntegTest.assertEquals((String)assetPaymentDetail.getAccountNumber(), (String)assetPayment.getAccountNumber());
                AssetPaymentServiceIntegTest.assertEquals((String)assetPaymentDetail.getChartOfAccountsCode(), (String)assetPayment.getChartOfAccountsCode());
                AssetPaymentServiceIntegTest.assertEquals((String)assetPaymentDetail.getFinancialObjectCode(), (String)assetPayment.getFinancialObjectCode());
                AssetPaymentServiceIntegTest.assertEquals((Object)amount, (Object)assetPayment.getAccountChargeAmount());
                AssetPaymentServiceIntegTest.assertEquals((Object)assetPaymentDetail.getPostingYear(), (Object)assetPayment.getFinancialDocumentPostingYear());
                AssetPaymentServiceIntegTest.assertEquals((String)assetPaymentDetail.getPostingPeriodCode(), (String)assetPayment.getFinancialDocumentPostingPeriodCode());
            }
            assetsNewCost.put(capitalAssetNumber, calculatedAssetNewCost);
        }
        for (x = 0; x < document.getAssetPaymentAssetDetail().size(); ++x) {
            assetPaymentAssetDetail = (AssetPaymentAssetDetail)document.getAssetPaymentAssetDetail().get(x);
            assetPaymentAssetDetail.refreshReferenceObject("asset");
            capitalAssetNumber = assetPaymentAssetDetail.getAsset().getCapitalAssetNumber();
            calculatedAssetNewCost = (KualiDecimal)assetsNewCost.get(capitalAssetNumber);
            AssetPaymentServiceIntegTest.assertEquals((Object)calculatedAssetNewCost, (Object)assetPaymentAssetDetail.getAsset().getTotalCostAmount());
        }
    }

    public DocumentHeader getDocumentHeader() throws Exception {
        WorkflowDocument workflowDocument = ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).createWorkflowDocument(((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentTypeNameByClass(AssetPaymentDocument.class), GlobalVariables.getUserSession().getPerson());
        DocumentHeader documentHeader = new DocumentHeader();
        documentHeader.setWorkflowDocument(workflowDocument);
        documentHeader.setDocumentNumber(workflowDocument.getDocumentId());
        documentHeader.setFinancialDocumentStatusCode("A");
        documentHeader.setExplanation("New asset payment");
        documentHeader.setDocumentDescription("New asset payment");
        documentHeader.setFinancialDocumentTotalAmount(KualiDecimal.ZERO);
        return documentHeader;
    }

    public void testExtractPostedDatePeriod() throws Exception {
        AssetPaymentDetail assetPaymentDetail = new AssetPaymentDetail();
        int currentYear = this.universityDateService.getCurrentFiscalYear();
        int testYear = this.universityDateService.getCurrentFiscalYear() + 1000;
        LocalDate currentDate = LocalDate.of(currentYear, 1, 1);
        Date jsqlD = Date.valueOf(currentDate);
        assetPaymentDetail.setExpenditureFinancialDocumentPostedDate(jsqlD);
        AssetPaymentServiceIntegTest.assertTrue((boolean)this.assetPaymentService.extractPostedDatePeriod(assetPaymentDetail));
        currentDate = LocalDate.of(testYear, 1, 1);
        jsqlD = Date.valueOf(currentDate);
        assetPaymentDetail.setExpenditureFinancialDocumentPostedDate(jsqlD);
        AssetPaymentServiceIntegTest.assertFalse((boolean)this.assetPaymentService.extractPostedDatePeriod(assetPaymentDetail));
    }
}

