/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobalDetail;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.impl.AssetServiceImpl;
import org.kuali.kfs.module.cam.document.service.impl.RetirementInfoServiceImpl;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class RetirementInfoServiceTest {
    private RetirementInfoServiceImpl cut;
    private Asset asset;
    @Mock
    private ParameterService parameterSvcMock;

    RetirementInfoServiceTest() {
    }

    @BeforeEach
    public void setUp() {
        this.asset = new Asset();
        this.asset.setInventoryStatusCode("R");
        Mockito.when((Object)this.parameterSvcMock.getParameterValuesAsString((Class)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenReturn(new ArrayList<String>(Arrays.asList("O", "R", "E")));
        AssetServiceImpl assetServiceImpl = new AssetServiceImpl();
        assetServiceImpl.setParameterService(this.parameterSvcMock);
        this.cut = new RetirementInfoServiceImpl();
        this.cut.setAssetService((AssetService)assetServiceImpl);
        this.cut.setParameterService(this.parameterSvcMock);
    }

    private AssetRetirementGlobalDetail createRetirementDetail(String docNumber, int daysToAdd, String docStatus) {
        AssetRetirementGlobalDetail globalDetail = new AssetRetirementGlobalDetail();
        globalDetail.setDocumentNumber(docNumber);
        AssetRetirementGlobal retirementGlobalSpy = (AssetRetirementGlobal)Mockito.spy(AssetRetirementGlobal.class);
        ((AssetRetirementGlobal)Mockito.doNothing().when((Object)retirementGlobalSpy)).refreshReferenceObject(ArgumentMatchers.anyString());
        retirementGlobalSpy.setRetirementDate(Date.valueOf(LocalDate.now().plusDays(daysToAdd)));
        DocumentHeader header = new DocumentHeader();
        header.setFinancialDocumentStatusCode(docStatus);
        retirementGlobalSpy.setDocumentHeader(header);
        globalDetail.setAssetRetirementGlobal(retirementGlobalSpy);
        return globalDetail;
    }

    @Test
    void setRetirementInfo() {
        this.asset.getAssetRetirementHistory().add(this.createRetirementDetail("12345", 0, "A"));
        this.asset.getAssetRetirementHistory().add(this.createRetirementDetail("123457", 1, "A"));
        this.cut.setRetirementInfo(this.asset);
        Assertions.assertNotNull((Object)this.asset.getRetirementInfo());
        Assertions.assertEquals((Object)"123457", (Object)this.asset.getRetirementInfo().getDocumentNumber());
    }

    @Test
    void setRetirementInfo_Disapproved() {
        this.asset.getAssetRetirementHistory().add(this.createRetirementDetail("12345", 0, "A"));
        this.asset.getAssetRetirementHistory().add(this.createRetirementDetail("123457", 1, "D"));
        this.cut.setRetirementInfo(this.asset);
        Assertions.assertNotNull((Object)this.asset.getRetirementInfo());
        Assertions.assertEquals((Object)"12345", (Object)this.asset.getRetirementInfo().getDocumentNumber());
    }

    @Test
    void setRetirementInfo_NotRetired() {
        this.asset.setInventoryStatusCode("A");
        this.cut.setRetirementInfo(this.asset);
        Assertions.assertNull((Object)this.asset.getRetirementInfo());
    }
}

