/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.module.cam.businessobject.GeneralLedgerEntry;
import org.kuali.kfs.module.cam.document.service.impl.GlLineServiceImpl;

@Execution(value=ExecutionMode.SAME_THREAD)
class GlLineServiceImplTest {
    public static final String REFERENCE_FINANCIAL_DOCUMENT_NUMBER = "123456";
    private GlLineServiceImpl cut;
    private GeneralLedgerEntry generalLedgerEntry;

    GlLineServiceImplTest() {
    }

    @BeforeEach
    public void setUp() {
        this.cut = new GlLineServiceImpl();
        this.generalLedgerEntry = new GeneralLedgerEntry();
        this.generalLedgerEntry.setReferenceFinancialDocumentNumber(REFERENCE_FINANCIAL_DOCUMENT_NUMBER);
    }

    @Test
    void fetchReferenceFinancialDocumentNumberIfPoOrCmDocument_PREQ() {
        this.generalLedgerEntry.setFinancialDocumentTypeCode("PREQ");
        Assertions.assertEquals((Object)REFERENCE_FINANCIAL_DOCUMENT_NUMBER, (Object)this.cut.fetchReferenceFinancialDocumentNumberIfPreqOrCmDocument(this.generalLedgerEntry));
    }

    @Test
    void fetchReferenceFinancialDocumentNumberIfPoOrCmDocument_CM() {
        this.generalLedgerEntry.setFinancialDocumentTypeCode("CM");
        Assertions.assertEquals((Object)REFERENCE_FINANCIAL_DOCUMENT_NUMBER, (Object)this.cut.fetchReferenceFinancialDocumentNumberIfPreqOrCmDocument(this.generalLedgerEntry));
    }

    @Test
    void fetchReferenceFinancialDocumentNumberIfPoOrCmDocument_GLT() {
        this.generalLedgerEntry.setFinancialDocumentTypeCode("GLT");
        Assertions.assertNull((Object)this.cut.fetchReferenceFinancialDocumentNumberIfPreqOrCmDocument(this.generalLedgerEntry));
    }
}

