/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.fixture;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.api.document.DocumentStatus;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.Mockito;

public enum DocumentHeaderFixture {
    REQS1{

        @Override
        public DocumentHeader newRecord() {
            DocumentHeader obj = new DocumentHeader();
            obj.setDocumentNumber("11");
            obj.setDocumentDescription("CAB Test Data 1");
            obj.setWorkflowDocument((WorkflowDocument)Mockito.mock(WorkflowDocument.class));
            obj.setWorkflowDocumentTypeName("REQS");
            obj.setWorkflowDocumentStatusCode(DocumentStatus.FINAL.getCode());
            obj.setApplicationDocumentStatus("Awaiting Contract Manager Assignment");
            obj.setInitiatorPrincipalId(1.principalId("khuntley"));
            obj.setWorkflowCreateDate(new Timestamp(new Date().getTime()));
            return obj;
        }
    }
    ,
    REQS2{

        @Override
        public DocumentHeader newRecord() {
            DocumentHeader obj = new DocumentHeader();
            obj.setDocumentNumber("12");
            obj.setDocumentDescription("CAB Test Data 1");
            obj.setWorkflowDocument((WorkflowDocument)Mockito.mock(WorkflowDocument.class));
            obj.setWorkflowDocumentTypeName("REQS");
            obj.setWorkflowDocumentStatusCode(DocumentStatus.FINAL.getCode());
            obj.setApplicationDocumentStatus("Awaiting Contract Manager Assignment");
            obj.setInitiatorPrincipalId(2.principalId("khuntley"));
            obj.setWorkflowCreateDate(new Timestamp(new Date().getTime()));
            return obj;
        }
    }
    ,
    REQS3{

        @Override
        public DocumentHeader newRecord() {
            DocumentHeader obj = new DocumentHeader();
            obj.setDocumentNumber("13");
            obj.setDocumentDescription("CAB Test Data 1");
            obj.setWorkflowDocument((WorkflowDocument)Mockito.mock(WorkflowDocument.class));
            obj.setWorkflowDocumentTypeName("REQS");
            obj.setWorkflowDocumentStatusCode(DocumentStatus.FINAL.getCode());
            obj.setApplicationDocumentStatus("In Process");
            obj.setInitiatorPrincipalId(3.principalId("khuntley"));
            obj.setWorkflowCreateDate(new Timestamp(new Date().getTime()));
            return obj;
        }
    }
    ,
    PO1{

        @Override
        public DocumentHeader newRecord() {
            DocumentHeader obj = new DocumentHeader();
            obj.setDocumentNumber("21");
            obj.setDocumentDescription("CAB Test Data 1");
            obj.setWorkflowDocument((WorkflowDocument)Mockito.mock(WorkflowDocument.class));
            obj.setWorkflowDocumentTypeName("PO");
            obj.setWorkflowDocumentStatusCode(DocumentStatus.FINAL.getCode());
            obj.setApplicationDocumentStatus("Open");
            obj.setInitiatorPrincipalId(4.principalId("khuntley"));
            obj.setWorkflowCreateDate(new Timestamp(new Date().getTime()));
            return obj;
        }
    }
    ,
    PO2{

        @Override
        public DocumentHeader newRecord() {
            DocumentHeader obj = new DocumentHeader();
            obj.setDocumentNumber("22");
            obj.setDocumentDescription("CAB Test Data 1");
            obj.setWorkflowDocument((WorkflowDocument)Mockito.mock(WorkflowDocument.class));
            obj.setWorkflowDocumentTypeName("PO");
            obj.setWorkflowDocumentStatusCode(DocumentStatus.FINAL.getCode());
            obj.setApplicationDocumentStatus("Open");
            obj.setInitiatorPrincipalId(5.principalId("khuntley"));
            obj.setWorkflowCreateDate(new Timestamp(new Date().getTime()));
            return obj;
        }
    }
    ,
    PO3{

        @Override
        public DocumentHeader newRecord() {
            DocumentHeader obj = new DocumentHeader();
            obj.setDocumentNumber("23");
            obj.setDocumentDescription("CAB Test Data 1");
            obj.setWorkflowDocument((WorkflowDocument)Mockito.mock(WorkflowDocument.class));
            obj.setWorkflowDocumentTypeName("PO");
            obj.setWorkflowDocumentStatusCode(DocumentStatus.FINAL.getCode());
            obj.setApplicationDocumentStatus("Open");
            obj.setInitiatorPrincipalId(6.principalId("khuntley"));
            obj.setWorkflowCreateDate(new Timestamp(new Date().getTime()));
            return obj;
        }
    }
    ,
    PREQ1{

        @Override
        public DocumentHeader newRecord() {
            DocumentHeader obj = new DocumentHeader();
            obj.setDocumentNumber("31");
            obj.setDocumentDescription("PO: 1007 Vendor: BESCO WATER TREATMENT I");
            obj.setWorkflowDocument((WorkflowDocument)Mockito.mock(WorkflowDocument.class));
            obj.setWorkflowDocumentTypeName("PREQ");
            obj.setWorkflowDocumentStatusCode(DocumentStatus.FINAL.getCode());
            obj.setApplicationDocumentStatus("Department-Approved");
            obj.setInitiatorPrincipalId(7.principalId("khuntley"));
            obj.setWorkflowCreateDate(new Timestamp(new Date().getTime()));
            return obj;
        }
    }
    ,
    PREQ2{

        @Override
        public DocumentHeader newRecord() {
            DocumentHeader obj = new DocumentHeader();
            obj.setDocumentNumber("32");
            obj.setDocumentDescription("PO: 1007 Vendor: BESCO WATER TREATMENT I");
            obj.setWorkflowDocument((WorkflowDocument)Mockito.mock(WorkflowDocument.class));
            obj.setWorkflowDocumentTypeName("PREQ");
            obj.setWorkflowDocumentStatusCode(DocumentStatus.FINAL.getCode());
            obj.setApplicationDocumentStatus("Department-Approved");
            obj.setInitiatorPrincipalId(8.principalId("appleton"));
            obj.setWorkflowCreateDate(new Timestamp(new Date().getTime()));
            return obj;
        }
    }
    ,
    PREQ3{

        @Override
        public DocumentHeader newRecord() {
            DocumentHeader obj = new DocumentHeader();
            obj.setDocumentNumber("33");
            obj.setDocumentDescription("PO: 1007 Vendor: BESCO WATER TREATMENT I");
            obj.setWorkflowDocument((WorkflowDocument)Mockito.mock(WorkflowDocument.class));
            obj.setWorkflowDocumentTypeName("PREQ");
            obj.setWorkflowDocumentStatusCode(DocumentStatus.FINAL.getCode());
            obj.setApplicationDocumentStatus("Department-Approved");
            obj.setInitiatorPrincipalId(9.principalId("appleton"));
            obj.setWorkflowCreateDate(new Timestamp(new Date().getTime()));
            return obj;
        }
    }
    ,
    PREQ4{

        @Override
        public DocumentHeader newRecord() {
            DocumentHeader obj = new DocumentHeader();
            obj.setDocumentNumber("34");
            obj.setDocumentDescription("PO: 1007 Vendor: BESCO WATER TREATMENT I");
            obj.setWorkflowDocument((WorkflowDocument)Mockito.mock(WorkflowDocument.class));
            obj.setWorkflowDocumentTypeName("PREQ");
            obj.setWorkflowDocumentStatusCode(DocumentStatus.FINAL.getCode());
            obj.setApplicationDocumentStatus("Department-Approved");
            obj.setInitiatorPrincipalId(10.principalId("appleton"));
            obj.setWorkflowCreateDate(new Timestamp(new Date().getTime()));
            return obj;
        }
    }
    ,
    PREQ5{

        @Override
        public DocumentHeader newRecord() {
            DocumentHeader obj = new DocumentHeader();
            obj.setDocumentNumber("35");
            obj.setDocumentDescription("PO: 1007 Vendor: BESCO WATER TREATMENT I");
            obj.setWorkflowDocument((WorkflowDocument)Mockito.mock(WorkflowDocument.class));
            obj.setWorkflowDocumentTypeName("PREQ");
            obj.setWorkflowDocumentStatusCode(DocumentStatus.FINAL.getCode());
            obj.setApplicationDocumentStatus("Department-Approved");
            obj.setInitiatorPrincipalId(11.principalId("appleton"));
            obj.setWorkflowCreateDate(new Timestamp(new Date().getTime()));
            return obj;
        }
    }
    ,
    PREQ6{

        @Override
        public DocumentHeader newRecord() {
            DocumentHeader obj = new DocumentHeader();
            obj.setDocumentNumber("36");
            obj.setDocumentDescription("PO: 1007 Vendor: BESCO WATER TREATMENT I");
            obj.setWorkflowDocument((WorkflowDocument)Mockito.mock(WorkflowDocument.class));
            obj.setWorkflowDocumentTypeName("PREQ");
            obj.setWorkflowDocumentStatusCode(DocumentStatus.FINAL.getCode());
            obj.setApplicationDocumentStatus("Department-Approved");
            obj.setInitiatorPrincipalId(12.principalId("appleton"));
            obj.setWorkflowCreateDate(new Timestamp(new Date().getTime()));
            return obj;
        }
    }
    ,
    CM1{

        @Override
        public DocumentHeader newRecord() {
            DocumentHeader obj = new DocumentHeader();
            obj.setDocumentNumber("41");
            obj.setDocumentDescription("PO: 1007 Vendor: BESCO WATER TREATMENT I");
            obj.setWorkflowDocument((WorkflowDocument)Mockito.mock(WorkflowDocument.class));
            obj.setWorkflowDocumentTypeName("CM");
            obj.setWorkflowDocumentStatusCode(DocumentStatus.FINAL.getCode());
            obj.setApplicationDocumentStatus("Complete");
            obj.setInitiatorPrincipalId(13.principalId("appleton"));
            obj.setWorkflowCreateDate(new Timestamp(new Date().getTime()));
            return obj;
        }
    }
    ,
    CINV1{

        @Override
        public DocumentHeader newRecord() {
            DocumentHeader obj = new DocumentHeader();
            obj.setDocumentNumber("51");
            obj.setDocumentDescription("Customer Invoice1");
            obj.setWorkflowDocument((WorkflowDocument)Mockito.mock(WorkflowDocument.class));
            obj.setWorkflowDocumentTypeName("INV");
            obj.setWorkflowDocumentStatusCode(DocumentStatus.FINAL.getCode());
            obj.setInitiatorPrincipalId(14.principalId("khuntley"));
            obj.setWorkflowCreateDate(new Timestamp(new Date().getTime()));
            return obj;
        }
    }
    ,
    CINV2{

        @Override
        public DocumentHeader newRecord() {
            DocumentHeader obj = new DocumentHeader();
            obj.setDocumentNumber("52");
            obj.setDocumentDescription("Customer Invoice2");
            obj.setWorkflowDocument((WorkflowDocument)Mockito.mock(WorkflowDocument.class));
            obj.setWorkflowDocumentTypeName("INV");
            obj.setWorkflowDocumentStatusCode(DocumentStatus.FINAL.getCode());
            obj.setInitiatorPrincipalId(15.principalId("khuntley"));
            obj.setWorkflowCreateDate(new Timestamp(new Date().getTime()));
            return obj;
        }
    };


    public abstract DocumentHeader newRecord();

    public static void setUpData() {
        BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        businessObjectService.save(DocumentHeaderFixture.getAll());
    }

    private static List<DocumentHeader> getAll() {
        ArrayList<DocumentHeader> recs = new ArrayList<DocumentHeader>();
        recs.add(CINV1.newRecord());
        recs.add(CINV2.newRecord());
        return recs;
    }

    public static String principalId(String principalName) {
        Person person = ((PersonService)SpringContext.getBean(PersonService.class)).getPersonByPrincipalName(principalName);
        if (person != null) {
            return person.getPrincipalId();
        }
        return null;
    }
}

