/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.utils;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.module.cam.businessobject.BarcodeInventoryErrorDetail;
import org.kuali.kfs.module.cam.document.BarcodeInventoryErrorDocument;
import org.kuali.kfs.module.cam.fixture.BarcodeInventoryErrorDetailPredicateFixture;
import org.kuali.kfs.module.cam.util.BarcodeInventoryErrorDetailTransformer;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class BarcodeInventoryErrorDetailTransformerTest {
    BarcodeInventoryErrorDetailTransformerTest() {
    }

    @Test
    void testUpdateAssetInformation() {
        BarcodeInventoryErrorDocument barcodeInventoryErrorDocument;
        try (MockedStatic kradServiceLocatorWebStaticMock = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            DocumentHeaderService documentHeaderServiceMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
            kradServiceLocatorWebStaticMock.when(KRADServiceLocatorWeb::getDocumentHeaderService).thenReturn((Object)documentHeaderServiceMock);
            barcodeInventoryErrorDocument = BarcodeInventoryErrorDetailPredicateFixture.DATA.getBarcodeInventoryErrorDocument();
        }
        List<BarcodeInventoryErrorDetail> barcodeInventoryErrorDetails = BarcodeInventoryErrorDetailPredicateFixture.DATA.getBarcodeInventoryDetail();
        List<BarcodeInventoryErrorDetail> barcodeInventoryErrorExpectedDetails = BarcodeInventoryErrorDetailPredicateFixture.DATA.getExpectedResults();
        BarcodeInventoryErrorDetailTransformer transformer = new BarcodeInventoryErrorDetailTransformer(barcodeInventoryErrorDocument);
        barcodeInventoryErrorDetails.forEach(arg_0 -> ((BarcodeInventoryErrorDetailTransformer)transformer).transform(arg_0));
        for (int row = 0; row < barcodeInventoryErrorDetails.size(); ++row) {
            BarcodeInventoryErrorDetail barcodeInventoryErrorDetail = barcodeInventoryErrorDetails.get(row);
            BarcodeInventoryErrorDetail barcodeInventoryErrorExpectedDetail = barcodeInventoryErrorExpectedDetails.get(row);
            Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)barcodeInventoryErrorExpectedDetail.getCampusCode(), (Object)barcodeInventoryErrorDetail.getCampusCode()), () -> Assertions.assertEquals((Object)barcodeInventoryErrorExpectedDetail.getBuildingCode(), (Object)barcodeInventoryErrorDetail.getBuildingCode()), () -> Assertions.assertEquals((Object)barcodeInventoryErrorExpectedDetail.getBuildingRoomNumber(), (Object)barcodeInventoryErrorDetail.getBuildingRoomNumber()), () -> Assertions.assertEquals((Object)barcodeInventoryErrorExpectedDetail.getBuildingSubRoomNumber(), (Object)barcodeInventoryErrorDetail.getBuildingSubRoomNumber()), () -> Assertions.assertEquals((Object)barcodeInventoryErrorExpectedDetail.getAssetConditionCode(), (Object)barcodeInventoryErrorDetail.getAssetConditionCode())});
        }
    }
}

