/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.kns.rules.TransactionalDocumentRuleBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.document.EquipmentLoanOrReturnDocument;
import org.kuali.kfs.module.cam.service.AssetLockService;
import org.kuali.kfs.sys.businessobject.State;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.util.KfsDateUtils;

public class EquipmentLoanOrReturnDocumentRule
extends TransactionalDocumentRuleBase {
    private AssetLockService assetLockService;
    private DateTimeService dateTimeService;

    protected List<Long> retrieveAssetNumberForLocking(Document document) {
        EquipmentLoanOrReturnDocument equipmentLoanOrReturnDocument = (EquipmentLoanOrReturnDocument)document;
        ArrayList<Long> assetNumbers = new ArrayList<Long>();
        if (equipmentLoanOrReturnDocument.getCapitalAssetNumber() != null) {
            assetNumbers.add(equipmentLoanOrReturnDocument.getCapitalAssetNumber());
        }
        return assetNumbers;
    }

    protected boolean processCustomRouteDocumentBusinessRules(Document document) {
        if (!super.processCustomRouteDocumentBusinessRules(document)) {
            return false;
        }
        EquipmentLoanOrReturnDocument equipmentLoanOrReturnDocument = (EquipmentLoanOrReturnDocument)document;
        boolean valid = this.processValidation(equipmentLoanOrReturnDocument);
        return valid &= !this.getAssetLockService().isAssetLocked(this.retrieveAssetNumberForLocking(document), "ELR", document.getDocumentNumber());
    }

    protected boolean processValidation(EquipmentLoanOrReturnDocument equipmentLoanOrReturnDocument) {
        boolean valid = true;
        if (equipmentLoanOrReturnDocument.getBorrowerPerson() == null) {
            valid = false;
            GlobalVariables.getMessageMap().putError("document.borrowerPerson.principalName", "error.invalid.borrower.id", new String[0]);
        }
        valid &= this.validateTagNumber(equipmentLoanOrReturnDocument);
        valid &= this.validateLoanDate(equipmentLoanOrReturnDocument);
        return valid &= this.validStateZipCode(equipmentLoanOrReturnDocument);
    }

    protected boolean validateTagNumber(EquipmentLoanOrReturnDocument equipmentLoanOrReturnDocument) {
        boolean valid = true;
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("capitalAssetNumber", equipmentLoanOrReturnDocument.getCapitalAssetNumber());
        Asset asset = (Asset)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(Asset.class, map);
        if (asset.getCampusTagNumber() == null) {
            valid = false;
            GlobalVariables.getMessageMap().putError("document.campusTagNumber", "error.campus.tag.number.required", new String[0]);
        }
        return valid;
    }

    protected boolean validateLoanDate(EquipmentLoanOrReturnDocument equipmentLoanOrReturnDocument) {
        java.sql.Date expectReturnDate;
        boolean valid = true;
        java.sql.Date loanDate = KfsDateUtils.clearTimeFields((java.sql.Date)equipmentLoanOrReturnDocument.getLoanDate());
        LocalDate localDate = this.getDateTimeService().getLocalDate(loanDate).plusYears(2L);
        java.sql.Date maxDate = java.sql.Date.valueOf(localDate);
        java.sql.Date loanReturnDate = equipmentLoanOrReturnDocument.getLoanReturnDate();
        if (equipmentLoanOrReturnDocument.isNewLoan() && loanDate.before(KfsDateUtils.clearTimeFields((Date)new Date()))) {
            GlobalVariables.getMessageMap().putError("document.loanDate", "error.invalid.loan.date", new String[0]);
        }
        if ((expectReturnDate = equipmentLoanOrReturnDocument.getExpectedReturnDate()) != null) {
            KfsDateUtils.clearTimeFields((java.sql.Date)expectReturnDate);
            if (expectReturnDate.before(loanDate)) {
                valid = false;
                GlobalVariables.getMessageMap().putError("document.expectedReturnDate", "error.invalid.expected.return.date", new String[0]);
            }
            if (maxDate.before(expectReturnDate)) {
                valid = false;
                GlobalVariables.getMessageMap().putError("document.expectedReturnDate", "error.invalid.expected.max.date", new String[0]);
            }
        }
        if (loanReturnDate != null) {
            KfsDateUtils.clearTimeFields((java.sql.Date)loanReturnDate);
            if (loanDate.after(loanReturnDate) || maxDate.before(loanReturnDate)) {
                valid = false;
                GlobalVariables.getMessageMap().putError("document.loanReturnDate", "error.invalid.loan.return.date", new String[0]);
            }
        }
        return valid;
    }

    protected boolean validStateZipCode(EquipmentLoanOrReturnDocument equipmentLoanOrReturnDocument) {
        boolean valid = true;
        if (StringUtils.isBlank((CharSequence)equipmentLoanOrReturnDocument.getBorrowerCountryCode())) {
            equipmentLoanOrReturnDocument.setBorrowerCountryCode("US");
        }
        if (equipmentLoanOrReturnDocument.getBorrowerCountryCode().equals("US")) {
            equipmentLoanOrReturnDocument.refreshReferenceObject("borrowerState");
            State borrowState = equipmentLoanOrReturnDocument.getBorrowerState();
            if (ObjectUtils.isNull((Object)borrowState)) {
                GlobalVariables.getMessageMap().putError("document.borrowerStateCode", "error.invalid.borrower.state.code", new String[]{equipmentLoanOrReturnDocument.getBorrowerStateCode()});
                valid = false;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)equipmentLoanOrReturnDocument.getBorrowerStorageStateCode()) && StringUtils.isBlank((CharSequence)equipmentLoanOrReturnDocument.getBorrowerStorageCountryCode())) {
            equipmentLoanOrReturnDocument.setBorrowerStorageCountryCode("US");
        }
        String storageCountryCode = equipmentLoanOrReturnDocument.getBorrowerStorageCountryCode();
        String storageAddress = equipmentLoanOrReturnDocument.getBorrowerStorageAddress();
        if (StringUtils.isNotBlank((CharSequence)storageAddress) && StringUtils.isNotBlank((CharSequence)storageCountryCode) && storageCountryCode.equals("US")) {
            equipmentLoanOrReturnDocument.refreshReferenceObject("borrowerStorageState");
            if (StringUtils.isBlank((CharSequence)equipmentLoanOrReturnDocument.getBorrowerStorageStateCode())) {
                GlobalVariables.getMessageMap().putError("document.borrowerStorageStateCode", "error.borrower.storage.state.required", new String[]{equipmentLoanOrReturnDocument.getBorrowerCountryCode()});
                valid = false;
            } else {
                State borrowStorageState = equipmentLoanOrReturnDocument.getBorrowerStorageState();
                if (ObjectUtils.isNull((Object)borrowStorageState)) {
                    GlobalVariables.getMessageMap().putError("document.borrowerStorageStateCode", "error.invalid.borrower.storage.state.code", new String[]{equipmentLoanOrReturnDocument.getBorrowerStorageStateCode()});
                    valid = false;
                }
            }
            if (StringUtils.isBlank((CharSequence)equipmentLoanOrReturnDocument.getBorrowerStorageZipCode())) {
                GlobalVariables.getMessageMap().putError("document.borrowerStorageZipCode", "error.borrower.storage.zip.required", new String[]{equipmentLoanOrReturnDocument.getBorrowerCountryCode()});
                valid = false;
            }
        }
        return valid;
    }

    public AssetLockService getAssetLockService() {
        if (this.assetLockService == null) {
            this.assetLockService = (AssetLockService)SpringContext.getBean(AssetLockService.class);
        }
        return this.assetLockService;
    }

    public DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        }
        return this.dateTimeService;
    }
}

