/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.criteria.Predicate;
import org.kuali.kfs.core.api.criteria.PredicateFactory;
import org.kuali.kfs.core.api.criteria.QueryByCriteria;
import org.kuali.kfs.core.api.parameter.ParameterEvaluatorService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.api.parameter.ParameterRepositoryService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.coreservice.impl.parameter.Parameter;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.fp.businessobject.CapitalAccountingLines;
import org.kuali.kfs.fp.businessobject.CapitalAssetAccountsGroupDetails;
import org.kuali.kfs.fp.businessobject.CapitalAssetInformation;
import org.kuali.kfs.fp.businessobject.CapitalAssetInformationDetail;
import org.kuali.kfs.fp.document.AdvanceDepositDocument;
import org.kuali.kfs.fp.document.CapitalAccountingLinesDocumentBase;
import org.kuali.kfs.fp.document.CapitalAssetEditable;
import org.kuali.kfs.fp.document.CapitalAssetInformationDocumentBase;
import org.kuali.kfs.fp.document.CashReceiptDocument;
import org.kuali.kfs.fp.document.CreditCardReceiptDocument;
import org.kuali.kfs.fp.document.DistributionOfIncomeAndExpenseDocument;
import org.kuali.kfs.fp.document.GeneralErrorCorrectionDocument;
import org.kuali.kfs.fp.document.GeneralLedgerTransferDocument;
import org.kuali.kfs.fp.document.InternalBillingDocument;
import org.kuali.kfs.fp.document.IntraAccountAdjustmentDocument;
import org.kuali.kfs.fp.document.ProcurementCardDocument;
import org.kuali.kfs.fp.document.ServiceBillingDocument;
import org.kuali.kfs.fp.document.YearEndDistributionOfIncomeAndExpenseDocument;
import org.kuali.kfs.fp.document.YearEndGeneralErrorCorrectionDocument;
import org.kuali.kfs.integration.cam.CapitalAssetManagementAssetTransactionType;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.integration.purap.CapitalAssetLocation;
import org.kuali.kfs.integration.purap.CapitalAssetSystem;
import org.kuali.kfs.integration.purap.ExternalPurApItem;
import org.kuali.kfs.integration.purap.ItemCapitalAsset;
import org.kuali.kfs.integration.purap.PurchasingAccountsPayableModuleService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.batch.ExtractStep;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetLock;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.businessobject.AssetTransactionType;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.businessobject.GeneralLedgerEntry;
import org.kuali.kfs.module.cam.businessobject.GeneralLedgerEntryAsset;
import org.kuali.kfs.module.cam.businessobject.PretagDetail;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableItemAsset;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableLineAssetAccount;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.GlLineService;
import org.kuali.kfs.module.cam.document.service.PurApInfoService;
import org.kuali.kfs.module.cam.service.AssetLockService;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.AccountsPayableItem;
import org.kuali.kfs.module.purap.businessobject.AvailabilityMatrix;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingCapitalAssetItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingItemBase;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.AccountingLineBase;
import org.kuali.kfs.sys.businessobject.Building;
import org.kuali.kfs.sys.businessobject.Campus;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.businessobject.Room;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.businessobject.TargetAccountingLine;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public class CapitalAssetManagementModuleServiceImpl
implements CapitalAssetManagementModuleService {
    private static final Logger LOG = LogManager.getLogger();
    protected GlLineService glLineService;
    protected DataDictionaryService dataDictionaryService;
    protected ParameterEvaluatorService parameterEvaluatorService;
    protected ConfigurationService configurationService;
    protected ParameterRepositoryService parameterRepositoryService;
    protected BusinessObjectService businessObjectService;
    protected ParameterService parameterService;
    protected AssetService assetService;
    protected PurApInfoService purApInfoService;
    protected KualiModuleService kualiModuleService;
    protected BusinessObjectDictionaryService businessObjectDictionaryService;
    protected DictionaryValidationService dictionaryValidationService;
    protected PurchasingAccountsPayableModuleService purchasingAccountsPayableModuleService;
    private AssetLockService assetLockService;

    public boolean storeAssetLocks(List<Long> capitalAssetNumbers, String documentNumber, String documentType, String lockingInformation) {
        List<AssetLock> assetLocks = this.assetLockService.buildAssetLockHelper(capitalAssetNumbers, documentNumber, documentType, StringUtils.isBlank((CharSequence)lockingInformation) ? "-1" : lockingInformation);
        return this.assetLockService.checkAndSetAssetLocks(assetLocks, false);
    }

    public void deleteAssetLocks(String documentNumber, String lockingInformation) {
        this.assetLockService.deleteAssetLocks(documentNumber, lockingInformation);
    }

    public boolean isAssetLockedByCurrentDocument(String documentNumber, String lockingInformation) {
        return this.assetLockService.isAssetLockedByCurrentDocument(documentNumber, lockingInformation);
    }

    public boolean isAssetLocked(List<Long> assetNumbers, String documentTypeName, String excludingDocumentNumber) {
        return this.assetLockService.isAssetLocked(assetNumbers, documentTypeName, excludingDocumentNumber);
    }

    public void generateCapitalAssetLock(Document document, String documentTypeName) {
        ArrayList<AssetLock> assetLocks = new ArrayList<AssetLock>();
        StringBuilder capitalAssetToBeLocked = new StringBuilder();
        if (document instanceof CapitalAssetEditable) {
            List capitalAssets = ((CapitalAssetEditable)document).getCapitalAssetInformation();
            if (this.isDocumentEligibleForCABBatch(documentTypeName)) {
                List<String> includedObjectSubTypeCodes = this.getBatchIncludedObjectSubTypes();
                List<String> excludedChartCodes = this.getBatchExcludedChartCodes();
                List<String> excludedSubFundCodes = this.getBatchExcludedSubFundCodes();
                for (CapitalAssetInformation assetLine : capitalAssets) {
                    Long capitalAssetNumber = assetLine.getCapitalAssetNumber();
                    if (capitalAssetNumber == null || !this.isAssetLineEligibleForCABBatch(assetLine, ((CapitalAssetInformationDocumentBase)document).getPostingYear(), includedObjectSubTypeCodes, excludedChartCodes, excludedSubFundCodes)) continue;
                    AssetLock newLock = new AssetLock(document.getDocumentNumber(), capitalAssetNumber, assetLine.getCapitalAssetLineNumber() == null ? "-1" : assetLine.getCapitalAssetLineNumber().toString(), documentTypeName);
                    assetLocks.add(newLock);
                    if (!capitalAssetToBeLocked.toString().isEmpty()) {
                        capitalAssetToBeLocked.append(",");
                    }
                    capitalAssetToBeLocked.append(capitalAssetNumber.toString());
                }
                if (assetLocks.isEmpty()) {
                    this.deleteAssetLocks(document.getDocumentNumber(), null);
                } else if (!this.assetLockService.checkAndSetAssetLocks(assetLocks, true)) {
                    throw new ValidationException("Asset " + capitalAssetToBeLocked.toString() + " is being locked by other documents.");
                }
            }
        }
    }

    public boolean isFpDocumentEligibleForAssetLock(AccountingDocument accountingDocument, String documentType) {
        ArrayList excludedDocTypeCodes = new ArrayList(this.parameterService.getParameterValuesAsString(ExtractStep.class, "DOCUMENT_TYPES_EXCLUDED"));
        if (!excludedDocTypeCodes.isEmpty() && excludedDocTypeCodes.contains(documentType)) {
            return false;
        }
        ArrayList<String> includedFinancialObjectSubTypeCodes = new ArrayList<String>(this.parameterService.getParameterValuesAsString(ExtractStep.class, "SUB_TYPES"));
        ArrayList<String> excludedChartCodes = new ArrayList<String>(this.parameterService.getParameterValuesAsString(ExtractStep.class, "CHARTS_EXCLUDED"));
        ArrayList<String> excludedSubFundCodes = new ArrayList<String>(this.parameterService.getParameterValuesAsString(ExtractStep.class, "SUB_FUNDS_EXCLUDED"));
        List sAccountingLines = accountingDocument.getSourceAccountingLines();
        for (SourceAccountingLine sourceAccountingLine : sAccountingLines) {
            if (!this.isAccountLineEligibleForCABBatch(includedFinancialObjectSubTypeCodes, excludedChartCodes, excludedSubFundCodes, (AccountingLineBase)sourceAccountingLine)) continue;
            return true;
        }
        List tAccountingLines = accountingDocument.getTargetAccountingLines();
        for (TargetAccountingLine targetAccountingLine : tAccountingLines) {
            if (!this.isAccountLineEligibleForCABBatch(includedFinancialObjectSubTypeCodes, excludedChartCodes, excludedSubFundCodes, (AccountingLineBase)targetAccountingLine)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAccountLineEligibleForCABBatch(List<String> includedFinancialObjectSubTypeCodes, List<String> excludedChartCodes, List<String> excludedSubFundCodes, AccountingLineBase accountingLine) {
        if (!includedFinancialObjectSubTypeCodes.isEmpty() && !includedFinancialObjectSubTypeCodes.contains(accountingLine.getObjectCode().getFinancialObjectSubTypeCode())) {
            return false;
        }
        if (!excludedChartCodes.isEmpty() && excludedChartCodes.contains(accountingLine.getChartOfAccountsCode())) {
            return false;
        }
        return excludedSubFundCodes.isEmpty() || !excludedSubFundCodes.contains(accountingLine.getAccount().getSubFundGroupCode());
    }

    public void deleteDocumentAssetLocks(Document document) {
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isCanceled() || workflowDocument.isDisapproved() || workflowDocument.isRecalled() || workflowDocument.isException()) {
            this.deleteAssetLocks(document.getDocumentNumber(), null);
        }
    }

    public List<CapitalAssetManagementAssetTransactionType> getAllAssetTransactionTypes() {
        Class assetTransactionTypeClass = this.getKualiModuleService().getResponsibleModuleService(CapitalAssetManagementAssetTransactionType.class).getExternalizableBusinessObjectImplementation(CapitalAssetManagementAssetTransactionType.class);
        HashMap<String, String> searchKeys = new HashMap<String, String>();
        searchKeys.put("active", "Y");
        return (List)this.businessObjectService.findMatching(assetTransactionTypeClass, searchKeys);
    }

    public boolean validatePurchasingData(AccountingDocument accountingDocument) {
        boolean valid = true;
        PurchasingDocument purchasingDocument = (PurchasingDocument)accountingDocument;
        String systemTypeCode = purchasingDocument.getCapitalAssetSystemTypeCode();
        String capitalAssetSystemStateCode = purchasingDocument.getCapitalAssetSystemStateCode();
        String documentType = purchasingDocument instanceof RequisitionDocument ? "REQUISITION" : "PURCHASE_ORDER";
        for (PurApItem item : purchasingDocument.getItems()) {
            List accountingLines = item.getSourceAccountingLines();
            for (PurApAccountingLine accountingLine : accountingLines) {
                String coa = accountingLine.getChartOfAccountsCode();
                if ("IND".equals(systemTypeCode)) {
                    valid &= this.validateIndividualCapitalAssetSystemFromPurchasing(capitalAssetSystemStateCode, purchasingDocument.getPurchasingCapitalAssetItems(), coa, documentType);
                    continue;
                }
                if ("ONE".equals(systemTypeCode)) {
                    valid &= this.validateOneSystemCapitalAssetSystemFromPurchasing(capitalAssetSystemStateCode, purchasingDocument.getPurchasingCapitalAssetSystems(), purchasingDocument.getPurchasingCapitalAssetItems(), coa, documentType);
                    continue;
                }
                if (!"MUL".equals(systemTypeCode)) continue;
                valid &= this.validateMultipleSystemsCapitalAssetSystemFromPurchasing(capitalAssetSystemStateCode, purchasingDocument.getPurchasingCapitalAssetSystems(), purchasingDocument.getPurchasingCapitalAssetItems(), coa, documentType);
            }
        }
        return valid;
    }

    public boolean validateAccountsPayableData(AccountingDocument accountingDocument) {
        AccountsPayableDocument apDocument = (AccountsPayableDocument)accountingDocument;
        boolean valid = true;
        for (PurApItem purApItem : apDocument.getItems()) {
            AccountsPayableItem accountsPayableItem = (AccountsPayableItem)purApItem;
            if (accountsPayableItem.getItemType().isAdditionalChargeIndicator() || !StringUtils.isNotEmpty((CharSequence)accountsPayableItem.getCapitalAssetTransactionTypeCode())) continue;
            valid &= this.validateAccountsPayableItem(accountsPayableItem);
        }
        return valid;
    }

    public boolean doesAccountingLineFailAutomaticPurchaseOrderRules(AccountingLine accountingLine) {
        PurApAccountingLine purapAccountingLine = (PurApAccountingLine)accountingLine;
        purapAccountingLine.refreshNonUpdateableReferences();
        return this.parameterEvaluatorService.getParameterEvaluator(KfsParameterConstants.CAPITAL_ASSETS_DOCUMENT.class, "PURCHASING_ACCOUNTS_PAYABLE_OBJECT_LEVELS", purapAccountingLine.getObjectCode().getFinancialObjectLevelCode()).evaluationSucceeds();
    }

    public boolean doesDocumentFailAutomaticPurchaseOrderRules(AccountingDocument accountingDocument) {
        PurchasingDocument purchasingDocument = (PurchasingDocument)accountingDocument;
        return ObjectUtils.isNotNull((Object)purchasingDocument.getPurchasingCapitalAssetItems()) && !purchasingDocument.getPurchasingCapitalAssetItems().isEmpty();
    }

    public boolean validateAutomaticPurchaseOrderRule(AccountingDocument accountingDocument) {
        PurchasingDocument purchasingDocument = (PurchasingDocument)accountingDocument;
        for (PurApItem item : purchasingDocument.getItems()) {
            if (!this.doesItemNeedCapitalAsset(item.getItemTypeCode(), item.getSourceAccountingLines())) continue;
            return false;
        }
        return true;
    }

    public boolean doesItemNeedCapitalAsset(String itemTypeCode, List accountingLines) {
        if ("TRDI".equals(itemTypeCode)) {
            return false;
        }
        for (Object entry : accountingLines) {
            PurApAccountingLine accountingLine = (PurApAccountingLine)entry;
            accountingLine.refreshReferenceObject("objectCode");
            if (!ObjectUtils.isNotNull((Object)accountingLine.getObjectCode()) || !this.isCapitalAssetObjectCode(accountingLine.getObjectCode())) continue;
            return true;
        }
        return false;
    }

    public boolean validateUpdateCAMSView(AccountingDocument accountingDocument) {
        PurchasingDocument purchasingDocument = (PurchasingDocument)accountingDocument;
        boolean valid = true;
        for (PurApItem purapItem : purchasingDocument.getItems()) {
            PurchasingCapitalAssetItem camsItem;
            if (!purapItem.getItemType().isLineItemIndicator() || this.doesItemNeedCapitalAsset(purapItem.getItemTypeCode(), purapItem.getSourceAccountingLines()) || (camsItem = purchasingDocument.getPurchasingCapitalAssetItem(purapItem.getItemIdentifier())) == null || camsItem.isEmpty()) continue;
            valid = false;
            GlobalVariables.getMessageMap().putError("newPurchasingItemCapitalAssetLine", "error.capitalAsset.item.not.cams.eligible", new String[]{"in line item # " + purapItem.getItemLineNumber()});
        }
        return valid;
    }

    public boolean validateAddItemCapitalAssetBusinessRules(ItemCapitalAsset asset) {
        boolean valid = asset.getCapitalAssetNumber() == null ? false : this.dictionaryValidationService.isBusinessObjectValid((BusinessObject)asset);
        if (!valid) {
            String propertyName = "newPurchasingItemCapitalAssetLine.capitalAssetNumber";
            String errorKey = "errors.item.capitalAsset.assetNumber.must.be.longValue.notNull";
            GlobalVariables.getMessageMap().putError("newPurchasingItemCapitalAssetLine.capitalAssetNumber", "errors.item.capitalAsset.assetNumber.must.be.longValue.notNull", new String[0]);
        } else {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("capitalAssetNumber", asset.getCapitalAssetNumber().toString());
            Asset retrievedAsset = (Asset)this.businessObjectService.findByPrimaryKey(Asset.class, params);
            if (ObjectUtils.isNull((Object)((Object)retrievedAsset))) {
                valid = false;
                String label = this.getDataDictionaryService().getAttributeLabel(CapitalAssetInformation.class, "capitalAssetNumber");
                GlobalVariables.getMessageMap().putError("newPurchasingItemCapitalAssetLine.capitalAssetNumber", "error.existence", new String[]{label});
            } else {
                boolean isCapitalAsset;
                boolean bl = isCapitalAsset = this.assetService.isCapitalAsset(retrievedAsset) && !this.assetService.isAssetRetired(retrievedAsset);
                if (!isCapitalAsset) {
                    valid = false;
                    String propertyName = "newPurchasingItemCapitalAssetLine.capitalAssetNumber";
                    String errorKey = "error.asset.active.capital.asset.required";
                    GlobalVariables.getMessageMap().putError("newPurchasingItemCapitalAssetLine.capitalAssetNumber", "error.asset.active.capital.asset.required", new String[0]);
                }
            }
        }
        return valid;
    }

    public boolean warningObjectLevelCapital(AccountingDocument accountingDocument) {
        org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument purapDocument = (org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument)accountingDocument;
        for (PurApItem item : purapDocument.getItems()) {
            if (!item.getItemType().isLineItemIndicator() || !item.getItemType().isQuantityBasedGeneralLedgerIndicator() || !ObjectUtils.isNotNull((Object)item.getItemUnitPrice())) continue;
            List accounts = item.getSourceAccountingLines();
            BigDecimal unitPrice = item.getItemUnitPrice();
            String itemIdentifier = item.getItemIdentifierString();
            for (PurApAccountingLine account : accounts) {
                ObjectCode objectCode = account.getObjectCode();
                if (this.validateLevelCapitalAssetIndication(unitPrice, objectCode, itemIdentifier)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean validateIndividualCapitalAssetSystemFromPurchasing(String systemState, List<PurchasingCapitalAssetItem> capitalAssetItems, String chartCode, String documentType) {
        boolean valid = this.validateAllFieldRequirementsByChart(systemState, null, capitalAssetItems, chartCode, documentType, "IND");
        valid &= this.validateQuantityOnLocationsEqualsQuantityOnItem(capitalAssetItems, "IND", systemState);
        valid &= this.validateIndividualSystemPurchasingTransactionTypesAllowingAssetNumbers(capitalAssetItems);
        return valid &= this.validateNonQuantityDrivenAllowedIndicatorAndTradeIn(capitalAssetItems);
    }

    protected boolean validateOneSystemCapitalAssetSystemFromPurchasing(String systemState, List<CapitalAssetSystem> capitalAssetSystems, List<PurchasingCapitalAssetItem> capitalAssetItems, String chartCode, String documentType) {
        boolean valid = this.validateAllFieldRequirementsByChart(systemState, capitalAssetSystems, capitalAssetItems, chartCode, documentType, "ONE");
        String capitalAssetTransactionType = capitalAssetItems.get(0).getCapitalAssetTransactionTypeCode();
        String prefix = "document.purchasingCapitalAssetSystems[0].";
        valid &= this.validatePurchasingTransactionTypesAllowingAssetNumbers(capitalAssetSystems.get(0), capitalAssetTransactionType, "document.purchasingCapitalAssetSystems[0].");
        return valid &= this.validateNonQuantityDrivenAllowedIndicatorAndTradeIn(capitalAssetItems);
    }

    protected boolean validateMultipleSystemsCapitalAssetSystemFromPurchasing(String systemState, List<CapitalAssetSystem> capitalAssetSystems, List<PurchasingCapitalAssetItem> capitalAssetItems, String chartCode, String documentType) {
        boolean valid = this.validateAllFieldRequirementsByChart(systemState, capitalAssetSystems, capitalAssetItems, chartCode, documentType, "MUL");
        String capitalAssetTransactionType = capitalAssetItems.get(0).getCapitalAssetTransactionTypeCode();
        String prefix = "document.purchasingCapitalAssetSystems[0].";
        valid &= this.validatePurchasingTransactionTypesAllowingAssetNumbers(capitalAssetSystems.get(0), capitalAssetTransactionType, "document.purchasingCapitalAssetSystems[0].");
        return valid &= this.validateNonQuantityDrivenAllowedIndicatorAndTradeIn(capitalAssetItems);
    }

    protected boolean validateAllFieldRequirementsByChart(String systemState, List<CapitalAssetSystem> capitalAssetSystems, List<PurchasingCapitalAssetItem> capitalAssetItems, String chartCode, String documentType, String systemType) {
        boolean valid = true;
        QueryByCriteria.Builder qbc = QueryByCriteria.Builder.create();
        qbc.setPredicates(new Predicate[]{PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"namespaceCode", (Object)"KFS-CAM"), PredicateFactory.equal((String)"componentCode", (Object)"Document"), PredicateFactory.like((String)"name", (CharSequence)("CHARTS_REQUIRING%" + documentType))})});
        List results = this.parameterRepositoryService.findParameters(qbc.build()).getResults();
        for (Parameter parameter : results) {
            if (!ObjectUtils.isNotNull((Object)parameter)) continue;
            if (systemType.equals("IND")) {
                valid &= this.validateFieldRequirementByChartForIndividualSystemType(systemState, capitalAssetItems, chartCode, parameter.getName(), parameter.getValue());
                continue;
            }
            valid &= this.validateFieldRequirementByChartForOneOrMultipleSystemType(systemType, systemState, capitalAssetSystems, capitalAssetItems, chartCode, parameter.getName(), parameter.getValue());
        }
        return valid;
    }

    public boolean validateAllFieldRequirementsByChart(AccountingDocument accountingDocument) {
        PurchasingDocument purchasingDocument = (PurchasingDocument)accountingDocument;
        String documentType = purchasingDocument instanceof RequisitionDocument ? "REQUISITION" : "PURCHASE_ORDER";
        for (PurApItem item : purchasingDocument.getItems()) {
            if (!this.shouldValidate(item)) continue;
            List accountingLines = item.getSourceAccountingLines();
            for (PurApAccountingLine accountingLine : accountingLines) {
                String coa = accountingLine.getChartOfAccountsCode();
                QueryByCriteria.Builder qbc = QueryByCriteria.Builder.create();
                qbc.setPredicates(new Predicate[]{PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"namespaceCode", (Object)"KFS-CAM"), PredicateFactory.equal((String)"componentCode", (Object)"Document"), PredicateFactory.like((String)"name", (CharSequence)("CHARTS_REQUIRING%" + documentType)), PredicateFactory.like((String)"value", (CharSequence)("%" + coa + "%"))})});
                List results = this.parameterRepositoryService.findParameters(qbc.build()).getResults();
                for (Parameter parameter : results) {
                    if (!ObjectUtils.isNotNull((Object)parameter) || parameter.getValue() == null) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean validatePurchasingObjectSubType(AccountingDocument accountingDocument) {
        PurchasingDocument purchasingDocument = (PurchasingDocument)accountingDocument;
        for (PurApItem item : purchasingDocument.getItems()) {
            if (!this.shouldValidate(item)) continue;
            List accountingLines = item.getSourceAccountingLines();
            for (PurApAccountingLine accountingLine : accountingLines) {
                accountingLine.refreshReferenceObject("objectCode");
                if (!ObjectUtils.isNotNull((Object)accountingLine.getObjectCode()) || !this.isCapitalAssetObjectCode(accountingLine.getObjectCode())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean shouldValidate(PurApItem item) {
        if (item instanceof PurchaseOrderItem) {
            return ((PurchaseOrderItem)item).isItemActiveIndicator();
        }
        return true;
    }

    protected boolean validateFieldRequirementByChartForOneOrMultipleSystemType(String systemType, String systemState, List<CapitalAssetSystem> capitalAssetSystems, List<PurchasingCapitalAssetItem> capitalAssetItems, String chartCode, String parameterName, String parameterValueString) {
        boolean valid;
        block9: {
            valid = true;
            boolean needValidation = this.parameterEvaluatorService.getParameterEvaluator(KfsParameterConstants.CAPITAL_ASSETS_DOCUMENT.class, parameterName, chartCode).evaluationSucceeds();
            if (!needValidation) break block9;
            if (parameterName.startsWith("CHARTS_REQUIRING_LOCATIONS_ADDRESS")) {
                return this.validateCapitalAssetLocationAddressFieldsOneOrMultipleSystemType(capitalAssetSystems);
            }
            String mappedName = (String)PurapConstants.CAMS_REQUIREDNESS_FIELDS.REQUIREDNESS_FIELDS_BY_PARAMETER_NAMES.get(parameterName);
            if (mappedName != null) {
                String availableValue = this.getValueFromAvailabilityMatrix(mappedName, systemType, systemState);
                if (availableValue.equals("NONE")) {
                    return true;
                }
                if (mappedName.equals("capitalAssetTransactionTypeCode")) {
                    Object[] mappedNames = new String[]{"purchasingCapitalAssetItems", mappedName};
                    for (PurchasingCapitalAssetItem item : capitalAssetItems) {
                        StringBuffer keyBuffer = new StringBuffer("document.purchasingCapitalAssetItems[" + (item.getPurchasingItem().getItemLineNumber() - 1) + "].");
                        valid &= this.validateFieldRequirementByChartHelper(item, ArrayUtils.subarray((Object[])mappedNames, (int)1, (int)mappedNames.length), keyBuffer, item.getPurchasingItem().getItemLineNumber());
                    }
                } else {
                    ArrayList<String> mappedNamesList = new ArrayList<String>();
                    mappedNamesList.add("purchasingCapitalAssetSystems");
                    if (mappedName.contains(".")) {
                        mappedNamesList.addAll(this.mappedNameSplitter(mappedName));
                    } else {
                        mappedNamesList.add(mappedName);
                    }
                    int count = 0;
                    for (CapitalAssetSystem system : capitalAssetSystems) {
                        StringBuffer keyBuffer = new StringBuffer("document.purchasingCapitalAssetSystems[" + count + "].");
                        valid &= this.validateFieldRequirementByChartHelper(system, ArrayUtils.subarray((Object[])mappedNamesList.toArray(), (int)1, (int)mappedNamesList.size()), keyBuffer, null);
                        ++count;
                    }
                }
            }
        }
        return valid;
    }

    protected boolean validateFieldRequirementByChartForIndividualSystemType(String systemState, List<PurchasingCapitalAssetItem> capitalAssetItems, String chartCode, String parameterName, String parameterValueString) {
        boolean valid = true;
        boolean needValidation = this.parameterEvaluatorService.getParameterEvaluator(KfsParameterConstants.CAPITAL_ASSETS_DOCUMENT.class, parameterName, chartCode).evaluationSucceeds();
        if (needValidation) {
            if (parameterName.startsWith("CHARTS_REQUIRING_LOCATIONS_ADDRESS")) {
                return this.validateCapitalAssetLocationAddressFieldsForIndividualSystemType(capitalAssetItems);
            }
            String mappedName = (String)PurapConstants.CAMS_REQUIREDNESS_FIELDS.REQUIREDNESS_FIELDS_BY_PARAMETER_NAMES.get(parameterName);
            if (mappedName != null) {
                String availableValue = this.getValueFromAvailabilityMatrix(mappedName, "IND", systemState);
                if (availableValue.equals("NONE")) {
                    return true;
                }
                ArrayList<String> mappedNamesList = new ArrayList<String>();
                if (mappedName.equals("capitalAssetTransactionTypeCode")) {
                    mappedNamesList.add("purchasingCapitalAssetItems");
                    mappedNamesList.add(mappedName);
                } else {
                    mappedNamesList.add("purchasingCapitalAssetItems");
                    mappedNamesList.add("purchasingCapitalAssetSystem");
                    if (mappedName.contains(".")) {
                        mappedNamesList.addAll(this.mappedNameSplitter(mappedName));
                    } else {
                        mappedNamesList.add(mappedName);
                    }
                }
                for (PurchasingCapitalAssetItem item : capitalAssetItems) {
                    StringBuffer keyBuffer = new StringBuffer("document.purchasingCapitalAssetItems[" + (item.getPurchasingItem().getItemLineNumber() - 1) + "].");
                    valid &= this.validateFieldRequirementByChartHelper(item, ArrayUtils.subarray((Object[])mappedNamesList.toArray(), (int)1, (int)mappedNamesList.size()), keyBuffer, item.getPurchasingItem().getItemLineNumber());
                }
            }
        }
        return valid;
    }

    protected List<String> mappedNameSplitter(String mappedName) {
        ArrayList<String> result = new ArrayList<String>();
        String[] mappedNamesArray = mappedName.split("\\.");
        Collections.addAll(result, mappedNamesArray);
        return result;
    }

    protected boolean validateFieldRequirementByChartHelper(Object bean, Object[] mappedNames, StringBuffer errorKey, Integer itemNumber) {
        boolean valid = true;
        Object value = ObjectUtils.getPropertyValue((Object)bean, (String)((String)mappedNames[0]));
        if (ObjectUtils.isNull((Object)value)) {
            errorKey.append(mappedNames[0]);
            Object fieldName = this.dataDictionaryService.getAttributeErrorLabel(bean.getClass(), (String)mappedNames[0]);
            if (itemNumber != null) {
                fieldName = (String)fieldName + " in Item " + itemNumber;
            }
            GlobalVariables.getMessageMap().putError(errorKey.toString(), "error.required", new String[]{fieldName});
            return false;
        }
        if (value instanceof Collection) {
            if (((Collection)value).isEmpty()) {
                Class offendingClass;
                errorKey.append(mappedNames[0]);
                String mappedNameStr = (String)mappedNames[0];
                String methodToInvoke = "get" + mappedNameStr.substring(0, 1).toUpperCase(Locale.US) + mappedNameStr.substring(1, mappedNameStr.length() - 1) + "Class";
                try {
                    offendingClass = (Class)bean.getClass().getMethod(methodToInvoke, null).invoke(bean, (Object[])null);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                BusinessObjectEntry boe = this.businessObjectDictionaryService.getBusinessObjectEntry(offendingClass.getName());
                List offendingAttributes = boe.getAttributes();
                AttributeDefinition offendingAttribute = (AttributeDefinition)offendingAttributes.get(0);
                String fieldName = this.dataDictionaryService.getAttributeShortLabel(offendingClass, offendingAttribute.getName());
                GlobalVariables.getMessageMap().putError(errorKey.toString(), "error.required", new String[]{fieldName});
                return false;
            }
            int count = 0;
            for (Object o : (Collection)value) {
                errorKey.append(mappedNames[0]).append("[").append(count).append("].");
                ++count;
                valid &= this.validateFieldRequirementByChartHelper(o, ArrayUtils.subarray((Object[])mappedNames, (int)1, (int)mappedNames.length), errorKey, itemNumber);
            }
            return valid;
        }
        if (StringUtils.isBlank((CharSequence)value.toString())) {
            errorKey.append(mappedNames[0]);
            GlobalVariables.getMessageMap().putError(errorKey.toString(), "error.required", new String[]{(String)mappedNames[0]});
            return false;
        }
        if (mappedNames.length > 1) {
            errorKey.append(mappedNames[0]).append(".");
            valid = this.validateFieldRequirementByChartHelper(value, ArrayUtils.subarray((Object[])mappedNames, (int)1, (int)mappedNames.length), errorKey, itemNumber);
            return valid;
        }
        return true;
    }

    protected String getValueFromAvailabilityMatrix(String fieldName, String systemType, String systemState) {
        for (AvailabilityMatrix am : PurapConstants.CAMS_AVAILABILITY_MATRIX.MATRIX_LIST) {
            if (!am.fieldName.equals(fieldName) || !am.systemState.equals(systemState) || !am.systemType.equals(systemType)) continue;
            return am.availableValue;
        }
        return null;
    }

    protected boolean validateQuantityOnLocationsEqualsQuantityOnItem(List<PurchasingCapitalAssetItem> capitalAssetItems, String systemType, String systemState) {
        boolean valid = true;
        String availableValue = this.getValueFromAvailabilityMatrix("capitalAssetLocations.itemQuantity", systemType, systemState);
        if (availableValue.equals("NONE")) {
            return true;
        }
        int count = 0;
        for (PurchasingCapitalAssetItem item : capitalAssetItems) {
            if (item.getPurchasingItem() != null && item.getPurchasingItem().getItemType().isQuantityBasedGeneralLedgerIndicator() && !item.getPurchasingCapitalAssetSystem().getCapitalAssetLocations().isEmpty()) {
                KualiDecimal total = new KualiDecimal(0);
                for (CapitalAssetLocation location : item.getPurchasingCapitalAssetSystem().getCapitalAssetLocations()) {
                    if (!ObjectUtils.isNotNull((Object)location.getItemQuantity())) continue;
                    total = (KualiDecimal)total.add((AbstractKualiDecimal)location.getItemQuantity());
                }
                if (!item.getPurchasingItem().getItemQuantity().equals((Object)total)) {
                    valid = false;
                    String errorKey = "error.capitalAsset.locations.quantity.must.equal.item.quantity";
                    String propertyName = "document.purchasingCapitalAssetItems[" + count + "].purchasingCapitalAssetSystem.newPurchasingCapitalAssetLocationLine.itemQuantity";
                    GlobalVariables.getMessageMap().putError(propertyName, "error.capitalAsset.locations.quantity.must.equal.item.quantity", new String[]{Integer.toString(count + 1)});
                }
            }
            ++count;
        }
        return valid;
    }

    protected boolean validateIndividualSystemPurchasingTransactionTypesAllowingAssetNumbers(List<PurchasingCapitalAssetItem> capitalAssetItems) {
        boolean valid = true;
        int count = 0;
        for (PurchasingCapitalAssetItem capitalAssetItem : capitalAssetItems) {
            String prefix = "document.purchasingCapitalAssetItems[" + count + "].";
            valid &= this.validatePurchasingTransactionTypesAllowingAssetNumbers(capitalAssetItem.getPurchasingCapitalAssetSystem(), capitalAssetItem.getCapitalAssetTransactionTypeCode(), prefix);
            ++count;
        }
        return valid;
    }

    protected boolean validatePurchasingTransactionTypesAllowingAssetNumbers(CapitalAssetSystem capitalAssetSystem, String capitalAssetTransactionType, String prefix) {
        boolean allowedAssetNumbers = this.parameterEvaluatorService.getParameterEvaluator(KfsParameterConstants.CAPITAL_ASSETS_DOCUMENT.class, "PURCHASING_ASSET_TRANSACTION_TYPES_ALLOWING_ASSET_NUMBERS", capitalAssetTransactionType).evaluationSucceeds();
        if (allowedAssetNumbers) {
            return true;
        }
        for (ItemCapitalAsset asset : capitalAssetSystem.getItemCapitalAssets()) {
            if (asset.getCapitalAssetNumber() == null) continue;
            String propertyName = prefix + "capitalAssetTransactionTypeCode";
            GlobalVariables.getMessageMap().putError(propertyName, "error.capitalAsset.asset.numbers.not.allowed.trans.type", new String[]{capitalAssetTransactionType});
            return false;
        }
        return true;
    }

    protected boolean validateNonQuantityDrivenAllowedIndicatorAndTradeIn(List<PurchasingCapitalAssetItem> capitalAssetItems) {
        boolean valid = true;
        int count = 0;
        for (PurchasingCapitalAssetItem capitalAssetItem : capitalAssetItems) {
            String prefix = "document.purchasingCapitalAssetItems[" + count + "].";
            if (StringUtils.isNotBlank((CharSequence)capitalAssetItem.getCapitalAssetTransactionTypeCode()) && !capitalAssetItem.getCapitalAssetTransactionType().getCapitalAssetNonquantityDrivenAllowIndicator() && !capitalAssetItem.getPurchasingItem().getItemType().isQuantityBasedGeneralLedgerIndicator()) {
                String propertyName = prefix + "capitalAssetTransactionTypeCode";
                GlobalVariables.getMessageMap().putError(propertyName, "error.capitalAsset.trans.type.not.allowing.non.quantity.items", new String[]{capitalAssetItem.getCapitalAssetTransactionTypeCode()});
                valid = false;
            }
            ++count;
        }
        return valid;
    }

    public boolean validateItemCapitalAssetWithErrors(String recurringPaymentTypeCode, ExternalPurApItem item, boolean apoCheck) {
        PurchasingItemBase purchasingItem = (PurchasingItemBase)item;
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath("document.purchasingCapitalAsset*,newPurchasingItemCapitalAssetLine*,newPurchasingCapitalAssetLocationLine*,document.capitalAssetSystemStateCode");
        boolean result = this.validatePurchasingItemCapitalAsset(recurringPaymentTypeCode, (PurchasingItem)purchasingItem);
        GlobalVariables.getMessageMap().clearErrorPath();
        return result;
    }

    protected boolean validatePurchasingItemCapitalAsset(String recurringPaymentTypeCode, PurchasingItem item) {
        boolean valid = true;
        String capitalAssetTransactionTypeCode = "";
        AssetTransactionType capitalAssetTransactionType = null;
        String itemIdentifier = item.getItemIdentifierString();
        if (item.getPurchasingCapitalAssetItem() != null) {
            capitalAssetTransactionTypeCode = item.getPurchasingCapitalAssetItem().getCapitalAssetTransactionTypeCode();
            capitalAssetTransactionType = (AssetTransactionType)item.getPurchasingCapitalAssetItem().getCapitalAssetTransactionType();
        }
        if (StringUtils.isNotEmpty((CharSequence)capitalAssetTransactionTypeCode)) {
            valid = this.validateCapitalAssetTransactionTypeVersusRecurrence(capitalAssetTransactionType, recurringPaymentTypeCode, itemIdentifier);
        }
        return valid & this.validatePurapItemCapitalAsset((PurApItem)item, capitalAssetTransactionType);
    }

    protected boolean validatePurapItemCapitalAsset(PurApItem item, AssetTransactionType capitalAssetTransactionType) {
        boolean valid = true;
        String itemIdentifier = item.getItemIdentifierString();
        boolean quantityBased = item.getItemType().isQuantityBasedGeneralLedgerIndicator();
        HashSet<String> capitalOrExpenseSet = new HashSet<String>();
        boolean performObjectCodeVersusTransactionTypeValidation = true;
        if (item instanceof AccountsPayableItem) {
            performObjectCodeVersusTransactionTypeValidation = false;
        }
        for (PurApAccountingLine accountingLine : item.getSourceAccountingLines()) {
            accountingLine.refreshReferenceObject("objectCode");
            ObjectCode objectCode = accountingLine.getObjectCode();
            if (!ObjectUtils.isNotNull((Object)objectCode)) continue;
            String capitalOrExpense = this.objectCodeCapitalOrExpense(objectCode);
            capitalOrExpenseSet.add(capitalOrExpense);
            valid &= this.validateAccountingLinesNotCapitalAndExpense(capitalOrExpenseSet, itemIdentifier, objectCode);
            if (!performObjectCodeVersusTransactionTypeValidation || capitalAssetTransactionType == null) continue;
            valid &= this.validateObjectCodeVersusTransactionType(objectCode, capitalAssetTransactionType, itemIdentifier, quantityBased);
        }
        return valid;
    }

    protected boolean validateAccountingLinesNotCapitalAndExpense(HashSet<String> capitalOrExpenseSet, String itemIdentifier, ObjectCode objectCode) {
        boolean valid = true;
        if (capitalOrExpenseSet.size() > 1) {
            GlobalVariables.getMessageMap().putError("financialObjectLevelCode", "errors.item.capitalAsset.capital.and.expense", new String[]{itemIdentifier, objectCode.getFinancialObjectCodeName()});
            valid = false;
        }
        return valid;
    }

    protected boolean validateLevelCapitalAssetIndication(BigDecimal unitPrice, ObjectCode objectCode, String itemIdentifier) {
        ArrayList possibleCAMSObjectLevels;
        BigDecimal priceThreshold;
        String capitalAssetPriceThresholdParam = this.getParameterService().getParameterValueAsString(AssetGlobal.class, "CAPITALIZATION_LIMIT_AMOUNT");
        try {
            priceThreshold = new BigDecimal(capitalAssetPriceThresholdParam);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("the parameter for CAPITAL_ASSET_OBJECT_LEVELS came was not able to be converted to a number.", nfe);
        }
        if (unitPrice.compareTo(priceThreshold) >= 0 && (possibleCAMSObjectLevels = new ArrayList(this.getParameterService().getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSETS_DOCUMENT.class, "PURCHASING_ACCOUNTS_PAYABLE_POSSIBLE_OBJECT_LEVELS"))).contains(objectCode.getFinancialObjectLevelCode())) {
            String warning = this.configurationService.getPropertyValueAsString("warnings.item.capitalAsset.threshold.objectCodeLevel");
            warning = StringUtils.replace((String)warning, (String)"{0}", (String)itemIdentifier);
            warning = StringUtils.replace((String)warning, (String)"{1}", (String)priceThreshold.toString());
            KNSGlobalVariables.getMessageList().add(warning, new String[0]);
            return false;
        }
        return true;
    }

    protected boolean validateObjectCodeVersusTransactionType(ObjectCode objectCode, CapitalAssetManagementAssetTransactionType capitalAssetTransactionType, String itemIdentifier, boolean quantityBasedItem) {
        boolean valid = true;
        String[] objectCodeSubTypes = new String[]{};
        if (this.isCapitalAssetObjectCode(objectCode)) {
            String capitalAssetSubtypeRequiredText;
            String alternativeItemTypeStr;
            String itemTypeStr;
            if (quantityBasedItem) {
                String capitalAssetQuantitySubtypeRequiredText = capitalAssetTransactionType.getCapitalAssetQuantitySubtypeRequiredText();
                itemTypeStr = "Qty";
                alternativeItemTypeStr = "No Qty";
                capitalAssetSubtypeRequiredText = capitalAssetQuantitySubtypeRequiredText;
                if (capitalAssetQuantitySubtypeRequiredText != null) {
                    objectCodeSubTypes = StringUtils.split((String)capitalAssetQuantitySubtypeRequiredText, (String)";");
                }
            } else {
                String capitalAssetNonquantitySubtypeRequiredText = capitalAssetTransactionType.getCapitalAssetNonquantitySubtypeRequiredText();
                itemTypeStr = "No Qty";
                alternativeItemTypeStr = "Qty";
                capitalAssetSubtypeRequiredText = capitalAssetNonquantitySubtypeRequiredText;
                if (capitalAssetNonquantitySubtypeRequiredText != null) {
                    objectCodeSubTypes = StringUtils.split((String)capitalAssetNonquantitySubtypeRequiredText, (String)";");
                }
            }
            boolean found = false;
            for (String subType : objectCodeSubTypes) {
                if (!StringUtils.equals((CharSequence)subType, (CharSequence)objectCode.getFinancialObjectSubTypeCode())) continue;
                found = true;
                break;
            }
            if (!found) {
                List errorPath = GlobalVariables.getMessageMap().getErrorPath();
                if (errorPath != null && errorPath.isEmpty()) {
                    String errorPathPrefix = "document.item";
                    GlobalVariables.getMessageMap().addToErrorPath("document.item");
                    GlobalVariables.getMessageMap().putError("capitalAssetTransactionType", "errors.item.capitalAsset.tranType.objectCodeSubtype", new String[]{itemIdentifier, itemTypeStr, capitalAssetTransactionType.getCapitalAssetTransactionTypeDescription(), objectCode.getFinancialObjectCodeName(), capitalAssetSubtypeRequiredText, alternativeItemTypeStr});
                    GlobalVariables.getMessageMap().removeFromErrorPath("document.item");
                } else {
                    GlobalVariables.getMessageMap().putError("capitalAssetTransactionType", "errors.item.capitalAsset.tranType.objectCodeSubtype", new String[]{itemIdentifier, itemTypeStr, capitalAssetTransactionType.getCapitalAssetTransactionTypeDescription(), objectCode.getFinancialObjectCodeName(), capitalAssetSubtypeRequiredText, alternativeItemTypeStr});
                }
                valid = false;
            }
        }
        return valid;
    }

    protected boolean validateCapitalAssetTransactionTypeVersusRecurrence(CapitalAssetManagementAssetTransactionType capitalAssetTransactionType, String recurringPaymentTypeCode, String itemIdentifier) {
        boolean valid = true;
        if (capitalAssetTransactionType != null && capitalAssetTransactionType.getCapitalAssetTransactionTypeCode() != null) {
            String recurringTransactionTypeCodes = this.getParameterService().getParameterValueAsString(KfsParameterConstants.CAPITAL_ASSETS_DOCUMENT.class, "PURCHASING_ASSET_TRANSACTION_TYPES_REQUIRING_RECURRING_PAYMENT_TERMS");
            if (StringUtils.isNotEmpty((CharSequence)recurringPaymentTypeCode)) {
                if (!StringUtils.contains((CharSequence)recurringTransactionTypeCodes, (CharSequence)capitalAssetTransactionType.getCapitalAssetTransactionTypeCode())) {
                    GlobalVariables.getMessageMap().putError("capitalAssetTransactionType", "errors.item.capitalAsset.wrong.tranType", new String[]{itemIdentifier, capitalAssetTransactionType.getCapitalAssetTransactionTypeDescription(), "Recurring"});
                    valid = false;
                }
            } else if (StringUtils.contains((CharSequence)recurringTransactionTypeCodes, (CharSequence)capitalAssetTransactionType.getCapitalAssetTransactionTypeCode())) {
                GlobalVariables.getMessageMap().putError("capitalAssetTransactionType", "errors.item.capitalAsset.wrong.tranType", new String[]{itemIdentifier, capitalAssetTransactionType.getCapitalAssetTransactionTypeDescription(), "Non-recurring"});
                valid = false;
            }
        } else if (StringUtils.isNotEmpty((CharSequence)recurringPaymentTypeCode)) {
            GlobalVariables.getMessageMap().putError("capitalAssetTransactionType", "errors.item.capitalAsset.no.tranType", new String[]{itemIdentifier, "Recurring"});
            valid = false;
        } else {
            GlobalVariables.getMessageMap().putError("capitalAssetTransactionType", "errors.item.capitalAsset.no.tranType", new String[]{itemIdentifier, "Non-recurring"});
            valid = false;
        }
        return valid;
    }

    protected String objectCodeCapitalOrExpense(ObjectCode oc) {
        String capital = "Capital";
        String expense = "Expense";
        return this.isCapitalAssetObjectCode(oc) ? "Capital" : "Expense";
    }

    protected boolean isCapitalAssetObjectCode(ObjectCode oc) {
        String capitalAssetObjectSubType = this.getParameterService().getParameterValueAsString(KfsParameterConstants.CAPITAL_ASSETS_DOCUMENT.class, "PURCHASING_OBJECT_SUB_TYPES");
        return StringUtils.containsIgnoreCase((CharSequence)capitalAssetObjectSubType, (CharSequence)oc.getFinancialObjectSubTypeCode());
    }

    protected boolean validateCapitalAssetLocationAddressFieldsOneOrMultipleSystemType(List<CapitalAssetSystem> capitalAssetSystems) {
        boolean valid = true;
        int systemCount = 0;
        for (CapitalAssetSystem system : capitalAssetSystems) {
            List capitalAssetLocations = system.getCapitalAssetLocations();
            StringBuffer errorKey = new StringBuffer("document.purchasingCapitalAssetSystems[" + systemCount++ + "].");
            errorKey.append("capitalAssetLocations");
            int locationCount = 0;
            for (CapitalAssetLocation location : capitalAssetLocations) {
                errorKey.append("[").append(locationCount++).append("].");
                AssetType assetType = this.getAssetType(system.getCapitalAssetTypeCode());
                boolean isMoving = ObjectUtils.isNotNull((Object)((Object)assetType)) && assetType.isMovingIndicator();
                boolean ignoreBuilding = ObjectUtils.isNotNull((Object)((Object)assetType)) && assetType.isRequiredBuildingIndicator();
                valid &= this.validateCapitalAssetLocationAddressFields(location, isMoving, ignoreBuilding, errorKey);
            }
        }
        return valid;
    }

    protected boolean validateCapitalAssetLocationAddressFieldsForIndividualSystemType(List<PurchasingCapitalAssetItem> capitalAssetItems) {
        boolean valid = true;
        for (PurchasingCapitalAssetItem item : capitalAssetItems) {
            CapitalAssetSystem system = item.getPurchasingCapitalAssetSystem();
            List capitalAssetLocations = system.getCapitalAssetLocations();
            StringBuffer errorKey = new StringBuffer("document.purchasingCapitalAssetItems[" + (item.getPurchasingItem().getItemLineNumber() - 1) + "].");
            errorKey.append("purchasingCapitalAssetSystem.capitalAssetLocations");
            int i = 0;
            for (CapitalAssetLocation location : capitalAssetLocations) {
                errorKey.append("[").append(i++).append("].");
                AssetType assetType = this.getAssetType(system.getCapitalAssetTypeCode());
                boolean isMoving = ObjectUtils.isNotNull((Object)((Object)assetType)) && assetType.isMovingIndicator();
                boolean isRequiredBuilding = ObjectUtils.isNotNull((Object)((Object)assetType)) && assetType.isRequiredBuildingIndicator();
                valid &= this.validateCapitalAssetLocationAddressFields(location, isMoving, isRequiredBuilding, errorKey);
            }
        }
        return valid;
    }

    protected boolean validateCapitalAssetLocationAddressFields(CapitalAssetLocation location, boolean isMoving, boolean isRequiredBuilding, StringBuffer errorKey) {
        boolean valid = true;
        if (!location.isOffCampusIndicator() && StringUtils.isBlank((CharSequence)location.getCampusCode())) {
            GlobalVariables.getMessageMap().putError(errorKey.toString(), "error.required", new String[]{"campusCode"});
            valid = false;
        }
        if (isMoving) {
            if (!location.isOffCampusIndicator()) {
                if (StringUtils.isBlank((CharSequence)location.getBuildingRoomNumber())) {
                    GlobalVariables.getMessageMap().putError(errorKey.toString(), "error.required", new String[]{"buildingRoomNumber"});
                    valid = false;
                }
                if (StringUtils.isBlank((CharSequence)location.getBuildingCode())) {
                    GlobalVariables.getMessageMap().putError(errorKey.toString(), "error.required", new String[]{"buildingCode"});
                    valid = false;
                }
            }
            valid &= this.validateCapitalAssetAddressFields(location, errorKey);
        } else {
            if (StringUtils.isNotBlank((CharSequence)location.getBuildingRoomNumber())) {
                GlobalVariables.getMessageMap().putError(errorKey.toString(), "error.asset.location.room.number.non.movable", new String[]{"buildingRoomNumber"});
                valid = false;
            }
            if (isRequiredBuilding) {
                if (!location.isOffCampusIndicator() && StringUtils.isBlank((CharSequence)location.getBuildingCode())) {
                    GlobalVariables.getMessageMap().putError(errorKey.toString(), "error.required", new String[]{"buildingCode"});
                    valid = false;
                }
                valid &= this.validateCapitalAssetAddressFields(location, errorKey);
            } else if (StringUtils.isNotBlank((CharSequence)location.getBuildingCode())) {
                GlobalVariables.getMessageMap().putError(errorKey.toString(), "error.asset.location.building.number.non.movable", new String[]{"buildingCode"});
                valid = false;
            }
        }
        return valid;
    }

    protected boolean validateCapitalAssetAddressFields(CapitalAssetLocation location, StringBuffer errorKey) {
        boolean valid = true;
        if (StringUtils.isBlank((CharSequence)location.getCapitalAssetLine1Address())) {
            GlobalVariables.getMessageMap().putError(errorKey.toString(), "error.required", new String[]{"capitalAssetLine1Address"});
            valid = false;
        }
        if (StringUtils.isBlank((CharSequence)location.getCapitalAssetCityName())) {
            GlobalVariables.getMessageMap().putError(errorKey.toString(), "error.required", new String[]{"capitalAssetCityName"});
            valid = false;
        }
        if (StringUtils.isBlank((CharSequence)location.getCapitalAssetCountryCode())) {
            GlobalVariables.getMessageMap().putError(errorKey.toString(), "error.required", new String[]{"capitalAssetCountryCode"});
            valid = false;
        } else if (location.getCapitalAssetCountryCode().equals("US")) {
            if (StringUtils.isBlank((CharSequence)location.getCapitalAssetStateCode())) {
                GlobalVariables.getMessageMap().putError(errorKey.toString(), "error.required", new String[]{"capitalAssetStateCode"});
                valid = false;
            }
            if (StringUtils.isBlank((CharSequence)location.getCapitalAssetPostalCode())) {
                GlobalVariables.getMessageMap().putError(errorKey.toString(), "error.required", new String[]{"capitalAssetPostalCode"});
                valid = false;
            }
        }
        return valid;
    }

    protected boolean validateAccountsPayableItem(AccountsPayableItem apItem) {
        return this.validatePurapItemCapitalAsset((PurApItem)apItem, (AssetTransactionType)apItem.getCapitalAssetTransactionType());
    }

    public boolean validateFinancialProcessingData(AccountingDocument accountingDocument, CapitalAssetInformation capitalAssetInformation, int index) {
        boolean isUpdateAssetBlank;
        boolean isNewAssetBlank;
        AccountCapitalObjectCode accountCapitalObjectCode = this.getCapitalAssetObjectSubTypeLinesFlag(accountingDocument);
        boolean valid = accountCapitalObjectCode.validateAssetInfoAllowed(accountingDocument, isNewAssetBlank = this.isNewAssetBlank(capitalAssetInformation), isUpdateAssetBlank = this.isUpdateAssetBlank(capitalAssetInformation));
        if (valid) {
            if (AccountCapitalObjectCode.BOTH_NONCAP.equals((Object)accountCapitalObjectCode)) {
                return true;
            }
            if (!isUpdateAssetBlank) {
                valid = this.validateUpdateCapitalAssetField(capitalAssetInformation, accountingDocument, index);
            } else {
                valid = this.checkNewCapitalAssetFieldsExist(capitalAssetInformation, accountingDocument, index);
                if (valid) {
                    valid = this.validateNewCapitalAssetFields(capitalAssetInformation, index, accountingDocument);
                }
            }
        }
        return valid;
    }

    protected AccountCapitalObjectCode getCapitalAssetObjectSubTypeLinesFlag(AccountingDocument accountingDocument) {
        ArrayList financialProcessingCapitalObjectSubTypes = new ArrayList(this.getParameterService().getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSETS_DOCUMENT.class, "FINANCIAL_PROCESSING_CAPITAL_OBJECT_SUB_TYPES"));
        AccountCapitalObjectCode capitalAssetObjectSubTypeLinesFlag = AccountCapitalObjectCode.BOTH_NONCAP;
        List sAccountingLines = accountingDocument.getSourceAccountingLines();
        for (SourceAccountingLine sourceAccountingLine : sAccountingLines) {
            String objectSubTypeCode;
            ObjectCode objectCode = sourceAccountingLine.getObjectCode();
            if (!ObjectUtils.isNotNull((Object)objectCode) || !financialProcessingCapitalObjectSubTypes.contains(objectSubTypeCode = objectCode.getFinancialObjectSubTypeCode())) continue;
            capitalAssetObjectSubTypeLinesFlag = AccountCapitalObjectCode.FROM_CAPITAL_TO_NONCAP;
            break;
        }
        List tAccountingLines = accountingDocument.getTargetAccountingLines();
        for (TargetAccountingLine targetAccountingLine : tAccountingLines) {
            String objectSubTypeCode;
            ObjectCode objectCode = targetAccountingLine.getObjectCode();
            if (!ObjectUtils.isNotNull((Object)objectCode) || !financialProcessingCapitalObjectSubTypes.contains(objectSubTypeCode = objectCode.getFinancialObjectSubTypeCode())) continue;
            capitalAssetObjectSubTypeLinesFlag = capitalAssetObjectSubTypeLinesFlag == AccountCapitalObjectCode.FROM_CAPITAL_TO_NONCAP ? AccountCapitalObjectCode.BOTH_CAPITAL : AccountCapitalObjectCode.FROM_NONCAP_TO_CAPITAL;
            break;
        }
        return capitalAssetObjectSubTypeLinesFlag;
    }

    public boolean hasCapitalAssetObjectSubType(AccountingDocument accountingDocument) {
        AccountCapitalObjectCode accountCapitalObjectCode = this.getCapitalAssetObjectSubTypeLinesFlag(accountingDocument);
        return accountCapitalObjectCode != null && !accountCapitalObjectCode.equals((Object)AccountCapitalObjectCode.BOTH_NONCAP);
    }

    public boolean hasCapitalAssetObjectSubType(AccountingLine accountingLine) {
        Collection financialProcessingCapitalObjectSubTypes = this.getParameterService().getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSETS_DOCUMENT.class, "FINANCIAL_PROCESSING_CAPITAL_OBJECT_SUB_TYPES");
        ObjectCode objectCode = accountingLine.getObjectCode();
        if (ObjectUtils.isNotNull((Object)objectCode)) {
            return financialProcessingCapitalObjectSubTypes.contains(objectCode.getFinancialObjectSubTypeCode());
        }
        return false;
    }

    protected boolean isNewAssetBlank(CapitalAssetInformation capitalAssetInformation) {
        boolean isBlank = true;
        boolean createAsset = StringUtils.equalsIgnoreCase((CharSequence)capitalAssetInformation.getCapitalAssetActionIndicator(), (CharSequence)"C");
        if (createAsset && (ObjectUtils.isNotNull((Object)capitalAssetInformation.getCapitalAssetTypeCode()) || ObjectUtils.isNotNull((Object)capitalAssetInformation.getVendorName()) || ObjectUtils.isNotNull((Object)capitalAssetInformation.getCapitalAssetQuantity()) && capitalAssetInformation.getCapitalAssetQuantity() > 0 || ObjectUtils.isNotNull((Object)capitalAssetInformation.getCapitalAssetManufacturerName()) || ObjectUtils.isNotNull((Object)capitalAssetInformation.getCapitalAssetManufacturerModelNumber()) || ObjectUtils.isNotNull((Object)capitalAssetInformation.getCapitalAssetDescription()))) {
            isBlank = false;
        }
        return isBlank;
    }

    protected boolean isUpdateAssetBlank(CapitalAssetInformation capitalAssetInformation) {
        boolean isBlank = true;
        boolean updateAsset = StringUtils.equalsIgnoreCase((CharSequence)capitalAssetInformation.getCapitalAssetActionIndicator(), (CharSequence)"M");
        if (updateAsset && ObjectUtils.isNotNull((Object)capitalAssetInformation.getCapitalAssetNumber())) {
            isBlank = false;
        }
        return isBlank;
    }

    protected boolean validateUpdateCapitalAssetField(CapitalAssetInformation capitalAssetInformation, AccountingDocument accountingDocument, int index) {
        boolean valid = true;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("capitalAssetNumber", capitalAssetInformation.getCapitalAssetNumber().toString());
        Asset asset = (Asset)this.businessObjectService.findByPrimaryKey(Asset.class, params);
        ArrayList<Long> assetNumbers = new ArrayList<Long>();
        assetNumbers.add(capitalAssetInformation.getCapitalAssetNumber());
        MessageMap errors = GlobalVariables.getMessageMap();
        errors.removeFromErrorPath("capitalAssetInformation[" + index + "].");
        errors.removeFromErrorPath(capitalAssetInformation.getCapitalAssetActionIndicator().equalsIgnoreCase("C") ? "capitalAssetInformation" : "capitalAssetModify");
        errors.removeFromErrorPath("document");
        String errorPathPrefix = "document.capitalAssetInformation[" + index + "].capitalAssetNumber";
        if (ObjectUtils.isNull((Object)((Object)asset))) {
            valid = false;
            String label = this.getDataDictionaryService().getAttributeLabel(CapitalAssetInformation.class, "capitalAssetNumber");
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(errorPathPrefix, "error.existence", new String[]{label});
        } else if (!this.getAssetService().isCapitalAsset(asset) || this.getAssetService().isAssetRetired(asset)) {
            valid = false;
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(errorPathPrefix, "error.asset.active.capital.asset.required", new String[0]);
        } else {
            String documentNumber = accountingDocument.getDocumentNumber();
            String documentType = this.getDocumentTypeName(accountingDocument);
            if (this.isFpDocumentEligibleForAssetLock(accountingDocument, documentType) && this.isAssetLocked(assetNumbers, documentType, documentNumber)) {
                valid = false;
            }
        }
        return valid;
    }

    protected boolean checkNewCapitalAssetFieldsExist(CapitalAssetInformation capitalAssetInformation, AccountingDocument accountingDocument, int caLineIndex) {
        String label;
        String manufacturerNameRequired;
        String vendorNameRequired;
        String label2;
        boolean valid = true;
        if (StringUtils.isBlank((CharSequence)capitalAssetInformation.getCapitalAssetTypeCode())) {
            label2 = this.getDataDictionaryService().getAttributeLabel(CapitalAssetInformation.class, "capitalAssetTypeCode");
            GlobalVariables.getMessageMap().putError("capitalAssetTypeCode", "error.required", new String[]{label2});
            valid = false;
        }
        if (capitalAssetInformation.getCapitalAssetQuantity() == null || capitalAssetInformation.getCapitalAssetQuantity() <= 0) {
            label2 = this.getDataDictionaryService().getAttributeLabel(CapitalAssetInformation.class, "capitalAssetQuantity");
            GlobalVariables.getMessageMap().putError("capitalAssetQuantity", "error.required", new String[]{label2});
            valid = false;
        }
        if ("Y".equalsIgnoreCase(vendorNameRequired = this.getParameterService().getParameterValueAsString(Asset.class, "VENDOR_REQUIRED_FOR_NON_MOVEABLE_ASSET_IND")) && !(accountingDocument instanceof ProcurementCardDocument) && StringUtils.isBlank((CharSequence)capitalAssetInformation.getVendorName())) {
            String label3 = this.getDataDictionaryService().getAttributeLabel(CapitalAssetInformation.class, "vendorName");
            GlobalVariables.getMessageMap().putError("vendorName", "error.required", new String[]{label3});
            valid = false;
        }
        if ("Y".equalsIgnoreCase(manufacturerNameRequired = this.getParameterService().getParameterValueAsString(Asset.class, "MANUFACTURER_REQUIRED_FOR_NON_MOVEABLE_ASSET_IND")) && StringUtils.isBlank((CharSequence)capitalAssetInformation.getCapitalAssetManufacturerName())) {
            label = this.getDataDictionaryService().getAttributeLabel(CapitalAssetInformation.class, "capitalAssetManufacturerName");
            GlobalVariables.getMessageMap().putError("capitalAssetManufacturerName", "error.required", new String[]{label});
            valid = false;
        }
        if (StringUtils.isBlank((CharSequence)capitalAssetInformation.getCapitalAssetDescription())) {
            label = this.getDataDictionaryService().getAttributeLabel(CapitalAssetInformation.class, "capitalAssetDescription");
            GlobalVariables.getMessageMap().putError("capitalAssetDescription", "error.required", new String[]{label});
            valid = false;
        }
        int index = 0;
        List capitalAssetInformationDetails = capitalAssetInformation.getCapitalAssetInformationDetails();
        for (CapitalAssetInformationDetail dtl : capitalAssetInformationDetails) {
            String label4;
            AssetType assetType;
            String errorPathPrefix = "document.capitalAssetInformation[" + caLineIndex + "].capitalAssetInformationDetails";
            if (StringUtils.isBlank((CharSequence)dtl.getCampusCode())) {
                String label5 = this.getDataDictionaryService().getAttributeLabel(Campus.class, "campusCode");
                GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(errorPathPrefix + "[" + index + "].campusCode", "error.required", new String[]{label5});
                valid = false;
            }
            if ((ObjectUtils.isNull((Object)((Object)(assetType = this.getAssetType(capitalAssetInformation.getCapitalAssetTypeCode())))) || assetType.isMovingIndicator() || assetType.isRequiredBuildingIndicator()) && StringUtils.isBlank((CharSequence)dtl.getBuildingCode())) {
                label4 = this.getDataDictionaryService().getAttributeLabel(Building.class, "buildingCode");
                GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(errorPathPrefix + "[" + index + "].buildingCode", "error.required", new String[]{label4});
                valid = false;
            }
            if ((ObjectUtils.isNull((Object)((Object)assetType)) || assetType.isMovingIndicator()) && StringUtils.isBlank((CharSequence)dtl.getBuildingRoomNumber())) {
                label4 = this.getDataDictionaryService().getAttributeLabel(Room.class, "buildingRoomNumber");
                GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(errorPathPrefix + "[" + index + "].buildingRoomNumber", "error.required", new String[]{label4});
                valid = false;
            }
            ++index;
        }
        return valid;
    }

    protected boolean validateNewCapitalAssetFields(CapitalAssetInformation capitalAssetInformation, int index, AccountingDocument accountingDocument) {
        boolean valid = true;
        if (!this.isAssetTypeExisting(capitalAssetInformation.getCapitalAssetTypeCode())) {
            valid = false;
            String label = this.getDataDictionaryService().getAttributeLabel(CapitalAssetInformation.class, "capitalAssetTypeCode");
            GlobalVariables.getMessageMap().putError("capitalAssetTypeCode", "error.existence", new String[]{label});
        }
        if (valid &= this.validateTotalNumberOfAssetTagLines(capitalAssetInformation)) {
            valid = this.validateAssetTagLocationLines(capitalAssetInformation, index, accountingDocument);
        }
        return valid;
    }

    public boolean validateAssetTags(AccountingDocument accountingDocument) {
        boolean valid = true;
        ArrayList<TagRecord> allTags = new ArrayList<TagRecord>();
        CapitalAssetEditable capitalAssetEditable = (CapitalAssetEditable)accountingDocument;
        List capitalAssets = capitalAssetEditable.getCapitalAssetInformation();
        int indexCapital = 0;
        for (CapitalAssetInformation capitalAsset : capitalAssets) {
            if ("C".equals(capitalAsset.getCapitalAssetActionIndicator())) {
                List capitalAssetInformationDetails = capitalAsset.getCapitalAssetInformationDetails();
                int index = 0;
                for (CapitalAssetInformationDetail dtl : capitalAssetInformationDetails) {
                    String errorPathPrefix;
                    dtl.refreshReferenceObject("building");
                    if (ObjectUtils.isNotNull((Object)dtl.getBuilding()) && !dtl.getBuilding().isActive()) {
                        errorPathPrefix = "document.capitalAssetInformation[" + indexCapital + "].capitalAssetInformationDetails";
                        GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(errorPathPrefix + "[" + index + "].buildingCode", "error.document.capitalAssetDetail.inactive.building.notAllowed", new String[]{dtl.getBuildingCode()});
                        valid = false;
                    }
                    dtl.refreshReferenceObject("room");
                    if (ObjectUtils.isNotNull((Object)dtl.getRoom()) && !dtl.getRoom().isActive()) {
                        errorPathPrefix = "document.capitalAssetInformation[" + indexCapital + "].capitalAssetInformationDetails";
                        GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(errorPathPrefix + "[" + index + "].buildingRoomNumber", "error.document.capitalAssetDetail.inactive.room.notAllowed", new String[]{dtl.getBuildingRoomNumber()});
                        valid = false;
                    }
                    ++index;
                    this.businessObjectDictionaryService.performForceUppercase((BusinessObject)dtl);
                    if (!StringUtils.isNotBlank((CharSequence)dtl.getCapitalAssetTagNumber()) || dtl.getCapitalAssetTagNumber().equalsIgnoreCase("N")) continue;
                    allTags.add(new TagRecord(dtl.getCapitalAssetTagNumber(), capitalAsset.getCapitalAssetLineNumber(), dtl.getCapitalAssetLineNumber(), dtl.getItemLineNumber()));
                }
            }
            ++indexCapital;
        }
        for (TagRecord tagRecord : allTags) {
            if (!this.isTagDuplicated(allTags, tagRecord)) continue;
            tagRecord.setDuplicate(true);
            valid = false;
        }
        for (TagRecord tagRecord : allTags) {
            if (!tagRecord.isDuplicate()) continue;
            int indexAsset = 0;
            for (CapitalAssetInformation capitalAsset : capitalAssets) {
                if ("C".equals(capitalAsset.getCapitalAssetActionIndicator())) {
                    List capitalAssetInformationDetails = capitalAsset.getCapitalAssetInformationDetails();
                    int index = 0;
                    for (CapitalAssetInformationDetail dtl : capitalAssetInformationDetails) {
                        if (StringUtils.equals((CharSequence)dtl.getCapitalAssetTagNumber(), (CharSequence)tagRecord.getTagNumber())) {
                            String errorPathPrefix = "document.capitalAssetInformation[" + indexAsset + "].capitalAssetInformationDetails";
                            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(errorPathPrefix + "[" + index + "].capitalAssetTagNumber", "error.asset.campus.tag.number.duplicate", new String[]{tagRecord.getTagNumber()});
                        }
                        ++index;
                    }
                }
                ++indexAsset;
            }
        }
        return valid;
    }

    protected boolean isTagDuplicated(List<TagRecord> allTags, TagRecord tagRecord) {
        if (!this.getAssetService().findActiveAssetsMatchingTagNumber(tagRecord.getTagNumber()).isEmpty()) {
            return true;
        }
        int duplicateCount = 0;
        for (TagRecord checkTagRecord : allTags) {
            if (!checkTagRecord.getTagNumber().equals(tagRecord.getTagNumber())) continue;
            ++duplicateCount;
        }
        if (duplicateCount > 1) {
            tagRecord.setDuplicate(true);
            return true;
        }
        return false;
    }

    protected boolean validateAssetTagLocationLines(CapitalAssetInformation capitalAssetInformation, int capitalAssetIndex, AccountingDocument accountingDocument) {
        boolean valid = true;
        List capitalAssetInformationDetails = capitalAssetInformation.getCapitalAssetInformationDetails();
        int index = 0;
        for (CapitalAssetInformationDetail dtl : capitalAssetInformationDetails) {
            String label;
            HashMap<String, String> params;
            this.businessObjectDictionaryService.performForceUppercase((BusinessObject)dtl);
            String errorPathPrefix = "document.capitalAssetInformation[" + capitalAssetIndex + "].capitalAssetInformationDetails";
            Campus campus = (Campus)this.businessObjectService.findBySinglePrimaryKey(Campus.class, (Object)dtl.getCampusCode());
            if (ObjectUtils.isNull((Object)campus)) {
                valid = false;
                String label2 = this.getDataDictionaryService().getAttributeLabel(Campus.class, "campusCode");
                GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(errorPathPrefix + "[" + index + "].campusCode", "error.existence", new String[]{label2});
            }
            if (StringUtils.isNotBlank((CharSequence)dtl.getCampusCode()) && StringUtils.isNotBlank((CharSequence)dtl.getBuildingCode())) {
                params = new HashMap<String, String>();
                params.put("campusCode", dtl.getCampusCode());
                params.put("buildingCode", dtl.getBuildingCode());
                Building building = (Building)this.businessObjectService.findByPrimaryKey(Building.class, params);
                if (ObjectUtils.isNull((Object)building)) {
                    valid = false;
                    GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(errorPathPrefix + "[" + index + "].buildingCode", "error.asset.location.invalid.building.code", new String[]{dtl.getBuildingCode(), dtl.getCampusCode()});
                }
            }
            AssetType assetType = this.getAssetType(capitalAssetInformation.getCapitalAssetTypeCode());
            if (StringUtils.isNotBlank((CharSequence)dtl.getBuildingCode()) && ObjectUtils.isNotNull((Object)((Object)assetType)) && !assetType.isMovingIndicator() && !assetType.isRequiredBuildingIndicator()) {
                valid = false;
                label = this.getDataDictionaryService().getAttributeLabel(Building.class, "buildingCode");
                GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(errorPathPrefix + "[" + index + "].buildingCode", "error.asset.location.building.number.non.movable", new String[]{label});
            }
            if (StringUtils.isNotBlank((CharSequence)dtl.getCampusCode()) && StringUtils.isNotBlank((CharSequence)dtl.getBuildingCode()) && StringUtils.isNotBlank((CharSequence)dtl.getBuildingRoomNumber())) {
                params = new HashMap();
                params.put("campusCode", dtl.getCampusCode());
                params.put("buildingCode", dtl.getBuildingCode());
                params.put("buildingRoomNumber", dtl.getBuildingRoomNumber());
                Room room = (Room)this.businessObjectService.findByPrimaryKey(Room.class, params);
                if (ObjectUtils.isNull((Object)room)) {
                    valid = false;
                    GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(errorPathPrefix + "[" + index + "].buildingRoomNumber", "error.asset.location.invalid.room.code", new String[]{dtl.getBuildingRoomNumber(), dtl.getBuildingCode(), dtl.getCampusCode()});
                }
            }
            if (StringUtils.isNotBlank((CharSequence)dtl.getBuildingRoomNumber()) && ObjectUtils.isNotNull((Object)((Object)assetType)) && !assetType.isMovingIndicator()) {
                valid = false;
                label = this.getDataDictionaryService().getAttributeLabel(Room.class, "buildingRoomNumber");
                GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(errorPathPrefix + "[" + index + "].buildingRoomNumber", "error.asset.location.room.number.non.movable", new String[]{label});
            }
            ++index;
        }
        return valid;
    }

    public boolean isAssetTypeExisting(String assetTypeCode) {
        AssetType assetType = this.getAssetType(assetTypeCode);
        return ObjectUtils.isNotNull((Object)((Object)assetType));
    }

    protected AssetType getAssetType(String assetTypeCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("capitalAssetTypeCode", assetTypeCode);
        return (AssetType)this.businessObjectService.findByPrimaryKey(AssetType.class, params);
    }

    protected boolean validateTotalNumberOfAssetTagLines(CapitalAssetInformation capitalAssetInformation) {
        boolean valid = true;
        Integer userInputAssetQuantity = capitalAssetInformation.getCapitalAssetQuantity();
        if (userInputAssetQuantity != null && (ObjectUtils.isNull((Object)capitalAssetInformation.getCapitalAssetInformationDetails()) || capitalAssetInformation.getCapitalAssetInformationDetails().isEmpty())) {
            GlobalVariables.getMessageMap().putError("capitalAssetQuantity", "error.asset.tag.line.required", new String[0]);
            valid = false;
        } else if (userInputAssetQuantity != null && userInputAssetQuantity.intValue() != capitalAssetInformation.getCapitalAssetInformationDetails().size()) {
            GlobalVariables.getMessageMap().putError("capitalAssetQuantity", "error.asset.quantity.not.matching.tag.lines", new String[0]);
            valid = false;
        }
        return valid;
    }

    protected boolean isTagNumberDuplicate(List<CapitalAssetInformationDetail> capitalAssetInformationDetails, CapitalAssetInformationDetail dtl) {
        boolean duplicateTag = false;
        int tagCounter = 0;
        if (!this.getAssetService().findActiveAssetsMatchingTagNumber(dtl.getCapitalAssetTagNumber()).isEmpty()) {
            duplicateTag = true;
        } else {
            for (CapitalAssetInformationDetail capitalAssetInfoDetl : capitalAssetInformationDetails) {
                if (!capitalAssetInfoDetl.getCapitalAssetTagNumber().equalsIgnoreCase(dtl.getCapitalAssetTagNumber())) continue;
                ++tagCounter;
            }
            if (tagCounter > 1) {
                duplicateTag = true;
            }
        }
        return duplicateTag;
    }

    public void notifyRouteStatusChange(DocumentHeader documentHeader) {
        WorkflowDocument workflowDocument = documentHeader.getWorkflowDocument();
        String documentNumber = documentHeader.getDocumentNumber();
        String documentType = workflowDocument.getDocumentTypeName();
        if (workflowDocument.isCanceled() || workflowDocument.isDisapproved()) {
            this.activateCabPOLines(documentNumber);
            this.activateCabGlLines(documentNumber);
        }
        if (workflowDocument.isProcessed()) {
            this.updatePOLinesStatusAsProcessed(documentNumber);
            this.updateGlLinesStatusAsProcessed(documentNumber);
            Integer poId = this.getPurchaseOrderIdentifier(documentNumber);
            if (poId != null) {
                List<Long> assetNumbers = null;
                if ("AA".equalsIgnoreCase(documentType)) {
                    assetNumbers = this.getAssetNumbersFromAssetGlobal(documentNumber);
                } else if ("MPAY".equalsIgnoreCase(documentType)) {
                    assetNumbers = this.getAssetNumbersFromAssetPayment(documentNumber);
                }
                if (!assetNumbers.isEmpty()) {
                    String noteText = this.buildNoteTextForPurApDoc(documentType, assetNumbers);
                    this.purchasingAccountsPayableModuleService.addAssignedAssetNumbers(poId, workflowDocument.getInitiatorPrincipalId(), noteText);
                }
            }
        }
    }

    protected void updateGlLinesStatusAsProcessed(String documentNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("capitalAssetManagementDocumentNumber", documentNumber);
        Collection matchingGlAssets = this.businessObjectService.findMatching(GeneralLedgerEntryAsset.class, fieldValues);
        if (matchingGlAssets != null && !matchingGlAssets.isEmpty()) {
            for (GeneralLedgerEntryAsset generalLedgerEntryAsset : matchingGlAssets) {
                GeneralLedgerEntry generalLedgerEntry = generalLedgerEntryAsset.getGeneralLedgerEntry();
                if (generalLedgerEntry.getTransactionLedgerEntryAmount().compareTo((AbstractKualiDecimal)generalLedgerEntry.getTransactionLedgerSubmitAmount()) == 0) {
                    generalLedgerEntry.setActivityStatusCode("P");
                    this.businessObjectService.save((PersistableBusinessObject)generalLedgerEntry);
                }
                if (this.isFpDocumentFullyProcessed(generalLedgerEntry)) {
                    this.deleteAssetLocks(generalLedgerEntry.getDocumentNumber(), null);
                    continue;
                }
                this.deleteAssetLocks(generalLedgerEntry.getDocumentNumber(), generalLedgerEntryAsset.getCapitalAssetBuilderLineNumber() == null ? "-1" : generalLedgerEntryAsset.getCapitalAssetBuilderLineNumber().toString());
            }
        }
    }

    protected boolean isFpDocumentFullyProcessed(GeneralLedgerEntry generalLedgerEntry) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("documentNumber", generalLedgerEntry.getDocumentNumber());
        Collection matchingGlEntries = this.businessObjectService.findMatching(GeneralLedgerEntry.class, fieldValues);
        for (GeneralLedgerEntry glEntry : matchingGlEntries) {
            if ("P".equals(glEntry.getActivityStatusCode())) continue;
            return false;
        }
        return true;
    }

    protected void updatePOLinesStatusAsProcessed(String documentNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("capitalAssetManagementDocumentNumber", documentNumber);
        Collection matchingAssets = this.businessObjectService.findMatching(PurchasingAccountsPayableItemAsset.class, fieldValues);
        if (matchingAssets != null && !matchingAssets.isEmpty()) {
            for (PurchasingAccountsPayableItemAsset itemAsset : matchingAssets) {
                itemAsset.setActivityStatusCode("P");
                for (PurchasingAccountsPayableLineAssetAccount assetAccount : itemAsset.getPurchasingAccountsPayableLineAssetAccounts()) {
                    assetAccount.setActivityStatusCode("P");
                    GeneralLedgerEntry generalLedgerEntry = assetAccount.getGeneralLedgerEntry();
                    if (!this.isGlEntryFullyProcessed(generalLedgerEntry)) continue;
                    generalLedgerEntry.setActivityStatusCode("P");
                    this.businessObjectService.save((PersistableBusinessObject)generalLedgerEntry);
                }
                PurchasingAccountsPayableDocument purapDocument = itemAsset.getPurchasingAccountsPayableDocument();
                if (this.isDocumentFullyProcessed(purapDocument)) {
                    purapDocument.setActivityStatusCode("P");
                }
                this.businessObjectService.save((PersistableBusinessObject)purapDocument);
                String lockingInformation = null;
                PurchaseOrderDocument poDocument = this.getPurApInfoService().getCurrentDocumentForPurchaseOrderIdentifier(purapDocument.getPurchaseOrderIdentifier());
                if ("IND".equalsIgnoreCase(poDocument.getCapitalAssetSystemTypeCode())) {
                    lockingInformation = itemAsset.getAccountsPayableLineItemIdentifier().toString();
                }
                if (!this.isAccountsPayableItemLineFullyProcessed(purapDocument, lockingInformation)) continue;
                this.deleteAssetLocks(purapDocument.getDocumentNumber(), lockingInformation);
            }
        }
    }

    protected boolean isAccountsPayableItemLineFullyProcessed(PurchasingAccountsPayableDocument purapDocument, String lockingInformation) {
        for (PurchasingAccountsPayableItemAsset item : purapDocument.getPurchasingAccountsPayableItemAssets()) {
            if ((!StringUtils.isBlank((CharSequence)lockingInformation) || "P".equals(item.getActivityStatusCode())) && (!StringUtils.isNotBlank((CharSequence)lockingInformation) || !item.getAccountsPayableLineItemIdentifier().equals(lockingInformation) || "P".equals(item.getActivityStatusCode()))) continue;
            return false;
        }
        return true;
    }

    protected boolean isGlEntryFullyProcessed(GeneralLedgerEntry glEntry) {
        for (PurchasingAccountsPayableLineAssetAccount account : glEntry.getPurApLineAssetAccounts()) {
            if ("P".equalsIgnoreCase(account.getActivityStatusCode())) continue;
            return false;
        }
        return true;
    }

    protected boolean isDocumentFullyProcessed(PurchasingAccountsPayableDocument purapDocument) {
        for (PurchasingAccountsPayableItemAsset item : purapDocument.getPurchasingAccountsPayableItemAssets()) {
            if ("P".equalsIgnoreCase(item.getActivityStatusCode())) continue;
            return false;
        }
        return true;
    }

    protected String buildNoteTextForPurApDoc(String documentType, List<Long> assetNumbers) {
        StringBuffer noteText = new StringBuffer();
        if ("AA".equalsIgnoreCase(documentType)) {
            noteText.append("Asset Numbers have been created for this document: ");
        } else {
            noteText.append("Existing Asset Numbers have been applied for this document: ");
        }
        if (assetNumbers != null || assetNumbers.size() > 0) {
            noteText.append(assetNumbers.get(0).toString());
            if (assetNumbers.size() > 1) {
                noteText.append(",....,");
                noteText.append(assetNumbers.get(assetNumbers.size() - 1).toString());
            }
        }
        return noteText.toString();
    }

    protected List<Long> getAssetNumbersFromAssetGlobal(String documentNumber) {
        ArrayList<Long> assetNumbers = new ArrayList<Long>();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("documentNumber", documentNumber);
        Collection assetGlobalDetails = this.businessObjectService.findMatching(AssetGlobalDetail.class, fieldValues);
        for (AssetGlobalDetail detail : assetGlobalDetails) {
            assetNumbers.add(detail.getCapitalAssetNumber());
        }
        return assetNumbers;
    }

    protected List<Long> getAssetNumbersFromAssetPayment(String documentNumber) {
        ArrayList<Long> assetNumbers = new ArrayList<Long>();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("documentNumber", documentNumber);
        Collection paymentAssetDetails = this.businessObjectService.findMatching(AssetPaymentAssetDetail.class, fieldValues);
        for (AssetPaymentAssetDetail detail : paymentAssetDetails) {
            if (!ObjectUtils.isNotNull((Object)((Object)detail.getAsset()))) continue;
            assetNumbers.add(detail.getCapitalAssetNumber());
        }
        return assetNumbers;
    }

    protected Integer getPurchaseOrderIdentifier(String camsDocumentNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("capitalAssetManagementDocumentNumber", camsDocumentNumber);
        Collection matchingItems = this.businessObjectService.findMatching(PurchasingAccountsPayableItemAsset.class, fieldValues);
        Iterator iterator = matchingItems.iterator();
        if (iterator.hasNext()) {
            PurchasingAccountsPayableItemAsset item = (PurchasingAccountsPayableItemAsset)iterator.next();
            if (ObjectUtils.isNull((Object)((Object)item.getPurchasingAccountsPayableDocument()))) {
                item.refreshReferenceObject("purchasingAccountsPayableDocument");
            }
            return item.getPurchasingAccountsPayableDocument().getPurchaseOrderIdentifier();
        }
        return null;
    }

    public String getCurrentPurchaseOrderDocumentNumber(String camsDocumentNumber) {
        PurchaseOrderDocument poDocument;
        Integer poId = this.getPurchaseOrderIdentifier(camsDocumentNumber);
        if (poId != null && ObjectUtils.isNotNull((Object)(poDocument = this.getPurApInfoService().getCurrentDocumentForPurchaseOrderIdentifier(poId)))) {
            return poDocument.getDocumentNumber();
        }
        return null;
    }

    protected void activateCabGlLines(String documentNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("capitalAssetManagementDocumentNumber", documentNumber);
        Collection matchingGlAssets = this.getBusinessObjectService().findMatching(GeneralLedgerEntryAsset.class, fieldValues);
        if (matchingGlAssets != null && !matchingGlAssets.isEmpty()) {
            Integer capitalAssetLineNumber = 0;
            GeneralLedgerEntry generalLedgerEntry = new GeneralLedgerEntry();
            Iterator iterator = matchingGlAssets.iterator();
            if (iterator.hasNext()) {
                GeneralLedgerEntryAsset generalLedgerEntryAsset = (GeneralLedgerEntryAsset)((Object)iterator.next());
                capitalAssetLineNumber = generalLedgerEntryAsset.getCapitalAssetBuilderLineNumber();
                generalLedgerEntry = generalLedgerEntryAsset.getGeneralLedgerEntry();
            }
            CapitalAssetInformation capitalAssetInformation = this.glLineService.findCapitalAssetInformation(generalLedgerEntry.getDocumentNumber(), capitalAssetLineNumber);
            List groupAccountingLines = capitalAssetInformation.getCapitalAssetAccountsGroupDetails();
            Collection<GeneralLedgerEntry> documentGlEntries = this.glLineService.findAllGeneralLedgerEntry(generalLedgerEntry.getDocumentNumber());
            for (CapitalAssetAccountsGroupDetails accountingLine : groupAccountingLines) {
                Collection<GeneralLedgerEntry> glEntries = this.glLineService.findMatchingGeneralLedgerEntries(documentGlEntries, accountingLine);
                for (GeneralLedgerEntry glEntry : glEntries) {
                    this.reduceTransactionSumbitGlEntryAmount(glEntry, accountingLine.getAmount());
                }
            }
            capitalAssetInformation.setCapitalAssetProcessedIndicator(false);
            this.getBusinessObjectService().save((PersistableBusinessObject)capitalAssetInformation);
            this.resetTransactionSumbitGlEntryAmounts(generalLedgerEntry);
        }
        this.getBusinessObjectService().delete(new ArrayList(matchingGlAssets));
    }

    protected void reduceTransactionSumbitGlEntryAmount(GeneralLedgerEntry matchingGLEntry, KualiDecimal accountLineAmount) {
        KualiDecimal submitTotalAmount = KualiDecimal.ZERO;
        if (ObjectUtils.isNotNull((Object)matchingGLEntry.getTransactionLedgerSubmitAmount())) {
            submitTotalAmount = matchingGLEntry.getTransactionLedgerSubmitAmount();
        }
        matchingGLEntry.setTransactionLedgerSubmitAmount((KualiDecimal)submitTotalAmount.subtract((AbstractKualiDecimal)((KualiDecimal)accountLineAmount.abs())));
        if (matchingGLEntry.getTransactionLedgerSubmitAmount().isLessThan((AbstractKualiDecimal)matchingGLEntry.getTransactionLedgerEntryAmount())) {
            matchingGLEntry.setActivityStatusCode("N");
        }
        this.businessObjectService.save((PersistableBusinessObject)matchingGLEntry);
    }

    protected boolean resetTransactionSumbitGlEntryAmounts(GeneralLedgerEntry glEntry) {
        List<CapitalAssetInformation> capitalAssets = this.glLineService.findAllCapitalAssetInformation(glEntry.getDocumentNumber());
        for (CapitalAssetInformation capitalAsset : capitalAssets) {
            if (!capitalAsset.isCapitalAssetProcessedIndicator()) continue;
            return false;
        }
        Collection<GeneralLedgerEntry> glLines = this.glLineService.findAllGeneralLedgerEntry(glEntry.getDocumentNumber());
        for (GeneralLedgerEntry glLine : glLines) {
            glLine.setTransactionLedgerSubmitAmount(KualiDecimal.ZERO);
            glLine.setActivityStatusCode("N");
        }
        this.getBusinessObjectService().save(new ArrayList<GeneralLedgerEntry>(glLines));
        return true;
    }

    protected void activateCabPOLines(String documentNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("capitalAssetManagementDocumentNumber", documentNumber);
        Collection matchingPoAssets = this.businessObjectService.findMatching(PurchasingAccountsPayableItemAsset.class, fieldValues);
        if (matchingPoAssets != null && !matchingPoAssets.isEmpty()) {
            for (PurchasingAccountsPayableItemAsset itemAsset : matchingPoAssets) {
                PurchasingAccountsPayableDocument purapDocument = itemAsset.getPurchasingAccountsPayableDocument();
                purapDocument.setActivityStatusCode("M");
                this.businessObjectService.save((PersistableBusinessObject)purapDocument);
                itemAsset.setActivityStatusCode("M");
                this.businessObjectService.save((PersistableBusinessObject)itemAsset);
                List<PurchasingAccountsPayableLineAssetAccount> lineAssetAccounts = itemAsset.getPurchasingAccountsPayableLineAssetAccounts();
                for (PurchasingAccountsPayableLineAssetAccount assetAccount : lineAssetAccounts) {
                    assetAccount.setActivityStatusCode("M");
                    this.businessObjectService.save((PersistableBusinessObject)assetAccount);
                    GeneralLedgerEntry generalLedgerEntry = assetAccount.getGeneralLedgerEntry();
                    KualiDecimal submitAmount = generalLedgerEntry.getTransactionLedgerSubmitAmount();
                    if (submitAmount == null) {
                        submitAmount = KualiDecimal.ZERO;
                    }
                    submitAmount = (KualiDecimal)submitAmount.subtract((AbstractKualiDecimal)assetAccount.getItemAccountTotalAmount());
                    generalLedgerEntry.setTransactionLedgerSubmitAmount(submitAmount);
                    generalLedgerEntry.setActivityStatusCode("M");
                    this.businessObjectService.save((PersistableBusinessObject)generalLedgerEntry);
                }
            }
        }
    }

    protected String getDocumentTypeName(AccountingDocument accountingDocument) {
        String documentTypeName;
        if (accountingDocument instanceof YearEndGeneralErrorCorrectionDocument) {
            documentTypeName = "YEGE";
        } else if (accountingDocument instanceof YearEndDistributionOfIncomeAndExpenseDocument) {
            documentTypeName = "YEDI";
        } else if (accountingDocument instanceof ServiceBillingDocument) {
            documentTypeName = "SB";
        } else if (accountingDocument instanceof GeneralErrorCorrectionDocument) {
            documentTypeName = "GEC";
        } else if (accountingDocument instanceof CashReceiptDocument) {
            documentTypeName = "CR";
        } else if (accountingDocument instanceof AdvanceDepositDocument) {
            documentTypeName = "AD";
        } else if (accountingDocument instanceof CreditCardReceiptDocument) {
            documentTypeName = "CCR";
        } else if (accountingDocument instanceof DistributionOfIncomeAndExpenseDocument) {
            documentTypeName = "DI";
        } else if (accountingDocument instanceof InternalBillingDocument) {
            documentTypeName = "IB";
        } else if (accountingDocument instanceof ProcurementCardDocument) {
            documentTypeName = "PCDO";
        } else if (accountingDocument instanceof IntraAccountAdjustmentDocument) {
            documentTypeName = "IAA";
        } else if (accountingDocument instanceof GeneralLedgerTransferDocument) {
            documentTypeName = "GLT";
        } else {
            throw new RuntimeException("Invalid FP document type.");
        }
        return documentTypeName;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public boolean hasCAMSCapitalAssetObjectSubType(AccountingLine line) {
        Collection capitalObjectSubTypes = this.getParameterService().getParameterValuesAsString(AssetGlobal.class, "CAPITAL_OBJECT_SUB_TYPES");
        ObjectCode objectCode = line.getObjectCode();
        if (ObjectUtils.isNotNull((Object)objectCode)) {
            return capitalObjectSubTypes.contains(objectCode.getFinancialObjectSubTypeCode());
        }
        return false;
    }

    public boolean validateAllCapitalAccountingLinesProcessed(AccountingDocument accountingDocumentForValidation) {
        LOG.debug("validateCapitalAccountingLines - start");
        if (!(accountingDocumentForValidation instanceof CapitalAssetEditable)) {
            return true;
        }
        CapitalAccountingLinesDocumentBase capitalAccountingLinesDocumentBase = (CapitalAccountingLinesDocumentBase)accountingDocumentForValidation;
        List capitalAccountingLines = capitalAccountingLinesDocumentBase.getCapitalAccountingLines();
        boolean isValid = this.allCapitalAccountingLinesProcessed(capitalAccountingLines);
        return isValid;
    }

    protected boolean allCapitalAccountingLinesProcessed(List<CapitalAccountingLines> capitalAccountingLines) {
        LOG.debug("allCapitalAccountingLinesProcessed - start");
        boolean processed = true;
        for (CapitalAccountingLines capitalAccountingLine : capitalAccountingLines) {
            if (capitalAccountingLine.isSelectLine()) continue;
            processed = false;
            GlobalVariables.getMessageMap().putError("document.capitalAccountingLines*", "error.document.capitalAccountingLines.notProcessed", new String[0]);
            break;
        }
        return processed;
    }

    public boolean validateTotalAmountMatch(AccountingDocument accountingDocumentForValidation) {
        LOG.debug("validateTotalAmountMatch - start");
        if (!(accountingDocumentForValidation instanceof CapitalAssetEditable)) {
            return true;
        }
        CapitalAccountingLinesDocumentBase capitalAccountingLinesDocumentBase = (CapitalAccountingLinesDocumentBase)accountingDocumentForValidation;
        List capitalAccountingLines = capitalAccountingLinesDocumentBase.getCapitalAccountingLines();
        CapitalAssetEditable capitalAssetEditable = (CapitalAssetEditable)accountingDocumentForValidation;
        List capitalAssets = capitalAssetEditable.getCapitalAssetInformation();
        return this.totalAmountMatchForCapitalAccountingLinesAndCapitalAssets(capitalAccountingLines, capitalAssets);
    }

    protected boolean totalAmountMatchForCapitalAccountingLinesAndCapitalAssets(List<CapitalAccountingLines> capitalAccountingLines, List<CapitalAssetInformation> capitalAssets) {
        KualiDecimal capitalAccountingLinesTotals = KualiDecimal.ZERO;
        KualiDecimal capitalAAssetTotals = KualiDecimal.ZERO;
        for (CapitalAccountingLines capitalAccountingLine : capitalAccountingLines) {
            capitalAccountingLinesTotals = (KualiDecimal)capitalAccountingLinesTotals.add((AbstractKualiDecimal)capitalAccountingLine.getAmount());
        }
        for (CapitalAssetInformation capitalAsset : capitalAssets) {
            capitalAAssetTotals = (KualiDecimal)capitalAAssetTotals.add((AbstractKualiDecimal)capitalAsset.getCapitalAssetLineAmount());
        }
        if (capitalAccountingLinesTotals.isGreaterThan((AbstractKualiDecimal)capitalAAssetTotals)) {
            GlobalVariables.getMessageMap().putError("document.capitalAccountingLines*", "error.document.capitalAccountingLines.totalAmountNotDistributed", new String[0]);
            return false;
        }
        if (capitalAccountingLinesTotals.isLessThan((AbstractKualiDecimal)capitalAAssetTotals)) {
            GlobalVariables.getMessageMap().putError("document.capitalAccountingLines*", "error.document.capitalAccountingLines.moreTotalAmountDistributed", new String[0]);
            return false;
        }
        return true;
    }

    public boolean validateCapitlAssetsAmountToAccountingLineAmount(AccountingDocument accountingDocument) {
        boolean valid = true;
        CapitalAccountingLinesDocumentBase caldb = (CapitalAccountingLinesDocumentBase)accountingDocument;
        List capitalAccountingLines = caldb.getCapitalAccountingLines();
        List capitalAssetInformation = caldb.getCapitalAssetInformation();
        for (CapitalAccountingLines capitalAccountingLine : capitalAccountingLines) {
            if (!capitalAccountingLine.getAmount().isLessThan((AbstractKualiDecimal)this.getCapitalAccountingLineAmountAllocated(capitalAssetInformation, capitalAccountingLine))) continue;
            GlobalVariables.getMessageMap().putError("document.capitalAccountingLines*", "error.document.capitalAccountingLines.capitalAssetsAmountGreater", new String[]{capitalAccountingLine.getSequenceNumber().toString(), capitalAccountingLine.getLineType(), capitalAccountingLine.getChartOfAccountsCode(), capitalAccountingLine.getAccountNumber(), capitalAccountingLine.getFinancialObjectCode()});
            valid = false;
        }
        return valid;
    }

    protected KualiDecimal getCapitalAccountingLineAmountAllocated(List<CapitalAssetInformation> currentCapitalAssetInformation, CapitalAccountingLines capitalAccountingLine) {
        KualiDecimal capitalAccountingLineAmount = KualiDecimal.ZERO;
        for (CapitalAssetInformation capitalAsset : currentCapitalAssetInformation) {
            List groupAccountLines = capitalAsset.getCapitalAssetAccountsGroupDetails();
            for (CapitalAssetAccountsGroupDetails groupAccountLine : groupAccountLines) {
                if (groupAccountLine.getCapitalAssetLineNumber().compareTo(capitalAsset.getCapitalAssetLineNumber()) != 0 || groupAccountLine.getSequenceNumber().compareTo(capitalAccountingLine.getSequenceNumber()) != 0 || !groupAccountLine.getFinancialDocumentLineTypeCode().equals("Source".equals(capitalAccountingLine.getLineType()) ? "F" : "T") || !groupAccountLine.getChartOfAccountsCode().equals(capitalAccountingLine.getChartOfAccountsCode()) || !groupAccountLine.getAccountNumber().equals(capitalAccountingLine.getAccountNumber()) || !groupAccountLine.getFinancialObjectCode().equals(capitalAccountingLine.getFinancialObjectCode())) continue;
                capitalAccountingLineAmount = (KualiDecimal)capitalAccountingLineAmount.add((AbstractKualiDecimal)groupAccountLine.getAmount());
            }
        }
        return capitalAccountingLineAmount;
    }

    public boolean validateCapitalAccountingLines(AccountingDocument accountingDocumentForValidation) {
        LOG.debug("validateCapitalAccountingLines - start");
        if (!(accountingDocumentForValidation instanceof CapitalAssetEditable)) {
            return true;
        }
        CapitalAccountingLinesDocumentBase capitalAccountingLinesDocumentBase = (CapitalAccountingLinesDocumentBase)accountingDocumentForValidation;
        List capitalAccountingLines = capitalAccountingLinesDocumentBase.getCapitalAccountingLines();
        CapitalAssetEditable capitalAssetEditable = (CapitalAssetEditable)accountingDocumentForValidation;
        List capitalAssets = capitalAssetEditable.getCapitalAssetInformation();
        return this.capitalAssetExistsForCapitalAccountingLinesProcessed(capitalAccountingLines, capitalAssets);
    }

    public boolean isDocumentEligibleForCABBatch(String documentType) {
        boolean eligible = true;
        ArrayList excludedDocTypeCodes = new ArrayList(this.parameterService.getParameterValuesAsString(ExtractStep.class, "DOCUMENT_TYPES_EXCLUDED"));
        if (excludedDocTypeCodes.contains(documentType)) {
            eligible = false;
        }
        return eligible;
    }

    public List<String> getBatchIncludedObjectSubTypes() {
        return new ArrayList<String>(this.parameterService.getParameterValuesAsString(ExtractStep.class, "SUB_TYPES"));
    }

    public List<String> getBatchExcludedChartCodes() {
        return new ArrayList<String>(this.parameterService.getParameterValuesAsString(ExtractStep.class, "CHARTS_EXCLUDED"));
    }

    public List<String> getBatchExcludedSubFundCodes() {
        return new ArrayList<String>(this.parameterService.getParameterValuesAsString(ExtractStep.class, "SUB_FUNDS_EXCLUDED"));
    }

    public boolean isAssetLineEligibleForCABBatch(CapitalAssetInformation assetLine, Integer postingYear, List<String> includedFinancialObjectSubTypeCodes, List<String> excludedChartCodes, List<String> excludedSubFundCodes) {
        boolean eligible = true;
        List acctDetailLines = assetLine.getCapitalAssetAccountsGroupDetails();
        for (CapitalAssetAccountsGroupDetails detailLine : acctDetailLines) {
            eligible = true;
            ObjectCode objectCodeBO = this.retrieveFinancialObject(postingYear, detailLine);
            if (ObjectUtils.isNotNull((Object)objectCodeBO) && includedFinancialObjectSubTypeCodes != null && !includedFinancialObjectSubTypeCodes.contains(objectCodeBO.getFinancialObjectSubTypeCode())) {
                eligible = false;
            }
            if (eligible && excludedChartCodes != null && excludedChartCodes.contains(detailLine.getChartOfAccountsCode())) {
                eligible = false;
            }
            if (eligible && excludedSubFundCodes != null && ObjectUtils.isNotNull((Object)detailLine.getAccount()) && excludedSubFundCodes.contains(detailLine.getAccount().getSubFundGroupCode())) {
                eligible = false;
            }
            if (!eligible) continue;
            break;
        }
        return eligible;
    }

    protected ObjectCode retrieveFinancialObject(Integer postingYear, CapitalAssetAccountsGroupDetails acctDetailLine) {
        ObjectCode financialObject = null;
        if (ObjectUtils.isNotNull((Object)acctDetailLine)) {
            HashMap<String, Object> primaryKeys = new HashMap<String, Object>();
            primaryKeys.put("universityFiscalYear", postingYear);
            primaryKeys.put("chartOfAccountsCode", acctDetailLine.getChartOfAccountsCode());
            primaryKeys.put("financialObjectCode", acctDetailLine.getFinancialObjectCode());
            financialObject = (ObjectCode)this.businessObjectService.findByPrimaryKey(ObjectCode.class, primaryKeys);
        }
        return financialObject;
    }

    protected boolean capitalAssetExistsForCapitalAccountingLinesProcessed(List<CapitalAccountingLines> capitalAccountingLines, List<CapitalAssetInformation> capitalAssets) {
        LOG.debug("capitalAssetExistsForCapitalAccountingLinesProcessed - start");
        for (CapitalAccountingLines capitalAccountingLine : capitalAccountingLines) {
            if (this.capitalAssetExist(capitalAccountingLine, capitalAssets)) continue;
            GlobalVariables.getMessageMap().putError("document.capitalAccountingLines*", "error.document.capitalAccountingLines.capitalAssetsInformationMissing", new String[]{capitalAccountingLine.getSequenceNumber().toString(), capitalAccountingLine.getLineType(), capitalAccountingLine.getChartOfAccountsCode(), capitalAccountingLine.getAccountNumber(), capitalAccountingLine.getFinancialObjectCode()});
            return false;
        }
        return true;
    }

    protected boolean capitalAssetExist(CapitalAccountingLines capitalAccountingLine, List<CapitalAssetInformation> capitalAssetInformation) {
        if (ObjectUtils.isNull(capitalAssetInformation) && capitalAssetInformation.size() <= 0) {
            return false;
        }
        for (CapitalAssetInformation capitalAsset : capitalAssetInformation) {
            List groupAccountLines = capitalAsset.getCapitalAssetAccountsGroupDetails();
            for (CapitalAssetAccountsGroupDetails groupAccountLine : groupAccountLines) {
                if (groupAccountLine.getCapitalAssetLineNumber().compareTo(capitalAsset.getCapitalAssetLineNumber()) != 0 || groupAccountLine.getSequenceNumber().compareTo(capitalAccountingLine.getSequenceNumber()) != 0 || !groupAccountLine.getFinancialDocumentLineTypeCode().equals("Source".equals(capitalAccountingLine.getLineType()) ? "F" : "T") || !groupAccountLine.getChartOfAccountsCode().equals(capitalAccountingLine.getChartOfAccountsCode()) || !groupAccountLine.getAccountNumber().equals(capitalAccountingLine.getAccountNumber()) || !groupAccountLine.getFinancialObjectCode().equals(capitalAccountingLine.getFinancialObjectCode())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean markProcessedGLEntryLine(String documentNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("capitalAssetManagementDocumentNumber", documentNumber);
        Collection matchingGlAssets = this.businessObjectService.findMatching(GeneralLedgerEntryAsset.class, fieldValues);
        if (matchingGlAssets != null && !matchingGlAssets.isEmpty()) {
            for (GeneralLedgerEntryAsset generalLedgerEntryAsset : matchingGlAssets) {
                GeneralLedgerEntry generalLedgerEntry = generalLedgerEntryAsset.getGeneralLedgerEntry();
                if (this.glLineService.findUnprocessedCapitalAssetInformation(generalLedgerEntry.getDocumentNumber()) == 0L) {
                    generalLedgerEntry.setActivityStatusCode("E");
                } else {
                    generalLedgerEntry.setActivityStatusCode("N");
                }
                this.businessObjectService.save((PersistableBusinessObject)generalLedgerEntry);
            }
        }
        return true;
    }

    public void setGlLineService(GlLineService glLineService) {
        this.glLineService = glLineService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public void setParameterEvaluatorService(ParameterEvaluatorService parameterEvaluatorService) {
        this.parameterEvaluatorService = parameterEvaluatorService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setParameterRepositoryService(ParameterRepositoryService parameterRepositoryService) {
        this.parameterRepositoryService = parameterRepositoryService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    public void setPurApInfoService(PurApInfoService purApInfoService) {
        this.purApInfoService = purApInfoService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public AssetService getAssetService() {
        return this.assetService;
    }

    public PurApInfoService getPurApInfoService() {
        return this.purApInfoService;
    }

    public KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public void setBusinessObjectDictionaryService(BusinessObjectDictionaryService businessObjectDictionaryService) {
        this.businessObjectDictionaryService = businessObjectDictionaryService;
    }

    public void setDictionaryValidationService(DictionaryValidationService dictionaryValidationService) {
        this.dictionaryValidationService = dictionaryValidationService;
    }

    public void setPurchasingAccountsPayableModuleService(PurchasingAccountsPayableModuleService purchasingAccountsPayableModuleService) {
        this.purchasingAccountsPayableModuleService = purchasingAccountsPayableModuleService;
    }

    public void reactivatePretagDetails(String campusTagNumber) {
        if (campusTagNumber != null && !campusTagNumber.isEmpty()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("campusTagNumber", campusTagNumber);
            List pretagDetailList = (List)this.businessObjectService.findMatching(PretagDetail.class, map);
            if (ObjectUtils.isNotNull((Object)pretagDetailList)) {
                for (PretagDetail pretagDetail : pretagDetailList) {
                    pretagDetail.setActive(true);
                    this.businessObjectService.save((PersistableBusinessObject)pretagDetail);
                }
            }
        }
    }

    public void filterNonCapitalAssets(List<CapitalAssetInformation> infos) {
    }

    public void setAssetLockService(AssetLockService assetLockService) {
        this.assetLockService = assetLockService;
    }

    public final class TagRecord {
        protected String tagNumber;
        protected int assetLineNumber;
        protected int assetDetailLineNumber;
        protected int assetItemLineNumber;
        protected boolean duplicate;

        public TagRecord(String tagNumber, int assetLineNumber, int assetDetailLineNumber, int itemLineNumber) {
            this.tagNumber = tagNumber;
            this.assetLineNumber = assetLineNumber;
            this.assetDetailLineNumber = assetDetailLineNumber;
            this.assetItemLineNumber = itemLineNumber;
            this.duplicate = false;
        }

        public String getTagNumber() {
            return this.tagNumber;
        }

        public int getAssetLineNumber() {
            return this.assetLineNumber;
        }

        public int getAssetDetailLineNumber() {
            return this.assetDetailLineNumber;
        }

        public void setTagNumber(String tagNumber) {
            this.tagNumber = tagNumber;
        }

        public void setAssetLineNumber(int assetLineNumber) {
            this.assetLineNumber = assetLineNumber;
        }

        public void setAssetDetailLineNumber(int assetDetailLineNumber) {
            this.assetDetailLineNumber = assetDetailLineNumber;
        }

        public int getAssetItemLineNumber() {
            return this.assetItemLineNumber;
        }

        public void setAssetItemLineNumber(int assetItemLineNumber) {
            this.assetItemLineNumber = assetItemLineNumber;
        }

        public boolean isDuplicate() {
            return this.duplicate;
        }

        public void setDuplicate(boolean duplicate) {
            this.duplicate = duplicate;
        }
    }

    protected static enum AccountCapitalObjectCode {
        BOTH_NONCAP{

            @Override
            boolean validateAssetInfoAllowed(AccountingDocument accountingDocument, boolean isNewAssetBlank, boolean isUpdateAssetBlank) {
                boolean valid = true;
                if (!isNewAssetBlank || !isUpdateAssetBlank) {
                    GlobalVariables.getMessageMap().putError("capitalAssetNumber", "error.asset.do.not.enter.any.data", new String[0]);
                    valid = false;
                }
                return valid;
            }

            @Override
            boolean isDocumentTypeRestricted(AccountingDocument accountingDocument) {
                return false;
            }
        }
        ,
        FROM_CAPITAL_TO_NONCAP{

            @Override
            boolean validateAssetInfoAllowed(AccountingDocument accountingDocument, boolean isNewAssetBlank, boolean isUpdateAssetBlank) {
                boolean valid = 2.validateAssetInfoEntered(isNewAssetBlank, isUpdateAssetBlank);
                if (valid) {
                    if (this.isDocumentTypeRestricted(accountingDocument)) {
                        valid = 2.validateOnlyOneAssetInfoEntered(isNewAssetBlank, isUpdateAssetBlank);
                    } else if (!isNewAssetBlank || isUpdateAssetBlank) {
                        GlobalVariables.getMessageMap().putError("capitalAssetNumber", "error.asset.update.allow.only", new String[0]);
                        valid = false;
                    }
                }
                return valid;
            }

            @Override
            boolean isDocumentTypeRestricted(AccountingDocument accountingDocument) {
                return accountingDocument instanceof InternalBillingDocument;
            }
        }
        ,
        FROM_NONCAP_TO_CAPITAL{

            @Override
            boolean validateAssetInfoAllowed(AccountingDocument accountingDocument, boolean isNewAssetBlank, boolean isUpdateAssetBlank) {
                boolean valid = 3.validateAssetInfoEntered(isNewAssetBlank, isUpdateAssetBlank);
                if (valid && this.isDocumentTypeRestricted(accountingDocument)) {
                    valid = 3.validateOnlyOneAssetInfoEntered(isNewAssetBlank, isUpdateAssetBlank);
                }
                return valid;
            }

            @Override
            boolean isDocumentTypeRestricted(AccountingDocument accountingDocument) {
                return true;
            }
        }
        ,
        BOTH_CAPITAL{

            @Override
            boolean validateAssetInfoAllowed(AccountingDocument accountingDocument, boolean isNewAssetBlank, boolean isUpdateAssetBlank) {
                return 4.validateAssetInfoEntered(isNewAssetBlank, isUpdateAssetBlank) && 4.validateOnlyOneAssetInfoEntered(isNewAssetBlank, isUpdateAssetBlank);
            }

            @Override
            boolean isDocumentTypeRestricted(AccountingDocument accountingDocument) {
                return false;
            }
        };


        protected static boolean validateAssetInfoEntered(boolean isNewAssetBlank, boolean isUpdateAssetBlank) {
            boolean valid = true;
            if (isNewAssetBlank && isUpdateAssetBlank) {
                GlobalVariables.getMessageMap().putError("capitalAssetNumber", "error.asset.require.data.entry", new String[0]);
                valid = false;
            }
            return valid;
        }

        protected static boolean validateOnlyOneAssetInfoEntered(boolean isNewAssetBlank, boolean isUpdateAssetBlank) {
            boolean valid = true;
            if (!isNewAssetBlank && !isUpdateAssetBlank) {
                GlobalVariables.getMessageMap().putError("capitalAssetNumber", "error.asset.new.or.update.only", new String[0]);
                valid = false;
            }
            return valid;
        }

        abstract boolean validateAssetInfoAllowed(AccountingDocument var1, boolean var2, boolean var3);

        abstract boolean isDocumentTypeRestricted(AccountingDocument var1);
    }
}

