/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.module.cam.batch.service.AssetBarcodeInventoryLoadService;
import org.kuali.kfs.module.cam.document.web.struts.AssetBarCodeInventoryInputFileForm;
import org.kuali.kfs.sys.FileUtil;
import org.kuali.kfs.sys.batch.BatchInputFileSetType;

public class AssetBarcodeInventoryInputFileType
implements BatchInputFileSetType {
    private static final Logger LOG = LogManager.getLogger();
    private String directoryPath;
    private static final String FILE_NAME_PREFIX = "barcode_inv";
    private static final String FILE_NAME_PART_DELIMITER = "_";
    private DateTimeService dateTimeService;
    private AssetBarcodeInventoryLoadService assetBarcodeInventoryLoadService;

    public String getDirectoryPath(String fileType) {
        return this.directoryPath;
    }

    public void setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
        FileUtil.createDirectory((String)directoryPath);
    }

    public List<String> getFileTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.add("csv");
        return types;
    }

    public String getFileExtension() {
        return ".csv";
    }

    public String getFileExtension(String fileType) {
        return "." + fileType;
    }

    public Map<String, String> getFileTypeDescription() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("csv", "CSV File");
        return values;
    }

    public String getFileName(String fileType, String principalName, String fileUserIdentifier, Date creationDate) {
        StringBuilder buf = new StringBuilder();
        fileUserIdentifier = StringUtils.deleteWhitespace((String)fileUserIdentifier);
        fileUserIdentifier = StringUtils.remove((String)fileUserIdentifier, (String)FILE_NAME_PART_DELIMITER);
        buf.append(FILE_NAME_PREFIX).append(FILE_NAME_PART_DELIMITER).append(principalName).append(FILE_NAME_PART_DELIMITER).append(fileUserIdentifier).append(FILE_NAME_PART_DELIMITER).append(this.dateTimeService.toDateTimeStringForFilename(creationDate)).append(this.getFileExtension(fileType));
        return buf.toString();
    }

    public String getAuthorPrincipalName(File file) {
        String[] fileNameParts = StringUtils.split((String)file.getName(), (String)FILE_NAME_PART_DELIMITER);
        if (fileNameParts.length > 2) {
            return fileNameParts[2];
        }
        return null;
    }

    public String getFileSetTypeIdentifer() {
        return "assetBarcodeInventoryInputFileType";
    }

    public String getTitleKey() {
        return "message.upload.title.barCodeInventory";
    }

    public boolean isFileRequired(String fileType) {
        return true;
    }

    public String getDoneFileDirectoryPath() {
        return this.directoryPath;
    }

    public String getDoneFileExtension() {
        return ".done";
    }

    public String getDoneFileName(Person user, String fileUserIdentifier, Date creationDate) {
        StringBuilder buf = new StringBuilder();
        fileUserIdentifier = StringUtils.deleteWhitespace((String)fileUserIdentifier);
        fileUserIdentifier = StringUtils.remove((String)fileUserIdentifier, (String)FILE_NAME_PART_DELIMITER);
        buf.append(FILE_NAME_PREFIX).append(FILE_NAME_PART_DELIMITER).append(user.getPrincipalName()).append(FILE_NAME_PART_DELIMITER).append(fileUserIdentifier).append(FILE_NAME_PART_DELIMITER).append(this.dateTimeService.toDateTimeStringForFilename(creationDate)).append(this.getDoneFileExtension());
        return buf.toString();
    }

    public Set<String> extractFileUserIdentifiers(Person user, List<File> files) {
        TreeSet<String> extractedFileUserIdentifiers = new TreeSet<String>();
        String prefixString = "barcode_inv_" + user.getPrincipalName() + FILE_NAME_PART_DELIMITER;
        PrefixFileFilter prefixFilter = new PrefixFileFilter(prefixString);
        SuffixFileFilter suffixFilter = new SuffixFileFilter(".csv");
        AndFileFilter combinedFilter = new AndFileFilter((IOFileFilter)prefixFilter, (IOFileFilter)suffixFilter);
        for (File file : files) {
            if (!combinedFilter.accept(file)) continue;
            String fileName = file.getName();
            if (fileName.endsWith(".csv")) {
                extractedFileUserIdentifiers.add(StringUtils.substringBetween((String)fileName, (String)prefixString, (String)".csv"));
                continue;
            }
            LOG.error("Unable to determine file user identifier for file name: {}", (Object)fileName);
            throw new RuntimeException("Unable to determine file user identifier for file name: " + fileName);
        }
        return extractedFileUserIdentifiers;
    }

    public void process(Map<String, File> typeToFiles) {
    }

    public void process(Map<String, File> typeToFiles, AssetBarCodeInventoryInputFileForm form) {
        this.assetBarcodeInventoryLoadService.processFile(typeToFiles.get("csv"), form);
    }

    public boolean validate(Map<String, File> typeToFiles) {
        boolean isValid = true;
        if (!this.assetBarcodeInventoryLoadService.isFileFormatValid(typeToFiles.get("csv"))) {
            isValid = false;
        }
        return isValid;
    }

    public String generageDoneFileWithDataFile(String fileUserIdentifier) {
        return null;
    }

    public String generateDoneFileName(Person user, String fileUserIdentifier) {
        return null;
    }

    public String generateFileName(String fileType, String principalName, String fileUserIdentifier) {
        return null;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setAssetBarcodeInventoryLoadService(AssetBarcodeInventoryLoadService assetBarcodeInventoryLoadService) {
        this.assetBarcodeInventoryLoadService = assetBarcodeInventoryLoadService;
    }
}

