/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.parameter.ParameterEvaluator;
import org.kuali.kfs.core.api.parameter.ParameterEvaluatorService;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.maintenance.MaintenanceLock;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobalDetail;
import org.kuali.kfs.module.cam.document.gl.AssetRetirementGeneralLedgerPendingEntrySource;
import org.kuali.kfs.module.cam.document.service.AssetPaymentService;
import org.kuali.kfs.module.cam.document.service.AssetRetirementService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.LedgerPostingMaintainable;

public class AssetRetirementGlobalMaintainableImpl
extends LedgerPostingMaintainable {
    private static final Logger LOG = LogManager.getLogger();
    protected static final String RETIRED_ASSET_TRANSFERRED_EXTERNALLY = "RetiredAssetTransferredExternally";
    protected static final String RETIRED_ASSET_SOLD_OR_GIFTED = "RetiredAssetSoldOrGifted";
    protected static volatile DocumentService documentService;

    protected boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        String retirementReason = ((AssetRetirementGlobal)this.getBusinessObject()).getRetirementReasonCode();
        if (RETIRED_ASSET_TRANSFERRED_EXTERNALLY.equals(nodeName)) {
            return "9".equalsIgnoreCase(retirementReason);
        }
        if (RETIRED_ASSET_SOLD_OR_GIFTED.equals(nodeName)) {
            return "1".equalsIgnoreCase(retirementReason) || "6".equalsIgnoreCase(retirementReason);
        }
        if ("RequiresOrganizationInactiveReview".equals(nodeName)) {
            return this.isRequiresOrganizationInactiveRouteNode();
        }
        throw new UnsupportedOperationException("Cannot answer split question for this node you call \"" + nodeName + "\"");
    }

    protected boolean isRequiresOrganizationInactiveRouteNode() {
        List<AssetRetirementGlobalDetail> assetRetirementGlobalDetails = ((AssetRetirementGlobal)this.getBusinessObject()).getAssetRetirementGlobalDetails();
        ArrayList<Long> assets = new ArrayList<Long>();
        for (AssetRetirementGlobalDetail assetRetirementGlobalDetail : assetRetirementGlobalDetails) {
            Asset asset = assetRetirementGlobalDetail.getAsset();
            if (asset.getOrganizationOwnerAccount().getOrganization().isActive()) continue;
            assets.add(asset.getCapitalAssetNumber());
        }
        return !assets.isEmpty();
    }

    public List<MaintenanceLock> generateMaintenanceLocks() {
        return new ArrayList<MaintenanceLock>();
    }

    protected CapitalAssetManagementModuleService getCapitalAssetManagementModuleService() {
        return (CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class);
    }

    public void setupNewFromExisting(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.setupNewFromExisting(document, parameters);
        AssetRetirementGlobal assetRetirementGlobal = (AssetRetirementGlobal)this.getBusinessObject();
        if (this.getAssetRetirementService().isAssetRetiredByMerged(assetRetirementGlobal) && ObjectUtils.isNotNull((Object)assetRetirementGlobal.getMergedTargetCapitalAssetNumber())) {
            assetRetirementGlobal.setMergedTargetCapitalAssetDescription(assetRetirementGlobal.getMergedTargetCapitalAsset().getCapitalAssetDescription());
        }
        if ("M".equals(assetRetirementGlobal.getRetirementReasonCode())) {
            document.getDocumentHeader().setDocumentDescription("Merge an Asset");
        }
        if (this.isFiscalPeriodEditable(document) && this.isPeriod13(assetRetirementGlobal)) {
            try {
                if (ObjectUtils.isNotNull((Object)assetRetirementGlobal.getPostingYear())) {
                    assetRetirementGlobal.setAccountingPeriodCompositeString(assetRetirementGlobal.getAccountingPeriod().getUniversityFiscalPeriodCode() + assetRetirementGlobal.getPostingYear());
                }
                assetRetirementGlobal.refreshNonUpdateableReferences();
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
    }

    private boolean isFiscalPeriodEditable(MaintenanceDocument document) {
        String docType = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        ParameterEvaluatorService parameterEvaluatorService = (ParameterEvaluatorService)SpringContext.getBean(ParameterEvaluatorService.class);
        ParameterEvaluator evaluator = parameterEvaluatorService.getParameterEvaluator("KFS-SYS", "Document", "FISCAL_PERIOD_SELECTION_DOCUMENT_TYPES", docType);
        return evaluator.evaluationSucceeds();
    }

    public List getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        for (Section section : sections) {
            if (!section.getSectionId().equalsIgnoreCase("Accounting Period") || this.isAuthorizedToEditFiscalPeriod((Document)document)) continue;
            section.setReadOnly(true);
        }
        return sections;
    }

    private boolean isAuthorizedToEditFiscalPeriod(Document document) {
        Person user = GlobalVariables.getUserSession().getPerson();
        return this.getDocumentDictionaryService().getDocumentAuthorizer(document).isAuthorized((Object)document, "KFS-SYS", "Edit Accounting Period", user.getPrincipalId());
    }

    protected void processGlobalsAfterRetrieve() {
        super.processGlobalsAfterRetrieve();
        AssetRetirementGlobal assetRetirementGlobal = (AssetRetirementGlobal)this.getBusinessObject();
        List<AssetRetirementGlobalDetail> assetRetirementGlobalDetails = assetRetirementGlobal.getAssetRetirementGlobalDetails();
        for (AssetRetirementGlobalDetail assetRetirementGlobalDetail : assetRetirementGlobalDetails) {
            this.getAssetService().setAssetSummaryFields(assetRetirementGlobalDetail.getAsset());
        }
    }

    public void addMultipleValueLookupResults(MaintenanceDocument document, String collectionName, Collection<PersistableBusinessObject> rawValues, boolean needsBlank, PersistableBusinessObject bo) {
        AssetRetirementGlobal assetRetirementGlobal = (AssetRetirementGlobal)document.getDocumentBusinessObject();
        int nElements = assetRetirementGlobal.getAssetRetirementGlobalDetails().size() + rawValues.size();
        if (!this.getAssetService().isDocumentEnrouting((Document)document) && !this.getAssetRetirementService().isAllowedRetireMultipleAssets(document) && nElements > 1) {
            GlobalVariables.getMessageMap().putErrorForSectionId("Asset Detail Information", "error.multiple.asset.retired", new String[0]);
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            super.addMultipleValueLookupResults(document, collectionName, rawValues, needsBlank, bo);
        }
    }

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        super.refresh(refreshCaller, fieldValues, document);
        AssetRetirementGlobal assetRetirementGlobal = (AssetRetirementGlobal)document.getDocumentBusinessObject();
        List<AssetRetirementGlobalDetail> assetRetirementGlobalDetails = assetRetirementGlobal.getAssetRetirementGlobalDetails();
        if ("multipleValues".equalsIgnoreCase(refreshCaller)) {
            for (AssetRetirementGlobalDetail assetRetirementGlobalDetail : assetRetirementGlobalDetails) {
                this.getAssetService().setAssetSummaryFields(assetRetirementGlobalDetail.getAsset());
            }
        } else if ("assetLookupable".equalsIgnoreCase(refreshCaller)) {
            String referencesToRefresh = (String)fieldValues.get("referencesToRefresh");
            if (this.getAssetRetirementService().isAssetRetiredByMerged(assetRetirementGlobal) && "mergedTargetCapitalAsset".equals(referencesToRefresh)) {
                assetRetirementGlobal.setMergedTargetCapitalAssetDescription(assetRetirementGlobal.getMergedTargetCapitalAsset().getCapitalAssetDescription());
            }
            AssetRetirementGlobalDetail newDetail = (AssetRetirementGlobalDetail)((Object)this.newCollectionLines.get("assetRetirementGlobalDetails"));
            this.getAssetService().setAssetSummaryFields(newDetail.getAsset());
        }
    }

    public void doRouteStatusChange(DocumentHeader documentHeader) {
        super.doRouteStatusChange(documentHeader);
        AssetRetirementGlobal assetRetirementGlobal = (AssetRetirementGlobal)this.getBusinessObject();
        if (documentHeader.getWorkflowDocument().isEnroute()) {
            boolean allPaymentsFederalOwned = true;
            List<AssetRetirementGlobalDetail> assetRetirementGlobalDetails = assetRetirementGlobal.getAssetRetirementGlobalDetails();
            for (AssetRetirementGlobalDetail assetRetirementGlobalDetail : assetRetirementGlobalDetails) {
                for (AssetPayment assetPayment : assetRetirementGlobalDetail.getAsset().getAssetPayments()) {
                    if (this.getAssetPaymentService().isPaymentFederalOwned(assetPayment)) continue;
                    allPaymentsFederalOwned = false;
                }
            }
            if (allPaymentsFederalOwned) {
                KNSGlobalVariables.getMessageList().add("message.no.ledger.entry.required.retirement", new String[0]);
            }
        }
        if (documentHeader.getWorkflowDocument().isProcessed()) {
            assetRetirementGlobal.setRetirementDate(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate());
            ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)assetRetirementGlobal);
            if (this.getAssetRetirementService().isAssetRetiredByMerged(assetRetirementGlobal)) {
                assetRetirementGlobal.getMergedTargetCapitalAsset().setCapitalAssetDescription(assetRetirementGlobal.getMergedTargetCapitalAssetDescription());
                ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)assetRetirementGlobal.getMergedTargetCapitalAsset());
            }
        }
        new AssetRetirementGeneralLedgerPendingEntrySource(documentHeader).doRouteStatusChange(assetRetirementGlobal.getGeneralLedgerPendingEntries());
        WorkflowDocument workflowDoc = documentHeader.getWorkflowDocument();
        if (workflowDoc.isCanceled() || workflowDoc.isDisapproved() || workflowDoc.isProcessed() || workflowDoc.isFinal()) {
            this.getCapitalAssetManagementModuleService().deleteAssetLocks(this.getDocumentNumber(), null);
        }
    }

    public void addNewLineToCollection(String collectionName) {
        super.addNewLineToCollection(collectionName);
        AssetRetirementGlobal assetRetirementGlobal = (AssetRetirementGlobal)this.getBusinessObject();
        if (StringUtils.isBlank((CharSequence)assetRetirementGlobal.getMergedTargetCapitalAssetDescription()) && ObjectUtils.isNotNull((Object)assetRetirementGlobal.getMergedTargetCapitalAssetNumber())) {
            assetRetirementGlobal.setMergedTargetCapitalAssetDescription(assetRetirementGlobal.getMergedTargetCapitalAsset().getCapitalAssetDescription());
        }
    }

    public Class<? extends PersistableBusinessObject> getPrimaryEditedBusinessObjectClass() {
        return Asset.class;
    }

    public Map<String, String> populateNewCollectionLines(Map<String, String> fieldValues, MaintenanceDocument maintenanceDocument, String methodToCall) {
        String capitalAssetNumber = fieldValues.get("assetRetirementGlobalDetails.capitalAssetNumber");
        if (StringUtils.isNotBlank((CharSequence)capitalAssetNumber)) {
            fieldValues.remove("assetRetirementGlobalDetails.capitalAssetNumber");
            fieldValues.put("assetRetirementGlobalDetails.capitalAssetNumber", capitalAssetNumber.trim());
        }
        return super.populateNewCollectionLines(fieldValues, maintenanceDocument, methodToCall);
    }

    private AssetRetirementService getAssetRetirementService() {
        return (AssetRetirementService)SpringContext.getBean(AssetRetirementService.class);
    }

    private AssetService getAssetService() {
        return (AssetService)SpringContext.getBean(AssetService.class);
    }

    private AssetPaymentService getAssetPaymentService() {
        return (AssetPaymentService)SpringContext.getBean(AssetPaymentService.class);
    }

    private boolean isPeriod13(AssetRetirementGlobal assetRetirementGlobal) {
        if (ObjectUtils.isNull((Object)assetRetirementGlobal.getAccountingPeriod())) {
            return false;
        }
        return "13".equals(assetRetirementGlobal.getAccountingPeriod().getUniversityFiscalPeriodCode());
    }

    protected static DocumentService getDocumentService() {
        if (documentService == null) {
            documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        }
        return documentService;
    }
}

