/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.web.struts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.document.AssetTransferDocument;
import org.kuali.kfs.module.cam.document.service.AssetLocationService;
import org.kuali.kfs.module.cam.document.service.AssetPaymentService;
import org.kuali.kfs.module.cam.document.service.PaymentSummaryService;
import org.kuali.kfs.module.cam.document.web.struts.AssetTransferForm;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.web.struts.FinancialSystemTransactionalDocumentActionBase;

public class AssetTransferAction
extends FinancialSystemTransactionalDocumentActionBase {
    private static final Logger LOG = LogManager.getLogger();

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward docHandlerForward = super.docHandler(mapping, form, request, response);
        AssetTransferForm assetTransferForm = (AssetTransferForm)form;
        AssetTransferDocument assetTransferDocument = (AssetTransferDocument)assetTransferForm.getDocument();
        this.handleRequestFromLookup(request, assetTransferForm, assetTransferDocument);
        this.handleRequestFromWorkflow(assetTransferForm, assetTransferDocument);
        Asset asset = assetTransferDocument.getAsset();
        asset.refreshReferenceObject("assetLocations");
        asset.refreshReferenceObject("assetPayments");
        ((AssetLocationService)SpringContext.getBean(AssetLocationService.class)).setOffCampusLocation(asset);
        ((PaymentSummaryService)SpringContext.getBean(PaymentSummaryService.class)).calculateAndSetPaymentSummary(asset);
        String command = assetTransferForm.getCommand();
        if ("initiate".equals(command)) {
            assetTransferDocument.setOldOrganizationOwnerChartOfAccountsCode(asset.getOrganizationOwnerChartOfAccountsCode());
            assetTransferDocument.setOldOrganizationOwnerAccountNumber(asset.getOrganizationOwnerAccountNumber());
        }
        this.refresh(mapping, form, request, response);
        return docHandlerForward;
    }

    protected void handleRequestFromWorkflow(AssetTransferForm assetTransferForm, AssetTransferDocument assetTransferDocument) {
        LOG.debug("Start- Handle request from workflow");
        if (assetTransferForm.getDocId() != null) {
            assetTransferDocument.refreshReferenceObject("asset");
            PersonService personService = (PersonService)SpringContext.getBean(PersonService.class);
            Person person = personService.getPerson(assetTransferDocument.getRepresentativeUniversalIdentifier());
            if (person != null) {
                assetTransferDocument.setAssetRepresentative(person);
            } else {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = assetTransferDocument::getRepresentativeUniversalIdentifier;
                LOG.error("org.kuali.kfs.kim.api.identity.PersonService returned null for uuid {}", supplierArray);
            }
        }
    }

    protected void handleRequestFromLookup(HttpServletRequest request, AssetTransferForm assetTransferForm, AssetTransferDocument assetTransferDocument) {
        LOG.debug("Start - Handle request from asset lookup screen");
        if (assetTransferForm.getDocId() == null) {
            String capitalAssetNumber = request.getParameter("capitalAssetNumber");
            assetTransferDocument.setCapitalAssetNumber(Long.valueOf(capitalAssetNumber));
            assetTransferDocument.refreshReferenceObject("asset");
        }
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((KualiDocumentFormBase)form).setMessageMapFromPreviousRequest(new MessageMap());
        ActionForward actionForward = super.refresh(mapping, form, request, response);
        AssetTransferDocument assetTransferDocument = ((AssetTransferForm)form).getAssetTransferDocument();
        assetTransferDocument.refreshReferenceObject("organizationOwnerAccount");
        assetTransferDocument.refreshReferenceObject("oldOrganizationOwnerAccount");
        return actionForward;
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.route(mapping, form, request, response);
        this.allPaymentsFederalOwnedMessage(form);
        return actionForward;
    }

    protected void allPaymentsFederalOwnedMessage(ActionForm form) {
        boolean allPaymentsFederalOwned = true;
        AssetTransferDocument assetTransferDocument = ((AssetTransferForm)form).getAssetTransferDocument();
        for (AssetPayment assetPayment : assetTransferDocument.getAsset().getAssetPayments()) {
            if (this.getAssetPaymentService().isPaymentFederalOwned(assetPayment)) continue;
            allPaymentsFederalOwned = false;
        }
        if (allPaymentsFederalOwned) {
            KNSGlobalVariables.getMessageList().add(0, (Object)new ErrorMessage("message.no.ledger.entry.required.transfer", new String[0]));
        }
    }

    protected AssetPaymentService getAssetPaymentService() {
        return (AssetPaymentService)SpringContext.getBean(AssetPaymentService.class);
    }
}

