/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.authorization;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DocumentDictionaryService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.CamsConstants;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetComponent;
import org.kuali.kfs.module.cam.businessobject.AssetRepairHistory;
import org.kuali.kfs.module.cam.document.authorization.AssetAuthorizer;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.authorization.FinancialSystemMaintenanceDocumentPresentationControllerBase;

public class AssetPresentationController
extends FinancialSystemMaintenanceDocumentPresentationControllerBase {
    public Set<String> getConditionallyHiddenPropertyNames(BusinessObject businessObject) {
        Set fields = super.getConditionallyHiddenPropertyNames(businessObject);
        MaintenanceDocument document = (MaintenanceDocument)businessObject;
        if (((AssetService)SpringContext.getBean(AssetService.class)).isAssetFabrication(document)) {
            fields.addAll(Arrays.asList(CamsConstants.Asset.EDIT_DETAIL_INFORMATION_FIELDS));
            fields.addAll(Arrays.asList(CamsConstants.Asset.EDIT_ORGANIZATION_INFORMATION_FIELDS));
        }
        Asset asset = (Asset)document.getNewMaintainableObject().getBusinessObject();
        this.hideInactiveAssetComponent(fields, asset);
        this.hideInactiveAssetRepairHistory(fields, asset);
        this.hideInactiveAssetWarranty(fields, asset);
        int size = asset.getAssetPayments().size();
        for (int i = 0; i < size; ++i) {
            fields.add("assetPayments[" + i + "].paymentSequenceNumber");
            fields.add("assetPayments[" + i + "].capitalAssetNumber");
        }
        if (!"M".equals(asset.getRetirementReasonCode())) {
            fields.add("retirementInfo.assetRetirementGlobal.mergedTargetCapitalAssetNumber");
        }
        return fields;
    }

    public Set<String> getConditionallyReadOnlyPropertyNames(MaintenanceDocument document) {
        AssetAuthorizer documentAuthorizer;
        boolean isAuthorized;
        Set fields = super.getConditionallyReadOnlyPropertyNames(document);
        if (((AssetService)SpringContext.getBean(AssetService.class)).isAssetFabrication(document)) {
            fields.add("inventoryStatusCode");
            fields.add("vendorName");
            fields.add("acquisitionTypeCode");
        } else {
            fields.add("acquisitionTypeCode");
            fields.addAll(Arrays.asList(CamsConstants.Asset.FABRICATION_INFORMATION_FIELDS));
        }
        Asset asset = (Asset)document.getNewMaintainableObject().getBusinessObject();
        if (((AssetService)SpringContext.getBean(AssetService.class)).isAssetTaggedInPriorFiscalYear(asset) && !(isAuthorized = (documentAuthorizer = (AssetAuthorizer)((DocumentDictionaryService)SpringContext.getBean(DocumentDictionaryService.class)).getDocumentAuthorizer((Document)document)).isAuthorized((BusinessObject)document, "KFS-CAM", "Edit When Tagged Prior Fiscal Year", GlobalVariables.getUserSession().getPerson().getPrincipalId()))) {
            fields.addAll(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(Asset.class, "PRIOR_YEAR_RESTRICTED_FIELDS"));
        }
        return fields;
    }

    public Set<String> getConditionallyHiddenSectionIds(BusinessObject businessObject) {
        Set fields = super.getConditionallyHiddenSectionIds(businessObject);
        MaintenanceDocument document = (MaintenanceDocument)businessObject;
        Asset asset = (Asset)document.getNewMaintainableObject().getBusinessObject();
        if (asset.getAssetPayments().size() > 10) {
            fields.add("paymentInformation");
        }
        if (((AssetService)SpringContext.getBean(AssetService.class)).isAssetFabrication(document)) {
            fields.add("landInformation");
            fields.add("paymentInformation");
            fields.add("paymentLookup");
            fields.add("documentLookup");
            fields.add("depreciationInformation");
            fields.add("history");
            fields.add("retirementInformation");
            fields.add("equipmentLoanInformation");
            fields.add("warrenty");
            fields.add("repairHistory");
            fields.add("components");
            fields.add("mergeHistory");
        } else {
            if (asset.getEstimatedFabricationCompletionDate() == null) {
                fields.add("fabricationInformation");
            }
            if (!((AssetService)SpringContext.getBean(AssetService.class)).isAssetRetired(asset)) {
                fields.add("retirementInformation");
            }
            if (asset.getExpectedReturnDate() == null || asset.getLoanReturnDate() != null) {
                fields.add("equipmentLoanInformation");
            }
            if (asset.getSeparateHistory() == null) {
                fields.add("history");
            }
        }
        return fields;
    }

    public boolean canEdit(Document document) {
        Set<String> nodeNames;
        WorkflowDocument workflowDocument;
        AssetService assetService = (AssetService)SpringContext.getBean(AssetService.class);
        if (assetService.isAssetFabrication((MaintenanceDocument)document) && (workflowDocument = document.getDocumentHeader().getWorkflowDocument()).isEnroute() && (nodeNames = assetService.getCurrentRouteLevels(workflowDocument)).contains("Management") && !workflowDocument.isApprovalRequested()) {
            return false;
        }
        MaintenanceDocument maintDocument = (MaintenanceDocument)document;
        Asset asset = (Asset)maintDocument.getOldMaintainableObject().getBusinessObject();
        return !this.getAssetService().isAssetRetired(asset) & super.canEdit(document);
    }

    public boolean canBlanketApprove(Document document) {
        return true;
    }

    public boolean canRoute(Document document) {
        MaintenanceDocument maitDocument = (MaintenanceDocument)document;
        Asset asset = (Asset)maitDocument.getOldMaintainableObject().getBusinessObject();
        return !this.getAssetService().isAssetRetired(asset) & super.canRoute(document);
    }

    public boolean canSave(Document document) {
        MaintenanceDocument maitDocument = (MaintenanceDocument)document;
        Asset asset = (Asset)maitDocument.getOldMaintainableObject().getBusinessObject();
        return !this.getAssetService().isAssetRetired(asset) & super.canSave(document);
    }

    protected AssetService getAssetService() {
        return (AssetService)SpringContext.getBean(AssetService.class);
    }

    private void hideInactiveAssetWarranty(Set<String> fields, Asset asset) {
        if (ObjectUtils.isNotNull((Object)((Object)asset.getAssetWarranty())) && !asset.getAssetWarranty().isActive()) {
            fields.add("assetWarranty");
        }
    }

    private void hideInactiveAssetComponent(Set<String> fields, Asset asset) {
        List<AssetComponent> components = asset.getAssetComponents();
        int i = 0;
        for (AssetComponent component : components) {
            if (!component.isActive()) {
                fields.add("assetComponents[" + i + "]");
            }
            ++i;
        }
    }

    private void hideInactiveAssetRepairHistory(Set<String> fields, Asset asset) {
        int i = 0;
        for (AssetRepairHistory assetRepairHistory : asset.getAssetRepairHistory()) {
            if (!assetRepairHistory.isActive()) {
                fields.add("assetRepairHistory[" + i + "]");
            }
            ++i;
        }
    }
}

