/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.OffsetDefinition;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coa.service.OffsetDefinitionService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.fp.document.TransferOfFundsDocument;
import org.kuali.kfs.kim.api.identity.Person;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kns.rules.DocumentRuleBase;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.CamsPropertyConstants;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetFabrication;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetObjectCode;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.document.AssetTransferDocument;
import org.kuali.kfs.module.cam.document.service.AssetLocationService;
import org.kuali.kfs.module.cam.document.service.AssetObjectCodeService;
import org.kuali.kfs.module.cam.document.service.AssetPaymentService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.AssetTransferService;
import org.kuali.kfs.module.cam.service.AssetLockService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.springframework.util.AutoPopulatingList;

public class AssetTransferDocumentRule
extends DocumentRuleBase {
    private static final Map<AssetLocationService.LocationField, String> LOCATION_FIELD_MAP = new HashMap<AssetLocationService.LocationField, String>();
    protected UniversityDateService universityDateService;
    protected AssetPaymentService assetPaymentService;
    protected AssetService assetService;
    protected ObjectCodeService objectCodeService;
    protected AssetLockService assetLockService;

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        AssetTransferDocument assetTransferDocument = (AssetTransferDocument)document;
        Asset asset = assetTransferDocument.getAsset();
        boolean valid = this.checkReferencesExist(assetTransferDocument);
        assetTransferDocument.clearGlPostables();
        if (valid && (valid = this.validateAssetObjectCodeDefn(assetTransferDocument, asset))) {
            ((AssetTransferService)SpringContext.getBean(AssetTransferService.class)).createGLPostables(assetTransferDocument);
            if (!((GeneralLedgerPendingEntryService)SpringContext.getBean(GeneralLedgerPendingEntryService.class)).generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)assetTransferDocument)) {
                throw new ValidationException("General Ledger GLPE generation failed");
            }
        }
        return valid;
    }

    protected List<Long> retrieveAssetNumberForLocking(Document document) {
        AssetTransferDocument assetTransferDocument = (AssetTransferDocument)document;
        ArrayList<Long> assetNumbers = new ArrayList<Long>();
        if (assetTransferDocument.getAsset().getCapitalAssetNumber() != null) {
            assetNumbers.add(assetTransferDocument.getAsset().getCapitalAssetNumber());
        }
        return assetNumbers;
    }

    protected boolean validateAssetObjectCodeDefn(AssetTransferDocument assetTransferDocument, Asset asset) {
        if (!this.isNonCapitalAsset(asset) && StringUtils.isNotBlank((CharSequence)assetTransferDocument.getOrganizationOwnerChartOfAccountsCode()) && StringUtils.isNotBlank((CharSequence)assetTransferDocument.getOrganizationOwnerAccountNumber())) {
            boolean valid = true;
            List<AssetPayment> assetPayments = asset.getAssetPayments();
            ObjectCodeService objectCodeService = (ObjectCodeService)SpringContext.getBean(ObjectCodeService.class);
            for (AssetPayment assetPayment : assetPayments) {
                AssetObjectCode targetAssetObjectCode;
                if (!((AssetPaymentService)SpringContext.getBean(AssetPaymentService.class)).isPaymentEligibleForGLPosting(assetPayment) || assetPayment.getAccountChargeAmount().isZero()) continue;
                ObjectCode objectCode = objectCodeService.getByPrimaryIdForCurrentYear(assetPayment.getChartOfAccountsCode(), assetPayment.getFinancialObjectCode());
                AssetObjectCode originAssetObjectCode = ((AssetObjectCodeService)SpringContext.getBean(AssetObjectCodeService.class)).findAssetObjectCode(asset.getOrganizationOwnerChartOfAccountsCode(), objectCode.getFinancialObjectSubTypeCode());
                if (valid &= this.validateAssetObjectCode(originAssetObjectCode, asset.getOrganizationOwnerChartOfAccountsCode(), objectCode.getFinancialObjectSubTypeCode())) {
                    valid = this.validateFinancialObjectCodes(asset, assetPayment, originAssetObjectCode);
                }
                if (!(valid &= this.validateAssetObjectCode(targetAssetObjectCode = ((AssetObjectCodeService)SpringContext.getBean(AssetObjectCodeService.class)).findAssetObjectCode(assetTransferDocument.getOrganizationOwnerChartOfAccountsCode(), objectCode.getFinancialObjectSubTypeCode()), assetTransferDocument.getOrganizationOwnerChartOfAccountsCode(), objectCode.getFinancialObjectSubTypeCode()))) continue;
                valid = this.validateFinancialObjectCodes(asset, assetPayment, targetAssetObjectCode);
            }
            return valid;
        }
        return true;
    }

    protected boolean validateAssetObjectCode(AssetObjectCode assetObjectCode, String chartOfAccountsCode, String finObjectSubTypeCode) {
        boolean valid = true;
        if (ObjectUtils.isNull((Object)((Object)assetObjectCode))) {
            this.putError("documentNumber", "error.asset.object.code.not.found", chartOfAccountsCode, finObjectSubTypeCode);
            valid = false;
        } else if (!assetObjectCode.isActive()) {
            this.putError("documentNumber", "error.asset.object.code.inactive", chartOfAccountsCode, finObjectSubTypeCode);
            valid = false;
        }
        return valid;
    }

    protected boolean validateFinancialObjectCodes(Asset asset, AssetPayment assetPayment, AssetObjectCode assetObjectCode) {
        AssetPaymentService assetPaymentService = this.getAssetPaymentService();
        boolean valid = true;
        if (assetPaymentService.isPaymentEligibleForCapitalizationGLPosting(assetPayment)) {
            assetObjectCode.refreshReferenceObject("capitalizationFinancialObject");
            valid = this.validateFinObjectCodeForGLPosting(asset.getOrganizationOwnerChartOfAccountsCode(), assetObjectCode.getCapitalizationFinancialObjectCode(), assetObjectCode.getCapitalizationFinancialObject(), "Capitalization");
        }
        if (assetPaymentService.isPaymentEligibleForAccumDeprGLPosting(assetPayment)) {
            assetObjectCode.refreshReferenceObject("accumulatedDepreciationFinancialObject");
            valid &= this.validateFinObjectCodeForGLPosting(asset.getOrganizationOwnerChartOfAccountsCode(), assetObjectCode.getAccumulatedDepreciationFinancialObjectCode(), assetObjectCode.getAccumulatedDepreciationFinancialObject(), "Accummulate Depreciation");
        }
        if (assetPaymentService.isPaymentEligibleForOffsetGLPosting(assetPayment)) {
            OffsetDefinition offsetDefinition = ((OffsetDefinitionService)SpringContext.getBean(OffsetDefinitionService.class)).getByPrimaryId(this.getUniversityDateService().getCurrentFiscalYear(), assetObjectCode.getChartOfAccountsCode(), "AT", "AC");
            valid &= this.validateFinObjectCodeForGLPosting(asset.getOrganizationOwnerChartOfAccountsCode(), offsetDefinition.getFinancialObjectCode(), offsetDefinition.getFinancialObject(), "Offset Amount");
        }
        return valid;
    }

    protected boolean validateFinObjectCodeForGLPosting(String chartOfAccountsCode, String finObjectCode, ObjectCode finObject, String glPostingType) {
        boolean valid = true;
        if (StringUtils.isBlank((CharSequence)finObjectCode)) {
            this.putError("documentNumber", "error.object.code.from.asset.object.code.not.found", glPostingType, chartOfAccountsCode);
            valid = false;
        } else if (ObjectUtils.isNull((Object)finObject)) {
            this.putError("documentNumber", "error.object.code.from.asset.object.code.invalid", glPostingType, finObjectCode, chartOfAccountsCode);
            valid = false;
        } else if (!finObject.isActive()) {
            this.putError("documentNumber", "error.object.code.from.asset.object.code.inactive", glPostingType, finObjectCode, chartOfAccountsCode);
            valid = false;
        }
        return valid;
    }

    protected boolean processCustomRouteDocumentBusinessRules(Document document) {
        if (!super.processCustomRouteDocumentBusinessRules(document) || GlobalVariables.getMessageMap().hasErrors()) {
            return false;
        }
        Asset asset = ((AssetTransferDocument)document).getAsset();
        boolean valid = true;
        if (((AssetService)SpringContext.getBean(AssetService.class)).isAssetRetired(asset)) {
            valid = false;
            GlobalVariables.getMessageMap().putError("document.documentNumber", "error.asset.retired.notransfer", new String[]{asset.getCapitalAssetNumber().toString(), asset.getRetirementReason().getRetirementReasonName()});
        }
        if (valid) {
            valid = this.applyRules(document);
        }
        return valid &= !this.getAssetLockService().isAssetLocked(this.retrieveAssetNumberForLocking(document), "AT", document.getDocumentNumber());
    }

    protected boolean applyRules(Document document) {
        boolean valid = true;
        AssetTransferDocument assetTransferDocument = (AssetTransferDocument)document;
        String inventoryStatusCode = assetTransferDocument.getAsset().getInventoryStatus().getInventoryStatusCode();
        if (inventoryStatusCode != null && !StringUtils.equalsIgnoreCase((CharSequence)inventoryStatusCode, (CharSequence)"N") && !StringUtils.equalsIgnoreCase((CharSequence)inventoryStatusCode, (CharSequence)"D")) {
            valid = this.validateOwnerAccount(assetTransferDocument);
        }
        valid &= this.validateLocation(assetTransferDocument);
        if (assetTransferDocument.isInterdepartmentalSalesIndicator() && StringUtils.isBlank((CharSequence)assetTransferDocument.getTransferOfFundsFinancialDocumentNumber())) {
            this.putError("transferOfFundsFinancialDocumentNumber", "error.transfer.fund.financial.doc.required", new String[0]);
            valid = false;
        }
        return valid &= this.validatePaymentObjectCodes(assetTransferDocument);
    }

    protected boolean validateLocation(AssetTransferDocument assetTransferDocument) {
        GlobalVariables.getMessageMap().addToErrorPath("document");
        Asset asset = assetTransferDocument.getAsset();
        asset.refreshReferenceObject("capitalAssetType");
        boolean isCapitalAsset = this.getAssetService().isCapitalAsset(asset);
        boolean valid = ((AssetLocationService)SpringContext.getBean(AssetLocationService.class)).validateLocation(LOCATION_FIELD_MAP, (BusinessObject)assetTransferDocument, isCapitalAsset, asset.getCapitalAssetType());
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return valid;
    }

    protected boolean checkReferencesExist(AssetTransferDocument assetTransferDocument) {
        TransferOfFundsDocument transferOfFundsFinancialDocument;
        boolean valid = true;
        assetTransferDocument.refreshReferenceObject("asset");
        if (this.getAssetService().isAssetLoaned(assetTransferDocument.getAsset())) {
            this.putError("asset.capitalAssetNumber", "error.transfer.asset.loaned", new String[0]);
            valid = false;
        }
        if (StringUtils.isNotBlank((CharSequence)assetTransferDocument.getOrganizationOwnerChartOfAccountsCode())) {
            assetTransferDocument.refreshReferenceObject("organizationOwnerChartOfAccounts");
            if (ObjectUtils.isNull((Object)assetTransferDocument.getOrganizationOwnerChartOfAccounts())) {
                this.putError("organizationOwnerChartOfAccountsCode", "error.receiving.org.chart.code.invalid", assetTransferDocument.getOrganizationOwnerChartOfAccountsCode());
                valid = false;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)assetTransferDocument.getOrganizationOwnerAccountNumber())) {
            assetTransferDocument.refreshReferenceObject("organizationOwnerAccount");
            if (ObjectUtils.isNull((Object)assetTransferDocument.getOrganizationOwnerAccount())) {
                this.putError("organizationOwnerAccountNumber", "error.receiving.org.acct.invalid", assetTransferDocument.getOrganizationOwnerAccountNumber(), assetTransferDocument.getOrganizationOwnerChartOfAccountsCode());
                valid = false;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)assetTransferDocument.getTransferOfFundsFinancialDocumentNumber()) && (ObjectUtils.isNull((Object)(transferOfFundsFinancialDocument = assetTransferDocument.getTransferOfFundsFinancialDocument())) || !"A".equals(transferOfFundsFinancialDocument.getFinancialSystemDocumentHeader().getFinancialDocumentStatusCode()))) {
            this.putError("transferOfFundsFinancialDocumentNumber", "error.transfer.fund.financial.doc.invalid", new String[0]);
            valid = false;
        }
        if (StringUtils.isNotBlank((CharSequence)assetTransferDocument.getCampusCode())) {
            assetTransferDocument.refreshReferenceObject("campus");
            if (ObjectUtils.isNull((Object)assetTransferDocument.getCampus())) {
                this.putError("campusCode", "error.invalid.campus.code", assetTransferDocument.getCampusCode());
                valid = false;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)assetTransferDocument.getBuildingCode())) {
            assetTransferDocument.refreshReferenceObject("building");
            if (ObjectUtils.isNull((Object)assetTransferDocument.getBuilding())) {
                this.putError("buildingCode", "error.invalid.building.code", assetTransferDocument.getBuildingCode(), assetTransferDocument.getCampusCode());
                valid = false;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)assetTransferDocument.getBuildingRoomNumber())) {
            assetTransferDocument.refreshReferenceObject("buildingRoom");
            if (ObjectUtils.isNull((Object)assetTransferDocument.getBuildingRoom())) {
                this.putError("buildingRoomNumber", "error.invalid.room.code", assetTransferDocument.getBuildingCode(), assetTransferDocument.getBuildingRoomNumber(), assetTransferDocument.getCampusCode());
                valid = false;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)assetTransferDocument.getAssetRepresentative().getPrincipalName())) {
            PersonService personService = (PersonService)SpringContext.getBean(PersonService.class);
            Person person = personService.getPersonByPrincipalName(assetTransferDocument.getAssetRepresentative().getPrincipalName());
            if (person != null) {
                assetTransferDocument.setAssetRepresentative(person);
                assetTransferDocument.setRepresentativeUniversalIdentifier(person.getPrincipalId());
            } else {
                this.putError("assetRepresentative.principalName", "error.representative.user.invalid", assetTransferDocument.getAssetRepresentative().getPrincipalName());
                valid = false;
            }
        }
        return valid;
    }

    protected boolean validateOwnerAccount(AssetTransferDocument assetTransferDocument) {
        boolean valid = true;
        Asset asset = assetTransferDocument.getAsset();
        boolean assetMovable = this.getAssetService().isAssetMovableCheckByPayment(asset);
        Account organizationOwnerAccount = assetTransferDocument.getOrganizationOwnerAccount();
        if (ObjectUtils.isNotNull((Object)organizationOwnerAccount) && organizationOwnerAccount.isExpired()) {
            this.putError("organizationOwnerAccountNumber", "error.receiving.org.acct.invalid", assetTransferDocument.getOrganizationOwnerAccountNumber(), assetTransferDocument.getOrganizationOwnerChartOfAccountsCode());
            valid = false;
        } else if (this.getAssetService().isCapitalAsset(asset) && !asset.getAssetPayments().isEmpty()) {
            Organization ownerOrg = organizationOwnerAccount.getOrganization();
            Account campusPlantAccount = ownerOrg.getCampusPlantAccount();
            Account organizationPlantAccount = ownerOrg.getOrganizationPlantAccount();
            if (assetMovable && ObjectUtils.isNull((Object)organizationPlantAccount)) {
                this.putError("organizationOwnerAccountNumber", "error.org.plant.fund.unknown", new String[0]);
                valid = false;
            }
            if (!assetMovable && ObjectUtils.isNull((Object)campusPlantAccount)) {
                this.putError("organizationOwnerAccountNumber", "error.campus.plant.fund.unknown", new String[0]);
                valid = false;
            }
        }
        return valid;
    }

    protected boolean validatePaymentObjectCodes(AssetTransferDocument assetTransferDocument) {
        boolean valid = true;
        List<AssetPayment> assetPayments = assetTransferDocument.getAsset().getAssetPayments();
        String chartOfAccountsCode = assetTransferDocument.getOrganizationOwnerChartOfAccountsCode();
        Integer fiscalYear = this.getUniversityDateService().getCurrentUniversityDate().getUniversityFiscalYear();
        for (AssetPayment assetPayment : assetPayments) {
            if ("Y".equals(assetPayment.getTransferPaymentCode()) || this.getObjectCodeService().getByPrimaryId(fiscalYear, chartOfAccountsCode, assetPayment.getFinancialObjectCode()) != null) continue;
            this.putError("organizationOwnerChartOfAccountsCode", "error.transfer.document.payment.object.code.doesnt.exists", assetPayment.getFinancialObjectCode(), fiscalYear.toString());
            valid = false;
        }
        return valid;
    }

    public AutoPopulatingList<ErrorMessage> putError(String propertyName, String errorKey, String ... errorParameters) {
        return GlobalVariables.getMessageMap().putError("document." + propertyName, errorKey, errorParameters);
    }

    private boolean isNonCapitalAsset(Asset asset) {
        ArrayList capitalAssetAcquisitionTypeCodes = new ArrayList();
        capitalAssetAcquisitionTypeCodes.addAll(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(AssetGlobal.class, "CAPITAL_OBJECT_ACQUISITION_CODES"));
        capitalAssetAcquisitionTypeCodes.addAll(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(AssetGlobal.class, "NON_NEW_ACQUISITION_CODES"));
        capitalAssetAcquisitionTypeCodes.addAll(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(AssetGlobal.class, "NEW_ACQUISITION_CODE"));
        capitalAssetAcquisitionTypeCodes.addAll(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(AssetFabrication.class, "ACQUISITION_TYPE"));
        capitalAssetAcquisitionTypeCodes.addAll(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(AssetGlobal.class, "PRE_TAGGING_ACQUISITION_CODE"));
        return ObjectUtils.isNull((Object)asset.getAcquisitionTypeCode()) || !capitalAssetAcquisitionTypeCodes.contains(asset.getAcquisitionTypeCode());
    }

    public UniversityDateService getUniversityDateService() {
        if (this.universityDateService == null) {
            this.universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
        }
        return this.universityDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public AssetPaymentService getAssetPaymentService() {
        if (this.assetPaymentService == null) {
            this.assetPaymentService = (AssetPaymentService)SpringContext.getBean(AssetPaymentService.class);
        }
        return this.assetPaymentService;
    }

    public void setAssetPaymentService(AssetPaymentService assetPaymentService) {
        this.assetPaymentService = assetPaymentService;
    }

    public AssetService getAssetService() {
        if (this.assetService == null) {
            this.assetService = (AssetService)SpringContext.getBean(AssetService.class);
        }
        return this.assetService;
    }

    public AssetLockService getAssetLockService() {
        if (this.assetLockService == null) {
            this.assetLockService = (AssetLockService)SpringContext.getBean(AssetLockService.class);
        }
        return this.assetLockService;
    }

    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    public ObjectCodeService getObjectCodeService() {
        if (this.objectCodeService == null) {
            this.objectCodeService = (ObjectCodeService)SpringContext.getBean(ObjectCodeService.class);
        }
        return this.objectCodeService;
    }

    public void setObjectCodeService(ObjectCodeService objectCodeService) {
        this.objectCodeService = objectCodeService;
    }

    static {
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.CAMPUS_CODE, "campusCode");
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.BUILDING_CODE, "buildingCode");
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.ROOM_NUMBER, "buildingRoomNumber");
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.SUB_ROOM_NUMBER, "buildingSubRoomNumber");
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.STREET_ADDRESS, "offCampusAddress");
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.CITY_NAME, "offCampusCityName");
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.STATE_CODE, "offCampusStateCode");
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.ZIP_CODE, "offCampusZipCode");
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.COUNTRY_CODE, CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_COUNTRY_CODE);
        LOCATION_FIELD_MAP.put(AssetLocationService.LocationField.CONTACT_NAME, "offCampusName");
    }
}

