/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.dataaccess.impl;

import java.sql.Date;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.Proposal;
import org.kuali.kfs.module.cg.dataaccess.CloseDao;
import org.kuali.kfs.module.cg.document.ProposalAwardCloseDocument;
import org.kuali.kfs.sys.util.TransactionalServiceUtils;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public class CloseDaoOjb
extends PlatformAwareDaoBaseOjb
implements CloseDao {
    @Override
    public String getMaxApprovedClose(Date today) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("userInitiatedCloseDate", (Object)today);
        criteria.addEqualTo("documentHeader.workflowDocumentStatusCode", (Object)"R");
        ReportQueryByCriteria rqbc = new ReportQueryByCriteria(ProposalAwardCloseDocument.class, criteria);
        rqbc.setAttributes(new String[]{"documentNumber"});
        rqbc.addOrderByDescending("documentNumber");
        Iterator documentHeaderIdsIterator = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)rqbc);
        if (documentHeaderIdsIterator.hasNext()) {
            Object[] result = (Object[])TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)documentHeaderIdsIterator);
            if (result[0] != null) {
                return result[0].toString();
            }
            return null;
        }
        return null;
    }

    @Override
    public String getMostRecentClose(Date today) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("userInitiatedCloseDate", (Object)today);
        criteria.addEqualTo("documentHeader.workflowDocumentStatusCode", (Object)"A");
        ReportQueryByCriteria rqbc = new ReportQueryByCriteria(ProposalAwardCloseDocument.class, criteria);
        rqbc.setAttributes(new String[]{"documentNumber"});
        rqbc.addOrderByDescending("documentNumber");
        this.getPersistenceBrokerTemplate().clearCache();
        if (this.getPersistenceBrokerTemplate().getCount((Query)rqbc) == 0) {
            return null;
        }
        Iterator documentHeaderIdsIterator = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)rqbc);
        Object[] result = (Object[])TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)documentHeaderIdsIterator);
        if (result[0] != null) {
            return result[0].toString();
        }
        return null;
    }

    @Override
    public Collection<Award> getAwardsToClose(ProposalAwardCloseDocument close) {
        Criteria criteria = new Criteria();
        criteria.addIsNull("awardClosingDate");
        criteria.addLessOrEqualThan((Object)"awardEntryDate", (Object)close.getCloseOnOrBeforeDate());
        criteria.addNotEqualTo((Object)"awardStatusCode", (Object)"U");
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(Award.class, (Criteria)criteria));
    }

    @Override
    public Collection<Proposal> getProposalsToClose(ProposalAwardCloseDocument close) {
        Criteria criteria = new Criteria();
        criteria.addIsNull("proposalClosingDate");
        criteria.addLessOrEqualThan((Object)"proposalSubmissionDate", (Object)close.getCloseOnOrBeforeDate());
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(Proposal.class, (Criteria)criteria));
    }
}

