/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.maintenance.MaintenanceLock;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.businessobject.AwardFundManager;
import org.kuali.kfs.module.cg.businessobject.AwardOrganization;
import org.kuali.kfs.module.cg.businessobject.AwardProjectDirector;
import org.kuali.kfs.module.cg.businessobject.AwardSubcontractor;
import org.kuali.kfs.module.cg.businessobject.CGProjectDirector;
import org.kuali.kfs.module.cg.businessobject.Proposal;
import org.kuali.kfs.module.cg.document.ContractsGrantsBillingMaintainable;
import org.kuali.kfs.module.cg.document.validation.impl.AwardRuleUtil;
import org.kuali.kfs.module.cg.service.ContractsAndGrantsBillingService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class AwardMaintainableImpl
extends ContractsGrantsBillingMaintainable {
    private static final Logger LOG = Logger.getLogger(AwardMaintainableImpl.class);
    private static volatile AccountsReceivableModuleBillingService accountsReceivableModuleBillingService;

    public void processAfterRetrieve() {
        this.refreshAward(false);
        super.processAfterRetrieve();
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        Award oldAward = (Award)document.getOldMaintainableObject().getBusinessObject();
        Award newAward = (Award)document.getNewMaintainableObject().getBusinessObject();
        if (ObjectUtils.isNotNull((Object)((Object)oldAward)) && ObjectUtils.isNotNull((Object)((Object)newAward))) {
            oldAward.getAwardAccounts().clear();
            newAward.getAwardAccounts().clear();
        }
        this.getAward().setMilestoneSchedule(((AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class)).getMilestoneSchedule());
        this.getAward().setPredeterminedBillingSchedule(((AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class)).getPredeterminedBillingSchedule());
    }

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterNew(document, parameters);
        String defaultInvoiceParm = AwardMaintainableImpl.getAccountsReceivableModuleBillingService().getDefaultInvoicingOption();
        String defaultBillingScheduleParm = AwardMaintainableImpl.getAccountsReceivableModuleBillingService().getDefaultBillingFrequency();
        this.getAward().setInvoicingOptionCode(defaultInvoiceParm);
        if (StringUtils.isNotBlank((String)defaultBillingScheduleParm)) {
            this.getAward().setBillingFrequencyCode(defaultBillingScheduleParm);
        } else {
            this.getAward().setBillingFrequencyCode("MNTH");
        }
    }

    public void prepareForSave() {
        List<AwardSubcontractor> awardSubcontractors;
        List<AwardOrganization> organizations;
        List<AwardFundManager> managers;
        this.refreshAward(false);
        List<AwardProjectDirector> directors = this.getAward().getAwardProjectDirectors();
        if (directors.size() == 1) {
            directors.get(0).setAwardPrimaryProjectDirectorIndicator(true);
        }
        if ((managers = this.getAward().getAwardFundManagers()) != null && managers.size() == 1) {
            managers.get(0).setPrimaryFundManagerIndicator(true);
        }
        if ((organizations = this.getAward().getAwardOrganizations()).size() == 1) {
            organizations.get(0).setAwardPrimaryOrganizationIndicator(true);
        }
        if ((awardSubcontractors = this.getAward().getAwardSubcontractors()) != null && !awardSubcontractors.isEmpty()) {
            HashMap subcontractorAwardMap = new HashMap();
            ArrayList<AwardSubcontractor> newSubcontractorRecords = new ArrayList<AwardSubcontractor>();
            for (AwardSubcontractor awardSubcontractor : awardSubcontractors) {
                if (!StringUtils.isBlank((String)awardSubcontractor.getAwardSubcontractorNumber())) {
                    if (!subcontractorAwardMap.containsKey(awardSubcontractor.getSubcontractorNumber())) {
                        subcontractorAwardMap.put(awardSubcontractor.getSubcontractorNumber(), new ArrayList());
                    }
                    ((List)subcontractorAwardMap.get(awardSubcontractor.getSubcontractorNumber())).add(awardSubcontractor);
                    continue;
                }
                newSubcontractorRecords.add(awardSubcontractor);
            }
            for (AwardSubcontractor awardSubcontractor : newSubcontractorRecords) {
                String awardSubcontractorNumber = "1";
                String awardSubcontractorAmendmentNumber = "1";
                List oldSubcontractors = (List)subcontractorAwardMap.get(awardSubcontractor.getSubcontractorNumber());
                if (oldSubcontractors != null) {
                    boolean[][] nums = new boolean[100][100];
                    for (AwardSubcontractor oldSub : oldSubcontractors) {
                        try {
                            nums[Integer.valueOf((String)oldSub.getAwardSubcontractorNumber()).intValue()][Integer.valueOf((String)oldSub.getAwardSubcontractorAmendmentNumber()).intValue()] = true;
                        }
                        catch (NumberFormatException ex) {
                            LOG.warn((Object)("Unexpected non-integer award subcontractor / amendment number: " + oldSub.getAwardSubcontractorNumber() + " / " + oldSub.getAwardSubcontractorAmendmentNumber()));
                        }
                    }
                    boolean isFoundNumbers = false;
                    for (int i = 1; i <= 99; ++i) {
                        for (int j = 1; j <= 99; ++j) {
                            if (nums[j][i]) continue;
                            awardSubcontractorNumber = Integer.toString(j);
                            awardSubcontractorAmendmentNumber = Integer.toString(i);
                            nums[j][i] = true;
                            isFoundNumbers = true;
                            break;
                        }
                        if (isFoundNumbers) break;
                    }
                }
                awardSubcontractor.setAwardSubcontractorNumber(awardSubcontractorNumber);
                awardSubcontractor.setAwardSubcontractorAmendmentNumber(awardSubcontractorAmendmentNumber);
            }
        }
        super.prepareForSave();
    }

    public void processAfterPost(MaintenanceDocument document, Map<String, String[]> parameters) {
        Proposal proposal;
        super.processAfterPost(document, parameters);
        Award newAward = (Award)document.getNewMaintainableObject().getBusinessObject();
        if (ObjectUtils.isNotNull((Object)((Object)newAward)) && ObjectUtils.isNotNull((Object)((Object)(proposal = newAward.getProposal()))) && proposal.getProposalNumber() != null) {
            ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)newAward.getProposal());
        }
    }

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        if (StringUtils.equals((String)"proposalLookupable", (String)((String)fieldValues.get("refreshCaller")))) {
            boolean isAwarded = AwardRuleUtil.isProposalAwarded(this.getAward());
            if (isAwarded) {
                String pathToMaintainable = "document.newMaintainableObject";
                GlobalVariables.getMessageMap().addToErrorPath(pathToMaintainable);
                GlobalVariables.getMessageMap().putError("proposalNumber", "error.cg.award.proposal.awarded", new String[]{this.getAward().getProposalNumber().toString()});
                GlobalVariables.getMessageMap().removeFromErrorPath(pathToMaintainable);
            }
            if (!isAwarded) {
                this.refreshAward(true);
                fieldValues.put("referencesToRefresh", "proposal");
                super.refresh(refreshCaller, fieldValues, document);
                this.getAward().populateFromProposal(this.getAward().getProposal());
                this.refreshAward(true);
            }
        } else {
            this.refreshAward("cf.kualiLookupable".equals(fieldValues.get("refreshCaller")));
            super.refresh(refreshCaller, fieldValues, document);
        }
    }

    private void refreshAward(boolean refreshFromLookup) {
        Award award = this.getAward();
        award.refreshNonUpdateableReferences();
        this.getNewCollectionLine("awardSubcontractors").refreshNonUpdateableReferences();
        this.getNewCollectionLine("awardProjectDirectors").refreshNonUpdateableReferences();
        this.getNewCollectionLine("awardFundManagers").refreshNonUpdateableReferences();
        this.getNewCollectionLine("awardAccounts").refreshNonUpdateableReferences();
        AwardMaintainableImpl.refreshNonUpdateableReferences(award.getAwardOrganizations());
        AwardMaintainableImpl.refreshNonUpdateableReferences(award.getAwardAccounts());
        AwardMaintainableImpl.refreshNonUpdateableReferences(award.getAwardSubcontractors());
        this.refreshAwardProjectDirectors(refreshFromLookup);
        this.refreshAwardFundManagers(refreshFromLookup);
    }

    private void refreshAwardProjectDirectors(boolean refreshFromLookup) {
        if (refreshFromLookup) {
            this.getNewCollectionLine("awardProjectDirectors").refreshNonUpdateableReferences();
            AwardMaintainableImpl.refreshNonUpdateableReferences(this.getAward().getAwardProjectDirectors());
            this.getNewCollectionLine("awardAccounts").refreshNonUpdateableReferences();
            AwardMaintainableImpl.refreshNonUpdateableReferences(this.getAward().getAwardAccounts());
        } else {
            AwardMaintainableImpl.refreshWithSecondaryKey((AwardProjectDirector)this.getNewCollectionLine("awardProjectDirectors"));
            for (AwardProjectDirector projectDirector : this.getAward().getAwardProjectDirectors()) {
                AwardMaintainableImpl.refreshWithSecondaryKey(projectDirector);
            }
            AwardMaintainableImpl.refreshWithSecondaryKey((AwardAccount)this.getNewCollectionLine("awardAccounts"));
            for (AwardAccount account : this.getAward().getAwardAccounts()) {
                AwardMaintainableImpl.refreshWithSecondaryKey(account);
            }
        }
    }

    private void refreshAwardFundManagers(boolean refreshFromLookup) {
        if (refreshFromLookup) {
            this.getNewCollectionLine("awardFundManagers").refreshNonUpdateableReferences();
            AwardMaintainableImpl.refreshNonUpdateableReferences(this.getAward().getAwardFundManagers());
            this.getNewCollectionLine("awardAccounts").refreshNonUpdateableReferences();
            AwardMaintainableImpl.refreshNonUpdateableReferences(this.getAward().getAwardAccounts());
        } else {
            AwardMaintainableImpl.refreshWithSecondaryKey((AwardFundManager)this.getNewCollectionLine("awardFundManagers"));
            for (AwardFundManager fundManager : this.getAward().getAwardFundManagers()) {
                AwardMaintainableImpl.refreshWithSecondaryKey(fundManager);
            }
        }
    }

    private static void refreshNonUpdateableReferences(Collection<? extends PersistableBusinessObject> collection) {
        for (PersistableBusinessObject persistableBusinessObject : collection) {
            persistableBusinessObject.refreshNonUpdateableReferences();
        }
    }

    private static void refreshWithSecondaryKey(CGProjectDirector director) {
        Person cgdir = director.getProjectDirector();
        if (ObjectUtils.isNotNull((Object)cgdir)) {
            Principal principal;
            String secondaryKey = cgdir.getPrincipalName();
            if (StringUtils.isNotBlank((String)secondaryKey)) {
                Principal dir = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(secondaryKey);
                director.setPrincipalId(dir == null ? null : dir.getPrincipalId());
            }
            if (StringUtils.isNotBlank((String)director.getPrincipalId()) && (principal = KimApiServiceLocator.getIdentityService().getPrincipal(director.getPrincipalId())) != null) {
                ((PersistableBusinessObject)director).refreshNonUpdateableReferences();
            }
        }
    }

    private static void refreshWithSecondaryKey(AwardFundManager fundManager) {
        Person cdFundMgr = fundManager.getFundManager();
        if (ObjectUtils.isNotNull((Object)cdFundMgr)) {
            Person person;
            String secondaryKey = cdFundMgr.getPrincipalName();
            if (StringUtils.isNotBlank((String)secondaryKey)) {
                Person fundMgr = ((PersonService)SpringContext.getBean(PersonService.class)).getPersonByPrincipalName(secondaryKey);
                fundManager.setPrincipalId(fundMgr == null ? null : fundMgr.getPrincipalId());
            }
            if (StringUtils.isNotBlank((String)fundManager.getPrincipalId()) && (person = ((PersonService)SpringContext.getBean(PersonService.class)).getPerson(fundManager.getPrincipalId())) != null) {
                fundManager.refreshNonUpdateableReferences();
            }
        }
    }

    public Award getAward() {
        return (Award)this.getBusinessObject();
    }

    public void addNewLineToCollection(String collectionName) {
        this.refreshAward(false);
        super.addNewLineToCollection(collectionName);
    }

    public List getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        Award award = this.getAward();
        if (StringUtils.isNotEmpty((String)award.getLetterOfCreditFundCode()) && StringUtils.isNotBlank((String)award.getLetterOfCreditFundCode())) {
            award.setBillingFrequencyCode("LOCB");
        }
        return super.getSections(document, oldMaintainable);
    }

    @Override
    protected Collection<?> getSectionIdsToIgnore() {
        if (!((AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class)).isContractsGrantsBillingEnhancementActive()) {
            return ((ContractsAndGrantsBillingService)SpringContext.getBean(ContractsAndGrantsBillingService.class)).getAwardContractsGrantsBillingSectionIds();
        }
        return CollectionUtils.EMPTY_COLLECTION;
    }

    public void doRouteStatusChange(DocumentHeader header) {
        super.doRouteStatusChange(header);
        Award award = this.getAward();
        WorkflowDocument workflowDoc = header.getWorkflowDocument();
        if (workflowDoc.isProcessed()) {
            Proposal proposal = award.getProposal();
            proposal.setProposalStatusCode("A");
            ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)proposal);
        }
    }

    public List<MaintenanceLock> generateMaintenanceLocks() {
        List locks = super.generateMaintenanceLocks();
        return locks;
    }

    public static AccountsReceivableModuleBillingService getAccountsReceivableModuleBillingService() {
        if (accountsReceivableModuleBillingService == null) {
            accountsReceivableModuleBillingService = (AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class);
        }
        return accountsReceivableModuleBillingService;
    }
}

